/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.io.Serializable;
import java.util.Arrays;
import org.nlogo.agent.Link;
import org.nlogo.agent.LinkManager;
import org.nlogo.agent.Protractor3D;
import org.nlogo.agent.Rotations3D$;
import org.nlogo.agent.TieManager;
import org.nlogo.agent.TreeAgentSet;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.Turtle3D;
import org.nlogo.api.AgentException;
import org.nlogo.api.Exceptions$;
import org.nlogo.api.Matrix3D;
import org.nlogo.api.Vect;
import org.nlogo.api.Vect$;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;

public class TieManager3D
extends TieManager {
    private final TreeAgentSet links;
    private final LinkManager linkManager;
    private final Protractor3D protractor;
    private Set<Turtle3D> seenTurtles;

    public TieManager3D(TreeAgentSet links, LinkManager linkManager, Protractor3D protractor) {
        this.links = links;
        this.linkManager = linkManager;
        this.protractor = protractor;
        super(links, linkManager, protractor);
        this.seenTurtles = Predef$.MODULE$.Set().empty();
    }

    public void turtleMoved(Turtle3D root, double newX, double newY, double newZ, double originalXcor, double originalYcor, double originalZcor) {
        boolean weroot = false;
        try {
            Seq<Turtle3D> myTies;
            if (this.seenTurtles.isEmpty()) {
                this.seenTurtles = (Set)this.seenTurtles.$plus((Object)root);
                weroot = true;
            }
            if (!(myTies = this.tiedTurtles3d(root, this.seenTurtles)).isEmpty()) {
                this.seenTurtles = (Set)this.seenTurtles.$plus$plus((IterableOnce)myTies.toSet());
                double changex = newX - originalXcor;
                double changey = newY - originalYcor;
                double changez = newZ - originalZcor;
                myTies.foreach(t -> t.xyandzcor(t.xcor() + changex, t.ycor() + changey, t.zcor() + changez));
            }
        }
        finally {
            if (weroot) {
                this.seenTurtles = Predef$.MODULE$.Set().empty();
            }
        }
    }

    public Seq<Turtle3D> tiedTurtles3d(Turtle root, Set<Turtle3D> seenTurtles) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.linkManager.outLinks(root, this.links));
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.collect$extension(object, (PartialFunction)new Serializable(root){
            private final Turtle root$1;
            {
                this.root$1 = root$3;
            }

            public final boolean isDefinedAt(Link x) {
                Link link = x;
                Link link2 = link;
                return link2.isTied();
            }

            public final Object applyOrElse(Link x, Function1 function1) {
                Link link = x;
                Link link2 = link;
                if (link2.isTied()) {
                    return link2.otherEnd(this.root$1);
                }
                return function1.apply((Object)x);
            }
        }, ClassTag$.MODULE$.apply(Turtle.class)));
        Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.collect$extension(object2, (PartialFunction)new Serializable(seenTurtles){
            private final Set seenTurtles$1;
            {
                this.seenTurtles$1 = seenTurtles$2;
            }

            public final boolean isDefinedAt(Turtle x) {
                Turtle3D t;
                Turtle turtle = x;
                return turtle instanceof Turtle3D && (t = (Turtle3D)turtle).id() != -1L && !this.seenTurtles$1.contains((Object)t);
            }

            public final Object applyOrElse(Turtle x, Function1 function1) {
                Turtle3D t;
                Turtle turtle = x;
                if (turtle instanceof Turtle3D && (t = (Turtle3D)turtle).id() != -1L && !this.seenTurtles$1.contains((Object)t)) {
                    return t;
                }
                return function1.apply((Object)x);
            }
        }, ClassTag$.MODULE$.apply(Turtle3D.class)));
        return ArrayOps$.MODULE$.toIndexedSeq$extension(object3);
    }

    @Override
    public void turtleTurned(Turtle root, double newHeading, double originalHeading) {
        Turtle3D t = (Turtle3D)root;
        this.turtleOrientationChanged(t, newHeading, t.pitch(), t.roll(), originalHeading, t.pitch(), t.roll());
    }

    public void turtleOrientationChanged(Turtle3D root, double newHeading, double newPitch, double newRoll, double oldHeading, double oldPitch, double oldRoll) {
        boolean weroot = false;
        try {
            Seq<Turtle3D> myTies;
            if (this.seenTurtles.isEmpty()) {
                this.seenTurtles = (Set)this.seenTurtles.$plus((Object)root);
                weroot = true;
            }
            if (!(myTies = this.tiedTurtles3d(root, this.seenTurtles)).isEmpty()) {
                this.seenTurtles = (Set)this.seenTurtles.$plus$plus((IterableOnce)myTies.toSet());
                Matrix3D ptrans = new Matrix3D();
                Matrix3D rtrans = new Matrix3D();
                double dh = Turtle.subtractHeadings(newHeading, oldHeading);
                double dp = Turtle.subtractHeadings(newPitch, oldPitch);
                double dr = Turtle.subtractHeadings(newRoll, oldRoll);
                Matrix3D htrans = Rotations3D$.MODULE$.zrot(-dh);
                Vect[] vects = Vect$.MODULE$.toVectors(newHeading, oldPitch, 0.0);
                ptrans.vrot(0.0, 0.0, 0.0, vects[1].x(), vects[1].y(), vects[1].z(), StrictMath.toRadians(dp));
                vects = Vect$.MODULE$.toVectors(newHeading, newPitch, oldRoll);
                rtrans.vrot(0.0, 0.0, 0.0, vects[0].x(), vects[0].y(), vects[0].z(), StrictMath.toRadians(dr));
                double[] out = new double[3];
                myTies.foreach(t -> {
                    try {
                        boolean rigid = Arrays.stream(this.linkManager.linksWith(root, (Turtle)t, this.links)).anyMatch(l -> {
                            String string = l.mode();
                            String string2 = "fixed";
                            return !(string != null ? !string.equals(string2) : string2 != null);
                        });
                        double[] leaf = this.protractor.towardsVector(root.xcor(), root.ycor(), root.zcor(), t.xcor(), t.ycor(), t.zcor(), true);
                        htrans.transform(leaf, out, 1);
                        ptrans.transform(out, out, 1);
                        rtrans.transform(out, out, 1);
                        double nx = t.xcor() + (out[0] - leaf[0]);
                        double ny = t.ycor() + (out[1] - leaf[1]);
                        double nz = t.zcor() + (out[2] - leaf[2]);
                        Set<Turtle3D> snapshot = this.seenTurtles;
                        try {
                            if (rigid) {
                                snapshot = this.seenTurtles;
                            }
                            t.xyandzcor(nx, ny, nz);
                        }
                        finally {
                            if (rigid) {
                                this.seenTurtles = snapshot;
                            }
                        }
                        if (rigid) {
                            Vect[] hvs = Vect$.MODULE$.toVectors(t.heading, t.pitch(), t.roll());
                            hvs[0] = hvs[0].transform(htrans);
                            hvs[1] = hvs[1].transform(htrans);
                            hvs[0] = hvs[0].transform(ptrans);
                            hvs[1] = hvs[1].transform(ptrans);
                            hvs[0] = hvs[0].transform(rtrans);
                            hvs[1] = hvs[1].transform(rtrans);
                            double[] leaf2 = Vect$.MODULE$.toAngles(hvs[0], hvs[1]);
                            t.headingPitchAndRoll(leaf2[0], leaf2[1], leaf2[2]);
                        }
                    }
                    catch (AgentException ex) {
                        Exceptions$.MODULE$.ignore(ex);
                    }
                });
            }
        }
        finally {
            if (weroot) {
                this.seenTurtles = Predef$.MODULE$.Set().empty();
            }
        }
    }
}

