/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet$;
import org.nlogo.agent.IndexedAgentSet;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Patch3D;
import org.nlogo.agent.PatchException;
import org.nlogo.agent.Topology$;
import org.nlogo.agent.Topology3D;
import org.nlogo.agent.Torus;
import org.nlogo.agent.World3D;
import org.nlogo.api.AgentException;
import org.nlogo.core.AgentKind$Patch$;
import scala.Int$;
import scala.runtime.BoxesRunTime;

public class Torus3D
extends Torus
implements Topology3D {
    private final World3D _world3d;

    public Torus3D(World3D _world3d) {
        this._world3d = _world3d;
        super(_world3d);
    }

    @Override
    public IndexedAgentSet getNeighbors3d(Patch3D source) {
        return AgentSet$.MODULE$.fromArray(AgentKind$Patch$.MODULE$, new Agent[]{this.getPN(source), this.getPE(source), this.getPS(source), this.getPW(source), this.getPNE(source), this.getPSE(source), this.getPSW(source), this.getPNW(source), this.getPatchUp(source), this.getPatchDown(source), this.getPNU(source), this.getPEU(source), this.getPSU(source), this.getPWU(source), this.getPNEU(source), this.getPSEU(source), this.getPSWU(source), this.getPNWU(source), this.getPND(source), this.getPED(source), this.getPSD(source), this.getPWD(source), this.getPNED(source), this.getPSED(source), this.getPSWD(source), this.getPNWD(source)});
    }

    @Override
    public IndexedAgentSet getNeighbors6(Patch3D source) {
        return AgentSet$.MODULE$.fromArray(AgentKind$Patch$.MODULE$, new Agent[]{this.getPN(source), this.getPE(source), this.getPS(source), this.getPW(source), this.getPatchUp(source), this.getPatchDown(source)});
    }

    @Override
    public Patch getPN(Patch source) {
        return this._world3d.fastGetPatchAt(source.pxcor, source.pycor == this.world().maxPycor() ? this.world().minPycor() : source.pycor + 1, ((Patch3D)source).pzcor);
    }

    @Override
    public Patch getPE(Patch source) {
        return this._world3d.fastGetPatchAt(source.pxcor == this.world().maxPxcor() ? this.world().minPxcor() : source.pxcor + 1, source.pycor, ((Patch3D)source).pzcor);
    }

    @Override
    public Patch getPS(Patch source) {
        return this._world3d.fastGetPatchAt(source.pxcor, source.pycor == this.world().minPycor() ? this.world().maxPycor() : source.pycor - 1, ((Patch3D)source).pzcor);
    }

    @Override
    public Patch getPW(Patch source) {
        return this._world3d.fastGetPatchAt(source.pxcor == this.world().minPxcor() ? this.world().maxPxcor() : source.pxcor - 1, source.pycor, ((Patch3D)source).pzcor);
    }

    @Override
    public Patch getPNE(Patch source) {
        return this._world3d.fastGetPatchAt(source.pxcor == this.world().maxPxcor() ? this.world().minPxcor() : source.pxcor + 1, source.pycor == this.world().maxPycor() ? this.world().minPycor() : source.pycor + 1, ((Patch3D)source).pzcor);
    }

    @Override
    public Patch getPSE(Patch source) {
        return this._world3d.fastGetPatchAt(source.pxcor == this.world().maxPxcor() ? this.world().minPxcor() : source.pxcor + 1, source.pycor == this.world().minPycor() ? this.world().maxPycor() : source.pycor - 1, ((Patch3D)source).pzcor);
    }

    @Override
    public Patch getPSW(Patch source) {
        return this._world3d.fastGetPatchAt(source.pxcor == this.world().minPxcor() ? this.world().maxPxcor() : source.pxcor - 1, source.pycor == this.world().minPycor() ? this.world().maxPycor() : source.pycor - 1, ((Patch3D)source).pzcor);
    }

    @Override
    public Patch getPNW(Patch source) {
        return this._world3d.fastGetPatchAt(source.pxcor == this.world().minPxcor() ? this.world().maxPxcor() : source.pxcor - 1, source.pycor == this.world().maxPycor() ? this.world().minPycor() : source.pycor + 1, ((Patch3D)source).pzcor);
    }

    @Override
    public Patch getPNU(Patch3D source) {
        return this.getPN(this.getPatchUp(source));
    }

    @Override
    public Patch getPEU(Patch3D source) {
        return this.getPE(this.getPatchUp(source));
    }

    @Override
    public Patch getPSU(Patch3D source) {
        return this.getPS(this.getPatchUp(source));
    }

    @Override
    public Patch getPWU(Patch3D source) {
        return this.getPW(this.getPatchUp(source));
    }

    @Override
    public Patch getPNEU(Patch3D source) {
        return this.getPNE(this.getPatchUp(source));
    }

    @Override
    public Patch getPSEU(Patch3D source) {
        return this.getPSE(this.getPatchUp(source));
    }

    @Override
    public Patch getPSWU(Patch3D source) {
        return this.getPSW(this.getPatchUp(source));
    }

    @Override
    public Patch getPNWU(Patch3D source) {
        return this.getPNW(this.getPatchUp(source));
    }

    @Override
    public Patch getPND(Patch3D source) {
        return this.getPN(this.getPatchDown(source));
    }

    @Override
    public Patch getPED(Patch3D source) {
        return this.getPE(this.getPatchDown(source));
    }

    @Override
    public Patch getPSD(Patch3D source) {
        return this.getPS(this.getPatchDown(source));
    }

    @Override
    public Patch getPWD(Patch3D source) {
        return this.getPW(this.getPatchDown(source));
    }

    @Override
    public Patch getPNED(Patch3D source) {
        return this.getPNE(this.getPatchDown(source));
    }

    @Override
    public Patch getPSED(Patch3D source) {
        return this.getPSE(this.getPatchDown(source));
    }

    @Override
    public Patch getPSWD(Patch3D source) {
        return this.getPSW(this.getPatchDown(source));
    }

    @Override
    public Patch getPNWD(Patch3D source) {
        return this.getPNW(this.getPatchDown(source));
    }

    public Patch getPatchUp(Patch3D source) {
        if (source.pzcor == this._world3d.maxPzcor()) {
            return this._world3d.fastGetPatchAt(source.pxcor, source.pycor, this._world3d.minPzcor());
        }
        return this._world3d.fastGetPatchAt(source.pxcor, source.pycor, source.pzcor + 1);
    }

    public Patch getPatchDown(Patch3D source) {
        if (source.pzcor == this._world3d.minPzcor()) {
            return this._world3d.fastGetPatchAt(source.pxcor, source.pycor, this._world3d.maxPzcor());
        }
        return this._world3d.fastGetPatchAt(source.pxcor, source.pycor, source.pzcor - 1);
    }

    @Override
    public double wrapZ(double z) {
        return Topology$.MODULE$.wrap(z, (double)this._world3d.minPzcor() - 0.5, (double)this._world3d.maxPzcor() + 0.5);
    }

    @Override
    public double shortestPathZ(double z1, double z2) {
        double zprime;
        int depth = this._world3d.worldDepth();
        double d = zprime = z1 > z2 ? z2 + (double)depth : z2 - (double)depth;
        if (StrictMath.abs(z2 - z1) > StrictMath.abs(zprime - z1)) {
            return zprime;
        }
        return z2;
    }

    @Override
    public double observerZ() {
        return this.world().observer().ozcor();
    }

    @Override
    public double distanceWrap(double _dx2, double _dy2, double _dz2, double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx2 = x1 > x2 ? x2 + (double)this.world().worldWidth() - x1 : x2 - (double)this.world().worldWidth() - x1;
        double dx = StrictMath.abs(dx2) < StrictMath.abs(_dx2) ? dx2 : _dx2;
        double dy2 = y1 > y2 ? y2 + (double)this.world().worldHeight() - y1 : y2 - (double)this.world().worldHeight() - y1;
        double dy = StrictMath.abs(dy2) < StrictMath.abs(_dy2) ? dy2 : _dy2;
        double dz2 = z1 > z2 ? z2 + (double)this._world3d.worldDepth() - z1 : z2 - (double)this._world3d.worldDepth() - z1;
        double dz = StrictMath.abs(dz2) < StrictMath.abs(_dz2) ? dz2 : _dz2;
        return StrictMath.sqrt(dx * dx + dy * dy + dz * dz);
    }

    @Override
    public double towardsPitchWrap(double _dx2, double _dy2, double _dz2) {
        World3D w = (World3D)this.world();
        double dx = Topology$.MODULE$.wrap(_dx2, -((double)this.world().worldWidth()) / 2.0, (double)this.world().worldWidth() / 2.0);
        double dy = Topology$.MODULE$.wrap(_dy2, -((double)this.world().worldHeight()) / 2.0, (double)this.world().worldHeight() / 2.0);
        double dz = Topology$.MODULE$.wrap(_dz2, -((double)w.worldDepth()) / 2.0, (double)w.worldDepth() / 2.0);
        return ((double)360 + StrictMath.toDegrees(StrictMath.atan(dz / StrictMath.sqrt(dx * dx + dy * dy)))) % (double)360;
    }

    @Override
    public Patch getPatchAt(double xc, double yc, double zc) throws AgentException {
        return this._world3d.getPatchAt(xc, yc, zc);
    }

    @Override
    public void diffuse(double diffuseparam, int vn) throws PatchException, AgentException {
        World3D w = this._world3d;
        int xx = w.worldWidth();
        int xx2 = xx * 2;
        int yy = w.worldHeight();
        int yy2 = yy * 2;
        int zz = w.worldDepth();
        int zz2 = zz * 2;
        double[][][] scratch = w.getPatchScratch3d();
        int z = 0;
        int y = 0;
        int x = 0;
        try {
            for (z = 0; z < zz; ++z) {
                for (y = 0; y < yy; ++y) {
                    for (x = 0; x < xx; ++x) {
                        scratch[x][y][z] = ((Number)w.fastGetPatchAt((int)this.wrapX(Int$.MODULE$.int2double(x)), (int)this.wrapY(Int$.MODULE$.int2double(y)), (int)this.wrapZ(Int$.MODULE$.int2double(z))).getPatchVariable(vn)).doubleValue();
                    }
                }
            }
        }
        catch (ClassCastException ex) {
            throw new PatchException(w.fastGetPatchAt((int)this.wrapX(Int$.MODULE$.int2double(x)), (int)this.wrapY(Int$.MODULE$.int2double(y)), (int)this.wrapZ(Int$.MODULE$.int2double(z))));
        }
        for (z = zz; z < zz2; ++z) {
            for (y = yy; y < yy2; ++y) {
                for (x = xx; x < xx2; ++x) {
                    double sum = 0.0;
                    sum = scratch[(x - 1) % xx][(y - 1) % yy][z % zz];
                    sum += scratch[(x - 1) % xx][y % yy][z % zz];
                    sum += scratch[(x - 1) % xx][(y + 1) % yy][z % zz];
                    sum += scratch[x % xx][(y - 1) % yy][z % zz];
                    sum += scratch[x % xx][(y + 1) % yy][z % zz];
                    sum += scratch[(x + 1) % xx][(y - 1) % yy][z % zz];
                    sum += scratch[(x + 1) % xx][y % yy][z % zz];
                    sum += scratch[(x + 1) % xx][(y + 1) % yy][z % zz];
                    sum += scratch[(x - 1) % xx][(y - 1) % yy][(z - 1) % zz];
                    sum += scratch[(x - 1) % xx][y % yy][(z - 1) % zz];
                    sum += scratch[(x - 1) % xx][(y + 1) % yy][(z - 1) % zz];
                    sum += scratch[x % xx][(y - 1) % yy][(z - 1) % zz];
                    sum += scratch[x % xx][(y + 1) % yy][(z - 1) % zz];
                    sum += scratch[(x + 1) % xx][(y - 1) % yy][(z - 1) % zz];
                    sum += scratch[(x + 1) % xx][y % yy][(z - 1) % zz];
                    sum += scratch[(x + 1) % xx][(y + 1) % yy][(z - 1) % zz];
                    sum += scratch[x % xx][y % yy][(z - 1) % zz];
                    sum += scratch[(x - 1) % xx][(y - 1) % yy][(z + 1) % zz];
                    sum += scratch[(x - 1) % xx][y % yy][(z + 1) % zz];
                    sum += scratch[(x - 1) % xx][(y + 1) % yy][(z + 1) % zz];
                    sum += scratch[x % xx][(y - 1) % yy][(z + 1) % zz];
                    sum += scratch[x % xx][(y + 1) % yy][(z + 1) % zz];
                    sum += scratch[(x + 1) % xx][(y - 1) % yy][(z + 1) % zz];
                    sum += scratch[(x + 1) % xx][y % yy][(z + 1) % zz];
                    sum += scratch[(x + 1) % xx][(y + 1) % yy][(z + 1) % zz];
                    double oldval = scratch[x - xx][y - yy][z - zz];
                    double newval = oldval * (1.0 - diffuseparam) + (sum += scratch[x % xx][y % yy][(z + 1) % zz]) / (double)26 * diffuseparam;
                    if (newval == oldval) continue;
                    w.getPatchAt(Int$.MODULE$.int2double(x - xx), Int$.MODULE$.int2double(y - yy), Int$.MODULE$.int2double(z - zz)).setPatchVariable(vn, BoxesRunTime.boxToDouble((double)newval));
                }
            }
        }
    }
}

