/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentIterator;
import org.nlogo.agent.AgentManagement;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.ArrayAgentSet;
import org.nlogo.agent.CompilationManagement;
import org.nlogo.agent.Directedness$Undetermined$;
import org.nlogo.agent.Exporter;
import org.nlogo.agent.Importer;
import org.nlogo.agent.ImporterJ;
import org.nlogo.agent.InRadiusOrCone;
import org.nlogo.agent.Link;
import org.nlogo.agent.LinkFactory;
import org.nlogo.agent.LinkManager;
import org.nlogo.agent.LinkManagerImpl;
import org.nlogo.agent.Observer;
import org.nlogo.agent.Patch;
import org.nlogo.agent.PatchException;
import org.nlogo.agent.Protractor;
import org.nlogo.agent.RootsTable;
import org.nlogo.agent.TieManager;
import org.nlogo.agent.Topology$;
import org.nlogo.agent.TreeAgentSet;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.Turtle2D;
import org.nlogo.agent.World;
import org.nlogo.agent.World$;
import org.nlogo.api.AgentException;
import org.nlogo.api.Color$;
import org.nlogo.api.CompilerServices;
import org.nlogo.api.ImporterUser;
import org.nlogo.core.AgentKind;
import org.nlogo.core.AgentKind$Link$;
import org.nlogo.core.AgentKind$Patch$;
import org.nlogo.core.Dialect;
import org.nlogo.core.Program;
import org.nlogo.core.WorldDimensions;
import org.nlogo.core.WorldDimensions$;
import org.nlogo.log.LogManager$;
import scala.Int$;
import scala.Predef$;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.Statics;

public class World2D
extends World
implements CompilationManagement,
AgentManagement {
    private Dialect org$nlogo$agent$CompilationManagement$$defaultDialect;
    private Program org$nlogo$agent$CompilationManagement$$_oldProgram;
    private CompilerServices org$nlogo$agent$CompilationManagement$$_compiler;
    private Program org$nlogo$agent$CompilationManagement$$_program;
    private final Protractor protractor;
    private final LinkManager linkManager;
    private final TreeAgentSet _links;
    private final TieManager tieManager;
    private final Seq<String> dimensionVariableNames;
    private final World.InRadiusOrCone inRadiusOrCone;

    public World2D() {
        CompilationManagement.$init$(this);
        this.protractor = new Protractor(this);
        this.linkManager = new LinkManagerImpl<World>(this, new LinkFactory<World>(this){
            private final /* synthetic */ World2D $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final Link apply(World world, Turtle src, Turtle dest, AgentSet breed) {
                return this.$outer.org$nlogo$agent$World2D$$_$$lessinit$greater$$anonfun$1(world, src, dest, breed);
            }
        });
        this._links = new TreeAgentSet(AgentKind$Link$.MODULE$, "LINKS");
        this.tieManager = new TieManager(this._links(), this.linkManager(), this.protractor());
        this.dimensionVariableNames = (Seq)((SeqOps)new .colon.colon((Object)"MIN-PXCOR", (List)new .colon.colon((Object)"MAX-PXCOR", (List)new .colon.colon((Object)"MIN-PYCOR", (List)new .colon.colon((Object)"MAX-PYCOR", (List)new .colon.colon((Object)"WORLD-WIDTH", (List)new .colon.colon((Object)"WORLD-HEIGHT", (List)Nil$.MODULE$)))))));
        this.inRadiusOrCone = new InRadiusOrCone(this);
        this.changeTopology(true, true);
        this.createPatches(this._minPxcor, this._maxPxcor, this._minPycor, this._maxPycor);
        this.setUpShapes(true);
        Statics.releaseFence();
    }

    @Override
    public Dialect org$nlogo$agent$CompilationManagement$$defaultDialect() {
        return this.org$nlogo$agent$CompilationManagement$$defaultDialect;
    }

    @Override
    public Program org$nlogo$agent$CompilationManagement$$_oldProgram() {
        return this.org$nlogo$agent$CompilationManagement$$_oldProgram;
    }

    @Override
    public CompilerServices org$nlogo$agent$CompilationManagement$$_compiler() {
        return this.org$nlogo$agent$CompilationManagement$$_compiler;
    }

    @Override
    public Program org$nlogo$agent$CompilationManagement$$_program() {
        return this.org$nlogo$agent$CompilationManagement$$_program;
    }

    @Override
    public void org$nlogo$agent$CompilationManagement$$_oldProgram_$eq(Program x$1) {
        this.org$nlogo$agent$CompilationManagement$$_oldProgram = x$1;
    }

    @Override
    public void org$nlogo$agent$CompilationManagement$$_compiler_$eq(CompilerServices x$1) {
        this.org$nlogo$agent$CompilationManagement$$_compiler = x$1;
    }

    @Override
    public void org$nlogo$agent$CompilationManagement$$_program_$eq(Program x$1) {
        this.org$nlogo$agent$CompilationManagement$$_program = x$1;
    }

    @Override
    public void org$nlogo$agent$CompilationManagement$_setter_$org$nlogo$agent$CompilationManagement$$defaultDialect_$eq(Dialect x$0) {
        this.org$nlogo$agent$CompilationManagement$$defaultDialect = x$0;
    }

    @Override
    public Protractor protractor() {
        return this.protractor;
    }

    @Override
    public LinkManager linkManager() {
        return this.linkManager;
    }

    @Override
    public TreeAgentSet _links() {
        return this._links;
    }

    @Override
    public TieManager tieManager() {
        return this.tieManager;
    }

    @Override
    public Seq<String> dimensionVariableNames() {
        return this.dimensionVariableNames;
    }

    @Override
    public World.InRadiusOrCone inRadiusOrCone() {
        return this.inRadiusOrCone;
    }

    @Override
    public Observer createObserver() {
        return new Observer(this);
    }

    @Override
    public void changeTopology(boolean xWrapping, boolean yWrapping) {
        this._topology_$eq(Topology$.MODULE$.get(this, xWrapping, yWrapping));
        if (this._patches() != null) {
            AgentIterator it = this._patches().iterator();
            while (it.hasNext()) {
                ((Patch)it.next()).topologyChanged();
            }
            return;
        }
    }

    @Override
    public void exportWorld(PrintWriter writer, boolean full) {
        new Exporter(this, writer).exportWorld(full);
    }

    @Override
    public void importWorld(ImporterJ.ErrorHandler errorHandler, ImporterUser importerUser, ImporterJ.StringReader stringReader, BufferedReader reader) throws IOException {
        new Importer(errorHandler, this, importerUser, stringReader).importWorld(reader);
    }

    public void drawLine(double x0, double y0, double x1, double y1, Object color, double size, String mode) {
        this.trailDrawer().drawLine(x0, y0, x1, y1, color, size, mode);
    }

    @Override
    public void diffuse(double param, int vn) throws PatchException, AgentException {
        this.topology().diffuse(param, vn);
    }

    @Override
    public void diffuse4(double param, int vn) throws PatchException, AgentException {
        this.topology().diffuse4(param, vn);
    }

    @Override
    public WorldDimensions getDimensions() {
        return WorldDimensions$.MODULE$.apply(this._minPxcor, this._maxPxcor, this._minPycor, this._maxPycor, this.patchSize(), this.wrappingAllowedInX(), this.wrappingAllowedInY());
    }

    @Override
    public Turtle getOrCreateTurtle(long id) {
        Turtle turtle = this.getTurtle(id);
        if (turtle == null) {
            Turtle2D newTurtle = new Turtle2D(this, id);
            this.nextTurtleIndex(StrictMath.max(this.nextTurtleIndex(), id + 1L));
            return newTurtle;
        }
        return turtle;
    }

    @Override
    public Turtle createTurtle(AgentSet breed) {
        Turtle2D baby = new Turtle2D(this, breed, World$.MODULE$.Zero(), World$.MODULE$.Zero());
        LogManager$.MODULE$.turtleCreated(baby.id(), breed.printName());
        return baby;
    }

    @Override
    public Turtle createTurtle(AgentSet breed, int c, int h) {
        Turtle2D baby = new Turtle2D(this, breed, World$.MODULE$.Zero(), World$.MODULE$.Zero());
        baby.colorDoubleUnchecked(Int$.MODULE$.int2double(5 + 10 * c));
        baby.heading(Int$.MODULE$.int2double(h));
        LogManager$.MODULE$.turtleCreated(baby.id(), breed.printName());
        return baby;
    }

    @Override
    public Patch getPatchAt(double x, double y) throws AgentException {
        int xc = this.wrapAndRoundX(x);
        int yc = this.wrapAndRoundY(y);
        int id = this._worldWidth * (this._maxPycor - yc) + xc - this._minPxcor;
        return this.getPatch(id);
    }

    public Patch getPatchAtWrap(double x, double y) {
        int intPart;
        double fractPart;
        int intPart2;
        double fractPart2;
        int xc;
        int minPx = this._minPxcor;
        int maxPy = this._maxPycor;
        double wrappedX = Topology$.MODULE$.wrap(x, (double)minPx - 0.5, (double)this._maxPxcor + 0.5);
        double wrappedY = Topology$.MODULE$.wrap(y, (double)this._minPycor - 0.5, (double)maxPy + 0.5);
        int n = wrappedX > 0.0 ? (int)(wrappedX + 0.5) : (xc = (fractPart2 = (double)(intPart2 = (int)wrappedX) - wrappedX) > 0.5 ? intPart2 - 1 : intPart2);
        int yc = wrappedY > 0.0 ? (int)(wrappedY + 0.5) : ((fractPart = (double)(intPart = (int)wrappedY) - wrappedY) > 0.5 ? intPart - 1 : intPart);
        int patchid = this._worldWidth * (maxPy - yc) + xc - minPx;
        return this.getPatch(patchid);
    }

    public Patch getPatchAtWrap(int x, int y) {
        return this.fastGetPatchAt(Topology$.MODULE$.wrapPcor(x, this._minPxcor, this._maxPxcor), Topology$.MODULE$.wrapPcor(y, this._minPycor, this._maxPycor));
    }

    @Override
    public Patch fastGetPatchAt(int xc, int yc) {
        return this.getPatch(this._worldWidth * (this._maxPycor - yc) + xc - this._minPxcor);
    }

    @Override
    public World copy() {
        World2D newWorld = new World2D();
        newWorld.tickCounter().ticks_$eq(this.tickCounter().ticks());
        newWorld.program(this.program());
        this.copyDimensions(newWorld);
        this.copyAgents(newWorld, newWorld);
        this.copyGrossState(newWorld);
        return newWorld;
    }

    @Override
    public void createPatches(int minPxcor, int maxPxcor, int minPycor, int maxPycor) {
        this._patchScratch_$eq(null);
        this._minPxcor = minPxcor;
        this._maxPxcor = maxPxcor;
        this._minPycor = minPycor;
        this._maxPycor = maxPycor;
        this._worldWidth = maxPxcor - minPxcor + 1;
        this._worldHeight = maxPycor - minPycor + 1;
        this._worldWidthBoxed_$eq(Int$.MODULE$.int2double(this._worldWidth));
        this._worldHeightBoxed_$eq(Int$.MODULE$.int2double(this._worldHeight));
        this._minPxcorBoxed_$eq(Int$.MODULE$.int2double(this._minPxcor));
        this._minPycorBoxed_$eq(Int$.MODULE$.int2double(this._minPycor));
        this._maxPxcorBoxed_$eq(Int$.MODULE$.int2double(this._maxPxcor));
        this._maxPycorBoxed_$eq(Int$.MODULE$.int2double(this._maxPycor));
        this.rootsTable_$eq(new RootsTable(this._worldWidth, this._worldHeight));
        this.recreateAllBreeds();
        this._turtles().clear();
        this._links().clear();
        this._links().directed_$eq(Directedness$Undetermined$.MODULE$);
        Agent[] patchArray = new Agent[this._worldWidth * this._worldHeight];
        this._patchColors_$eq(new int[this._worldWidth * this._worldHeight]);
        Arrays.fill(this._patchColors(), Color$.MODULE$.getARGBbyPremodulatedColorNumber(0.0));
        this._patchColorsDirty = true;
        int numVariables = this.program().patchesOwn().size();
        this.observer().resetPerspective();
        int x = minPxcor;
        int y = maxPycor;
        for (int i = 0; i < this._worldWidth * this._worldHeight; ++i) {
            Patch patch = new Patch(this, i, x, y, numVariables);
            if (++x > maxPxcor) {
                x = minPxcor;
                --y;
            }
            patchArray[i] = patch;
        }
        this._patches_$eq(new ArrayAgentSet((AgentKind)AgentKind$Patch$.MODULE$, "patches", patchArray));
        this._patchesWithLabels_$eq(0);
        this._patchesAllBlack = true;
        this._mayHavePartiallyTransparentObjects_$eq(false);
    }

    @Override
    public void clearAll() {
        AgentManagement.clearAll$(this);
    }

    @Override
    public void clearDrawing() {
    }

    @Override
    public void stamp(Agent agent, boolean erase) {
        this.trailDrawer().stamp(agent, erase);
    }

    @Override
    public Turtle sprout(Patch patch, AgentSet breed) {
        return new Turtle2D(this, breed, Predef$.MODULE$.double2Double((double)patch.pxcor), Predef$.MODULE$.double2Double((double)patch.pycor));
    }

    public final /* synthetic */ Link org$nlogo$agent$World2D$$_$$lessinit$greater$$anonfun$1(World world, Turtle src, Turtle dest, AgentSet breed) {
        Link l = new Link(world, src, dest, breed);
        l.setId(this.newLinkId());
        return l;
    }
}

