/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentManagement;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.ArrayAgentSet;
import org.nlogo.agent.CompilationManagement;
import org.nlogo.agent.DimensionManagement;
import org.nlogo.agent.Directedness$Undetermined$;
import org.nlogo.agent.Drawing3D;
import org.nlogo.agent.Exporter3D;
import org.nlogo.agent.Importer3D;
import org.nlogo.agent.ImporterJ;
import org.nlogo.agent.InRadiusOrCone3D;
import org.nlogo.agent.Link;
import org.nlogo.agent.Link3D;
import org.nlogo.agent.LinkFactory;
import org.nlogo.agent.LinkManager;
import org.nlogo.agent.LinkManagerImpl;
import org.nlogo.agent.Observer;
import org.nlogo.agent.Observer3D;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Patch3D;
import org.nlogo.agent.PatchException;
import org.nlogo.agent.Protractor3D;
import org.nlogo.agent.RootsTable;
import org.nlogo.agent.TieManager3D;
import org.nlogo.agent.Topology$;
import org.nlogo.agent.Topology3D;
import org.nlogo.agent.Torus3D;
import org.nlogo.agent.TreeAgentSet;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.Turtle3D;
import org.nlogo.agent.World;
import org.nlogo.agent.World$;
import org.nlogo.api.AgentException;
import org.nlogo.api.Color$;
import org.nlogo.api.CompilerServices;
import org.nlogo.api.ImporterUser;
import org.nlogo.api.NetLogoThreeDDialect$;
import org.nlogo.api.WorldDimensionException;
import org.nlogo.core.AgentKind;
import org.nlogo.core.AgentKind$Link$;
import org.nlogo.core.AgentKind$Patch$;
import org.nlogo.core.AgentKind$Turtle$;
import org.nlogo.core.Breed;
import org.nlogo.core.Dialect;
import org.nlogo.core.Program;
import org.nlogo.core.Program$;
import org.nlogo.core.WorldDimensions;
import org.nlogo.core.WorldDimensions3D;
import org.nlogo.log.LogManager$;
import scala.Array$;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class World3D
extends World
implements org.nlogo.api.World3D,
CompilationManagement,
DimensionManagement,
AgentManagement {
    private Dialect org$nlogo$agent$CompilationManagement$$defaultDialect;
    private Program org$nlogo$agent$CompilationManagement$$_oldProgram;
    private CompilerServices org$nlogo$agent$CompilationManagement$$_compiler;
    private Program org$nlogo$agent$CompilationManagement$$_program;
    private final Drawing3D drawing;
    private final Protractor3D protractor;
    private double[][][] _patchScratch3d;
    private final LinkManager linkManager;
    private final TreeAgentSet _links;
    private final TieManager3D tieManager;
    private final World.InRadiusOrCone inRadiusOrCone;
    private final Seq<String> dimensionVariableNames;
    private int _worldDepth;
    private int _maxPzcor;
    private int _minPzcor;
    private Double _worldDepthBoxed;
    private Double _maxPzcorBoxed;
    private Double _minPzcorBoxed;
    private final boolean wrappingAllowedInZ;

    public World3D() {
        CompilationManagement.$init$(this);
        this.drawing = new Drawing3D(this);
        this.protractor = new Protractor3D(this);
        this._patchScratch3d = (double[][][])Array$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new double[0][][]), ClassTag$.MODULE$.apply(Double.TYPE).wrap().wrap());
        this.linkManager = new LinkManagerImpl<World3D>(this, new LinkFactory<World3D>(this){
            private final /* synthetic */ World3D $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final Link apply(World3D world, Turtle src, Turtle dest, AgentSet breed) {
                return this.$outer.org$nlogo$agent$World3D$$_$$lessinit$greater$$anonfun$1(world, src, dest, breed);
            }
        });
        this._links = new TreeAgentSet(AgentKind$Link$.MODULE$, "LINKS");
        this.tieManager = new TieManager3D(this._links(), this.linkManager(), this.protractor());
        this.inRadiusOrCone = new InRadiusOrCone3D(this);
        this._mayHavePartiallyTransparentObjects_$eq(false);
        this.dimensionVariableNames = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MIN-PXCOR", "MAX-PXCOR", "MIN-PYCOR", "MAX-PYCOR", "MIN-PZCOR", "MAX-PZCOR", "WORLD-WIDTH", "WORLD-HEIGHT", "WORLD-DEPTH"}));
        this._worldDepth = 0;
        this._maxPzcor = 0;
        this._minPzcor = 0;
        this._worldDepthBoxed = Int$.MODULE$.int2double(this._worldDepth());
        this._maxPzcorBoxed = Int$.MODULE$.int2double(this._maxPzcor());
        this._minPzcorBoxed = Int$.MODULE$.int2double(this._minPzcor());
        this._topology_$eq(new Torus3D(this));
        this.createPatches(this._minPxcor, this._maxPxcor, this._minPycor, this._maxPycor, this._minPzcor(), this._maxPzcor());
        this.wrappingAllowedInZ = true;
        Statics.releaseFence();
    }

    @Override
    public Dialect org$nlogo$agent$CompilationManagement$$defaultDialect() {
        return this.org$nlogo$agent$CompilationManagement$$defaultDialect;
    }

    @Override
    public Program org$nlogo$agent$CompilationManagement$$_oldProgram() {
        return this.org$nlogo$agent$CompilationManagement$$_oldProgram;
    }

    @Override
    public CompilerServices org$nlogo$agent$CompilationManagement$$_compiler() {
        return this.org$nlogo$agent$CompilationManagement$$_compiler;
    }

    @Override
    public Program org$nlogo$agent$CompilationManagement$$_program() {
        return this.org$nlogo$agent$CompilationManagement$$_program;
    }

    @Override
    public void org$nlogo$agent$CompilationManagement$$_oldProgram_$eq(Program x$1) {
        this.org$nlogo$agent$CompilationManagement$$_oldProgram = x$1;
    }

    @Override
    public void org$nlogo$agent$CompilationManagement$$_compiler_$eq(CompilerServices x$1) {
        this.org$nlogo$agent$CompilationManagement$$_compiler = x$1;
    }

    @Override
    public void org$nlogo$agent$CompilationManagement$$_program_$eq(Program x$1) {
        this.org$nlogo$agent$CompilationManagement$$_program = x$1;
    }

    @Override
    public void org$nlogo$agent$CompilationManagement$_setter_$org$nlogo$agent$CompilationManagement$$defaultDialect_$eq(Dialect x$0) {
        this.org$nlogo$agent$CompilationManagement$$defaultDialect = x$0;
    }

    public Drawing3D drawing() {
        return this.drawing;
    }

    @Override
    public Protractor3D protractor() {
        return this.protractor;
    }

    @Override
    public org.nlogo.api.Protractor3D protractor3D() {
        return this.protractor();
    }

    @Override
    public LinkManager linkManager() {
        return this.linkManager;
    }

    @Override
    public TreeAgentSet _links() {
        return this._links;
    }

    @Override
    public TieManager3D tieManager() {
        return this.tieManager;
    }

    @Override
    public World.InRadiusOrCone inRadiusOrCone() {
        return this.inRadiusOrCone;
    }

    @Override
    public Seq<String> dimensionVariableNames() {
        return this.dimensionVariableNames;
    }

    public int _worldDepth() {
        return this._worldDepth;
    }

    public void _worldDepth_$eq(int x$1) {
        this._worldDepth = x$1;
    }

    public int _maxPzcor() {
        return this._maxPzcor;
    }

    public void _maxPzcor_$eq(int x$1) {
        this._maxPzcor = x$1;
    }

    public int _minPzcor() {
        return this._minPzcor;
    }

    public void _minPzcor_$eq(int x$1) {
        this._minPzcor = x$1;
    }

    @Override
    public int worldDepth() {
        return this._worldDepth();
    }

    @Override
    public int minPzcor() {
        return this._minPzcor();
    }

    @Override
    public int maxPzcor() {
        return this._maxPzcor();
    }

    public Double _worldDepthBoxed() {
        return this._worldDepthBoxed;
    }

    public void _worldDepthBoxed_$eq(Double x$1) {
        this._worldDepthBoxed = x$1;
    }

    public Double _maxPzcorBoxed() {
        return this._maxPzcorBoxed;
    }

    public void _maxPzcorBoxed_$eq(Double x$1) {
        this._maxPzcorBoxed = x$1;
    }

    public Double _minPzcorBoxed() {
        return this._minPzcorBoxed;
    }

    public void _minPzcorBoxed_$eq(Double x$1) {
        this._minPzcorBoxed = x$1;
    }

    public Double worldDepthBoxed() {
        return this._worldDepthBoxed();
    }

    public Double maxPzcorBoxed() {
        return this._maxPzcorBoxed();
    }

    public Double minPzcorBoxed() {
        return this._minPzcorBoxed();
    }

    @Override
    public Observer createObserver() {
        return new Observer3D(this);
    }

    @Override
    public void changeTopology(boolean xWrapping, boolean yWrapping) {
        this._topology_$eq(new Torus3D(this));
    }

    public void changeTopology(boolean xWrapping, boolean yWrapping, boolean zWrapping) {
        this._topology_$eq(new Torus3D(this));
    }

    public double shortestPathZ(double z1, double z2) {
        return ((Topology3D)((Object)this.topology())).shortestPathZ(z1, z2);
    }

    public boolean wrappingAllowedInZ() {
        return this.wrappingAllowedInZ;
    }

    @Override
    public double wrappedObserverZ(double z) {
        return ((Topology3D)((Object)this.topology())).wrapZ(z - this.followOffsetZ());
    }

    @Override
    public double followOffsetZ() {
        return ((Observer3D)this.observer()).followOffsetZ();
    }

    @Override
    public void diffuse(double param, int vn) throws PatchException, AgentException {
        this.topology().diffuse(param, vn);
    }

    @Override
    public void diffuse4(double param, int vn) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double wrapZ(double z) {
        return Topology$.MODULE$.wrap(z, (double)this._minPzcor() - 0.5, (double)this._maxPzcor() + 0.5);
    }

    public int wrapAndRoundZ(double _z) {
        double z = ((Topology3D)((Object)this.topology())).wrapZ(_z);
        if (z > 0.0) {
            return (int)(z + 0.5);
        }
        int intPart = (int)z;
        double fractPart = (double)intPart - z;
        if (fractPart > 0.5) {
            return intPart - 1;
        }
        return intPart;
    }

    public Patch getPatchAtWrap(double x, double y, double z) {
        double wrappedX = Topology$.MODULE$.wrap(x, (double)this._minPxcor - 0.5, (double)this._maxPxcor + 0.5);
        double wrappedY = Topology$.MODULE$.wrap(y, (double)this._minPycor - 0.5, (double)this._maxPycor + 0.5);
        double wrappedZ = Topology$.MODULE$.wrap(z, (double)this._minPzcor() - 0.5, (double)this._maxPzcor() + 0.5);
        int xc = World3D.roundBase$1(wrappedX);
        int yc = World3D.roundBase$1(wrappedY);
        int zc = World3D.roundBase$1(wrappedZ);
        int patchid = this._worldWidth * this._worldHeight * (this._maxPzcor() - zc) + this._worldWidth * (this._maxPycor - yc) + xc - this._minPxcor;
        return (Patch)this._patches().getByIndex(patchid);
    }

    public boolean validPatchCoordinates(int xc, int yc, int zc) {
        return xc >= this._minPxcor && xc <= this._maxPxcor && yc >= this._minPycor && yc <= this._maxPycor && zc >= this._minPzcor() && zc <= this._maxPzcor();
    }

    public Patch fastGetPatchAt(int xc, int yc, int zc) {
        return (Patch)this._patches().getByIndex(this._worldWidth * this._worldHeight * (this._maxPzcor() - zc) + this._worldWidth * (this._maxPycor - yc) + xc - this._minPxcor);
    }

    @Override
    public Patch fastGetPatchAt(int xc, int yc) {
        return this.fastGetPatchAt(xc, yc, 0);
    }

    @Override
    public void createPatches(WorldDimensions dim) {
        WorldDimensions3D d = (WorldDimensions3D)dim;
        this.createPatches(dim.minPxcor(), dim.maxPxcor(), dim.minPycor(), dim.maxPycor(), d.minPzcor(), d.maxPzcor());
    }

    @Override
    public void createPatches(int minPxcor, int maxPxcor, int minPycor, int maxPycor) {
        this.createPatches(minPxcor, maxPxcor, minPycor, maxPycor, 0, 0);
    }

    @Override
    public Program newProgram() {
        return Program$.MODULE$.fromDialect(NetLogoThreeDDialect$.MODULE$);
    }

    @Override
    public Program newProgram(Seq<String> interfaceGlobals) {
        Program program = this.newProgram();
        return program.copy(interfaceGlobals, program.copy$default$2(), program.copy$default$3(), program.copy$default$4(), program.copy$default$5(), program.copy$default$6(), program.copy$default$7(), program.copy$default$8());
    }

    @Override
    public World copy() {
        return null;
    }

    public void createPatches(int minPxcor, int maxPxcor, int minPycor, int maxPycor, int minPzcor, int maxPzcor) {
        this._patchScratch_$eq(null);
        this._patchScratch3d = null;
        this._minPxcor = minPxcor;
        this._maxPxcor = maxPxcor;
        this._minPycor = minPycor;
        this._maxPycor = maxPycor;
        this._minPzcor_$eq(minPzcor);
        this._maxPzcor_$eq(maxPzcor);
        this._worldWidth = this._maxPxcor - this._minPxcor + 1;
        this._worldHeight = this._maxPycor - this._minPycor + 1;
        this._worldDepth_$eq(this._maxPzcor() - this._minPzcor() + 1);
        this.rootsTable_$eq(new RootsTable(this._worldWidth, this._worldHeight));
        this._worldWidthBoxed_$eq(Int$.MODULE$.int2double(this._worldWidth));
        this._worldHeightBoxed_$eq(Int$.MODULE$.int2double(this._worldHeight));
        this._worldDepthBoxed_$eq(Int$.MODULE$.int2double(this._worldDepth()));
        this._minPxcorBoxed_$eq(Int$.MODULE$.int2double(this._minPxcor));
        this._minPycorBoxed_$eq(Int$.MODULE$.int2double(this._minPycor));
        this._minPzcorBoxed_$eq(Int$.MODULE$.int2double(this._minPzcor()));
        this._maxPxcorBoxed_$eq(Int$.MODULE$.int2double(this._maxPxcor));
        this._maxPycorBoxed_$eq(Int$.MODULE$.int2double(this._maxPycor));
        this._maxPzcorBoxed_$eq(Int$.MODULE$.int2double(this._maxPzcor()));
        this.breeds().clear();
        this.program().breeds().foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Breed breed = (Breed)tuple2._2();
                TreeAgentSet agentset = new TreeAgentSet(AgentKind$Turtle$.MODULE$, breed.name());
                return this.breeds().put(name.toUpperCase(Locale.ENGLISH), agentset);
            }
            throw new MatchError((Object)tuple2);
        });
        this._turtles().clear();
        this._links().clear();
        this._links().directed_$eq(Directedness$Undetermined$.MODULE$);
        int x = this._minPxcor;
        int y = this._maxPycor;
        int z = this._maxPzcor();
        Agent[] patchArray = new Agent[this._worldWidth * this._worldHeight * this._worldDepth()];
        this._patchColors_$eq(new int[this._worldWidth * this._worldHeight * this._worldDepth()]);
        Arrays.fill(this._patchColors(), Color$.MODULE$.getARGBbyPremodulatedColorNumber(0.0));
        this._patchColorsDirty = true;
        int numVariables = this.program().patchesOwn().size();
        this.observer().resetPerspective();
        for (int i = 0; i < this._worldWidth * this._worldHeight * this._worldDepth(); ++i) {
            Patch3D patch = new Patch3D(this, i, x, y, z, numVariables);
            if (++x == this._maxPxcor + 1) {
                x = this._minPxcor;
                if (--y == this._minPycor - 1) {
                    y = this._maxPycor;
                    --z;
                }
            }
            patchArray[i] = patch;
        }
        this._patches_$eq(new ArrayAgentSet((AgentKind)AgentKind$Patch$.MODULE$, "patches", patchArray));
        this._patchesWithLabels_$eq(0);
        this._patchesAllBlack = true;
        this._mayHavePartiallyTransparentObjects_$eq(false);
    }

    @Override
    public void exportWorld(PrintWriter writer, boolean full) {
        new Exporter3D(this, writer).exportWorld(full);
    }

    @Override
    public void importWorld(ImporterJ.ErrorHandler errorHandler, ImporterUser importerUser, ImporterJ.StringReader stringReader, BufferedReader reader) throws IOException {
        new Importer3D(errorHandler, this, importerUser, stringReader).importWorld(reader);
    }

    @Override
    public Turtle getOrCreateTurtle(long id) {
        Turtle turtle = this.getTurtle(id);
        if (turtle == null) {
            return new Turtle3D(this, id);
        }
        return turtle;
    }

    public double[][][] getPatchScratch3d() {
        if (this._patchScratch3d == null) {
            this._patchScratch3d = new double[this._worldWidth][this._worldHeight][this._worldDepth()];
        }
        return this._patchScratch3d;
    }

    @Override
    public WorldDimensions getDimensions() {
        return new WorldDimensions3D(this._minPxcor, this._maxPxcor, this._minPycor, this._maxPycor, this._minPzcor(), this._maxPzcor(), 12.0, true, true, true);
    }

    @Override
    public WorldDimensions setDimensionVariable(String variableName, int value, WorldDimensions d) throws WorldDimensionException {
        WorldDimensions3D wd = (WorldDimensions3D)d;
        String string = variableName.toUpperCase(Locale.ENGLISH);
        switch (string == null ? 0 : string.hashCode()) {
            case -1488152639: {
                if (!"MIN-PZCOR".equals(string)) break;
                return wd.copyThreeD(wd.copyThreeD$default$1(), wd.copyThreeD$default$2(), wd.copyThreeD$default$3(), wd.copyThreeD$default$4(), value, wd.copyThreeD$default$6(), wd.copyThreeD$default$7(), wd.copyThreeD$default$8(), wd.copyThreeD$default$9(), wd.copyThreeD$default$10());
            }
            case -1359467384: {
                if (!"WORLD-DEPTH".equals(string)) break;
                int newMin = this.growMin(wd.minPzcor(), wd.maxPzcor(), value, wd.minPzcor());
                int newMax = this.growMax(wd.minPzcor(), wd.maxPzcor(), value, wd.maxPzcor());
                return wd.copyThreeD(wd.copyThreeD$default$1(), wd.copyThreeD$default$2(), wd.copyThreeD$default$3(), wd.copyThreeD$default$4(), newMin, newMax, wd.copyThreeD$default$7(), wd.copyThreeD$default$8(), wd.copyThreeD$default$9(), wd.copyThreeD$default$10());
            }
            case 2034336083: {
                if (!"MAX-PZCOR".equals(string)) break;
                return wd.copyThreeD(wd.copyThreeD$default$1(), wd.copyThreeD$default$2(), wd.copyThreeD$default$3(), wd.copyThreeD$default$4(), wd.copyThreeD$default$5(), value, wd.copyThreeD$default$7(), wd.copyThreeD$default$8(), wd.copyThreeD$default$9(), wd.copyThreeD$default$10());
            }
        }
        String other = string;
        WorldDimensions newWd = DimensionManagement.setDimensionVariable$(this, variableName, value, d);
        return new WorldDimensions3D(newWd.minPxcor(), newWd.maxPxcor(), newWd.minPycor(), newWd.maxPycor(), wd.minPzcor(), wd.maxPzcor(), 12.0, true, true, true);
    }

    @Override
    public boolean equalDimensions(WorldDimensions d) {
        return d.minPxcor() == this._minPxcor && d.maxPxcor() == this._maxPxcor && d.minPycor() == this._minPycor && d.maxPycor() == this._maxPycor && ((WorldDimensions3D)d).minPzcor() == this._minPzcor() && ((WorldDimensions3D)d).maxPzcor() == this._maxPzcor();
    }

    @Override
    public Patch3D getPatchAt(double x, double y) throws AgentException {
        return this.getPatchAt(x, y, 0.0);
    }

    @Override
    public Patch3D getPatchAt(double x, double y, double z) throws AgentException {
        int xc = this.wrapAndRoundX(x);
        int yc = this.wrapAndRoundY(y);
        int zc = this.wrapAndRoundZ(z);
        int id = this._worldWidth * this._worldHeight * (this._maxPzcor() - zc) + this._worldWidth * (this._maxPycor - yc) + xc - this._minPxcor;
        return (Patch3D)this._patches().getByIndex(id);
    }

    @Override
    public Turtle createTurtle(AgentSet breed) {
        Turtle3D baby = new Turtle3D(this, breed, (Number)World$.MODULE$.Zero(), (Number)World$.MODULE$.Zero(), World$.MODULE$.Zero());
        LogManager$.MODULE$.turtleCreated(baby.id(), breed.printName());
        return baby;
    }

    @Override
    public Turtle createTurtle(AgentSet breed, int c, int h) {
        Turtle3D baby = new Turtle3D(this, breed, (Number)World$.MODULE$.Zero(), (Number)World$.MODULE$.Zero(), World$.MODULE$.Zero());
        baby.colorDoubleUnchecked(Int$.MODULE$.int2double(5 + 10 * c));
        baby.heading(Int$.MODULE$.int2double(h));
        LogManager$.MODULE$.turtleCreated(baby.id(), breed.printName());
        return baby;
    }

    @Override
    public Object getDrawing() {
        return this.drawing();
    }

    @Override
    public boolean sendPixels() {
        return false;
    }

    public void drawLine(double x0, double y0, double x1, double y1, Object color, double size, String mode) {
        this.drawing().drawLine(x0, y0, 0.0, x1, y1, 0.0, size, color);
    }

    public void drawLine(double x0, double y0, double z0, double x1, double y1, double z1, Object color, double size) {
        this.drawing().drawLine(x0, y0, z0, x1, y1, z1, size, color);
    }

    @Override
    public void clearAll() {
        AgentManagement.clearAll$(this);
        this.drawing().clear();
    }

    @Override
    public void clearDrawing() {
        this.drawing().clear();
    }

    @Override
    public void stamp(Agent agent, boolean erase) {
        if (!erase) {
            this.drawing().stamp(agent);
            return;
        }
    }

    @Override
    public Turtle sprout(Patch patch, AgentSet breed) {
        Patch3D p3d = (Patch3D)patch;
        return new Turtle3D(this, breed, Predef$.MODULE$.int2Integer(p3d.pxcor), Predef$.MODULE$.int2Integer(p3d.pycor), Predef$.MODULE$.int2Integer(p3d.pzcor));
    }

    public final /* synthetic */ Link org$nlogo$agent$World3D$$_$$lessinit$greater$$anonfun$1(World3D world, Turtle src, Turtle dest, AgentSet breed) {
        Link3D l = new Link3D((World)world, src, dest, breed);
        l.setId(this.newLinkId());
        return l;
    }

    private static final int roundBase$1(double base) {
        if (base > 0.0) {
            return (int)(base + 0.5);
        }
        int intPart = (int)base;
        double fractPart = (double)intPart - base;
        if (fractPart > 0.5) {
            return intPart - 1;
        }
        return intPart;
    }
}

