/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.analytics;

import java.io.Serializable;
import java.net.URI;
import org.matomo.java.tracking.MatomoException;
import org.matomo.java.tracking.MatomoRequest;
import org.matomo.java.tracking.MatomoRequests;
import org.matomo.java.tracking.MatomoTracker;
import org.matomo.java.tracking.TrackerConfiguration;
import org.nlogo.core.NetLogoPreferences$;
import org.nlogo.core.Token;
import org.nlogo.core.TokenType;
import org.nlogo.core.TokenType$Command$;
import org.nlogo.core.TokenType$Reporter$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class Analytics$
implements Serializable {
    private static boolean sendEnabled;
    private static final String category;
    public static final MatomoTracker org$nlogo$analytics$Analytics$$$tracker;
    private static long startTime;
    public static final Analytics$ MODULE$;

    private Analytics$() {
    }

    static {
        MODULE$ = new Analytics$();
        sendEnabled = false;
        String string = System.getProperty("org.nlogo.release");
        String string2 = "true";
        category = !(string != null ? !string.equals(string2) : string2 != null) ? "Desktop" : "Desktop (Devel)";
        TrackerConfiguration config = TrackerConfiguration.builder().apiEndpoint(URI.create("https://ccl.northwestern.edu:8080/matomo.php")).defaultSiteId(Predef$.MODULE$.int2Integer(1)).build();
        org$nlogo$analytics$Analytics$$$tracker = new MatomoTracker(config);
        startTime = 0L;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Analytics$.class);
    }

    private void wrapRequest(MatomoRequest request, boolean synchronous) {
        if (sendEnabled) {
            if (synchronous) {
                try {
                    new Thread(request){
                        private final MatomoRequest request$1;
                        {
                            this.request$1 = request$2;
                        }

                        public void run() {
                            Analytics$.org$nlogo$analytics$Analytics$$$tracker.sendBulkRequest(new MatomoRequest[]{this.request$1});
                        }
                    }.join(4000L);
                }
                catch (MatomoException e) {
                    Predef$.MODULE$.println((Object)e);
                }
                catch (InterruptedException interruptedException) {}
                return;
            }
            org$nlogo$analytics$Analytics$$$tracker.sendBulkRequestAsync(new MatomoRequest[]{request}).handle((_$1, error) -> {
                Analytics$.wrapRequest$$anonfun$1(_$1, error);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private boolean wrapRequest$default$2() {
        return false;
    }

    private String buildJson(Map<String, Object> properties) {
        return ((IterableOnceOps)properties.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                Object object = tuple2._2();
                String key = string;
                if (object instanceof String) {
                    String value = (String)object;
                    return "\"" + key + "\": \"" + value + "\"";
                }
                String key2 = string;
                if (object instanceof Double) {
                    double value = BoxesRunTime.unboxToDouble((Object)object);
                    return "\"" + key2 + "\": " + value;
                }
                String key3 = string;
                if (object instanceof Integer) {
                    int value = BoxesRunTime.unboxToInt((Object)object);
                    return "\"" + key3 + "\": " + value;
                }
                String key4 = string;
                if (object instanceof Boolean) {
                    boolean value = BoxesRunTime.unboxToBoolean((Object)object);
                    return "\"" + key4 + "\": " + value;
                }
                String key5 = string;
                Object value = object;
                return "\"" + key5 + "\": \"null\"";
            }
            throw new MatchError((Object)tuple2);
        })).mkString("{ ", ", ", " }");
    }

    public void appStart(String version, boolean is3D) {
        startTime = System.currentTimeMillis();
        Object[] objectArray = new Tuple2[4];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"version");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)version);
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"threed");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BoxesRunTime.boxToBoolean((boolean)is3D));
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"os");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)System.getProperty("os.name"));
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"arch");
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)System.getProperty("os.arch"));
        String json = this.buildJson((Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
        this.wrapRequest(MatomoRequests.event((String)category, (String)"App Start", (String)json, null).build(), this.wrapRequest$default$2());
    }

    public void appExit() {
        long length = (System.currentTimeMillis() - startTime) / 60000L;
        if (length > 0L) {
            this.wrapRequest(MatomoRequests.event((String)category, (String)"App Exit", null, (Double)Predef$.MODULE$.double2Double((double)length)).build(), true);
            return;
        }
    }

    public void preferenceChange(String name, String value) {
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)name);
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"value");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)value);
        String json = this.buildJson((Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
        this.wrapRequest(MatomoRequests.event((String)category, (String)"Preference Change", (String)json, null).build(), this.wrapRequest$default$2());
    }

    public void sdmOpen() {
        this.wrapRequest(MatomoRequests.event((String)category, (String)"SDM Open", null, null).build(), this.wrapRequest$default$2());
    }

    public void bspaceOpen() {
        this.wrapRequest(MatomoRequests.event((String)category, (String)"BehaviorSpace Open", null, null).build(), this.wrapRequest$default$2());
    }

    public void bspaceRun() {
        this.wrapRequest(MatomoRequests.event((String)category, (String)"BehaviorSpace Run", null, null).build(), this.wrapRequest$default$2());
    }

    public void threedViewOpen() {
        this.wrapRequest(MatomoRequests.event((String)category, (String)"3D View Open", null, null).build(), this.wrapRequest$default$2());
    }

    public void turtleShapeEditorOpen() {
        this.wrapRequest(MatomoRequests.event((String)category, (String)"Turtle Shape Editor Open", null, null).build(), this.wrapRequest$default$2());
    }

    public void turtleShapeEdit() {
        this.wrapRequest(MatomoRequests.event((String)category, (String)"Turtle Shape Edit", null, null).build(), this.wrapRequest$default$2());
    }

    public void linkShapeEditorOpen() {
        this.wrapRequest(MatomoRequests.event((String)category, (String)"Link Shape Editor Open", null, null).build(), this.wrapRequest$default$2());
    }

    public void linkShapeEdit() {
        this.wrapRequest(MatomoRequests.event((String)category, (String)"Link Shape Edit", null, null).build(), this.wrapRequest$default$2());
    }

    public void colorPickerOpen() {
        this.wrapRequest(MatomoRequests.event((String)category, (String)"Color Picker Open", null, null).build(), this.wrapRequest$default$2());
    }

    public void hubNetEditorOpen() {
        this.wrapRequest(MatomoRequests.event((String)category, (String)"HubNet Editor Open", null, null).build(), this.wrapRequest$default$2());
    }

    public void hubNetClientOpen() {
        this.wrapRequest(MatomoRequests.event((String)category, (String)"HubNet Client Open", null, null).build(), this.wrapRequest$default$2());
    }

    public void globalsMonitorOpen() {
        this.wrapRequest(MatomoRequests.event((String)category, (String)"Globals Monitor Open", null, null).build(), this.wrapRequest$default$2());
    }

    public void turtleMonitorOpen() {
        this.wrapRequest(MatomoRequests.event((String)category, (String)"Turtle Monitor Open", null, null).build(), this.wrapRequest$default$2());
    }

    public void patchMonitorOpen() {
        this.wrapRequest(MatomoRequests.event((String)category, (String)"Patch Monitor Open", null, null).build(), this.wrapRequest$default$2());
    }

    public void linkMonitorOpen() {
        this.wrapRequest(MatomoRequests.event((String)category, (String)"Link Monitor Open", null, null).build(), this.wrapRequest$default$2());
    }

    public void codeHash(int hash) {
        this.wrapRequest(MatomoRequests.event((String)category, (String)"Model Code Hash", (String)BoxesRunTime.boxToInteger((int)hash).toString(), null).build(), this.wrapRequest$default$2());
    }

    public void primUsage(Iterator<Token> tokens) {
        Future$.MODULE$.apply((Function0 & Serializable)() -> {
            this.primUsage$$anonfun$1(tokens);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)ExecutionContext$.MODULE$.global());
    }

    public void includeExtensions(String[] extensions) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])extensions);
        ArrayOps$.MODULE$.foreach$extension(object, extension -> this.wrapRequest(MatomoRequests.event((String)category, (String)"Include Extension", (String)extension, null).build(), this.wrapRequest$default$2()));
    }

    public void loadOldSizeWidgets(int widgets) {
        if (widgets > 0) {
            this.wrapRequest(MatomoRequests.event((String)category, (String)"Load Old Size Widgets", null, (Double)Predef$.MODULE$.double2Double((double)widgets)).build(), this.wrapRequest$default$2());
            return;
        }
    }

    public void modelingCommonsOpen() {
        this.wrapRequest(MatomoRequests.event((String)category, (String)"Modeling Commons Open", null, null).build(), this.wrapRequest$default$2());
    }

    public void modelingCommonsUpload() {
        this.wrapRequest(MatomoRequests.event((String)category, (String)"Modeling Commons Upload", null, null).build(), this.wrapRequest$default$2());
    }

    public void saveAsNetLogoWeb() {
        this.wrapRequest(MatomoRequests.event((String)category, (String)"Save as NetLogo Web", null, null).build(), this.wrapRequest$default$2());
    }

    public void refreshPreference() {
        sendEnabled = NetLogoPreferences$.MODULE$.getBoolean("sendAnalytics", false);
    }

    private static final /* synthetic */ void wrapRequest$$anonfun$1(Void _$1, Throwable error) {
        if (error != null) {
            Predef$.MODULE$.println((Object)error);
            return;
        }
    }

    private static final int $anonfun$1$$anonfun$1() {
        return 0;
    }

    private final void primUsage$$anonfun$1(Iterator tokens$1) {
        Map prims = (Map)tokens$1.foldLeft(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2;
            block2: {
                Map map;
                block4: {
                    Token token;
                    block3: {
                        tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                        if (tuple2 == null) break block2;
                        map = (Map)tuple2._1();
                        token = (Token)tuple2._2();
                        TokenType tokenType = token.tpe();
                        TokenType$Command$ tokenType$Command$ = TokenType$Command$.MODULE$;
                        if (!(tokenType == null ? tokenType$Command$ != null : !tokenType.equals(tokenType$Command$))) break block3;
                        TokenType tokenType2 = token.tpe();
                        TokenType$Reporter$ tokenType$Reporter$ = TokenType$Reporter$.MODULE$;
                        if (tokenType2 != null ? !tokenType2.equals(tokenType$Reporter$) : tokenType$Reporter$ != null) break block4;
                    }
                    String name = token.text().toLowerCase();
                    return (Map)map.$plus(Tuple2$.MODULE$.apply((Object)name, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)map.getOrElse((Object)name, Analytics$::$anonfun$1$$anonfun$1)) + 1))));
                }
                return map;
            }
            throw new MatchError((Object)tuple2);
        });
        if (prims.nonEmpty()) {
            this.wrapRequest(MatomoRequests.event((String)category, (String)"Primitive Usage", (String)this.buildJson((Map<String, Object>)prims), null).build(), this.wrapRequest$default$2());
            return;
        }
    }
}

