/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.List;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public class CSV {
    private final Function1<Object, String> dump;

    public CSV(Function1<Object, String> dump) {
        this.dump = dump;
    }

    public String blank() {
        return "";
    }

    public String data(Object obj) {
        return this.encode((String)this.dump.apply(obj));
    }

    public String number(double d) {
        return this.encode((String)this.dump.apply((Object)Predef$.MODULE$.double2Double(d)));
    }

    public String number(int i) {
        return this.encode((String)this.dump.apply((Object)Predef$.MODULE$.int2Integer(i)));
    }

    public <T> String dataRow(Object objs) {
        Object object = Predef$.MODULE$.genericArrayOps(objs);
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)obj -> this.data(obj), ClassTag$.MODULE$.apply(String.class))).mkString(",");
    }

    public <T> String dataRow(Seq<T> objs) {
        return ((IterableOnceOps)objs.map((Function1 & Serializable)obj -> this.data(obj))).mkString(",");
    }

    public String header(String s) {
        return this.encode(s);
    }

    public String headerRow(String[] strings) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])strings);
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)s -> this.encode((String)s), ClassTag$.MODULE$.apply(String.class))).mkString(",");
    }

    public String encode(String s) {
        String ss = (String)Option$.MODULE$.apply((Object)s).getOrElse(CSV::$anonfun$1);
        return "\"" + StringOps$.MODULE$.flatMap$extension(Predef$.MODULE$.augmentString(ss), (Function1 & Serializable)c -> CSV.escape$1(BoxesRunTime.unboxToChar((Object)c))) + "\"";
    }

    public void stringToCSV(PrintWriter writer, String text) {
        int CellWidth = 10000;
        int MaxColumns = 2;
        int i = 0;
        while (i < StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(text))) {
            StringBuilder line = new StringBuilder();
            int k = 0;
            while (k < MaxColumns && i < StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(text))) {
                int end = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(i + CellWidth), StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(text)));
                line.$plus$plus$eq(text.substring(i, end));
                if ((i += CellWidth) >= StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(text)) || ++k >= MaxColumns) continue;
                line.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)','));
            }
            writer.println(this.data(line.toString()));
        }
    }

    public String variableNameRow(List<String> v) {
        return this.variableNameRow((Seq<String>)CollectionConverters$.MODULE$.ListHasAsScala(v).asScala().toSeq());
    }

    public String variableNameRow(Seq<String> names) {
        return ((IterableOnceOps)names.map((Function1 & Serializable)_$1 -> this.encode((String)_$1).toLowerCase())).mkString(",");
    }

    private static final String escape$1(char c) {
        if (c == '\"') {
            return "\"\"";
        }
        return BoxesRunTime.boxToCharacter((char)c).toString();
    }

    private static final String $anonfun$1() {
        return "null";
    }
}

