/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import java.io.Serializable;
import java.text.DecimalFormat;
import org.nlogo.api.AgentException;
import org.nlogo.api.Approximate$;
import org.nlogo.api.Exceptions$;
import org.nlogo.api.LogoListBuilder;
import org.nlogo.core.Color;
import org.nlogo.core.ColorConstants$;
import org.nlogo.core.I18N$;
import org.nlogo.core.LogoList;
import org.nlogo.core.LogoList$;
import org.nlogo.core.Resource$;
import scala.Float$;
import scala.Function1;
import scala.Int$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.LinkedHashMap;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichFloat$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

public final class Color$
implements Color,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Color$.class.getDeclaredField("colorTranslations$lzy1"));
    private static int NumHues;
    private static int MaxColor;
    private static Double BoxedBlack;
    private static Double BoxedWhite;
    private static int[] org$nlogo$core$Color$$ColorsRGB;
    private static int[] org$nlogo$core$Color$$ARGB_Cache;
    private static LinkedHashMap rgbMap;
    private static final String[] ColorNames;
    private static final java.awt.Color[] AWT_Cache;
    private static final double[] ColorNumbers;
    private static final LogoList BaseColors;
    private static final String ColorTranslations;
    private volatile Object colorTranslations$lzy1;
    public static final Color$ MODULE$;

    private Color$() {
    }

    static {
        MODULE$ = new Color$();
        Color.$init$(MODULE$);
        ColorNames = new String[]{"gray", "red", "orange", "brown", "yellow", "green", "lime", "turquoise", "cyan", "sky", "blue", "violet", "magenta", "pink", "black", "white"};
        Object object = Predef$.MODULE$.intArrayOps((int[])RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), MODULE$.MaxColor() * 10).toArray(ClassTag$.MODULE$.apply(Integer.TYPE)));
        AWT_Cache = (java.awt.Color[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)i -> this.$init$$$anonfun$1(BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(java.awt.Color.class));
        ColorNumbers = new double[]{5.0, 15.0, 25.0, 35.0, 45.0, 55.0, 65.0, 75.0, 85.0, 95.0, 105.0, 115.0, 125.0, 135.0, Int$.MODULE$.int2double(ColorConstants$.MODULE$.Black()), ColorConstants$.MODULE$.White()};
        BaseColors = LogoList$.MODULE$.apply((Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 13).map((Function1 & Serializable)n -> this.$init$$$anonfun$2(BoxesRunTime.unboxToInt((Object)n))));
        ColorTranslations = "/system/color-translation.txt";
        Statics.releaseFence();
    }

    @Override
    public int NumHues() {
        return NumHues;
    }

    @Override
    public int MaxColor() {
        return MaxColor;
    }

    @Override
    public Double BoxedBlack() {
        return BoxedBlack;
    }

    @Override
    public Double BoxedWhite() {
        return BoxedWhite;
    }

    @Override
    public int[] org$nlogo$core$Color$$ColorsRGB() {
        return org$nlogo$core$Color$$ColorsRGB;
    }

    @Override
    public int[] org$nlogo$core$Color$$ARGB_Cache() {
        return org$nlogo$core$Color$$ARGB_Cache;
    }

    public LinkedHashMap rgbMap() {
        return rgbMap;
    }

    @Override
    public void org$nlogo$core$Color$_setter_$NumHues_$eq(int x$0) {
        NumHues = x$0;
    }

    @Override
    public void org$nlogo$core$Color$_setter_$MaxColor_$eq(int x$0) {
        MaxColor = x$0;
    }

    @Override
    public void org$nlogo$core$Color$_setter_$BoxedBlack_$eq(Double x$0) {
        BoxedBlack = x$0;
    }

    @Override
    public void org$nlogo$core$Color$_setter_$BoxedWhite_$eq(Double x$0) {
        BoxedWhite = x$0;
    }

    @Override
    public void org$nlogo$core$Color$_setter_$org$nlogo$core$Color$$ColorsRGB_$eq(int[] x$0) {
        org$nlogo$core$Color$$ColorsRGB = x$0;
    }

    @Override
    public void org$nlogo$core$Color$_setter_$org$nlogo$core$Color$$ARGB_Cache_$eq(int[] x$0) {
        org$nlogo$core$Color$$ARGB_Cache = x$0;
    }

    @Override
    public void org$nlogo$core$Color$_setter_$rgbMap_$eq(LinkedHashMap x$0) {
        rgbMap = x$0;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Color$.class);
    }

    public String[] ColorNames() {
        return ColorNames;
    }

    public String getColorNameByIndex(int index) {
        return this.ColorNames()[index];
    }

    public double getColorNumberByIndex(int index) {
        return ColorNumbers[index];
    }

    public LogoList BaseColors() {
        return BaseColors;
    }

    public java.awt.Color getColor(Object color) {
        Object object = color;
        if (object instanceof Double) {
            Double d = (Double)object;
            return AWT_Cache[(int)(d * (double)10)];
        }
        if (object instanceof LogoList) {
            LogoList logoList = (LogoList)object;
            LogoList list = logoList;
            if (list.size() == 3) {
                return new java.awt.Color(((Number)list.get(0)).intValue(), ((Number)list.get(1)).intValue(), ((Number)list.get(2)).intValue());
            }
            LogoList list2 = logoList;
            if (list2.size() == 4) {
                return new java.awt.Color(((Number)list2.get(0)).intValue(), ((Number)list2.get(1)).intValue(), ((Number)list2.get(2)).intValue(), ((Number)list2.get(3)).intValue());
            }
        }
        throw new IllegalStateException();
    }

    public String getClosestColorNameByARGB(int argb) {
        DecimalFormat formatter = new DecimalFormat("###.####");
        double d = this.getClosestColorNumberByARGB(argb);
        if ((double)ColorConstants$.MODULE$.Black() == d) {
            return this.getColorNameByIndex(14);
        }
        if (ColorConstants$.MODULE$.White() == d) {
            return this.getColorNameByIndex(15);
        }
        double closest = d;
        int baseColorNumber = (int)this.findCentralColorNumber(closest);
        double difference = closest - (double)baseColorNumber;
        String baseColorName = this.getColorNameByIndex((baseColorNumber - 5) / 10);
        if (difference == 0.0) {
            return baseColorName;
        }
        if (difference > 0.0) {
            return baseColorName + " + " + formatter.format(StrictMath.abs(difference));
        }
        return baseColorName + " - " + formatter.format(StrictMath.abs(difference));
    }

    public double getClosestColorNumberByHSB(float h, float s, float b) {
        float hh = RichFloat$.MODULE$.min$extension(Predef$.MODULE$.floatWrapper(RichFloat$.MODULE$.max$extension(Predef$.MODULE$.floatWrapper(0.0f), h)), 360.0f);
        float ss = RichFloat$.MODULE$.min$extension(Predef$.MODULE$.floatWrapper(RichFloat$.MODULE$.max$extension(Predef$.MODULE$.floatWrapper(0.0f), s)), 100.0f);
        float bb = RichFloat$.MODULE$.min$extension(Predef$.MODULE$.floatWrapper(RichFloat$.MODULE$.max$extension(Predef$.MODULE$.floatWrapper(0.0f), b)), 100.0f);
        int argb = java.awt.Color.HSBtoRGB(hh / 360.0f, ss / 100.0f, bb / 100.0f);
        return BoxesRunTime.unboxToDouble((Object)this.rgbMap().get((Object)BoxesRunTime.boxToDouble((double)Int$.MODULE$.int2double(argb))).getOrElse(() -> Color$.getClosestColorNumberByHSB$$anonfun$1(argb)));
    }

    public LogoList getRGBListByARGB(int argb) {
        LogoListBuilder result = new LogoListBuilder();
        result.add(Predef$.MODULE$.double2Double(Approximate$.MODULE$.approximate(Int$.MODULE$.int2double(argb >> 16 & 0xFF), 3)));
        result.add(Predef$.MODULE$.double2Double(Approximate$.MODULE$.approximate(Int$.MODULE$.int2double(argb >> 8 & 0xFF), 3)));
        result.add(Predef$.MODULE$.double2Double(Approximate$.MODULE$.approximate(Int$.MODULE$.int2double(argb & 0xFF), 3)));
        return result.toLogoList();
    }

    public LogoList getRGBAListByARGB(int argb) {
        LogoListBuilder result = new LogoListBuilder();
        result.add(BoxesRunTime.boxToDouble((double)Approximate$.MODULE$.approximate(Int$.MODULE$.int2double(argb >> 16 & 0xFF), 3)));
        result.add(BoxesRunTime.boxToDouble((double)Approximate$.MODULE$.approximate(Int$.MODULE$.int2double(argb >> 8 & 0xFF), 3)));
        result.add(BoxesRunTime.boxToDouble((double)Approximate$.MODULE$.approximate(Int$.MODULE$.int2double(argb & 0xFF), 3)));
        result.add(BoxesRunTime.boxToDouble((double)Approximate$.MODULE$.approximate(Int$.MODULE$.int2double(argb >> 24 & 0xFF), 3)));
        return result.toLogoList();
    }

    public LogoList getHSBListByARGB(int argb) {
        float[] hsb2 = new float[3];
        java.awt.Color.RGBtoHSB(argb >> 16 & 0xFF, argb >> 8 & 0xFF, argb & 0xFF, hsb2);
        LogoListBuilder result = new LogoListBuilder();
        result.add(BoxesRunTime.boxToDouble((double)Approximate$.MODULE$.approximate(Float$.MODULE$.float2double(hsb2[0] * 360.0f), 3)));
        result.add(BoxesRunTime.boxToDouble((double)Approximate$.MODULE$.approximate(Float$.MODULE$.float2double(hsb2[1] * 100.0f), 3)));
        result.add(BoxesRunTime.boxToDouble((double)Approximate$.MODULE$.approximate(Float$.MODULE$.float2double(hsb2[2] * 100.0f), 3)));
        return result.toLogoList();
    }

    public LogoList getHSBListByRGBList(LogoList rgbList) {
        int r = Predef$.MODULE$.double2Double(BoxesRunTime.unboxToDouble((Object)rgbList.get(0))).intValue();
        int g = Predef$.MODULE$.double2Double(BoxesRunTime.unboxToDouble((Object)rgbList.get(1))).intValue();
        int b = Predef$.MODULE$.double2Double(BoxesRunTime.unboxToDouble((Object)rgbList.get(2))).intValue();
        float[] hsbvals = java.awt.Color.RGBtoHSB(StrictMath.max(0, StrictMath.min(255, r)), StrictMath.max(0, StrictMath.min(255, g)), StrictMath.max(0, StrictMath.min(255, b)), null);
        LogoListBuilder llb = new LogoListBuilder();
        llb.add(BoxesRunTime.boxToDouble((double)Approximate$.MODULE$.approximate(Float$.MODULE$.float2double(hsbvals[0] * 360.0f), 3)));
        llb.add(BoxesRunTime.boxToDouble((double)Approximate$.MODULE$.approximate(Float$.MODULE$.float2double(hsbvals[1] * 100.0f), 3)));
        llb.add(BoxesRunTime.boxToDouble((double)Approximate$.MODULE$.approximate(Float$.MODULE$.float2double(hsbvals[2] * 100.0f), 3)));
        return llb.toLogoList();
    }

    public LogoList convertGoodHSBListToDumbOldHSBFormat(LogoList hsbvals) {
        LogoListBuilder hsbList = new LogoListBuilder();
        hsbList.add(BoxesRunTime.boxToDouble((double)Approximate$.MODULE$.approximate(0.7083333134651184 * Predef$.MODULE$.Double2double((Double)hsbvals.apply(0)), 3)));
        hsbList.add(BoxesRunTime.boxToDouble((double)Approximate$.MODULE$.approximate((double)2.55f * Predef$.MODULE$.Double2double((Double)hsbvals.apply(1)), 3)));
        hsbList.add(BoxesRunTime.boxToDouble((double)Approximate$.MODULE$.approximate((double)2.55f * Predef$.MODULE$.Double2double((Double)hsbvals.apply(2)), 3)));
        return hsbList.toLogoList();
    }

    public LogoList getHSBListByColor(double color) {
        double ccolor = color < 0.0 || color >= (double)140 ? this.modulateDouble(color) : color;
        return this.getHSBListByARGB(this.getARGBbyPremodulatedColorNumber(ccolor));
    }

    public java.awt.Color getComplement(java.awt.Color color) {
        float[] rgb = color.getRGBColorComponents(null);
        return new java.awt.Color((rgb[0] + 0.5f) % 1.0f, (rgb[1] + 0.5f) % 1.0f, (rgb[2] + 0.5f) % 1.0f);
    }

    public void validRGBList(LogoList rgb, boolean allowAlpha) throws AgentException {
        if (rgb.size() == 3 || allowAlpha && rgb.size() == 4) {
            try {
                for (int i = 0; i < rgb.size(); ++i) {
                    this.validRGB$1(((Double)rgb.get(i)).intValue());
                }
                return;
            }
            catch (ClassCastException e) {
                Exceptions$.MODULE$.ignore(e);
            }
        }
        String key = "org.nlogo.agent.Agent." + (allowAlpha ? "rgbListSizeError.3or4" : "rgbListSizeError.3");
        throw new AgentException(I18N$.MODULE$.errors().get(key));
    }

    private HashMap<Object, Object> colorTranslations() {
        Object object = this.colorTranslations$lzy1;
        if (object instanceof HashMap) {
            return (HashMap)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (HashMap)this.colorTranslations$lzyINIT1();
    }

    private Object colorTranslations$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.colorTranslations$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$_m_0, null, LazyVals.Evaluating$.MODULE$)) continue;
                    LazyVals.NullValue$ nullValue$ = null;
                    HashMap hashMap = null;
                    try {
                        HashMap map = (HashMap)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                        Iterator lines = Resource$.MODULE$.get(ColorTranslations).getLines();
                        lines.map((Function1 & Serializable)_$1 -> _$1.trim()).filter((Function1 & Serializable)_$2 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$2))).filter((Function1 & Serializable)_$3 -> StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(_$3)) != '#').foreach((Function1 & Serializable)line -> {
                            Object[] strs = line.split("\\s+");
                            Object object = Predef$.MODULE$.refArrayOps(strs);
                            int index = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)ArrayOps$.MODULE$.head$extension(object)));
                            Object object2 = Predef$.MODULE$.refArrayOps(strs);
                            return (HashMap)map.$plus$plus$eq((IterableOnce)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), ArrayOps$.MODULE$.size$extension(object2)).map(arg_0 -> Color$.colorTranslations$lzyINIT1$$anonfun$4$$anonfun$adapted$1((String[])strs, index, arg_0)));
                        });
                        hashMap = map;
                        nullValue$ = hashMap == null ? LazyVals.NullValue$.MODULE$ : hashMap;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$_m_0, LazyVals.Evaluating$.MODULE$, nullValue$)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.colorTranslations$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$_m_0, waiting, nullValue$);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$_m_0, LazyVals.Evaluating$.MODULE$, nullValue$)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.colorTranslations$lzy1;
                        LazyVals$.MODULE$.objCAS(this, OFFSET$_m_0, waiting, nullValue$);
                        waiting.countDown();
                    }
                    return hashMap;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$_m_0, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public int translateSavedColor(int color) {
        return BoxesRunTime.unboxToInt((Object)this.colorTranslations().get((Object)BoxesRunTime.boxToDouble((double)color)).map((Function1)(JFunction1.mcII.sp & Serializable)_$4 -> Predef$.MODULE$.int2Integer(_$4)).map((Function1)(JFunction1.mcII.sp & Serializable)index -> MODULE$.getARGBByIndex(index)).getOrElse(() -> Color$.translateSavedColor$$anonfun$3(color)));
    }

    private final /* synthetic */ java.awt.Color $init$$$anonfun$1(int i) {
        return new java.awt.Color(this.getARGBbyPremodulatedColorNumber((double)i / 10.0));
    }

    private final /* synthetic */ Double $init$$$anonfun$2(int n) {
        return BoxesRunTime.boxToDouble((double)Int$.MODULE$.int2double(n * 10 + 5));
    }

    private static final double getClosestColorNumberByHSB$$anonfun$1(int argb$1) {
        return MODULE$.estimateClosestColorNumberByRGB(argb$1);
    }

    private final void validRGB$1(int c) {
        if (c < 0 || c > 255) {
            throw new AgentException(I18N$.MODULE$.errors().get("org.nlogo.agent.Agent.rgbValueError"));
        }
    }

    private static /* bridge */ /* synthetic */ Tuple2 colorTranslations$lzyINIT1$$anonfun$4$$anonfun$adapted$1(String[] strs$2, int index$2, Object j) {
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(strs$2[BoxesRunTime.unboxToInt((Object)j)]))), (Object)BoxesRunTime.boxToInteger((int)index$2));
    }

    private static final int translateSavedColor$$anonfun$3(int color$1) {
        return color$1;
    }
}

