/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import org.nlogo.api.FileIO$;
import org.nlogo.core.NetLogoPreferences$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.BoxedUnit;

public interface InfoDownloader {
    public String prefsKey();

    public static Boolean enabled$(InfoDownloader $this) {
        return $this.enabled();
    }

    default public Boolean enabled() {
        return Predef$.MODULE$.boolean2Boolean(!Boolean.getBoolean("netlogo." + this.prefsKey() + ".disabled"));
    }

    public static Future apply$(InfoDownloader $this, URL url) {
        return $this.apply(url);
    }

    default public Future<Option<Tuple2<File, Boolean>>> apply(URL url) {
        if (Predef$.MODULE$.Boolean2boolean(this.enabled())) {
            Promise promise = Promise$.MODULE$.apply();
            Future$.MODULE$.apply((Function0 & Serializable)() -> {
                InfoDownloader.apply$$anonfun$1(url, promise);
                return BoxedUnit.UNIT;
            }, ExecutionContext.Implicits$.MODULE$.global());
            return promise.future().map((Function1 & Serializable)inputStream -> {
                boolean isWriting;
                MessageDigest md = MessageDigest.getInstance("MD5");
                DigestInputStream digest = new DigestInputStream((InputStream)inputStream, md);
                Files.copy(digest, Paths.get(FileIO$.MODULE$.perUserFile(this.urlToHash(url), FileIO$.MODULE$.perUserFile$default$2()), new String[0]), StandardCopyOption.REPLACE_EXISTING);
                byte[] localHash = NetLogoPreferences$.MODULE$.getByteArray(this.urlToFullHash(url), null);
                byte[] newHash = md.digest();
                File file = new File(FileIO$.MODULE$.perUserFile(this.urlToHash(url), FileIO$.MODULE$.perUserFile$default$2()));
                boolean bl = isWriting = !Arrays.equals(localHash, newHash);
                if (isWriting) {
                    NetLogoPreferences$.MODULE$.putByteArray(this.urlToFullHash(url), newHash);
                }
                return Option$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)file, (Object)Predef$.MODULE$.boolean2Boolean(isWriting)));
            }, ExecutionContext.Implicits$.MODULE$.global());
        }
        return Future$.MODULE$.apply(InfoDownloader::apply$$anonfun$3, ExecutionContext.Implicits$.MODULE$.global());
    }

    public static void invalidateCache$(InfoDownloader $this, URL url) {
        $this.invalidateCache(url);
    }

    default public void invalidateCache(URL url) {
        NetLogoPreferences$.MODULE$.put(this.urlToFullHash(url), "");
    }

    public static String urlToHash$(InfoDownloader $this, URL url) {
        return $this.urlToHash(url);
    }

    default public String urlToHash(URL url) {
        String noTrailingSlash = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(url.toString()), "/");
        return noTrailingSlash.substring(noTrailingSlash.lastIndexOf(47) + 1);
    }

    private String urlToFullHash(URL url) {
        return this.urlToHash(url) + "-md5";
    }

    private static void apply$$anonfun$1(URL url$1, Promise promise$1) {
        HttpURLConnection conn = (HttpURLConnection)url$1.openConnection();
        if (conn.getResponseCode() == 200) {
            promise$1.success((Object)conn.getInputStream());
            return;
        }
    }

    private static None$ apply$$anonfun$3() {
        return None$.MODULE$;
    }
}

