/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValueFactory;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.nlogo.api.ExtensionInstaller;
import org.nlogo.api.FileIO$;
import org.nlogo.api.LibraryInfoDownloader$;
import org.nlogo.api.LibraryManager$;
import org.nlogo.api.MetadataLoadingException;
import org.nlogo.core.LibraryInfo;
import org.nlogo.core.LibraryInfo$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals$;
import scala.runtime.java8.JFunction0;

public class LibraryManager
implements org.nlogo.core.LibraryManager {
    private final String userInstalledsPath = FileIO$.MODULE$.perUserExtensionFile("installed-libraries.conf", FileIO$.MODULE$.perUserExtensionFile$default$2()).toString();
    private final ExtensionInstaller extInstaller;
    private Seq<LibraryInfo> libraries;
    private Seq<Function1<Seq<LibraryInfo>, BoxedUnit>> infoChangeCallbacks;
    private final String allLibsPath;
    private final URL metadataURL;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(LibraryManager$.class.getDeclaredField("branchURL$lzy1"));

    public LibraryManager(Path userExtPath, Function0<BoxedUnit> unloadExtensions) {
        this.extInstaller = new ExtensionInstaller(userExtPath, unloadExtensions);
        this.libraries = (Seq)((SeqOps)Nil$.MODULE$);
        this.infoChangeCallbacks = (Seq)((SeqOps)Nil$.MODULE$);
        this.allLibsPath = FileIO$.MODULE$.perUserExtensionFile(LibraryManager$.org$nlogo$api$LibraryManager$$$allLibsName, FileIO$.MODULE$.perUserExtensionFile$default$2()).toString();
        this.metadataURL = LibraryManager$.org$nlogo$api$LibraryManager$$$metadataURL;
        if (!Files.exists(Paths.get(this.userInstalledsPath, new String[0]), new LinkOption[0])) {
            try {
                Files.createFile(Paths.get(this.userInstalledsPath, new String[0]), new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {}
        }
        this.reloadMetadata(true, this.reloadMetadata$default$2());
    }

    public String allLibsPath() {
        return this.allLibsPath;
    }

    public URL metadataURL() {
        return this.metadataURL;
    }

    public Seq<LibraryInfo> getExtensionInfos() {
        return this.libraries;
    }

    @Override
    public Option<LibraryInfo> lookupExtension(String name, String version) {
        return this.libraries.find((Function1 & Serializable)ext -> {
            String string = ext.codeName();
            String string2 = name;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    @Override
    public void installExtension(LibraryInfo ext) {
        if (Predef$.MODULE$.Boolean2boolean(LibraryInfoDownloader$.MODULE$.enabled())) {
            this.extInstaller.install(ext);
            this.updateInstalledVersion("extensions", ext, this.updateInstalledVersion$default$3());
            return;
        }
    }

    public void uninstallExtension(LibraryInfo ext) {
        if (Predef$.MODULE$.Boolean2boolean(LibraryInfoDownloader$.MODULE$.enabled())) {
            this.extInstaller.uninstall(ext);
            this.updateInstalledVersion("extensions", ext, true);
            return;
        }
    }

    @Override
    public void reloadMetadata() {
        this.reloadMetadata(false, this.reloadMetadata$default$2());
    }

    public void reloadMetadata(boolean isFirstLoad, boolean useBundled) {
        LibraryManager$.MODULE$.org$nlogo$api$LibraryManager$$$reloadMetadata(isFirstLoad, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.updateLists(new File(this.allLibsPath()), isFirstLoad, useBundled));
    }

    public boolean reloadMetadata$default$1() {
        return false;
    }

    public boolean reloadMetadata$default$2() {
        return true;
    }

    public void onLibInfoChange(Function1<Seq<LibraryInfo>, BoxedUnit> callback) {
        this.infoChangeCallbacks = (Seq)this.infoChangeCallbacks.$colon$plus(callback);
    }

    public void updateLists(File configFile, boolean isFirstLoad, boolean useBundled) {
        try {
            Config config = ConfigFactory.parseFile((File)configFile);
            Config installedLibsConf = useBundled ? ConfigFactory.parseFile((File)new File(this.userInstalledsPath)).withFallback((ConfigMergeable)LibraryManager$.org$nlogo$api$LibraryManager$$$bundledsConfig) : ConfigFactory.parseFile((File)new File(this.userInstalledsPath));
            this.updateList(config, installedLibsConf, "extensions", useBundled);
        }
        catch (ConfigException ex) {
            if (isFirstLoad) {
                LibraryInfoDownloader$.MODULE$.invalidateCache(this.metadataURL());
            }
            throw new MetadataLoadingException(ex);
        }
    }

    public boolean updateLists$default$2() {
        return false;
    }

    public boolean updateLists$default$3() {
        return true;
    }

    private void updateList(Config config, Config installedLibsConf, String category, boolean useBundled) {
        this.libraries = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(config.getConfigList(category)).asScala().map((Function1 & Serializable)c -> {
            String name = c.getString("name");
            String codeName = c.getString("codeName");
            String shortDesc = c.getString("shortDescription");
            String longDesc = c.getString("longDescription");
            String version = c.getString("version");
            URL homepage = new URL(c.getString("homepage"));
            String installedVersionPath = category + ".\"" + codeName + "\".installedVersion";
            Option installedVersion = LibraryManager.getStringOption$1(installedLibsConf, installedVersionPath, LibraryManager.getStringOption$default$3$1());
            boolean bundled = useBundled && LibraryManager$.org$nlogo$api$LibraryManager$$$bundledsConfig.hasPath(installedVersionPath) && installedVersion.isEmpty();
            Option minNetLogoVersion = LibraryManager.getStringOption$1(c, "minNetLogoVersion", LibraryManager.getStringOption$default$3$1());
            return LibraryInfo$.MODULE$.apply(name, codeName, shortDesc, longDesc, version, homepage, bundled, (Option<String>)installedVersion, (Option<String>)minNetLogoVersion, LibraryManager$.MODULE$.org$nlogo$api$LibraryManager$$$branchURL());
        })).toSeq();
        this.infoChangeCallbacks.foreach(_$1 -> _$1.apply(this.libraries));
    }

    private void updateInstalledVersion(String category, LibraryInfo lib, boolean uninstall) {
        LibraryManager libraryManager = this;
        synchronized (libraryManager) {
            Config userInstalleds = ConfigFactory.parseFile((File)new File(this.userInstalledsPath));
            Config updatedInstalleds = uninstall ? userInstalleds.withoutPath(category + ".\"" + lib.codeName() + "\"") : userInstalleds.withValue(category + ".\"" + lib.codeName() + "\".installedVersion", ConfigValueFactory.fromAnyRef((Object)lib.version()));
            ConfigRenderOptions renderOpts = ConfigRenderOptions.defaults().setOriginComments(false);
            String newInstalleds = updatedInstalleds.root().render(renderOpts);
            FileIO$.MODULE$.writeFile(this.userInstalledsPath, newInstalleds, false);
            this.updateLists(new File(this.allLibsPath()), false, this.updateLists$default$3());
        }
    }

    private boolean updateInstalledVersion$default$3() {
        return false;
    }

    private static final Option getStringOption$1(Config c, String path, Option option) {
        if (c.hasPath(path)) {
            return Option$.MODULE$.apply((Object)c.getString(path));
        }
        return option;
    }

    private static final Option getStringOption$default$3$1() {
        return None$.MODULE$;
    }
}

