/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import org.nlogo.api.AbstractModelLoader;
import org.nlogo.api.AbstractModelLoader$;
import org.nlogo.api.FormatterPair;
import org.nlogo.api.LabProtocol;
import org.nlogo.core.Model;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Failure$;
import scala.util.Try;

public interface ModelLoader
extends AbstractModelLoader {
    public Seq<FormatterPair<?, ?>> formats();

    public static boolean isCompatible$(ModelLoader $this, URI uri) {
        return $this.isCompatible(uri);
    }

    @Override
    default public boolean isCompatible(URI uri) {
        return AbstractModelLoader$.MODULE$.getURIExtension(uri).exists((Function1 & Serializable)extension -> this.isCompatible((String)extension));
    }

    public static boolean isCompatible$(ModelLoader $this, String extension) {
        return $this.isCompatible(extension);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    default public boolean isCompatible(String extension) {
        String string = extension;
        String string2 = "nlogo";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = extension;
        String string4 = "nlogo3d";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public static Try readModel$(ModelLoader $this, URI uri) {
        return $this.readModel(uri);
    }

    @Override
    default public Try<Model> readModel(URI uri) {
        Option option = this.formats().find((Function1 & Serializable)_$1 -> _$1.isCompatible(uri));
        if (None$.MODULE$.equals(option)) {
            return Failure$.MODULE$.apply((Throwable)new Exception("Unable to open model with current format: " + uri.getPath()));
        }
        if (option instanceof Some) {
            FormatterPair formatter = (FormatterPair)((Some)option).value();
            return formatter.load(uri);
        }
        throw new MatchError((Object)option);
    }

    public static Try readModel$(ModelLoader $this, String source, String extension) {
        return $this.readModel(source, extension);
    }

    @Override
    default public Try<Model> readModel(String source, String extension) {
        Option option = this.formats().find((Function1 & Serializable)_$2 -> _$2.isCompatible(source));
        if (None$.MODULE$.equals(option)) {
            return Failure$.MODULE$.apply((Throwable)new Exception("Unable to open model with current format: " + extension));
        }
        if (option instanceof Some) {
            FormatterPair formatter = (FormatterPair)((Some)option).value();
            return formatter.load(source);
        }
        throw new MatchError((Object)option);
    }

    public static Try save$(ModelLoader $this, Model model, URI uri) {
        return $this.save(model, uri);
    }

    @Override
    default public Try<URI> save(Model model, URI uri) {
        Option option = this.formats().find((Function1 & Serializable)_$3 -> _$3.isCompatible(model));
        if (None$.MODULE$.equals(option)) {
            return Failure$.MODULE$.apply((Throwable)new Exception("Unable to save NetLogo model in format specified by " + uri.getPath()));
        }
        if (option instanceof Some) {
            FormatterPair formatter = (FormatterPair)((Some)option).value();
            return formatter.save(model, uri);
        }
        throw new MatchError((Object)option);
    }

    public static Try sourceString$(ModelLoader $this, Model model, String extension) {
        return $this.sourceString(model, extension);
    }

    @Override
    default public Try<String> sourceString(Model model, String extension) {
        Option option = this.formats().find((Function1 & Serializable)_$4 -> _$4.isCompatible(model));
        if (None$.MODULE$.equals(option)) {
            return Failure$.MODULE$.apply((Throwable)new Exception("Unable to get source for NetLogo model in format: " + extension));
        }
        if (option instanceof Some) {
            FormatterPair formatter = (FormatterPair)((Some)option).value();
            return formatter.sourceString(model);
        }
        throw new MatchError((Object)option);
    }

    public static Model emptyModel$(ModelLoader $this, String extension) {
        return $this.emptyModel(extension);
    }

    @Override
    default public Model emptyModel(String extension) {
        FormatterPair format = (FormatterPair)this.formats().find((Function1 & Serializable)_$5 -> {
            String string = _$5.name();
            String string2 = extension;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).getOrElse(() -> ModelLoader.$anonfun$2(extension));
        return format.emptyModel();
    }

    public static Try readExperiments$(ModelLoader $this, String source, boolean editNames, Set existingNames) {
        return $this.readExperiments(source, editNames, (Set<String>)existingNames);
    }

    @Override
    default public Try<Tuple2<Seq<LabProtocol>, Set<String>>> readExperiments(String source, boolean editNames, Set<String> existingNames) {
        Failure init = Failure$.MODULE$.apply((Throwable)new Exception("Unable to read experiments."));
        return (Try)this.formats().foldLeft((Object)init, (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Try acc = (Try)tuple2._1();
                FormatterPair format = (FormatterPair)tuple2._2();
                if (acc.isSuccess()) {
                    return acc;
                }
                return format.readExperiments(source, editNames, existingNames);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public static Try writeExperiments$(ModelLoader $this, Seq experiments, Writer writer) {
        return $this.writeExperiments((Seq<LabProtocol>)experiments, writer);
    }

    @Override
    default public Try<BoxedUnit> writeExperiments(Seq<LabProtocol> experiments, Writer writer) {
        Failure init = Failure$.MODULE$.apply((Throwable)new Exception("Unable to write experiments."));
        return (Try)this.formats().foldLeft((Object)init, (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Try acc = (Try)tuple2._1();
                FormatterPair format = (FormatterPair)tuple2._2();
                if (acc.isSuccess()) {
                    return acc;
                }
                return format.writeExperiments(experiments, writer);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private static FormatterPair $anonfun$2(String extension$2) {
        throw new Exception("Unable to create empty NetLogo model for format: " + extension$2);
    }
}

