/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import java.io.Serializable;
import org.nlogo.api.Matrix3D;
import org.nlogo.api.Vect$;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class Vect
implements Product,
Serializable {
    private final double x;
    private final double y;
    private final double z;

    public static Vect apply(double d, double d2, double d3) {
        return Vect$.MODULE$.apply(d, d2, d3);
    }

    public static Vect axisTransformation(Vect vect, Vect vect2, Vect vect3, Vect vect4) {
        return Vect$.MODULE$.axisTransformation(vect, vect2, vect3, vect4);
    }

    public static Vect fromProduct(Product product) {
        return Vect$.MODULE$.fromProduct(product);
    }

    public static double[] toAngles(Vect vect, Vect vect2) {
        return Vect$.MODULE$.toAngles(vect, vect2);
    }

    public static Vect[] toVectors(double d, double d2, double d3) {
        return Vect$.MODULE$.toVectors(d, d2, d3);
    }

    public static Vect unapply(Vect vect) {
        return Vect$.MODULE$.unapply(vect);
    }

    public Vect(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.x()));
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.y()));
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.z()));
        return Statics.finalizeHash((int)n, (int)3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Vect)) return false;
        Vect vect = (Vect)object;
        if (this.x() != vect.x()) return false;
        if (this.y() != vect.y()) return false;
        if (this.z() != vect.z()) return false;
        if (!vect.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Vect;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "Vect";
    }

    public Object productElement(int n) {
        double d;
        int n2 = n;
        switch (n2) {
            case 0: {
                d = this._1();
                break;
            }
            case 1: {
                d = this._2();
                break;
            }
            case 2: {
                d = this._3();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return BoxesRunTime.boxToDouble((double)d);
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "x";
            }
            case 1: {
                return "y";
            }
            case 2: {
                return "z";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public double magnitude() {
        return StrictMath.sqrt(this.x() * this.x() + this.y() * this.y() + this.z() * this.z());
    }

    public double zeroify(double d) {
        if (StrictMath.abs(d) < Vect$.org$nlogo$api$Vect$$$Infinitesimal) {
            return 0.0;
        }
        return d;
    }

    public Vect invert() {
        return Vect$.MODULE$.apply(-this.x(), -this.y(), -this.z());
    }

    public Vect add(Vect v) {
        return Vect$.MODULE$.apply(this.x() + v.x(), this.y() + v.y(), this.z() + v.z());
    }

    public Vect subtract(Vect v) {
        return Vect$.MODULE$.apply(this.x() - v.x(), this.y() - v.y(), this.z() - v.z());
    }

    public Vect correct() {
        return Vect$.MODULE$.apply(this.zeroify(this.x()), this.zeroify(this.y()), this.zeroify(this.z()));
    }

    public Vect normalize() {
        double mag = this.magnitude();
        if (mag == 0.0) {
            return this;
        }
        return Vect$.MODULE$.apply(this.x() / mag, this.y() / mag, this.z() / mag);
    }

    public Vect rotateX(double delta) {
        double deltaRadians = StrictMath.toRadians(delta);
        double deltaSin = StrictMath.sin(deltaRadians);
        double deltaCos = StrictMath.cos(deltaRadians);
        return Vect$.MODULE$.apply(this.x(), this.y() * deltaCos - this.z() * deltaSin, this.y() * deltaSin + this.z() * deltaCos).correct();
    }

    public Vect rotateY(double delta) {
        double deltaRadians = StrictMath.toRadians(delta);
        double deltaSin = StrictMath.sin(deltaRadians);
        double deltaCos = StrictMath.cos(deltaRadians);
        return Vect$.MODULE$.apply(this.z() * deltaSin + this.x() * deltaCos, this.y(), this.z() * deltaCos - this.x() * deltaSin).correct();
    }

    public Vect rotateZ(double delta) {
        double deltaRadians = StrictMath.toRadians(delta);
        double deltaSin = StrictMath.sin(deltaRadians);
        double deltaCos = StrictMath.cos(deltaRadians);
        return Vect$.MODULE$.apply(this.x() * deltaCos - this.y() * deltaSin, this.x() * deltaSin + this.y() * deltaCos, this.z()).correct();
    }

    public Vect transform(Matrix3D trans) {
        double[] vec = new double[]{this.x(), this.y(), this.z()};
        trans.transform(vec, vec, 1);
        return Vect$.MODULE$.apply(vec[0], vec[1], vec[2]);
    }

    public double dot(Vect v) {
        return this.x() * v.x() + this.y() * v.y() + this.z() * v.z();
    }

    public Vect cross(Vect v) {
        return Vect$.MODULE$.apply(this.y() * v.z() - this.z() * v.y(), this.z() * v.x() - this.x() * v.z(), this.x() * v.y() - this.y() * v.x()).normalize();
    }

    public double angleTo(Vect v) {
        if (this.magnitude() == 0.0 || v.magnitude() == 0.0) {
            return 0.0;
        }
        double value = this.normalize().dot(v.normalize());
        double angle = StrictMath.acos(Vect$.MODULE$.org$nlogo$api$Vect$$$bindWithinOne(value));
        if (this.cross(v).z() == (double)-1) {
            return Math.PI * 2 - angle;
        }
        return angle;
    }

    public double org$nlogo$api$Vect$$angle(Vect v) {
        return StrictMath.acos(Vect$.MODULE$.org$nlogo$api$Vect$$$bindWithinOne(this.normalize().dot(v.normalize())));
    }

    public Vect copy(double x, double y, double z) {
        return new Vect(x, y, z);
    }

    public double copy$default$1() {
        return this.x();
    }

    public double copy$default$2() {
        return this.y();
    }

    public double copy$default$3() {
        return this.z();
    }

    public double _1() {
        return this.x();
    }

    public double _2() {
        return this.y();
    }

    public double _3() {
        return this.z();
    }
}

