/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.api;

import java.io.Serializable;
import java.io.Writer;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.nlogo.core.XMLElement;
import org.nlogo.core.XMLElement$;
import org.nlogo.core.model.NLogoXMLWriter;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public class XMLWriter
implements NLogoXMLWriter {
    private final XMLStreamWriter writer;
    private final String indentStr;
    private int indentLevel;
    private String lastStart;

    public XMLWriter(Writer dest) {
        this.writer = XMLOutputFactory.newFactory().createXMLStreamWriter(dest);
        this.indentStr = "  ";
        this.indentLevel = 0;
        this.lastStart = "";
    }

    @Override
    public void startDocument() {
        this.writer.writeStartDocument("utf-8", "1.0");
    }

    @Override
    public void startElement(String name) {
        this.writer.writeCharacters("\n");
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.indentLevel).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.writer.writeCharacters(this.indentStr));
        this.writer.writeStartElement(name);
        ++this.indentLevel;
        this.lastStart = name;
    }

    @Override
    public void attribute(String name, String value) {
        this.writer.writeAttribute(name, value);
    }

    @Override
    public void escapedText(String text) {
        if (StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(text), '<') || StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(text), '>') || StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(text), '&')) {
            this.writer.writeCData(StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("]]>")).replaceAllIn((CharSequence)text, "]]" + XMLElement$.MODULE$.CDataEscape() + ">"));
            return;
        }
        this.writer.writeCharacters(text);
    }

    @Override
    public void endElement(String name) {
        --this.indentLevel;
        String string = this.lastStart;
        String string2 = name;
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.writer.writeCharacters("\n");
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.indentLevel).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.writer.writeCharacters(this.indentStr));
        }
        this.writer.writeEndElement();
    }

    @Override
    public void element(XMLElement el2) {
        this.startElement(el2.name());
        el2.attributes().foreach(x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                this.attribute(key, value);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        if (el2.text().isEmpty()) {
            el2.children().foreach(el -> this.element((XMLElement)el));
        } else {
            this.escapedText(el2.text());
        }
        this.endElement(el2.name());
    }

    @Override
    public void endDocument() {
        this.writer.writeEndDocument();
        this.writer.writeCharacters("\n");
    }

    @Override
    public void close() {
        this.writer.close();
    }
}

