/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app;

import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.nlogo.analytics.Analytics$;
import org.nlogo.api.AbstractModelLoader;
import org.nlogo.api.Exceptions$;
import org.nlogo.api.FileIO$;
import org.nlogo.api.ModelReader$;
import org.nlogo.api.ModelType;
import org.nlogo.api.ModelType$Library$;
import org.nlogo.api.ModelType$New$;
import org.nlogo.api.ModelType$Normal$;
import org.nlogo.api.Version$;
import org.nlogo.api.Workspace;
import org.nlogo.app.ConvertIncludeFile;
import org.nlogo.app.DirtyMonitor;
import org.nlogo.app.FileManager$;
import org.nlogo.app.ModelConfig$;
import org.nlogo.app.ModelSaver;
import org.nlogo.app.ResourceManagerDialog;
import org.nlogo.app.TabManager;
import org.nlogo.app.codetab.TemporaryCodeTab;
import org.nlogo.app.common.Actions$;
import org.nlogo.app.common.Dialogs$;
import org.nlogo.app.common.ExceptionCatchingAction;
import org.nlogo.app.tools.ModelsLibraryDialog$;
import org.nlogo.app.tools.NetLogoWebSaver;
import org.nlogo.app.tools.NetLogoWebSaver$;
import org.nlogo.awt.Hierarchy$;
import org.nlogo.awt.UserCancelException;
import org.nlogo.core.ExternalResource;
import org.nlogo.core.I18N$;
import org.nlogo.core.Model;
import org.nlogo.core.OptionalSection;
import org.nlogo.core.Shape;
import org.nlogo.core.Widget;
import org.nlogo.core.XMLElement;
import org.nlogo.fileformat.ConversionResult;
import org.nlogo.fileformat.FailedConversionResult;
import org.nlogo.fileformat.SuccessfulConversion;
import org.nlogo.fileformat.SuccessfulConversion$;
import org.nlogo.mc.ModelingCommons$;
import org.nlogo.swing.FileDialog$;
import org.nlogo.swing.ModalProgressTask$;
import org.nlogo.swing.OptionPane;
import org.nlogo.swing.OptionPane$Icons$;
import org.nlogo.swing.OptionPane$Options$;
import org.nlogo.swing.UserAction;
import org.nlogo.swing.UserAction$;
import org.nlogo.swing.UserAction$KeyBindings$;
import org.nlogo.window.Events;
import org.nlogo.window.FileController;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.ReconfigureWorkspaceUI$;
import org.nlogo.workspace.AbstractWorkspaceScala;
import org.nlogo.workspace.OpenModel;
import org.nlogo.workspace.OpenModelFromSource$;
import org.nlogo.workspace.OpenModelFromURI$;
import org.nlogo.workspace.SaveModel;
import org.nlogo.workspace.SaveModel$;
import org.nlogo.workspace.SaveModelAs$;
import org.nlogo.workspace.WorkspaceFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.MapOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Try;

public class FileManager
implements Events.OpenModelEvent.Handler,
Events.LoadModelEvent.Handler {
    private final AbstractWorkspaceScala workspace;
    private final AbstractModelLoader modelLoader;
    private final Function2<Model, Path, ConversionResult> modelConverter;
    private final DirtyMonitor dirtyMonitor;
    public final ModelSaver org$nlogo$app$FileManager$$modelSaver;
    public final Object org$nlogo$app$FileManager$$eventRaiser;
    public final Container org$nlogo$app$FileManager$$parent;
    public final TabManager org$nlogo$app$FileManager$$tabManager;
    private final WorkspaceFactory workspaceFactory;
    private boolean firstLoad;
    private final FileController controller;

    public FileManager(AbstractWorkspaceScala workspace, AbstractModelLoader modelLoader, Function2<Model, Path, ConversionResult> modelConverter, DirtyMonitor dirtyMonitor, ModelSaver modelSaver, Object eventRaiser, Container parent, TabManager tabManager, WorkspaceFactory workspaceFactory) {
        this.workspace = workspace;
        this.modelLoader = modelLoader;
        this.modelConverter = modelConverter;
        this.dirtyMonitor = dirtyMonitor;
        this.org$nlogo$app$FileManager$$modelSaver = modelSaver;
        this.org$nlogo$app$FileManager$$eventRaiser = eventRaiser;
        this.org$nlogo$app$FileManager$$parent = parent;
        this.org$nlogo$app$FileManager$$tabManager = tabManager;
        this.workspaceFactory = workspaceFactory;
        this.firstLoad = true;
        this.controller = new FileController(parent, workspace);
    }

    public FileController controller() {
        return this.controller;
    }

    @Override
    public void handle(Events.OpenModelEvent e) {
        this.openFromPath(e.path, ModelType$Library$.MODULE$, e.shouldAutoInstallLibs);
    }

    @Override
    public void handle(Events.LoadModelEvent e) {
        this.org$nlogo$app$FileManager$$modelSaver.setCurrentModel(e.model);
    }

    public void aboutToCloseFiles() {
        if (this.dirtyMonitor.modelDirty()) {
            if (Dialogs$.MODULE$.userWantsToSaveFirst(I18N$.MODULE$.gui().get("file.save.offer.thisModel"), this.org$nlogo$app$FileManager$$parent)) {
                this.saveModel(false);
            } else {
                this.dirtyMonitor.discardNewAutoSaves();
            }
        }
        new Events.AboutToCloseFilesEvent().raise(this.org$nlogo$app$FileManager$$eventRaiser);
    }

    public void quit() throws UserCancelException {
        this.aboutToCloseFiles();
        ModelConfig$.MODULE$.pruneAutoSaves();
        new Events.AboutToQuitEvent().raise(this.org$nlogo$app$FileManager$$eventRaiser);
        this.workspace.getExtensionManager().reset();
        Analytics$.MODULE$.appExit();
        System.exit(0);
    }

    public void openFromPath(String path, ModelType modelType, boolean shouldAutoInstallLibs) {
        this.openFromURI(new File(path).toURI(), modelType, shouldAutoInstallLibs);
    }

    public boolean openFromPath$default$3() {
        return false;
    }

    public void openFromURI(URI uri, ModelType modelType, boolean shouldAutoInstallLibs) {
        URI uRI;
        BooleanRef autosaveFound = BooleanRef.create((boolean)false);
        Option<Path> option = ModelConfig$.MODULE$.findAutoSave(Paths.get(uri).toString());
        if (option instanceof Some) {
            Path path = (Path)((Some)option).value();
            autosaveFound.elem = true;
            uRI = new OptionPane(this.org$nlogo$app$FileManager$$parent, I18N$.MODULE$.gui().get("file.autosave.recover"), I18N$.MODULE$.gui().get("file.autosave.recover.message"), OptionPane$Options$.MODULE$.YesNo(), OptionPane$Icons$.MODULE$.Info()).getSelectedIndex() == 0 ? path.toUri() : uri;
        } else {
            uRI = uri;
        }
        URI newUri = uRI;
        this.org$nlogo$app$FileManager$$loadModel(this.org$nlogo$app$FileManager$$openModelURI(newUri)).foreach(m -> {
            this.openFromModel((Model)m, uri, modelType, shouldAutoInstallLibs);
            ModelType modelType = modelType;
            ModelType$Normal$ modelType$Normal$ = ModelType$Normal$.MODULE$;
            if (!(modelType != null ? !modelType.equals(modelType$Normal$) : modelType$Normal$ != null) && autosaveFound$1.elem) {
                this.saveModel(false);
                return;
            }
            this.dirtyMonitor.discardNewAutoSaves();
        });
    }

    public boolean openFromURI$default$3() {
        return false;
    }

    public Function1<OpenModel.Controller, Option<Model>> org$nlogo$app$FileManager$$openModelURI(URI uri) {
        return (Function1 & Serializable)fileController -> OpenModelFromURI$.MODULE$.apply(uri, (OpenModel.Controller)fileController, this.modelLoader, this.modelConverter, Version$.MODULE$);
    }

    public void openFromSource(URI uri, String modelSource, ModelType modelType) {
        this.org$nlogo$app$FileManager$$loadModel((Function1<OpenModel.Controller, Option<Model>>)(Function1 & Serializable)fileController -> OpenModelFromSource$.MODULE$.apply(uri, modelSource, (OpenModel.Controller)fileController, this.modelLoader, this.modelConverter, Version$.MODULE$)).foreach(m -> this.openFromModel((Model)m, uri, modelType, this.openFromModel$default$4()));
    }

    public void openModel(URI uri, Model model, ModelType modelType) {
        this.openFromModel(model, uri, modelType, this.openFromModel$default$4());
    }

    public void org$nlogo$app$FileManager$$runLoad(Container linkParent, URI uri, Model model, ModelType modelType, boolean shouldAutoInstallLibs) {
        boolean convertWidgetSizes = Version$.MODULE$.numericValue(model.version()) > Version$.MODULE$.numericValue("NetLogo 6.4.0") ? false : new OptionPane(this.org$nlogo$app$FileManager$$parent, I18N$.MODULE$.gui().get("menu.tools.convertWidgetSizes"), I18N$.MODULE$.gui().get("file.open.warn.convertWidgetSizes"), (Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)I18N$.MODULE$.gui().get("menu.tools.convertWidgetSizes.resizeAndAdjust"), (List)new .colon.colon((Object)I18N$.MODULE$.gui().get("file.open.skip"), (List)Nil$.MODULE$)))), OptionPane$Icons$.MODULE$.Info()).getSelectedIndex() == 0;
        ReconfigureWorkspaceUI$.MODULE$.apply(linkParent, uri, modelType, model, this.workspace, shouldAutoInstallLibs, convertWidgetSizes);
        ModelType modelType2 = modelType;
        ModelType$Normal$ modelType$Normal$ = ModelType$Normal$.MODULE$;
        if (!(modelType2 != null ? !modelType2.equals(modelType$Normal$) : modelType$Normal$ != null)) {
            FileDialog$.MODULE$.setDirectory(this.workspace.fileManager().prefix());
            return;
        }
    }

    public Option<Model> org$nlogo$app$FileManager$$loadModel(Function1<OpenModel.Controller, Option<Model>> openModel) {
        Option result = (Option)ModalProgressTask$.MODULE$.runForResultOnBackgroundThread(Hierarchy$.MODULE$.getFrame(this.org$nlogo$app$FileManager$$parent), I18N$.MODULE$.gui().get("dialog.interface.loading.task"), (JFunction0.mcV.sp & Serializable)() -> {}, (Function1 & Serializable)Unit -> (Option)openModel.apply((Object)this.controller()));
        if (result.isEmpty()) {
            new Events.LoadErrorEvent().raise(this.org$nlogo$app$FileManager$$eventRaiser);
        }
        return result;
    }

    public void newModel() throws IOException, UserCancelException {
        try {
            this.openFromModel(this.modelLoader.emptyModel(ModelReader$.MODULE$.modelSuffix()), this.getClass().getResource(ModelReader$.MODULE$.emptyModelPath()).toURI(), ModelType$New$.MODULE$, this.openFromModel$default$4());
        }
        catch (URISyntaxException ex) {
            Predef$.MODULE$.println((Object)("Unable to locate empty model: " + ModelReader$.MODULE$.emptyModelPath()));
        }
    }

    public void saveModel(boolean saveAs) throws UserCancelException {
        boolean isNew = this.workspace.getModelPath() == null;
        boolean newFormat = this.workspace.getModelFileName() != null && (this.workspace.getModelFileName().endsWith(".nlogox") || this.workspace.getModelFileName().endsWith(".nlogox3d"));
        SaveModel saveModel = saveAs || !newFormat ? SaveModelAs$.MODULE$ : SaveModel$.MODULE$;
        Option<Function0<Try<URI>>> saveThunk = saveModel.apply(this.currentModel(), this.modelLoader, this.controller(), this.workspace, Version$.MODULE$);
        saveThunk.foreach((Function1 & Serializable)thunk -> {
            Throwable throwable;
            Try try_;
            Saver saver = new Saver(this, (Function0<Try<URI>>)thunk, isNew);
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            Component tempParent = focusOwner == null ? this.org$nlogo$app$FileManager$$parent : focusOwner;
            ModalProgressTask$.MODULE$.onUIThread(Hierarchy$.MODULE$.getFrame(tempParent), I18N$.MODULE$.gui().get("dialog.interface.saving.task"), saver);
            if (!saver.result().isDefined()) {
                throw new UserCancelException();
            }
            Option<Try<URI>> option = saver.result();
            if (option instanceof Some && (try_ = (Try)((Some)option).value()) instanceof Failure && (throwable = ((Failure)try_).exception()) != null) {
                Throwable e = throwable;
                return new OptionPane(this.org$nlogo$app$FileManager$$parent, I18N$.MODULE$.gui().get("common.netlogo"), I18N$.MODULE$.gui().getN("menu.file.save.error", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{e.getMessage()})), OptionPane$Options$.MODULE$.Ok(), OptionPane$Icons$.MODULE$.Error());
            }
            ModelConfig$.MODULE$.setLastModified(this.workspace.getModelPath());
            return BoxedUnit.UNIT;
        });
    }

    private void openFromModel(Model model, URI uri, ModelType modelType, boolean shouldAutoInstallLibs) {
        if (this.firstLoad) {
            this.firstLoad = false;
            this.org$nlogo$app$FileManager$$runLoad(this.org$nlogo$app$FileManager$$parent, uri, model, modelType, shouldAutoInstallLibs);
            return;
        }
        Runnable loader = new Runnable(uri, model, modelType, shouldAutoInstallLibs, this){
            private final URI uri$5;
            private final Model model$1;
            private final ModelType modelType$3;
            private final boolean shouldAutoInstallLibs$2;
            private final /* synthetic */ FileManager $outer;
            {
                this.uri$5 = uri$6;
                this.model$1 = model$3;
                this.modelType$3 = modelType$4;
                this.shouldAutoInstallLibs$2 = shouldAutoInstallLibs$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void run() {
                this.$outer.org$nlogo$app$FileManager$$runLoad(this.$outer.org$nlogo$app$FileManager$$parent, this.uri$5, this.model$1, this.modelType$3, this.shouldAutoInstallLibs$2);
            }
        };
        ModalProgressTask$.MODULE$.onUIThread(Hierarchy$.MODULE$.getFrame(this.org$nlogo$app$FileManager$$parent), I18N$.MODULE$.gui().get("dialog.interface.loading.task"), loader);
    }

    private boolean openFromModel$default$4() {
        return false;
    }

    public String org$nlogo$app$FileManager$$userChooseLoadPath() throws UserCancelException {
        return FileDialog$.MODULE$.showFiles(this.org$nlogo$app$FileManager$$parent, I18N$.MODULE$.gui().get("menu.file.open"), 0, null, FileDialog$.MODULE$.showFiles$default$5());
    }

    public Model currentModel() {
        return this.org$nlogo$app$FileManager$$modelSaver.currentModel();
    }

    public Seq<UserAction.MenuAction> actions() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new ExceptionCatchingAction[]{new NewAction(this, this.org$nlogo$app$FileManager$$parent), new OpenAction(this, (Component)this.org$nlogo$app$FileManager$$parent), new QuitAction(this, (Component)this.org$nlogo$app$FileManager$$parent), new ModelsLibraryAction(this, (Component)this.org$nlogo$app$FileManager$$parent), new UploadToModelingCommonsAction(this.org$nlogo$app$FileManager$$parent, this.workspace, this.workspaceFactory, this.org$nlogo$app$FileManager$$modelSaver), new SaveAsNetLogoWebAction(this, this.workspace, this.org$nlogo$app$FileManager$$modelSaver, this.org$nlogo$app$FileManager$$parent), new ImportClientAction(this, this.workspace, this.org$nlogo$app$FileManager$$parent), new ManageResourcesAction(this, this.workspace, this.org$nlogo$app$FileManager$$parent)}));
    }

    public Seq<ExceptionCatchingAction> saveModelActions(Component parent) {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new ExceptionCatchingAction[]{this.saveAction$1(parent, false), this.saveAction$1(parent, true)}));
    }

    public UserAction.MenuAction convertTabAction(TemporaryCodeTab t) {
        String version = Version$.MODULE$.is3D() ? "NetLogo 3D 5.3.1" : "NetLogo 5.3.1";
        ConvertIncludeFile convertIncludeFile = new ConvertIncludeFile(this.modelConverter, version);
        return new ConvertNlsAction(t, this.org$nlogo$app$FileManager$$modelSaver, convertIncludeFile, this.workspace, this.controller());
    }

    private final ExceptionCatchingAction saveAction$1(Component parent$2, boolean saveAs) {
        return new UserAction.MenuAction(saveAs, parent$2, this){
            private final boolean saveAs$2;
            private final /* synthetic */ FileManager $outer;
            {
                this.saveAs$2 = saveAs$1;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super((String)(saveAs$1 ? I18N$.MODULE$.gui().get("menu.file.saveAs") + Actions$.MODULE$.Ellipsis() : I18N$.MODULE$.gui().get("menu.file.save")), parent$1);
                this.category_$eq(UserAction$.MODULE$.FileCategory());
                this.group_$eq(UserAction$.MODULE$.FileSaveGroup());
                this.accelerator_$eq(UserAction$KeyBindings$.MODULE$.keystroke(83, true, saveAs$1, UserAction$KeyBindings$.MODULE$.keystroke$default$4()));
                this.rank_$eq(0.0);
            }

            public void action() throws UserCancelException {
                Component component = this.$outer.org$nlogo$app$FileManager$$tabManager.getSelectedTab();
                if (component instanceof TemporaryCodeTab) {
                    TemporaryCodeTab tempTab = (TemporaryCodeTab)component;
                    tempTab.save(this.saveAs$2);
                } else {
                    this.$outer.saveModel(this.saveAs$2);
                }
                this.$outer.org$nlogo$app$FileManager$$tabManager.saveOpenTabs();
            }
        };
    }

    public static class ConvertNlsAction
    extends ExceptionCatchingAction
    implements UserAction.MenuAction {
        private final TemporaryCodeTab tab;
        private final ModelSaver modelSaver;
        private final ConvertIncludeFile convertIncludeFile;
        private final AbstractWorkspaceScala workspace;
        private final FileController controller;

        public ConvertNlsAction(TemporaryCodeTab tab, ModelSaver modelSaver, ConvertIncludeFile convertIncludeFile, AbstractWorkspaceScala workspace, FileController controller) {
            this.tab = tab;
            this.modelSaver = modelSaver;
            this.convertIncludeFile = convertIncludeFile;
            this.workspace = workspace;
            this.controller = controller;
            super(I18N$.MODULE$.gui().get("menu.edit.convertToNetLogoSix"), tab);
            this.category_$eq(UserAction$.MODULE$.EditCategory());
            this.group_$eq("ConversionGroup");
        }

        @Override
        public void action() {
            this.tab.filename().toOption().foreach(name -> FileIO$.MODULE$.resolvePath((String)name, Paths.get(this.workspace.getModelPath(), new String[0])).foreach(path -> {
                ConversionResult conversionResult = this.convertIncludeFile.apply((Path)path, this.modelSaver.currentModel(), this.tab.innerSource());
                if (conversionResult instanceof SuccessfulConversion) {
                    SuccessfulConversion successfulConversion = SuccessfulConversion$.MODULE$.unapply((SuccessfulConversion)conversionResult);
                    Model model = successfulConversion._1();
                    Model model2 = successfulConversion._2();
                    Model originalModel = model;
                    Model m2 = model2;
                    this.tab.innerSource_$eq(m2.code());
                    return;
                }
                if (conversionResult instanceof FailedConversionResult) {
                    FailedConversionResult failure = (FailedConversionResult)conversionResult;
                    this.controller.showAutoconversionError(failure, "nls").foreach(m -> this.tab.innerSource_$eq(m.code()));
                    return;
                }
                throw new MatchError((Object)conversionResult);
            }));
        }
    }

    public static class ImportClientAction
    extends ExceptionCatchingAction
    implements UserAction.MenuAction {
        public final FileManager org$nlogo$app$FileManager$ImportClientAction$$manager;
        public final AbstractWorkspaceScala org$nlogo$app$FileManager$ImportClientAction$$workspace;
        private final Component parent;
        private Option<IOException> exception;

        public ImportClientAction(FileManager manager, AbstractWorkspaceScala workspace, Component parent) {
            this.org$nlogo$app$FileManager$ImportClientAction$$manager = manager;
            this.org$nlogo$app$FileManager$ImportClientAction$$workspace = workspace;
            this.parent = parent;
            super(I18N$.MODULE$.gui().get("menu.file.import.hubNetClientInterface") + Actions$.MODULE$.Ellipsis(), parent);
            this.category_$eq(UserAction$.MODULE$.FileCategory());
            this.subcategory_$eq(UserAction$.MODULE$.FileImportSubcategory());
            this.exception = Option$.MODULE$.empty();
        }

        public Option<IOException> exception() {
            return this.exception;
        }

        public void exception_$eq(Option<IOException> x$1) {
            this.exception = x$1;
        }

        public Runnable importTask(String importPath, int sectionChoice) {
            return new Runnable(importPath, sectionChoice, this){
                private final String importPath$1;
                private final int sectionChoice$1;
                private final /* synthetic */ ImportClientAction $outer;
                {
                    this.importPath$1 = importPath$2;
                    this.sectionChoice$1 = sectionChoice$2;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public void run() {
                    try {
                        URI uri = Paths.get(this.importPath$1, new String[0]).toUri();
                        this.$outer.org$nlogo$app$FileManager$ImportClientAction$$manager.org$nlogo$app$FileManager$$loadModel(this.$outer.org$nlogo$app$FileManager$ImportClientAction$$manager.org$nlogo$app$FileManager$$openModelURI(uri)).map(model -> this.$outer.org$nlogo$app$FileManager$ImportClientAction$$workspace.getHubNetManager().foreach(_$1 -> _$1.importClientInterface((Model)model, this.sectionChoice$1 == 1)));
                    }
                    catch (IOException ex) {
                        this.$outer.exception_$eq((Option<IOException>)Some$.MODULE$.apply((Object)ex));
                    }
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{run$$anonfun$2(org.nlogo.core.Model ), run$$anonfun$2$$anonfun$1(org.nlogo.core.Model org.nlogo.api.HubNetInterface )}, serializedLambda);
                }
            };
        }

        @Override
        public void action() throws IOException, UserCancelException {
            String importPath = FileDialog$.MODULE$.showFiles(this.parent, I18N$.MODULE$.gui().get("menu.file.import.hubNetClientInterface"), 0, null, FileDialog$.MODULE$.showFiles$default$5());
            int choice = new OptionPane(this.frame(), I18N$.MODULE$.gui().get("menu.file.import.hubNetClientInterface.message"), I18N$.MODULE$.gui().get("menu.file.import.hubNetClientInterface.prompt"), (Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)I18N$.MODULE$.gui().get("menu.file.import.hubNetClientInterface.fromInterface"), (List)new .colon.colon((Object)I18N$.MODULE$.gui().get("menu.file.import.hubNetClientInterface.fromClient"), (List)Nil$.MODULE$)))), OptionPane$Icons$.MODULE$.Question()).getSelectedIndex();
            if (choice != 2) {
                ModalProgressTask$.MODULE$.onUIThread(this.frame(), I18N$.MODULE$.gui().get("dialog.interface.import.task"), this.importTask(importPath, choice));
                this.exception().foreach(FileManager$::org$nlogo$app$FileManager$ImportClientAction$$_$action$$anonfun$2);
                return;
            }
        }
    }

    public static class ManageResourcesAction
    extends ExceptionCatchingAction
    implements UserAction.MenuAction {
        private final AbstractWorkspaceScala workspace;

        public ManageResourcesAction(FileManager manager, AbstractWorkspaceScala workspace, Component parent) {
            this.workspace = workspace;
            super(I18N$.MODULE$.gui().get("menu.file.manageResources"), parent);
            this.category_$eq(UserAction$.MODULE$.FileCategory());
            this.group_$eq(UserAction$.MODULE$.FileResourcesGroup());
            this.rank_$eq(1.0);
        }

        @Override
        public void action() {
            new ResourceManagerDialog(((GUIWorkspace)this.workspace).getFrame(), this.workspace).setVisible(true);
        }
    }

    public static class ModelsLibraryAction
    extends ExceptionCatchingAction
    implements UserAction.MenuAction {
        private final FileManager manager;

        public ModelsLibraryAction(FileManager manager, Component parent) {
            this.manager = manager;
            super(I18N$.MODULE$.gui().get("menu.file.modelsLibrary"), parent);
            this.category_$eq(UserAction$.MODULE$.FileCategory());
            this.group_$eq(UserAction$.MODULE$.FileOpenGroup());
            this.rank_$eq(3.0);
            this.accelerator_$eq(UserAction$KeyBindings$.MODULE$.keystroke(77, true, UserAction$KeyBindings$.MODULE$.keystroke$default$3(), UserAction$KeyBindings$.MODULE$.keystroke$default$4()));
        }

        @Override
        public void action() throws UserCancelException {
            this.manager.aboutToCloseFiles();
            ModelsLibraryDialog$.MODULE$.open(this.frame(), sourceURI -> this.manager.openFromURI((URI)sourceURI, ModelType$Library$.MODULE$, this.manager.openFromURI$default$3()));
        }
    }

    public static class NewAction
    extends ExceptionCatchingAction
    implements UserAction.MenuAction {
        private final FileManager manager;

        public NewAction(FileManager manager, Container parent) {
            this.manager = manager;
            super(I18N$.MODULE$.gui().get("menu.file.new"), parent);
            this.category_$eq(UserAction$.MODULE$.FileCategory());
            this.group_$eq(UserAction$.MODULE$.FileOpenGroup());
            this.rank_$eq(1.0);
            this.accelerator_$eq(UserAction$KeyBindings$.MODULE$.keystroke(78, true, UserAction$KeyBindings$.MODULE$.keystroke$default$3(), UserAction$KeyBindings$.MODULE$.keystroke$default$4()));
        }

        @Override
        public void action() throws IOException, UserCancelException {
            this.manager.aboutToCloseFiles();
            this.manager.newModel();
        }
    }

    public static class OpenAction
    extends ExceptionCatchingAction
    implements UserAction.MenuAction {
        private final FileManager manager;

        public OpenAction(FileManager manager, Component parent) {
            this.manager = manager;
            super(I18N$.MODULE$.gui().get("menu.file.open") + Actions$.MODULE$.Ellipsis(), parent);
            this.category_$eq(UserAction$.MODULE$.FileCategory());
            this.group_$eq(UserAction$.MODULE$.FileOpenGroup());
            this.rank_$eq(2.0);
            this.accelerator_$eq(UserAction$KeyBindings$.MODULE$.keystroke(79, true, UserAction$KeyBindings$.MODULE$.keystroke$default$3(), UserAction$KeyBindings$.MODULE$.keystroke$default$4()));
        }

        @Override
        public void action() throws IOException, UserCancelException {
            this.manager.aboutToCloseFiles();
            this.manager.openFromPath(this.manager.org$nlogo$app$FileManager$$userChooseLoadPath(), ModelType$Normal$.MODULE$, this.manager.openFromPath$default$3());
        }
    }

    public static class QuitAction
    extends ExceptionCatchingAction
    implements UserAction.MenuAction {
        private final FileManager manager;

        public QuitAction(FileManager manager, Component parent) {
            this.manager = manager;
            super(I18N$.MODULE$.gui().get("menu.file.quit"), parent);
            this.category_$eq(UserAction$.MODULE$.FileCategory());
            this.group_$eq("Quit");
            this.accelerator_$eq(UserAction$KeyBindings$.MODULE$.keystroke(81, true, UserAction$KeyBindings$.MODULE$.keystroke$default$3(), UserAction$KeyBindings$.MODULE$.keystroke$default$4()));
        }

        @Override
        public void action() {
            try {
                this.manager.quit();
            }
            catch (UserCancelException ex) {
                Exceptions$.MODULE$.ignore(ex);
            }
        }
    }

    public static class SaveAsNetLogoWebAction
    extends ExceptionCatchingAction
    implements UserAction.MenuAction {
        private final FileManager manager;
        private final AbstractWorkspaceScala workspace;
        private final ModelSaver modelSaver;
        private final Component parent;

        public SaveAsNetLogoWebAction(FileManager manager, AbstractWorkspaceScala workspace, ModelSaver modelSaver, Component parent) {
            this.manager = manager;
            this.workspace = workspace;
            this.modelSaver = modelSaver;
            this.parent = parent;
            super(I18N$.MODULE$.gui().get("menu.file.saveAsNetLogoWeb"), parent);
            this.category_$eq(UserAction$.MODULE$.FileCategory());
            this.group_$eq(UserAction$.MODULE$.FileShareGroup());
            this.setEnabled(!Version$.MODULE$.is3D());
        }

        @Override
        public void action() throws IOException, UserCancelException {
            String exportPath = FileDialog$.MODULE$.showFiles(this.parent, I18N$.MODULE$.gui().get("menu.file.saveAsNetLogoWeb.dialog"), 1, this.suggestedFileName(), FileDialog$.MODULE$.showFiles$default$5());
            File exportFile = new File(exportPath);
            NetLogoWebSaver saver = NetLogoWebSaver$.MODULE$.apply(exportPath);
            String modelString = this.modelToSave();
            Seq<Tuple2<String, String>> includes = this.collectIncludes(modelString);
            if (includes.nonEmpty() && new OptionPane(this.parent, I18N$.MODULE$.gui().get("common.messages.warning"), I18N$.MODULE$.gui().get("menu.file.nlw.prompt.includesWarning"), OptionPane$Options$.MODULE$.OkCancel(), OptionPane$Icons$.MODULE$.Warning()).getSelectedIndex() != 0) {
                throw new UserCancelException();
            }
            Analytics$.MODULE$.saveAsNetLogoWeb();
            saver.save(modelString, exportFile.getName(), includes);
        }

        public String suggestedFileName() throws UserCancelException {
            ModelType modelType = this.workspace.getModelType();
            ModelType$New$ modelType$New$ = ModelType$New$.MODULE$;
            if (!(modelType != null ? !modelType.equals(modelType$New$) : modelType$New$ != null)) {
                this.manager.saveModel(false);
                int index = this.workspace.getModelFileName().lastIndexOf(".nlogo");
                if (index == -1) {
                    return this.workspace.getModelFileName();
                }
                return this.workspace.getModelFileName().substring(0, index) + ".html";
            }
            return this.workspace.modelNameForDisplay() + ".html";
        }

        public String modelToSave() throws IOException, UserCancelException {
            if (this.doesNotMatchWorkingCopy() && this.userWantsLastSaveExported()) {
                return this.modelSaver.modelAsString(this.modelSaver.priorModel(), "nlogox");
            }
            return this.modelSaver.modelAsString(this.modelSaver.currentModel(), "nlogox");
        }

        private boolean userWantsLastSaveExported() throws UserCancelException {
            ModelType modelType = this.workspace.getModelType();
            ModelType$Normal$ modelType$Normal$ = ModelType$Normal$.MODULE$;
            String typeKey = !(modelType != null ? !modelType.equals(modelType$Normal$) : modelType$Normal$ != null) ? "fromSave" : "fromLibrary";
            int choice = new OptionPane(this.parent, I18N$.MODULE$.gui().get("menu.file.nlw.prompt.title"), I18N$.MODULE$.gui().get("menu.file.nlw.prompt.message." + typeKey), (Seq<String>)((Seq)((SeqOps)new .colon.colon((Object)I18N$.MODULE$.gui().get("menu.file.nlw.prompt." + typeKey), (List)new .colon.colon((Object)I18N$.MODULE$.gui().get("menu.file.nlw.prompt.fromCurrentCopy"), (List)Nil$.MODULE$)))), OptionPane$Icons$.MODULE$.Question()).getSelectedIndex();
            if (choice == 0) {
                return true;
            }
            if (choice == 1) {
                return false;
            }
            throw new UserCancelException();
        }

        private boolean doesNotMatchWorkingCopy() {
            Model model = this.modelSaver.priorModel();
            Model model2 = this.modelSaver.currentModel();
            return model == null ? model2 != null : !((Object)model).equals(model2);
        }

        private Seq<Tuple2<String, String>> collectIncludes(String str) throws IOException {
            Option<Map<String, String>> includes = this.workspace.compiler().findIncludes(this.workspace.getModelPath(), str, this.workspace.getCompilationEnvironment());
            if (includes.isEmpty()) {
                return package$.MODULE$.Nil();
            }
            return ((MapOps)includes.get()).flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    String path = (String)tuple2._2();
                    BufferedSource file = Source$.MODULE$.fromFile(path, Codec$.MODULE$.fallbackSystemCodec());
                    String source = file.mkString();
                    file.close();
                    Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)name, (Object)source);
                    return (Seq)this.collectIncludes(source).$plus$colon((Object)tuple22);
                }
                throw new MatchError((Object)tuple2);
            }).toList();
        }
    }

    public class Saver
    implements Runnable {
        private final Function0<Try<URI>> thunk;
        private final boolean isNew;
        private Option<Try<URI>> result;
        private final /* synthetic */ FileManager $outer;

        public Saver(FileManager $outer, Function0<Try<URI>> thunk, boolean isNew) {
            this.thunk = thunk;
            this.isNew = isNew;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.result = Option$.MODULE$.empty();
        }

        public Function0<Try<URI>> thunk() {
            return this.thunk;
        }

        public Option<Try<URI>> result() {
            return this.result;
        }

        public void result_$eq(Option<Try<URI>> x$1) {
            this.result = x$1;
        }

        @Override
        public void run() {
            new Events.AboutToSaveModelEvent().raise(this.$outer.org$nlogo$app$FileManager$$eventRaiser);
            Try r = (Try)this.thunk().apply();
            r.foreach(uri -> {
                String path = Paths.get(uri).toString();
                Model model = this.$outer.org$nlogo$app$FileManager$$modelSaver.currentModel();
                String string = Version$.MODULE$.version();
                String string2 = model.copy$default$1();
                Seq<Widget> seq = model.copy$default$2();
                String string3 = model.copy$default$3();
                Seq<Shape.VectorShape> seq2 = model.copy$default$5();
                Seq<Shape.LinkShape> seq3 = model.copy$default$6();
                Seq<OptionalSection<?>> seq4 = model.copy$default$7();
                Seq<ExternalResource> seq5 = model.copy$default$8();
                Seq<XMLElement> seq6 = model.copy$default$9();
                this.$outer.org$nlogo$app$FileManager$$modelSaver.setCurrentModel(model.copy(string2, seq, string3, string, seq2, seq3, seq4, seq5, seq6));
                new Events.ModelSavedEvent(path, this.isNew).raise(this.$outer.org$nlogo$app$FileManager$$eventRaiser);
            });
            this.result_$eq((Option<Try<URI>>)Some$.MODULE$.apply((Object)r));
        }

        public final /* synthetic */ FileManager org$nlogo$app$FileManager$Saver$$$outer() {
            return this.$outer;
        }
    }

    public static class UploadToModelingCommonsAction
    extends ExceptionCatchingAction
    implements UserAction.MenuAction {
        private final Component parent;
        private final Workspace workspace;
        private final WorkspaceFactory workspaceFactory;
        private final ModelSaver modelSaver;

        public UploadToModelingCommonsAction(Component parent, Workspace workspace, WorkspaceFactory workspaceFactory, ModelSaver modelSaver) {
            this.parent = parent;
            this.workspace = workspace;
            this.workspaceFactory = workspaceFactory;
            this.modelSaver = modelSaver;
            super(I18N$.MODULE$.gui().get("menu.file.uploadMc"), parent);
            this.category_$eq(UserAction$.MODULE$.FileCategory());
            this.group_$eq(UserAction$.MODULE$.FileShareGroup());
        }

        @Override
        public void action() {
            ModelingCommons$.MODULE$.upload(Hierarchy$.MODULE$.getFrame(this.parent), this.modelSaver.modelAsString(this.modelSaver.currentModel(), "nlogox"), this.workspace, this.workspaceFactory);
        }
    }
}

