/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app;

import java.io.Serializable;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.runtime.BooleanRef;

public class FileWatcherThread
extends Thread {
    private final List<Path> paths;
    private final Function0<Object> callback;
    private final WatchService watchService;
    private final Map<WatchKey, Path> keyPathMap;

    public FileWatcherThread(List<Path> paths, Function0<Object> callback) {
        this.paths = paths;
        this.callback = callback;
        this.watchService = FileSystems.getDefault().newWatchService();
        Set parentSet = paths.map((Function1 & Serializable)_$1 -> _$1.getParent()).toSet();
        this.keyPathMap = ((IterableOnceOps)parentSet.map((Function1 & Serializable)x -> this.f((Path)x))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Tuple2<WatchKey, Path> f(Path x) {
        WatchKey watchKey = (WatchKey)Predef$.MODULE$.ArrowAssoc((Object)x.register(this.watchService, StandardWatchEventKinds.ENTRY_MODIFY));
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)watchKey, (Object)x);
    }

    @Override
    public void run() {
        try {
            BooleanRef done = BooleanRef.create((boolean)false);
            while (!done.elem && !this.isInterrupted()) {
                WatchKey key = this.watchService.take();
                CollectionConverters$.MODULE$.ListHasAsScala(key.pollEvents()).asScala().foreach(event -> this.keyPathMap.get((Object)key).foreach(dirPath -> {
                    Path eventPath = (Path)event.context();
                    Path fullEventPath = dirPath.resolve(eventPath);
                    if (this.paths.contains((Object)fullEventPath)) {
                        done$2.elem = this.callback.apply$mcZ$sp();
                        return;
                    }
                }));
                key.reset();
            }
        }
        catch (InterruptedException interruptedException) {
        }
    }
}

