/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app;

import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.swing.AbstractAction;
import org.nlogo.api.ModelType;
import org.nlogo.api.ModelType$New$;
import org.nlogo.api.ModelType$Normal$;
import org.nlogo.app.AppFrame;
import org.nlogo.app.FileManager;
import org.nlogo.app.ModelEntry;
import org.nlogo.app.ModelEntry$;
import org.nlogo.app.OpenRecentFileAction;
import org.nlogo.app.OpenRecentFileAction$;
import org.nlogo.app.RecentFiles;
import org.nlogo.core.I18N$;
import org.nlogo.swing.UserAction;
import org.nlogo.swing.UserAction$;
import org.nlogo.window.Events;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;

public class RecentFilesMenu
implements Events.ModelSavedEvent.Handler,
Events.BeforeLoadEvent.Handler {
    private final AppFrame frame;
    private final FileManager fileManager;
    private final RecentFiles recentFiles;
    private Seq<UserAction.MenuAction> currentActions;
    private Option<UserAction.Menu> menu;

    public RecentFilesMenu(AppFrame frame, FileManager fileManager) {
        this.frame = frame;
        this.fileManager = fileManager;
        this.recentFiles = new RecentFiles();
        this.currentActions = (Seq)((SeqOps)Nil$.MODULE$);
        this.menu = None$.MODULE$;
    }

    public RecentFiles recentFiles() {
        return this.recentFiles;
    }

    public void setMenu(UserAction.Menu newMenu) {
        this.menu.foreach(oldMenu -> this.currentActions.foreach(action -> oldMenu.revokeAction((UserAction.MenuAction)action)));
        this.menu = Some$.MODULE$.apply((Object)newMenu);
        this.refreshMenu();
    }

    @Override
    public void handle(Events.ModelSavedEvent e) {
        Option$.MODULE$.apply((Object)e.modelPath).foreach(p -> {
            this.recentFiles().add(ModelEntry$.MODULE$.apply((String)p, ModelType$Normal$.MODULE$));
            this.refreshMenu();
        });
    }

    @Override
    public void handle(Events.BeforeLoadEvent e) {
        ModelType modelType = e.modelType;
        ModelType$New$ modelType$New$ = ModelType$New$.MODULE$;
        if (modelType == null ? modelType$New$ != null : !modelType.equals(modelType$New$)) {
            e.modelPath.foreach(p -> {
                this.recentFiles().add(ModelEntry$.MODULE$.apply((String)p, e$1.modelType));
                this.refreshMenu();
            });
            return;
        }
    }

    public Seq<UserAction.MenuAction> computeActions() {
        List fileActions = this.recentFiles().models().isEmpty() ? (Seq)((SeqOps)new .colon.colon((Object)new EmptyAction(), (List)Nil$.MODULE$)) : ((List)this.recentFiles().models().zipWithIndex()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                ModelEntry modelEntry = (ModelEntry)tuple2._1();
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return new OpenRecentFileAction(this.frame, modelEntry, this.fileManager, i);
            }
            throw new MatchError((Object)tuple2);
        });
        return (Seq)fileActions.$colon$plus((Object)new ClearItems());
    }

    public void refreshMenu() {
        Seq<UserAction.MenuAction> oldActions = this.currentActions;
        this.currentActions = this.computeActions();
        this.menu.foreach(m -> {
            oldActions.foreach(action -> m.revokeAction((UserAction.MenuAction)action));
            this.currentActions.foreach(action -> m.offerAction((UserAction.MenuAction)action));
        });
    }

    public class ClearItems
    extends AbstractAction
    implements UserAction.MenuAction {
        public ClearItems() {
            if (RecentFilesMenu.this == null) {
                throw new NullPointerException();
            }
            super(I18N$.MODULE$.gui().get("menu.file.recent.clear"));
            this.category_$eq(UserAction$.MODULE$.FileCategory());
            this.subcategory_$eq(UserAction$.MODULE$.FileRecentSubcategory());
            this.group_$eq("org.nlogo.app.RecentFilesMenu.ClearItems");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RecentFilesMenu.this.recentFiles().clear();
            RecentFilesMenu.this.refreshMenu();
        }

        public final /* synthetic */ RecentFilesMenu org$nlogo$app$RecentFilesMenu$ClearItems$$$outer() {
            return RecentFilesMenu.this;
        }
    }

    public class EmptyAction
    extends AbstractAction
    implements UserAction.MenuAction {
        public EmptyAction() {
            if (RecentFilesMenu.this == null) {
                throw new NullPointerException();
            }
            super(I18N$.MODULE$.gui().get("common.menus.empty"));
            this.category_$eq(UserAction$.MODULE$.FileCategory());
            this.subcategory_$eq(UserAction$.MODULE$.FileRecentSubcategory());
            this.group_$eq(OpenRecentFileAction$.MODULE$.FilesGroup());
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        public final /* synthetic */ RecentFilesMenu org$nlogo$app$RecentFilesMenu$EmptyAction$$$outer() {
            return RecentFilesMenu.this;
        }
    }
}

