/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.MatteBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.nlogo.api.ExternalResourceManager;
import org.nlogo.api.Workspace;
import org.nlogo.app.ResourceManagerDialog$;
import org.nlogo.awt.Positioning$;
import org.nlogo.awt.UserCancelException;
import org.nlogo.core.ExternalResource;
import org.nlogo.core.I18N$;
import org.nlogo.swing.Button;
import org.nlogo.swing.FileDialog$;
import org.nlogo.swing.InputOptionPane;
import org.nlogo.swing.OptionPane;
import org.nlogo.swing.OptionPane$Icons$;
import org.nlogo.swing.OptionPane$Options$;
import org.nlogo.swing.ScrollPane;
import org.nlogo.swing.ScrollPane$;
import org.nlogo.swing.Transparent;
import org.nlogo.swing.Utils$;
import org.nlogo.theme.InterfaceColors$;
import org.nlogo.theme.ThemeSync;
import org.nlogo.window.Events;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public class ResourceManagerDialog
extends JDialog
implements ThemeSync {
    private final Frame parent;
    private final ExternalResourceManager manager;
    public final DefaultTableModel org$nlogo$app$ResourceManagerDialog$$tableModel;
    private final JTable table;
    private final ScrollPane scrollPane;
    public final Button org$nlogo$app$ResourceManagerDialog$$addButton;
    public final Button org$nlogo$app$ResourceManagerDialog$$exportButton;
    public final Button org$nlogo$app$ResourceManagerDialog$$renameButton;
    public final Button org$nlogo$app$ResourceManagerDialog$$removeButton;

    public ResourceManagerDialog(Frame parent, Workspace workspace) {
        this.parent = parent;
        super(parent, I18N$.MODULE$.gui().get("resource.manager"), true);
        this.manager = workspace.getResourceManager();
        this.org$nlogo$app$ResourceManagerDialog$$tableModel = new DefaultTableModel(0, 2);
        this.table = new JTable(this){
            private final TableColumn nameColumn;
            private final TableColumn extensionColumn;
            private final /* synthetic */ ResourceManagerDialog $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.org$nlogo$app$ResourceManagerDialog$$tableModel);
                this.setSelectionMode(0);
                this.setCellSelectionEnabled(false);
                this.setRowSelectionAllowed(true);
                this.getTableHeader().setReorderingAllowed(false);
                this.setDefaultRenderer(ResourceCellRenderer.class, new ResourceCellRenderer());
                this.getSelectionModel().addListSelectionListener(new ListSelectionListener(this){
                    private final /* synthetic */ $anon$1 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public void valueChanged(ListSelectionEvent e) {
                        this.$outer.org$nlogo$app$ResourceManagerDialog$_$$anon$$$outer().org$nlogo$app$ResourceManagerDialog$$enableButtons();
                    }
                });
                this.nameColumn = this.getColumnModel().getColumn(0);
                this.nameColumn().setHeaderValue("Name");
                this.nameColumn().setCellRenderer(new ResourceCellRenderer());
                this.nameColumn().setHeaderRenderer(new HeaderCellRenderer());
                this.extensionColumn = this.getColumnModel().getColumn(1);
                this.extensionColumn().setHeaderValue("Extension");
                this.extensionColumn().setCellRenderer(new ResourceCellRenderer());
                this.extensionColumn().setHeaderRenderer(new HeaderCellRenderer());
            }

            public TableColumn nameColumn() {
                return this.nameColumn;
            }

            public TableColumn extensionColumn() {
                return this.extensionColumn;
            }

            public boolean isCellEditable(int row, int column) {
                return false;
            }

            public final /* synthetic */ ResourceManagerDialog org$nlogo$app$ResourceManagerDialog$_$$anon$$$outer() {
                return this.$outer;
            }
        };
        this.scrollPane = new ScrollPane(this.table, ScrollPane$.MODULE$.$lessinit$greater$default$2(), ScrollPane$.MODULE$.$lessinit$greater$default$3());
        this.org$nlogo$app$ResourceManagerDialog$$addButton = new Button(I18N$.MODULE$.gui().get("resource.add"), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            block8: {
                try {
                    String string;
                    Tuple2 tuple2;
                    String file = FileDialog$.MODULE$.showFiles(parent, I18N$.MODULE$.gui().get("resource.select"), 0);
                    Path path = Paths.get(file, new String[0]);
                    Object[] split = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(path.getFileName().toString()), '.');
                    Object object = Predef$.MODULE$.refArrayOps(split);
                    if (ArrayOps$.MODULE$.size$extension(object) > 1) {
                        Object object2 = Predef$.MODULE$.refArrayOps(split);
                        Object object3 = Predef$.MODULE$.refArrayOps(split);
                        tuple2 = Tuple2$.MODULE$.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.dropRight$extension(object2, 1)).mkString("."), (Object)((String)ArrayOps$.MODULE$.last$extension(object3)));
                    } else {
                        tuple2 = Tuple2$.MODULE$.apply(split[0], (Object)"");
                    }
                    Tuple2 tuple22 = tuple2;
                    String fileName = (String)tuple22._1();
                    String extension = (String)tuple22._2();
                    String name = new InputOptionPane((Component)parent, I18N$.MODULE$.gui().get("resource.name"), I18N$.MODULE$.gui().get("resource.name"), fileName).getInput();
                    if (name == null) break block8;
                    String trimmed = name.trim();
                    if (trimmed.isEmpty()) {
                        new OptionPane(parent, I18N$.MODULE$.gui().get("common.messages.error"), I18N$.MODULE$.gui().get("resource.nameEmpty"), OptionPane$Options$.MODULE$.Ok(), OptionPane$Icons$.MODULE$.Error());
                        break block8;
                    }
                    byte[] bytes = Files.readAllBytes(path);
                    try {
                        string = StandardCharsets.UTF_8.newDecoder().decode(ByteBuffer.wrap(bytes)).toString();
                    }
                    catch (MalformedInputException malformedInputException) {
                        string = Base64.getEncoder().encodeToString(bytes);
                    }
                    String text = string;
                    ExternalResource resource = new ExternalResource(trimmed, extension, text);
                    if (this.manager.addResource(resource)) {
                        this.refreshList();
                        new Events.DirtyEvent((Option<String>)None$.MODULE$).raise(parent);
                        new Events.ResourcesChangedEvent().raise(parent);
                        break block8;
                    }
                    new OptionPane(parent, I18N$.MODULE$.gui().get("common.messages.error"), I18N$.MODULE$.gui().getN("resource.alreadyExists", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{trimmed})), OptionPane$Options$.MODULE$.Ok(), OptionPane$Icons$.MODULE$.Error());
                }
                catch (UserCancelException e) {}
            }
        });
        this.org$nlogo$app$ResourceManagerDialog$$exportButton = new Button(I18N$.MODULE$.gui().get("resource.export"), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            try {
                ExternalResource resource = (ExternalResource)this.manager.getResource(this.table.getValueAt(this.table.getSelectedRow(), 0).toString()).get();
                FileOutputStream stream = new FileOutputStream(FileDialog$.MODULE$.showFiles((Component)parent, I18N$.MODULE$.gui().get("resource.select"), 1, resource.name() + "." + resource.extension(), FileDialog$.MODULE$.showFiles$default$5()));
                stream.write(Base64.getDecoder().decode(resource.data()));
                stream.close();
            }
            catch (UserCancelException e) {}
        });
        this.org$nlogo$app$ResourceManagerDialog$$renameButton = new Button(I18N$.MODULE$.gui().get("resource.rename"), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            ExternalResource resource = (ExternalResource)this.manager.getResource(this.table.getValueAt(this.table.getSelectedRow(), 0).toString()).get();
            String name = new InputOptionPane((Component)parent, I18N$.MODULE$.gui().get("resource.newName"), I18N$.MODULE$.gui().get("resource.newName"), resource.name()).getInput();
            if (name != null) {
                String trimmed = name.trim();
                if (trimmed.isEmpty()) {
                    new OptionPane(parent, I18N$.MODULE$.gui().get("common.messages.error"), I18N$.MODULE$.gui().get("resource.nameEmpty"), OptionPane$Options$.MODULE$.Ok(), OptionPane$Icons$.MODULE$.Error());
                    return;
                }
                String string = trimmed;
                String string2 = resource.name();
                if (string == null ? string2 != null : !string.equals(string2)) {
                    this.manager.removeResource(resource.name());
                    if (this.manager.addResource(resource.copy(trimmed, resource.copy$default$2(), resource.copy$default$3()))) {
                        this.refreshList();
                        new Events.DirtyEvent((Option<String>)None$.MODULE$).raise(parent);
                        new Events.ResourcesChangedEvent().raise(parent);
                        return;
                    }
                    this.manager.addResource(resource);
                    new OptionPane(parent, I18N$.MODULE$.gui().get("common.messages.error"), I18N$.MODULE$.gui().getN("resource.alreadyExists", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{trimmed})), OptionPane$Options$.MODULE$.Ok(), OptionPane$Icons$.MODULE$.Error());
                    return;
                }
                return;
            }
        });
        this.org$nlogo$app$ResourceManagerDialog$$removeButton = new Button(I18N$.MODULE$.gui().get("resource.remove"), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            this.manager.removeResource(this.table.getValueAt(this.table.getSelectedRow(), 0).toString());
            this.refreshList();
            new Events.DirtyEvent((Option<String>)None$.MODULE$).raise(parent);
            new Events.ResourcesChangedEvent().raise(parent);
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.scrollPane, c);
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.add((Component)((Object)new Transparent(this){
            private final GridBagConstraints c;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super(new GridBagLayout());
                Transparent.$init$(this);
                this.c = new GridBagConstraints();
                this.c().insets = new Insets(0, 6, 6, 6);
                this.add((Component)$outer.org$nlogo$app$ResourceManagerDialog$$addButton, this.c());
                this.c().insets = new Insets(0, 0, 6, 6);
                this.add((Component)$outer.org$nlogo$app$ResourceManagerDialog$$exportButton, this.c());
                this.add((Component)$outer.org$nlogo$app$ResourceManagerDialog$$renameButton, this.c());
                this.add((Component)$outer.org$nlogo$app$ResourceManagerDialog$$removeButton, this.c());
            }

            public GridBagConstraints c() {
                return this.c;
            }
        }), c);
        this.refreshList();
        this.pack();
        Positioning$.MODULE$.center(this, parent);
        Utils$.MODULE$.addEscKeyAction(this, (Action)new AbstractAction(this){
            private final /* synthetic */ ResourceManagerDialog $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void actionPerformed(ActionEvent e) {
                this.$outer.setVisible(false);
            }
        });
        this.syncTheme();
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
    }

    private void refreshList() {
        this.org$nlogo$app$ResourceManagerDialog$$tableModel.setRowCount(0);
        this.manager.getResources().foreach(resource -> this.org$nlogo$app$ResourceManagerDialog$$tableModel.addRow(new Object[]{resource.name(), resource.extension()}));
        this.org$nlogo$app$ResourceManagerDialog$$enableButtons();
    }

    public void org$nlogo$app$ResourceManagerDialog$$enableButtons() {
        this.org$nlogo$app$ResourceManagerDialog$$exportButton.setEnabled(this.table.getSelectedRow() != -1);
        this.org$nlogo$app$ResourceManagerDialog$$renameButton.setEnabled(this.table.getSelectedRow() != -1);
        this.org$nlogo$app$ResourceManagerDialog$$removeButton.setEnabled(this.table.getSelectedRow() != -1);
    }

    @Override
    public void syncTheme() {
        this.getContentPane().setBackground(InterfaceColors$.MODULE$.dialogBackground());
        this.scrollPane.setBackground(InterfaceColors$.MODULE$.dialogBackground());
        this.table.setBackground(InterfaceColors$.MODULE$.dialogBackground());
        this.org$nlogo$app$ResourceManagerDialog$$addButton.syncTheme();
        this.org$nlogo$app$ResourceManagerDialog$$exportButton.syncTheme();
        this.org$nlogo$app$ResourceManagerDialog$$renameButton.syncTheme();
        this.org$nlogo$app$ResourceManagerDialog$$removeButton.syncTheme();
    }

    public class HeaderCellRenderer
    extends JPanel
    implements TableCellRenderer {
        private final JLabel label = new JLabel();

        public HeaderCellRenderer() {
            super(new GridBagLayout());
            this.label.setFont(this.label.getFont().deriveFont(1));
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.weightx = 1.0;
            c.insets = new Insets(3, 6, 3, 6);
            this.add((Component)this.label, c);
            Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.label.setText(value.toString());
            this.setBackground(InterfaceColors$.MODULE$.dialogBackground());
            if (column == 0) {
                this.setBorder(new MatteBorder(0, 0, 1, 0, InterfaceColors$.MODULE$.dialogText()));
            } else {
                this.setBorder(new MatteBorder(0, 1, 1, 0, InterfaceColors$.MODULE$.dialogText()));
            }
            this.label.setForeground(InterfaceColors$.MODULE$.dialogText());
            return this;
        }
    }

    public class ResourceCellRenderer
    extends JPanel
    implements TableCellRenderer {
        private final JLabel label = new JLabel();

        public ResourceCellRenderer() {
            super(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.weightx = 1.0;
            c.insets = new Insets(3, 6, 3, 6);
            this.add((Component)this.label, c);
            Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.label.setText(value.toString());
            if (isSelected) {
                this.setBackground(InterfaceColors$.MODULE$.dialogBackgroundSelected());
                this.label.setForeground(InterfaceColors$.MODULE$.dialogTextSelected());
            } else {
                this.setBackground(InterfaceColors$.MODULE$.dialogBackground());
                this.label.setForeground(InterfaceColors$.MODULE$.dialogText());
            }
            if (column == 0) {
                this.setBorder(new MatteBorder(0, 0, 1, 0, InterfaceColors$.MODULE$.dialogText()));
            } else {
                this.setBorder(new MatteBorder(0, 1, 1, 0, InterfaceColors$.MODULE$.dialogText()));
            }
            return this;
        }
    }
}

