/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app.codetab;

import javax.swing.JTextArea;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.nlogo.api.EditorAreaInterface;
import org.nlogo.editor.AdvancedEditorArea;

public class EditorAreaWrapper
implements EditorAreaInterface {
    private final JTextComponent text;

    public EditorAreaWrapper(JTextComponent text) {
        this.text = text;
    }

    @Override
    public String getLineOfText(int lineNum) {
        int lineStart = this.lineToStartOffset(lineNum);
        int lineEnd = this.lineToEndOffset(lineNum);
        return this.getText(lineStart, lineEnd - lineStart);
    }

    @Override
    public int getCaretPosition() {
        return this.text.getCaretPosition();
    }

    @Override
    public void setCaretPosition(int pos) {
        this.text.setCaretPosition(pos);
    }

    @Override
    public String getText(int start, int len) {
        return this.text.getDocument().getText(start, len);
    }

    @Override
    public int getSelectionStart() {
        return this.text.getSelectionStart();
    }

    @Override
    public int getSelectionEnd() {
        return this.text.getSelectionEnd();
    }

    @Override
    public void setSelectionStart(int pos) {
        this.text.setSelectionStart(pos);
    }

    @Override
    public void setSelectionEnd(int pos) {
        this.text.setSelectionEnd(pos);
    }

    @Override
    public int offsetToLine(int offset) {
        return this.text.getDocument().getDefaultRootElement().getElementIndex(offset);
    }

    @Override
    public int lineToStartOffset(int line) {
        return this.text.getDocument().getDefaultRootElement().getElement(line).getStartOffset();
    }

    @Override
    public int lineToEndOffset(int line) {
        return this.text.getDocument().getDefaultRootElement().getElement(line).getEndOffset();
    }

    @Override
    public void insertString(int pos, String spaces) {
        this.text.getDocument().insertString(pos, spaces, null);
    }

    @Override
    public void replaceSelection(String s) {
        this.text.replaceSelection(s);
    }

    @Override
    public void replace(int start, int len, String str) {
        try {
            JTextComponent jTextComponent = this.text;
            if (jTextComponent instanceof JTextArea) {
                JTextArea textArea = (JTextArea)jTextComponent;
                textArea.replaceRange(str, start, start + len);
            } else {
                Document document = this.text.getDocument();
                if (document instanceof AbstractDocument) {
                    AbstractDocument abstractDoc = (AbstractDocument)document;
                    abstractDoc.replace(start, len, str, null);
                } else {
                    Document doc = document;
                    doc.remove(start, len);
                    doc.insertString(start, str, null);
                }
            }
        }
        catch (IllegalArgumentException ex) {
            throw ex;
        }
        catch (BadLocationException ex) {
            throw ex;
        }
    }

    @Override
    public void remove(int start, int len) {
        this.text.getDocument().remove(start, len);
    }

    @Override
    public void beginCompoundEdit() {
        JTextComponent jTextComponent = this.text;
        if (jTextComponent instanceof AdvancedEditorArea) {
            AdvancedEditorArea a = (AdvancedEditorArea)((Object)jTextComponent);
            a.beginCompoundEdit();
            return;
        }
        EditorAreaInterface.beginCompoundEdit$(this);
    }

    @Override
    public void endCompoundEdit() {
        JTextComponent jTextComponent = this.text;
        if (jTextComponent instanceof AdvancedEditorArea) {
            AdvancedEditorArea a = (AdvancedEditorArea)((Object)jTextComponent);
            a.endCompoundEdit();
            return;
        }
        EditorAreaInterface.endCompoundEdit$(this);
    }
}

