/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app.codetab;

import java.io.Serializable;
import java.util.Locale;
import org.nlogo.api.CompilerServices;
import org.nlogo.api.EditorAreaInterface;
import org.nlogo.app.codetab.SmartIndenter$AddIndent$;
import org.nlogo.app.codetab.SmartIndenter$MaintainIndent$;
import org.nlogo.app.codetab.SmartIndenter$RemoveIndent$;
import org.nlogo.app.codetab.SmartIndenter$TokenizedLine$;
import org.nlogo.core.SourceLocatable;
import org.nlogo.core.Token;
import org.nlogo.core.TokenType;
import org.nlogo.core.TokenType$CloseBracket$;
import org.nlogo.core.TokenType$CloseParen$;
import org.nlogo.core.TokenType$Command$;
import org.nlogo.core.TokenType$Comment$;
import org.nlogo.core.TokenType$Keyword$;
import org.nlogo.core.TokenType$OpenBracket$;
import org.nlogo.core.TokenType$OpenParen$;
import org.nlogo.editor.Indenter;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.BufferedIterator;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

public class SmartIndenter
implements Indenter {
    public final EditorAreaInterface org$nlogo$app$codetab$SmartIndenter$$code;
    private final CompilerServices compiler;
    private final int TAB_WIDTH;
    public final SmartIndenter$TokenizedLine$ TokenizedLine$lzy1;
    public final SmartIndenter$AddIndent$ AddIndent$lzy1;
    public final SmartIndenter$MaintainIndent$ MaintainIndent$lzy1;
    public final SmartIndenter$RemoveIndent$ RemoveIndent$lzy1;

    public SmartIndenter(EditorAreaInterface code, CompilerServices compiler) {
        this.org$nlogo$app$codetab$SmartIndenter$$code = code;
        this.compiler = compiler;
        this.TokenizedLine$lzy1 = new SmartIndenter$TokenizedLine$(this);
        this.AddIndent$lzy1 = new SmartIndenter$AddIndent$(this);
        this.MaintainIndent$lzy1 = new SmartIndenter$MaintainIndent$(this);
        this.RemoveIndent$lzy1 = new SmartIndenter$RemoveIndent$(this);
        this.TAB_WIDTH = 2;
    }

    public final SmartIndenter$TokenizedLine$ TokenizedLine() {
        return this.TokenizedLine$lzy1;
    }

    public final SmartIndenter$AddIndent$ AddIndent() {
        return this.AddIndent$lzy1;
    }

    public final SmartIndenter$MaintainIndent$ MaintainIndent() {
        return this.MaintainIndent$lzy1;
    }

    public final SmartIndenter$RemoveIndent$ RemoveIndent() {
        return this.RemoveIndent$lzy1;
    }

    @Override
    public void handleTab() {
        this.org$nlogo$app$codetab$SmartIndenter$$code.beginCompoundEdit();
        Seq<LineIndent> indentations = this.lineIndentation(this.org$nlogo$app$codetab$SmartIndenter$$code.getSelectionStart(), this.org$nlogo$app$codetab$SmartIndenter$$code.getSelectionEnd());
        if (indentations.nonEmpty()) {
            this.executeIndentations(indentations, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.org$nlogo$app$codetab$SmartIndenter$$code.getCaretPosition())));
        }
        this.org$nlogo$app$codetab$SmartIndenter$$code.endCompoundEdit();
    }

    @Override
    public void handleUntab() {
        this.org$nlogo$app$codetab$SmartIndenter$$code.beginCompoundEdit();
        Seq<LineIndent> indentations = this.lineIndentation(this.org$nlogo$app$codetab$SmartIndenter$$code.getSelectionStart(), this.org$nlogo$app$codetab$SmartIndenter$$code.getSelectionEnd());
        if (indentations.nonEmpty()) {
            this.executeIndentations(indentations, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.org$nlogo$app$codetab$SmartIndenter$$code.getCaretPosition())));
        }
        this.org$nlogo$app$codetab$SmartIndenter$$code.endCompoundEdit();
    }

    @Override
    public void handleEnter() {
        this.org$nlogo$app$codetab$SmartIndenter$$code.beginCompoundEdit();
        this.org$nlogo$app$codetab$SmartIndenter$$code.replaceSelection("\n");
        int originalCaretPosition = this.org$nlogo$app$codetab$SmartIndenter$$code.getCaretPosition();
        int line = this.org$nlogo$app$codetab$SmartIndenter$$code.offsetToLine(this.org$nlogo$app$codetab$SmartIndenter$$code.getSelectionEnd());
        int start = this.org$nlogo$app$codetab$SmartIndenter$$code.lineToStartOffset(line);
        int end = this.org$nlogo$app$codetab$SmartIndenter$$code.lineToEndOffset(line);
        Seq<LineIndent> indentations = this.lineIndentation(start, end - 1);
        if (indentations.nonEmpty()) {
            this.executeIndentations(indentations, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)originalCaretPosition)));
        }
        this.org$nlogo$app$codetab$SmartIndenter$$code.endCompoundEdit();
    }

    @Override
    public void handleInsertion(String s) {
        int lineNum;
        this.org$nlogo$app$codetab$SmartIndenter$$code.beginCompoundEdit();
        if (((List)new .colon.colon((Object)"e", (List)new .colon.colon((Object)"n", (List)new .colon.colon((Object)"d", (List)Nil$.MODULE$)))).contains((Object)s.toLowerCase()) && this.org$nlogo$app$codetab$SmartIndenter$$code.getLineOfText(lineNum = this.org$nlogo$app$codetab$SmartIndenter$$code.offsetToLine(this.org$nlogo$app$codetab$SmartIndenter$$code.getSelectionStart())).trim().equalsIgnoreCase("end")) {
            this.indentSelectedLine();
        }
        this.org$nlogo$app$codetab$SmartIndenter$$code.endCompoundEdit();
    }

    @Override
    public void handleCloseBracket() {
        this.org$nlogo$app$codetab$SmartIndenter$$code.beginCompoundEdit();
        this.org$nlogo$app$codetab$SmartIndenter$$code.replaceSelection("]");
        this.indentSelectedLine();
        this.org$nlogo$app$codetab$SmartIndenter$$code.endCompoundEdit();
    }

    public void indentSelectedLine() {
        Seq<LineIndent> indentations = this.lineIndentation(this.org$nlogo$app$codetab$SmartIndenter$$code.getSelectionStart(), this.org$nlogo$app$codetab$SmartIndenter$$code.getSelectionEnd());
        if (indentations.nonEmpty()) {
            this.executeIndentations(indentations, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.org$nlogo$app$codetab$SmartIndenter$$code.getCaretPosition())));
            return;
        }
    }

    private void executeIndentations(Seq<LineIndent> indentations, Option<Object> caretPosition) {
        int start = ((LineIndent)indentations.head()).lineStart();
        int finish = ((LineIndent)indentations.last()).lineEnd();
        StringBuilder builder = new StringBuilder(finish - start);
        indentations.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(offset, indent) -> this.executeIndentations$$anonfun$1(builder, BoxesRunTime.unboxToInt((Object)offset), (LineIndent)indent));
        builder.delete(builder.length() - 1, builder.length());
        if (caretPosition.isDefined()) {
            caretPosition.foreach((Function1)(JFunction1.mcVI.sp & Serializable)startCaretPosition -> {
                int n;
                int startLine = this.org$nlogo$app$codetab$SmartIndenter$$code.offsetToLine(startCaretPosition);
                if (startCaretPosition >= start) {
                    int caretOffset = BoxesRunTime.unboxToInt((Object)indentations.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(x$1, x$2) -> SmartIndenter.$anonfun$3(startCaretPosition, BoxesRunTime.unboxToInt((Object)x$1), (LineIndent)x$2)));
                    n = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(startCaretPosition + caretOffset), 0);
                } else {
                    n = startCaretPosition;
                }
                int finalCaretPosition = n;
                this.org$nlogo$app$codetab$SmartIndenter$$code.replace(start, finish - start, builder.toString());
                this.org$nlogo$app$codetab$SmartIndenter$$code.setCaretPosition(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(finalCaretPosition), this.org$nlogo$app$codetab$SmartIndenter$$code.lineToStartOffset(startLine)));
            });
            return;
        }
        this.org$nlogo$app$codetab$SmartIndenter$$code.replace(start, finish - start, builder.toString());
    }

    private Seq<LineIndent> lineIndentation(int startOffset, int endOffset) {
        Tuple3 initialFoldParams;
        int endLine = this.org$nlogo$app$codetab$SmartIndenter$$code.offsetToLine(endOffset);
        int endOfEndLine = this.org$nlogo$app$codetab$SmartIndenter$$code.lineToEndOffset(endLine);
        BufferedIterator tokensFromZero = this.compiler.tokenizeForColorizationIterator(this.org$nlogo$app$codetab$SmartIndenter$$code.getText(0, endOfEndLine)).buffered();
        TokenLineIterator tokLineIter = new TokenLineIterator(this, (BufferedIterator<Token>)tokensFromZero, endLine);
        Tuple3 tuple3 = (Tuple3)tokLineIter.foldLeft(initialFoldParams = Tuple3$.MODULE$.apply((Object)package$.MODULE$.List().empty(), (Object)Option$.MODULE$.empty(), (Object)package$.MODULE$.Seq().empty()), (Function2 & Serializable)(acc, line) -> this.foldLineIndentations((Tuple3<List<Object>, Option<TokenizedLine>, Seq<LineIndent>>)acc, (TokenizedLine)line));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Seq lineIndents = (Seq)tuple3._3();
        Seq lineIndents2 = lineIndents;
        return (Seq)((IterableOps)lineIndents2.reverse()).dropWhile((Function1 & Serializable)_$5 -> _$5.lineEnd() < startOffset);
    }

    private Tuple3<List<Object>, Option<TokenizedLine>, Seq<LineIndent>> foldLineIndentations(Tuple3<List<Object>, Option<TokenizedLine>, Seq<LineIndent>> acc, TokenizedLine line) {
        Seq seq;
        int caretOffset;
        Tuple3<List<Object>, Option<TokenizedLine>, Seq<LineIndent>> tuple3 = acc;
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        List indentLevels = (List)tuple3._1();
        Option priorLine = (Option)tuple3._2();
        Seq indentAcc = (Seq)tuple3._3();
        Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)indentLevels, (Object)priorLine, (Object)indentAcc);
        List indentLevels2 = (List)tuple32._1();
        Option priorLine2 = (Option)tuple32._2();
        Seq indentAcc2 = (Seq)tuple32._3();
        int thisIndent = this.lineIndentationLevel((List<Object>)indentLevels2, line, (Option<TokenizedLine>)priorLine2, (Option<LineIndent>)indentAcc2.headOption());
        List<Object> newIndentLevels = this.indentationChange((List<Object>)indentLevels2, line, (Option<TokenizedLine>)priorLine2, (Option<LineIndent>)indentAcc2.headOption());
        int n = caretOffset = line.lineStart() <= this.org$nlogo$app$codetab$SmartIndenter$$code.getCaretPosition() && line.lineEnd() > this.org$nlogo$app$codetab$SmartIndenter$$code.getCaretPosition() && line.tokens().isEmpty() ? line.leadingSpaces() - (this.org$nlogo$app$codetab$SmartIndenter$$code.getCaretPosition() - line.lineStart()) : 0;
        if (thisIndent - line.leadingSpaces() == 0) {
            MaintainIndent maintainIndent = this.MaintainIndent().apply(line.lineNum(), line.lineStart(), line.lineEnd(), line.text(), caretOffset);
            seq = (Seq)indentAcc2.$plus$colon((Object)maintainIndent);
        } else if (thisIndent - line.leadingSpaces() > 0) {
            AddIndent addIndent = this.AddIndent().apply(line.lineNum(), line.lineStart(), line.lineEnd(), line.text(), thisIndent - line.leadingSpaces(), caretOffset);
            seq = (Seq)indentAcc2.$plus$colon((Object)addIndent);
        } else {
            RemoveIndent removeIndent = this.RemoveIndent().apply(line.lineNum(), line.lineStart(), line.lineEnd(), line.text(), thisIndent - line.leadingSpaces(), caretOffset);
            seq = (Seq)indentAcc2.$plus$colon((Object)removeIndent);
        }
        Seq newIndentAcc = seq;
        return Tuple3$.MODULE$.apply(newIndentLevels, (Object)Some$.MODULE$.apply((Object)line), (Object)newIndentAcc);
    }

    private int lineIndentationLevel(List<Object> indentLevels, TokenizedLine line, Option<TokenizedLine> priorLine, Option<LineIndent> priorAdjustment) {
        int priorIndentLevel = BoxesRunTime.unboxToInt((Object)indentLevels.headOption().getOrElse(SmartIndenter::$anonfun$5));
        Option option = line.tokens().headOption().map((Function1 & Serializable)_$6 -> _$6.tpe());
        if (option instanceof Some) {
            TokenType tokenType = (TokenType)((Some)option).value();
            if (TokenType$Keyword$.MODULE$.equals(tokenType)) {
                return 0;
            }
            if (TokenType$CloseBracket$.MODULE$.equals(tokenType) && line.bracketDelta() == 0) {
                return RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(priorIndentLevel - this.TAB_WIDTH), 0);
            }
            if (TokenType$CloseBracket$.MODULE$.equals(tokenType) || TokenType$CloseParen$.MODULE$.equals(tokenType)) {
                if (line.bracketDelta() < 0) {
                    if (indentLevels.length() > line.bracketsClosed()) {
                        return RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)indentLevels.apply(line.bracketsClosed()))), 0);
                    }
                    return BoxesRunTime.unboxToInt((Object)indentLevels.lastOption().getOrElse(SmartIndenter::lineIndentationLevel$$anonfun$2)) - this.TAB_WIDTH;
                }
            }
            if (TokenType$Comment$.MODULE$.equals(tokenType) && line.isOnlyComment()) {
                return BoxesRunTime.unboxToInt((Object)priorLine.flatMap((Function1 & Serializable)lastLine -> priorAdjustment.flatMap((Function1 & Serializable)adjustment -> lastLine.finalCommentStart().map((Function1)(JFunction1.mcII.sp & Serializable)finalCommentStart -> finalCommentStart + adjustment.delta()))).getOrElse(() -> SmartIndenter.lineIndentationLevel$$anonfun$4(priorIndentLevel)));
            }
            if (TokenType$OpenBracket$.MODULE$.equals(tokenType)) {
                return BoxesRunTime.unboxToInt((Object)this.preIndentationAmount(priorIndentLevel, line, priorLine, priorAdjustment).getOrElse(() -> SmartIndenter.lineIndentationLevel$$anonfun$5(priorIndentLevel)));
            }
        }
        return priorIndentLevel;
    }

    private Option<Object> preIndentationAmount(int priorIndentLevel, TokenizedLine line, Option<TokenizedLine> priorLine, Option<LineIndent> priorAdjustment) {
        if (line.leadingSpaces() > priorIndentLevel) {
            return priorLine.withFilter((Function1 & Serializable)lineAbove -> lineAbove.tokens().headOption().exists((Function1 & Serializable)_$7 -> {
                TokenType tokenType = _$7.tpe();
                TokenType$Command$ tokenType$Command$ = TokenType$Command$.MODULE$;
                return !(tokenType != null ? !tokenType.equals(tokenType$Command$) : tokenType$Command$ != null);
            }) && lineAbove.bracketDelta() == 0).flatMap((Function1 & Serializable)lineAbove -> priorAdjustment.map((Function1 & Serializable)adjustment -> {
                int leadingSpaces = line.leadingSpaces() + adjustment.delta();
                return Tuple2$.MODULE$.apply(adjustment, (Object)BoxesRunTime.boxToInteger((int)leadingSpaces));
            }).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    LineIndent adjustment = (LineIndent)tuple2._1();
                    int leadingSpaces = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    if (leadingSpaces % this.TAB_WIDTH == 1) {
                        return leadingSpaces + leadingSpaces % this.TAB_WIDTH;
                    }
                    return leadingSpaces;
                }
                throw new MatchError((Object)tuple2);
            }));
        }
        return None$.MODULE$;
    }

    private List<Object> indentationChange(List<Object> indentLevels, TokenizedLine line, Option<TokenizedLine> priorLine, Option<LineIndent> priorAdjustment) {
        int priorIndentLevel = BoxesRunTime.unboxToInt((Object)indentLevels.headOption().getOrElse(SmartIndenter::$anonfun$6));
        Option option = line.tokens().headOption().map((Function1 & Serializable)t -> Tuple2$.MODULE$.apply((Object)t.tpe(), (Object)t.text().toUpperCase(Locale.ENGLISH)));
        if (option instanceof Some) {
            Tuple2 tuple2 = (Tuple2)((Some)option).value();
            if (tuple2 != null) {
                TokenType tokenType = (TokenType)tuple2._1();
                String string = (String)tuple2._2();
                if (TokenType$Keyword$.MODULE$.equals(tokenType)) {
                    if ("TO".equals(string) || "TO-REPORT".equals(string)) {
                        return (List)new .colon.colon((Object)BoxesRunTime.boxToInteger((int)this.TAB_WIDTH), (List)Nil$.MODULE$);
                    }
                    if (line.bracketDelta() == 0) {
                        return (List)Nil$.MODULE$;
                    }
                }
                if (TokenType$OpenBracket$.MODULE$.equals(tokenType) && line.bracketDelta() > 0) {
                    return (List)this.preIndentationAmount(priorIndentLevel, line, priorLine, priorAdjustment).map((Function1)(JFunction1.mcII.sp & Serializable)_$8 -> _$8 + this.TAB_WIDTH).map((Function1 & Serializable)i -> SmartIndenter.indentationChange$$anonfun$3(line, indentLevels, BoxesRunTime.unboxToInt((Object)i))).getOrElse(() -> this.indentationChange$$anonfun$4(line, priorIndentLevel, indentLevels));
                }
            }
            if (line.bracketDelta() > 0) {
                return (List)package$.MODULE$.List().fill(line.bracketDelta(), () -> this.indentationChange$$anonfun$5(priorIndentLevel)).$plus$plus(indentLevels);
            }
            if (line.bracketDelta() < 0) {
                return (List)indentLevels.drop(-line.bracketDelta());
            }
        }
        return indentLevels;
    }

    public int org$nlogo$app$codetab$SmartIndenter$$countLeadingSpaces(String s) {
        return StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)_$9 -> SmartIndenter.countLeadingSpaces$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$9)))));
    }

    private String spaces(int n) {
        return package$.MODULE$.List().fill(n, SmartIndenter::spaces$$anonfun$1).mkString();
    }

    public static final /* synthetic */ TokenType org$nlogo$app$codetab$SmartIndenter$TokenizedLine$$_$bracketDelta$lzyINIT1$$anonfun$1(Token _$1) {
        return _$1.tpe();
    }

    private static final /* synthetic */ int bracketDelta$lzyINIT1$$anonfun$2(int x$1, TokenType x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)x$1), (Object)x$2);
        if (tuple2 != null) {
            int n = BoxesRunTime.unboxToInt((Object)tuple2._1());
            TokenType tokenType = (TokenType)tuple2._2();
            int i = n;
            if (TokenType$OpenBracket$.MODULE$.equals(tokenType) || TokenType$OpenParen$.MODULE$.equals(tokenType)) {
                return i + 1;
            }
            int i2 = n;
            if (TokenType$CloseBracket$.MODULE$.equals(tokenType) || TokenType$CloseParen$.MODULE$.equals(tokenType)) {
                return i2 - 1;
            }
            int i3 = n;
            return i3;
        }
        throw new MatchError((Object)tuple2);
    }

    public static /* bridge */ /* synthetic */ int org$nlogo$app$codetab$SmartIndenter$TokenizedLine$$_$bracketDelta$lzyINIT1$$anonfun$adapted$1(Object x$1, Object x$2) {
        return SmartIndenter.bracketDelta$lzyINIT1$$anonfun$2(BoxesRunTime.unboxToInt((Object)x$1), (TokenType)x$2);
    }

    public static final /* synthetic */ TokenType org$nlogo$app$codetab$SmartIndenter$TokenizedLine$$_$_$$anonfun$1(Token _$2) {
        return _$2.tpe();
    }

    public static final /* synthetic */ Tuple2 org$nlogo$app$codetab$SmartIndenter$TokenizedLine$$_$_$$anonfun$2(Tuple2 x$1, TokenType x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)x$1, (Object)x$2);
        if (tuple2 != null) {
            Tuple2 tuple22 = (Tuple2)tuple2._1();
            TokenType tokenType = (TokenType)tuple2._2();
            if (tuple22 != null) {
                int n = tuple22._1$mcI$sp();
                int n2 = tuple22._2$mcI$sp();
                int currentDelta = n;
                int maxClosed = n2;
                if (TokenType$CloseBracket$.MODULE$.equals(tokenType) || TokenType$CloseParen$.MODULE$.equals(tokenType)) {
                    return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(currentDelta + 1)), (Object)BoxesRunTime.boxToInteger((int)RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(maxClosed), currentDelta + 1)));
                }
                int currentDelta2 = n;
                int maxClosed2 = n2;
                if (TokenType$OpenBracket$.MODULE$.equals(tokenType) || TokenType$OpenParen$.MODULE$.equals(tokenType)) {
                    return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(currentDelta2 - 1)), (Object)BoxesRunTime.boxToInteger((int)maxClosed2));
                }
                int currentDelta3 = n;
                int maxClosed3 = n2;
                return new Tuple2.mcII.sp(currentDelta3, maxClosed3);
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean org$nlogo$app$codetab$SmartIndenter$TokenizedLine$$_$finalCommentStart$lzyINIT1$$anonfun$1(Token _$3) {
        TokenType tokenType = _$3.tpe();
        TokenType$Comment$ tokenType$Comment$ = TokenType$Comment$.MODULE$;
        return !(tokenType != null ? !tokenType.equals(tokenType$Comment$) : tokenType$Comment$ != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final /* synthetic */ int executeIndentations$$anonfun$1(StringBuilder builder$1, int offset, LineIndent indent) {
        int n;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)offset), (Object)indent);
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        int n2 = BoxesRunTime.unboxToInt((Object)tuple2._1());
        LineIndent lineIndent = (LineIndent)tuple2._2();
        int offset2 = n2;
        if (lineIndent instanceof AddIndent && ((AddIndent)lineIndent).org$nlogo$app$codetab$SmartIndenter$AddIndent$$$outer() == this) {
            AddIndent addIndent = this.AddIndent().unapply((AddIndent)lineIndent);
            int n3 = addIndent._1();
            int n4 = addIndent._2();
            int n5 = addIndent._3();
            String string = addIndent._4();
            int n6 = addIndent._5();
            int n7 = addIndent._6();
            String text = string;
            int delta = n6;
            builder$1.append(this.spaces(delta));
            builder$1.append(text);
            n = offset2 + delta;
        } else {
            int offset3 = n2;
            if (lineIndent instanceof RemoveIndent && ((RemoveIndent)lineIndent).org$nlogo$app$codetab$SmartIndenter$RemoveIndent$$$outer() == this) {
                RemoveIndent removeIndent = this.RemoveIndent().unapply((RemoveIndent)lineIndent);
                int n8 = removeIndent._1();
                int n9 = removeIndent._2();
                int n10 = removeIndent._3();
                String string = removeIndent._4();
                int n11 = removeIndent._5();
                int n12 = removeIndent._6();
                String text = string;
                int delta = n11;
                if (text.length() > -delta) {
                    builder$1.append(text.substring(-delta, text.length()));
                }
                n = offset3 + delta;
            } else {
                int offset4 = n2;
                if (!(lineIndent instanceof MaintainIndent) || ((MaintainIndent)lineIndent).org$nlogo$app$codetab$SmartIndenter$MaintainIndent$$$outer() != this) throw new MatchError((Object)tuple2);
                MaintainIndent maintainIndent = this.MaintainIndent().unapply((MaintainIndent)lineIndent);
                int n13 = maintainIndent._1();
                int n14 = maintainIndent._2();
                int n15 = maintainIndent._3();
                String string = maintainIndent._4();
                int n16 = maintainIndent._5();
                String text = string;
                builder$1.append(text);
                n = offset4;
            }
        }
        int newOffset = n;
        builder$1.append("\n");
        return newOffset;
    }

    private static final /* synthetic */ int $anonfun$3(int startCaretPosition$1, int x$1, LineIndent x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)x$1), (Object)x$2);
        if (tuple2 != null) {
            int n = BoxesRunTime.unboxToInt((Object)tuple2._1());
            LineIndent lineIndent = (LineIndent)tuple2._2();
            int offset = n;
            LineIndent indent = lineIndent;
            if (indent.lineStart() <= startCaretPosition$1 + 1) {
                return offset + indent.delta() + indent.caretOffset();
            }
            int offset2 = n;
            LineIndent indent2 = lineIndent;
            return offset2;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final int $anonfun$5() {
        return 0;
    }

    private static final int lineIndentationLevel$$anonfun$2() {
        return 2;
    }

    private static final int lineIndentationLevel$$anonfun$4(int priorIndentLevel$1) {
        return priorIndentLevel$1;
    }

    private static final int lineIndentationLevel$$anonfun$5(int priorIndentLevel$2) {
        return priorIndentLevel$2;
    }

    private static final int $anonfun$6() {
        return 0;
    }

    private static final int indentationChange$$anonfun$3$$anonfun$1(int i$1) {
        return i$1;
    }

    private static final /* synthetic */ List indentationChange$$anonfun$3(TokenizedLine line$3, List indentLevels$1, int i) {
        return (List)package$.MODULE$.List().fill(line$3.bracketDelta(), () -> SmartIndenter.indentationChange$$anonfun$3$$anonfun$1(i)).$plus$plus((IterableOnce)indentLevels$1);
    }

    private final int indentationChange$$anonfun$4$$anonfun$1(int priorIndentLevel$4) {
        return priorIndentLevel$4 + this.TAB_WIDTH;
    }

    private final List indentationChange$$anonfun$4(TokenizedLine line$4, int priorIndentLevel$3, List indentLevels$2) {
        return (List)package$.MODULE$.List().fill(line$4.bracketDelta(), () -> this.indentationChange$$anonfun$4$$anonfun$1(priorIndentLevel$3)).$plus$plus((IterableOnce)indentLevels$2);
    }

    private final int indentationChange$$anonfun$5(int priorIndentLevel$5) {
        return priorIndentLevel$5 + this.TAB_WIDTH;
    }

    private static final /* synthetic */ boolean countLeadingSpaces$$anonfun$1(char _$9) {
        return _$9 == ' ';
    }

    private static final char spaces$$anonfun$1() {
        return ' ';
    }

    public class AddIndent
    implements LineIndent,
    Product,
    Serializable {
        private final int lineNum;
        private final int lineStart;
        private final int lineEnd;
        private final String text;
        private final int delta;
        private final int caretOffset;
        private final /* synthetic */ SmartIndenter $outer;

        public AddIndent(SmartIndenter $outer, int lineNum, int lineStart, int lineEnd, String text, int delta, int caretOffset) {
            this.lineNum = lineNum;
            this.lineStart = lineStart;
            this.lineEnd = lineEnd;
            this.text = text;
            this.delta = delta;
            this.caretOffset = caretOffset;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.lineNum());
            n = Statics.mix((int)n, (int)this.lineStart());
            n = Statics.mix((int)n, (int)this.lineEnd());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.text()));
            n = Statics.mix((int)n, (int)this.delta());
            n = Statics.mix((int)n, (int)this.caretOffset());
            return Statics.finalizeHash((int)n, (int)6);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AddIndent)) return false;
            if (((AddIndent)object).org$nlogo$app$codetab$SmartIndenter$AddIndent$$$outer() != this.$outer) return false;
            AddIndent addIndent = (AddIndent)object;
            if (this.lineNum() != addIndent.lineNum()) return false;
            if (this.lineStart() != addIndent.lineStart()) return false;
            if (this.lineEnd() != addIndent.lineEnd()) return false;
            if (this.delta() != addIndent.delta()) return false;
            if (this.caretOffset() != addIndent.caretOffset()) return false;
            String string = this.text();
            String string2 = addIndent.text();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!addIndent.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof AddIndent;
        }

        public int productArity() {
            return 6;
        }

        public String productPrefix() {
            return "AddIndent";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return BoxesRunTime.boxToInteger((int)this._5());
                }
                case 5: {
                    return BoxesRunTime.boxToInteger((int)this._6());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "lineNum";
                }
                case 1: {
                    return "lineStart";
                }
                case 2: {
                    return "lineEnd";
                }
                case 3: {
                    return "text";
                }
                case 4: {
                    return "delta";
                }
                case 5: {
                    return "caretOffset";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public int lineNum() {
            return this.lineNum;
        }

        @Override
        public int lineStart() {
            return this.lineStart;
        }

        @Override
        public int lineEnd() {
            return this.lineEnd;
        }

        @Override
        public String text() {
            return this.text;
        }

        @Override
        public int delta() {
            return this.delta;
        }

        @Override
        public int caretOffset() {
            return this.caretOffset;
        }

        public AddIndent copy(int lineNum, int lineStart, int lineEnd, String text, int delta, int caretOffset) {
            return new AddIndent(this.$outer, lineNum, lineStart, lineEnd, text, delta, caretOffset);
        }

        public int copy$default$1() {
            return this.lineNum();
        }

        public int copy$default$2() {
            return this.lineStart();
        }

        public int copy$default$3() {
            return this.lineEnd();
        }

        public String copy$default$4() {
            return this.text();
        }

        public int copy$default$5() {
            return this.delta();
        }

        public int copy$default$6() {
            return this.caretOffset();
        }

        public int _1() {
            return this.lineNum();
        }

        public int _2() {
            return this.lineStart();
        }

        public int _3() {
            return this.lineEnd();
        }

        public String _4() {
            return this.text();
        }

        public int _5() {
            return this.delta();
        }

        public int _6() {
            return this.caretOffset();
        }

        public final /* synthetic */ SmartIndenter org$nlogo$app$codetab$SmartIndenter$AddIndent$$$outer() {
            return this.$outer;
        }
    }

    public interface LineIndent {
        public int lineNum();

        public int lineStart();

        public int lineEnd();

        public String text();

        public int delta();

        public int caretOffset();
    }

    public class MaintainIndent
    implements LineIndent,
    Product,
    Serializable {
        private final int lineNum;
        private final int lineStart;
        private final int lineEnd;
        private final String text;
        private final int caretOffset;
        private final /* synthetic */ SmartIndenter $outer;

        public MaintainIndent(SmartIndenter $outer, int lineNum, int lineStart, int lineEnd, String text, int caretOffset) {
            this.lineNum = lineNum;
            this.lineStart = lineStart;
            this.lineEnd = lineEnd;
            this.text = text;
            this.caretOffset = caretOffset;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.lineNum());
            n = Statics.mix((int)n, (int)this.lineStart());
            n = Statics.mix((int)n, (int)this.lineEnd());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.text()));
            n = Statics.mix((int)n, (int)this.caretOffset());
            return Statics.finalizeHash((int)n, (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MaintainIndent)) return false;
            if (((MaintainIndent)object).org$nlogo$app$codetab$SmartIndenter$MaintainIndent$$$outer() != this.$outer) return false;
            MaintainIndent maintainIndent = (MaintainIndent)object;
            if (this.lineNum() != maintainIndent.lineNum()) return false;
            if (this.lineStart() != maintainIndent.lineStart()) return false;
            if (this.lineEnd() != maintainIndent.lineEnd()) return false;
            if (this.caretOffset() != maintainIndent.caretOffset()) return false;
            String string = this.text();
            String string2 = maintainIndent.text();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!maintainIndent.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MaintainIndent;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "MaintainIndent";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return BoxesRunTime.boxToInteger((int)this._5());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "lineNum";
                }
                case 1: {
                    return "lineStart";
                }
                case 2: {
                    return "lineEnd";
                }
                case 3: {
                    return "text";
                }
                case 4: {
                    return "caretOffset";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public int lineNum() {
            return this.lineNum;
        }

        @Override
        public int lineStart() {
            return this.lineStart;
        }

        @Override
        public int lineEnd() {
            return this.lineEnd;
        }

        @Override
        public String text() {
            return this.text;
        }

        @Override
        public int caretOffset() {
            return this.caretOffset;
        }

        @Override
        public int delta() {
            return 0;
        }

        public MaintainIndent copy(int lineNum, int lineStart, int lineEnd, String text, int caretOffset) {
            return new MaintainIndent(this.$outer, lineNum, lineStart, lineEnd, text, caretOffset);
        }

        public int copy$default$1() {
            return this.lineNum();
        }

        public int copy$default$2() {
            return this.lineStart();
        }

        public int copy$default$3() {
            return this.lineEnd();
        }

        public String copy$default$4() {
            return this.text();
        }

        public int copy$default$5() {
            return this.caretOffset();
        }

        public int _1() {
            return this.lineNum();
        }

        public int _2() {
            return this.lineStart();
        }

        public int _3() {
            return this.lineEnd();
        }

        public String _4() {
            return this.text();
        }

        public int _5() {
            return this.caretOffset();
        }

        public final /* synthetic */ SmartIndenter org$nlogo$app$codetab$SmartIndenter$MaintainIndent$$$outer() {
            return this.$outer;
        }
    }

    public class RemoveIndent
    implements LineIndent,
    Product,
    Serializable {
        private final int lineNum;
        private final int lineStart;
        private final int lineEnd;
        private final String text;
        private final int delta;
        private final int caretOffset;
        private final /* synthetic */ SmartIndenter $outer;

        public RemoveIndent(SmartIndenter $outer, int lineNum, int lineStart, int lineEnd, String text, int delta, int caretOffset) {
            this.lineNum = lineNum;
            this.lineStart = lineStart;
            this.lineEnd = lineEnd;
            this.text = text;
            this.delta = delta;
            this.caretOffset = caretOffset;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.lineNum());
            n = Statics.mix((int)n, (int)this.lineStart());
            n = Statics.mix((int)n, (int)this.lineEnd());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.text()));
            n = Statics.mix((int)n, (int)this.delta());
            n = Statics.mix((int)n, (int)this.caretOffset());
            return Statics.finalizeHash((int)n, (int)6);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RemoveIndent)) return false;
            if (((RemoveIndent)object).org$nlogo$app$codetab$SmartIndenter$RemoveIndent$$$outer() != this.$outer) return false;
            RemoveIndent removeIndent = (RemoveIndent)object;
            if (this.lineNum() != removeIndent.lineNum()) return false;
            if (this.lineStart() != removeIndent.lineStart()) return false;
            if (this.lineEnd() != removeIndent.lineEnd()) return false;
            if (this.delta() != removeIndent.delta()) return false;
            if (this.caretOffset() != removeIndent.caretOffset()) return false;
            String string = this.text();
            String string2 = removeIndent.text();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!removeIndent.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RemoveIndent;
        }

        public int productArity() {
            return 6;
        }

        public String productPrefix() {
            return "RemoveIndent";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return BoxesRunTime.boxToInteger((int)this._5());
                }
                case 5: {
                    return BoxesRunTime.boxToInteger((int)this._6());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "lineNum";
                }
                case 1: {
                    return "lineStart";
                }
                case 2: {
                    return "lineEnd";
                }
                case 3: {
                    return "text";
                }
                case 4: {
                    return "delta";
                }
                case 5: {
                    return "caretOffset";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public int lineNum() {
            return this.lineNum;
        }

        @Override
        public int lineStart() {
            return this.lineStart;
        }

        @Override
        public int lineEnd() {
            return this.lineEnd;
        }

        @Override
        public String text() {
            return this.text;
        }

        @Override
        public int delta() {
            return this.delta;
        }

        @Override
        public int caretOffset() {
            return this.caretOffset;
        }

        public RemoveIndent copy(int lineNum, int lineStart, int lineEnd, String text, int delta, int caretOffset) {
            return new RemoveIndent(this.$outer, lineNum, lineStart, lineEnd, text, delta, caretOffset);
        }

        public int copy$default$1() {
            return this.lineNum();
        }

        public int copy$default$2() {
            return this.lineStart();
        }

        public int copy$default$3() {
            return this.lineEnd();
        }

        public String copy$default$4() {
            return this.text();
        }

        public int copy$default$5() {
            return this.delta();
        }

        public int copy$default$6() {
            return this.caretOffset();
        }

        public int _1() {
            return this.lineNum();
        }

        public int _2() {
            return this.lineStart();
        }

        public int _3() {
            return this.lineEnd();
        }

        public String _4() {
            return this.text();
        }

        public int _5() {
            return this.delta();
        }

        public int _6() {
            return this.caretOffset();
        }

        public final /* synthetic */ SmartIndenter org$nlogo$app$codetab$SmartIndenter$RemoveIndent$$$outer() {
            return this.$outer;
        }
    }

    public class TokenLineIterator
    implements Iterator<TokenizedLine> {
        private final BufferedIterator<Token> tokens;
        private final int endLine;
        private int currentLine;
        private int priorEnd;
        private final /* synthetic */ SmartIndenter $outer;

        public TokenLineIterator(SmartIndenter $outer, BufferedIterator<Token> tokens, int endLine) {
            this.tokens = tokens;
            this.endLine = endLine;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            IterableOnce.$init$((IterableOnce)this);
            IterableOnceOps.$init$((IterableOnceOps)this);
            Iterator.$init$((Iterator)this);
            this.currentLine = 0;
            this.priorEnd = -1;
        }

        public int currentLine() {
            return this.currentLine;
        }

        public void currentLine_$eq(int x$1) {
            this.currentLine = x$1;
        }

        public int priorEnd() {
            return this.priorEnd;
        }

        public void priorEnd_$eq(int x$1) {
            this.priorEnd = x$1;
        }

        public boolean hasNext() {
            return this.currentLine() <= this.endLine;
        }

        public TokenizedLine next() {
            TokenizedLine tokenizedLine;
            int lineStart = this.$outer.org$nlogo$app$codetab$SmartIndenter$$code.lineToStartOffset(this.currentLine());
            int rawEnd = this.$outer.org$nlogo$app$codetab$SmartIndenter$$code.lineToEndOffset(this.currentLine());
            while (((SourceLocatable)this.tokens.head()).end() < lineStart) {
                this.tokens.next();
            }
            String rawText = this.$outer.org$nlogo$app$codetab$SmartIndenter$$code.getText(lineStart, rawEnd - lineStart);
            Tuple2 tuple2 = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(rawText)) && StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(rawText)) == '\n' ? Tuple2$.MODULE$.apply((Object)rawText.substring(0, rawEnd - (lineStart + 1)), (Object)BoxesRunTime.boxToInteger((int)(rawEnd - 1))) : Tuple2$.MODULE$.apply((Object)rawText, (Object)BoxesRunTime.boxToInteger((int)rawEnd));
            String text = (String)tuple2._1();
            int lineEnd = BoxesRunTime.unboxToInt((Object)tuple2._2());
            int spaces = this.$outer.org$nlogo$app$codetab$SmartIndenter$$countLeadingSpaces(text);
            if (((SourceLocatable)this.tokens.head()).start() > lineEnd) {
                tokenizedLine = this.$outer.TokenizedLine().apply(this.currentLine(), lineStart, lineEnd, text, spaces, (Seq<Token>)((Seq)package$.MODULE$.Seq().empty()));
            } else {
                Seq lineTokensReversed = (Seq)package$.MODULE$.Seq().empty();
                while (this.tokens.hasNext() && ((SourceLocatable)this.tokens.head()).start() < lineEnd) {
                    Token token = (Token)this.tokens.next();
                    lineTokensReversed = (Seq)lineTokensReversed.$plus$colon((Object)token);
                }
                tokenizedLine = this.$outer.TokenizedLine().apply(this.currentLine(), lineStart, lineEnd, text, spaces, (Seq<Token>)((Seq)lineTokensReversed.reverse()));
            }
            TokenizedLine tokLine = tokenizedLine;
            this.priorEnd_$eq(lineEnd);
            this.currentLine_$eq(this.currentLine() + 1);
            return tokLine;
        }

        public final /* synthetic */ SmartIndenter org$nlogo$app$codetab$SmartIndenter$TokenLineIterator$$$outer() {
            return this.$outer;
        }
    }

    public class TokenizedLine
    implements Product,
    Serializable {
        public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(TokenizedLine.class.getDeclaredField("isOnlyComment$lzy1"));
        public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(TokenizedLine.class.getDeclaredField("finalCommentStart$lzy1"));
        public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(TokenizedLine.class.getDeclaredField("bracketsClosed$lzy1"));
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(TokenizedLine.class.getDeclaredField("bracketDelta$lzy1"));
        private final int lineNum;
        private final int lineStart;
        private final int lineEnd;
        private final String text;
        private final int leadingSpaces;
        private final Seq<Token> tokens;
        private volatile Object bracketDelta$lzy1;
        private volatile Object bracketsClosed$lzy1;
        private volatile Object finalCommentStart$lzy1;
        private volatile Object isOnlyComment$lzy1;
        private final /* synthetic */ SmartIndenter $outer;

        public TokenizedLine(SmartIndenter $outer, int lineNum, int lineStart, int lineEnd, String text, int leadingSpaces, Seq<Token> tokens) {
            this.lineNum = lineNum;
            this.lineStart = lineStart;
            this.lineEnd = lineEnd;
            this.text = text;
            this.leadingSpaces = leadingSpaces;
            this.tokens = tokens;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.lineNum());
            n = Statics.mix((int)n, (int)this.lineStart());
            n = Statics.mix((int)n, (int)this.lineEnd());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.text()));
            n = Statics.mix((int)n, (int)this.leadingSpaces());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.tokens()));
            return Statics.finalizeHash((int)n, (int)6);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TokenizedLine)) return false;
            if (((TokenizedLine)object).org$nlogo$app$codetab$SmartIndenter$TokenizedLine$$$outer() != this.$outer) return false;
            TokenizedLine tokenizedLine = (TokenizedLine)object;
            if (this.lineNum() != tokenizedLine.lineNum()) return false;
            if (this.lineStart() != tokenizedLine.lineStart()) return false;
            if (this.lineEnd() != tokenizedLine.lineEnd()) return false;
            if (this.leadingSpaces() != tokenizedLine.leadingSpaces()) return false;
            String string = this.text();
            String string2 = tokenizedLine.text();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Seq<Token> seq = this.tokens();
            Seq<Token> seq2 = tokenizedLine.tokens();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!tokenizedLine.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof TokenizedLine;
        }

        public int productArity() {
            return 6;
        }

        public String productPrefix() {
            return "TokenizedLine";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return BoxesRunTime.boxToInteger((int)this._5());
                }
                case 5: {
                    return this._6();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "lineNum";
                }
                case 1: {
                    return "lineStart";
                }
                case 2: {
                    return "lineEnd";
                }
                case 3: {
                    return "text";
                }
                case 4: {
                    return "leadingSpaces";
                }
                case 5: {
                    return "tokens";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int lineNum() {
            return this.lineNum;
        }

        public int lineStart() {
            return this.lineStart;
        }

        public int lineEnd() {
            return this.lineEnd;
        }

        public String text() {
            return this.text;
        }

        public int leadingSpaces() {
            return this.leadingSpaces;
        }

        public Seq<Token> tokens() {
            return this.tokens;
        }

        public int bracketDelta() {
            Object object = this.bracketDelta$lzy1;
            if (object instanceof Integer) {
                return BoxesRunTime.unboxToInt((Object)object);
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return BoxesRunTime.unboxToInt(null);
            }
            return BoxesRunTime.unboxToInt((Object)this.bracketDelta$lzyINIT1());
        }

        private Object bracketDelta$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.bracketDelta$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals.Evaluating$.MODULE$)) continue;
                        Serializable serializable = null;
                        Integer n = null;
                        try {
                            n = BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.tokens().map(SmartIndenter::org$nlogo$app$codetab$SmartIndenter$TokenizedLine$$_$bracketDelta$lzyINIT1$$anonfun$1)).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), SmartIndenter::org$nlogo$app$codetab$SmartIndenter$TokenizedLine$$_$bracketDelta$lzyINIT1$$anonfun$adapted$1)));
                            serializable = n == null ? LazyVals.NullValue$.MODULE$ : n;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals.Evaluating$.MODULE$, serializable)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.bracketDelta$lzy1;
                                LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, serializable);
                                waiting.countDown();
                            }
                        }
                        return n;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public int bracketsClosed() {
            Object object = this.bracketsClosed$lzy1;
            if (object instanceof Integer) {
                return BoxesRunTime.unboxToInt((Object)object);
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return BoxesRunTime.unboxToInt(null);
            }
            return BoxesRunTime.unboxToInt((Object)this.bracketsClosed$lzyINIT1());
        }

        private Object bracketsClosed$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.bracketsClosed$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$1, null, LazyVals.Evaluating$.MODULE$)) continue;
                        Serializable serializable = null;
                        Integer n = null;
                        try {
                            Tuple2 tuple2 = (Tuple2)((IterableOnceOps)this.tokens().map(SmartIndenter::org$nlogo$app$codetab$SmartIndenter$TokenizedLine$$_$_$$anonfun$1)).foldLeft((Object)new Tuple2.mcII.sp(0, 0), SmartIndenter::org$nlogo$app$codetab$SmartIndenter$TokenizedLine$$_$_$$anonfun$2);
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            int closedCount = tuple2._2$mcI$sp();
                            int closedCount2 = closedCount;
                            n = BoxesRunTime.boxToInteger((int)closedCount2);
                            serializable = n == null ? LazyVals.NullValue$.MODULE$ : n;
                        }
                        catch (Throwable throwable) {
                            if (!LazyVals$.MODULE$.objCAS(this, OFFSET$1, LazyVals.Evaluating$.MODULE$, serializable)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.bracketsClosed$lzy1;
                                LazyVals$.MODULE$.objCAS(this, OFFSET$1, waiting, serializable);
                                waiting.countDown();
                            }
                            throw throwable;
                        }
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$1, LazyVals.Evaluating$.MODULE$, serializable)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.bracketsClosed$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$1, waiting, serializable);
                            waiting.countDown();
                        }
                        return n;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS(this, OFFSET$1, object, new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public Option<Object> finalCommentStart() {
            Object object = this.finalCommentStart$lzy1;
            if (object instanceof Option) {
                return (Option)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (Option)this.finalCommentStart$lzyINIT1();
        }

        private Object finalCommentStart$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.finalCommentStart$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$2, null, LazyVals.Evaluating$.MODULE$)) continue;
                        LazyVals.NullValue$ nullValue$ = null;
                        Option option = null;
                        try {
                            option = this.tokens().lastOption().filter(SmartIndenter::org$nlogo$app$codetab$SmartIndenter$TokenizedLine$$_$finalCommentStart$lzyINIT1$$anonfun$1).map((Function1 & Serializable)_$4 -> _$4.start() - this.lineStart());
                            nullValue$ = option == null ? LazyVals.NullValue$.MODULE$ : option;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS(this, OFFSET$2, LazyVals.Evaluating$.MODULE$, nullValue$)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.finalCommentStart$lzy1;
                                LazyVals$.MODULE$.objCAS(this, OFFSET$2, waiting, nullValue$);
                                waiting.countDown();
                            }
                        }
                        return option;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS(this, OFFSET$2, object, new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public boolean isOnlyComment() {
            Object object = this.isOnlyComment$lzy1;
            if (object instanceof Boolean) {
                return BoxesRunTime.unboxToBoolean((Object)object);
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return BoxesRunTime.unboxToBoolean(null);
            }
            return BoxesRunTime.unboxToBoolean((Object)this.isOnlyComment$lzyINIT1());
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private Object isOnlyComment$lzyINIT1() {
            block9: {
                while (true) {
                    block10: {
                        if ((var1_1 = this.isOnlyComment$lzy1) != null) break block10;
                        if (!LazyVals$.MODULE$.objCAS(this, TokenizedLine.OFFSET$3, null, LazyVals.Evaluating$.MODULE$)) continue;
                        var2_2 /* !! */  = null;
                        var3_3 = null;
                        try {
                            if (this.tokens().length() != 1) ** GOTO lbl-1000
                            v0 = ((Token)this.tokens().head()).tpe();
                            var4_4 = TokenType$Comment$.MODULE$;
                            if (!(v0 != null ? v0.equals(var4_4) == false : var4_4 != null)) {
                                v1 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v1 = false;
                            }
                            var3_3 = BoxesRunTime.boxToBoolean((boolean)v1);
                            var2_2 /* !! */  = var3_3 == null ? LazyVals.NullValue$.MODULE$ : var3_3;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS(this, TokenizedLine.OFFSET$3, LazyVals.Evaluating$.MODULE$, var2_2 /* !! */ )) {
                                var6_7 = (LazyVals.Waiting)this.isOnlyComment$lzy1;
                                LazyVals$.MODULE$.objCAS(this, TokenizedLine.OFFSET$3, var6_7, var2_2 /* !! */ );
                                var6_7.countDown();
                            }
                        }
                        return var3_3;
                    }
                    if (!(var1_1 instanceof LazyVals.LazyValControlState)) break block9;
                    if (var1_1 == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS(this, TokenizedLine.OFFSET$3, var1_1, new LazyVals.Waiting());
                        continue;
                    }
                    if (!(var1_1 instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)var1_1).await();
                }
                return null;
            }
            return var1_1;
        }

        public TokenizedLine copy(int lineNum, int lineStart, int lineEnd, String text, int leadingSpaces, Seq<Token> tokens) {
            return new TokenizedLine(this.$outer, lineNum, lineStart, lineEnd, text, leadingSpaces, tokens);
        }

        public int copy$default$1() {
            return this.lineNum();
        }

        public int copy$default$2() {
            return this.lineStart();
        }

        public int copy$default$3() {
            return this.lineEnd();
        }

        public String copy$default$4() {
            return this.text();
        }

        public int copy$default$5() {
            return this.leadingSpaces();
        }

        public Seq<Token> copy$default$6() {
            return this.tokens();
        }

        public int _1() {
            return this.lineNum();
        }

        public int _2() {
            return this.lineStart();
        }

        public int _3() {
            return this.lineEnd();
        }

        public String _4() {
            return this.text();
        }

        public int _5() {
            return this.leadingSpaces();
        }

        public Seq<Token> _6() {
            return this.tokens();
        }

        public final /* synthetic */ SmartIndenter org$nlogo$app$codetab$SmartIndenter$TokenizedLine$$$outer() {
            return this.$outer;
        }
    }
}

