/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app.codetab;

import java.io.IOException;
import java.io.Serializable;
import javax.swing.text.JTextComponent;
import org.nlogo.api.FileIO$;
import org.nlogo.api.SourceOwner;
import org.nlogo.app.codetab.CodeTab;
import org.nlogo.app.codetab.ExternalFileManager;
import org.nlogo.app.codetab.TemporaryCodeTab$;
import org.nlogo.app.common.Dialogs$;
import org.nlogo.app.common.Events;
import org.nlogo.app.common.TabsInterface;
import org.nlogo.core.I18N$;
import org.nlogo.ide.FocusedOnlyAction;
import org.nlogo.swing.CloseableTab;
import org.nlogo.swing.FileDialog$;
import org.nlogo.swing.UserAction;
import org.nlogo.window.Events;
import org.nlogo.window.ExternalFileInterface;
import org.nlogo.workspace.AbstractWorkspace;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Either$;

public class TemporaryCodeTab
extends CodeTab
implements CloseableTab {
    private final TabsInterface tabs;
    private Either<String, String> _filename;
    private final ExternalFileManager externalFileManager;
    private final Function1<TemporaryCodeTab, UserAction.MenuAction> conversionAction;
    private boolean closing;
    private boolean saveNeeded;
    private final Seq<UserAction.MenuAction> activeMenuActions;

    public static String stripPath(String string) {
        return TemporaryCodeTab$.MODULE$.stripPath(string);
    }

    public TemporaryCodeTab(AbstractWorkspace workspace, TabsInterface tabs, Either<String, String> _filename, ExternalFileManager externalFileManager, Function1<TemporaryCodeTab, UserAction.MenuAction> conversionAction, boolean separateCodeWindow) {
        this.tabs = tabs;
        this._filename = _filename;
        this.externalFileManager = externalFileManager;
        this.conversionAction = conversionAction;
        super(workspace, tabs);
        this.closing = false;
        this.saveNeeded = false;
        this.checkCompilable(false);
        if (this.reload()) {
            externalFileManager.add(this);
        }
        this.setSeparate(separateCodeWindow);
        this.lineNumbersVisible_$eq(tabs.lineNumbersVisible());
        this.setIndenter(tabs.smartTabbingEnabled());
        this.activeMenuActions = (Seq)((IterableOps)((SeqOps)new .colon.colon((Object)this.undoAction(), (List)new .colon.colon((Object)this.redoAction(), (List)Nil$.MODULE$))).$plus$plus((IterableOnce)this.editorConfiguration().contextActions().filter((Function1 & Serializable)_$1 -> _$1 instanceof FocusedOnlyAction))).$plus$plus((IterableOnce)this.filename().fold((Function1 & Serializable)_$2 -> (Seq)((SeqOps)Nil$.MODULE$), (Function1 & Serializable)name -> (Seq)((SeqOps)new .colon.colon((Object)((UserAction.MenuAction)conversionAction.apply((Object)this)), (List)Nil$.MODULE$))));
    }

    private AbstractWorkspace workspace$accessor() {
        return super.workspace();
    }

    private Either<String, String> _filename() {
        return this._filename;
    }

    private void _filename_$eq(Either<String, String> x$0) {
        this._filename = x$0;
    }

    public boolean closing() {
        return this.closing;
    }

    public void closing_$eq(boolean x$1) {
        this.closing = x$1;
    }

    public boolean saveNeeded() {
        return this.saveNeeded;
    }

    public void saveNeeded_$eq(boolean x$1) {
        this.saveNeeded = x$1;
    }

    public Either<String, String> filename() {
        return this._filename();
    }

    public void filename_$eq(Either<String, String> newName) {
        Either<String, String> oldFilename = this._filename();
        this._filename_$eq(newName);
        if (oldFilename.isRight()) {
            Either<String, String> either = oldFilename;
            Either<String, String> either2 = newName;
            if (either == null ? either2 != null : !either.equals(either2)) {
                this.externalFileManager.nameChanged((String)oldFilename.getOrElse(TemporaryCodeTab::filename_$eq$$anonfun$1), (String)newName.getOrElse(TemporaryCodeTab::filename_$eq$$anonfun$2));
                return;
            }
        }
        if (oldFilename.isLeft()) {
            this.externalFileManager.add(this);
            return;
        }
    }

    public boolean reload() {
        BooleanRef loaded = BooleanRef.create((boolean)false);
        this.filename().foreach(path -> {
            try {
                this.innerSource_$eq(FileIO$.MODULE$.fileToString((String)path).replaceAll("\r\n", "\n"));
                this.dirty_$eq(false);
                this.saveNeeded_$eq(false);
                loaded$1.elem = true;
            }
            catch (IOException iOException) {
                this.innerSource_$eq("");
            }
        });
        return loaded.elem;
    }

    @Override
    public Seq<UserAction.MenuAction> activeMenuActions() {
        return this.activeMenuActions;
    }

    private void checkCompilable(boolean dirty) {
        if (this.getIncludesTable().exists((Function1 & Serializable)_$3 -> _$3.exists((Function1 & Serializable)_$4 -> BoxesRunTime.equals((Object)_$4._2(), (Object)this.filename().getOrElse(TemporaryCodeTab::checkCompilable$$anonfun$1$$anonfun$1$$anonfun$1))))) {
            this.compileButton().setEnabled(dirty);
            this.errorLabel().setWarning((Option<String>)None$.MODULE$);
            return;
        }
        this.compileButton().setEnabled(false);
        this.errorLabel().setWarning((Option<String>)Some$.MODULE$.apply((Object)I18N$.MODULE$.gui().get("tabs.code.cannotCompile")));
    }

    @Override
    public void dirty_$eq(boolean d) {
        this.checkCompilable(d);
        this._dirty_$eq(d);
        if (d) {
            this.saveNeeded_$eq(true);
            Either either = Either$.MODULE$.MergeableEither(this.filename());
            new Events.DirtyEvent((Option<String>)Some$.MODULE$.apply((Object)((String)Either.MergeableEither$.MODULE$.merge$extension(either)))).raise(this);
            return;
        }
    }

    public String filenameForDisplay() {
        Either either = Either$.MODULE$.MergeableEither(this.filename().map((Function1 & Serializable)filename -> TemporaryCodeTab$.MODULE$.stripPath((String)filename)));
        return (String)Either.MergeableEither$.MODULE$.merge$extension(either);
    }

    public void save(boolean saveAs) {
        if (saveAs || this.filename().isLeft()) {
            this.filename_$eq((Either<String, String>)package$.MODULE$.Right().apply((Object)this.userChooseSavePath()));
        }
        FileIO$.MODULE$.writeFile((String)this.filename().getOrElse(TemporaryCodeTab::save$$anonfun$1), ((JTextComponent)((Object)this.text())).getText());
        this.saveNeeded_$eq(false);
        this.compileIfDirty();
        this.dirty_$eq(false);
        Either either = Either$.MODULE$.MergeableEither(this.filename());
        new Events.ExternalFileSavedEvent((String)Either.MergeableEither$.MODULE$.merge$extension(either)).raise(this);
    }

    @Override
    public void close() {
        if (this.saveNeeded() && Dialogs$.MODULE$.userWantsToSaveFirst(this.filenameForDisplay(), this)) {
            this.save(false);
        }
        this.closing_$eq(true);
        this.tabs.closeExternalFile(this._filename());
    }

    public void compileIfDirty() {
        if (this.dirty()) {
            this.compile();
            return;
        }
    }

    @Override
    public void handle(Events.CompiledEvent e) {
        this.dirty_$eq(false);
        SourceOwner sourceOwner = e.sourceOwner;
        if (sourceOwner instanceof ExternalFileInterface) {
            ExternalFileInterface file = (ExternalFileInterface)sourceOwner;
            String string = file.getFileName();
            Object object = this.filename().getOrElse(TemporaryCodeTab::handle$$anonfun$1);
            if (!(string != null ? !string.equals(object) : object != null)) {
                this.setErrorLabel$1(e);
                return;
            }
        }
        if (sourceOwner instanceof CodeTab) {
            CodeTab tab = (CodeTab)sourceOwner;
            if (e.error == null) {
                this.setErrorLabel$1(e);
                return;
            }
        }
    }

    @Override
    public void handle(Events.SwitchedTabsEvent e) {
        if (!this.closing()) {
            super.handle(e);
            return;
        }
    }

    private String userChooseSavePath() {
        String newFileName = TemporaryCodeTab.appendIfNecessary$1(this.filenameForDisplay(), ".nls");
        String path = FileDialog$.MODULE$.showFiles(this, I18N$.MODULE$.gui().get("file.save.external"), 1, newFileName, FileDialog$.MODULE$.showFiles$default$5());
        return TemporaryCodeTab.appendIfNecessary$1(path, ".nls");
    }

    private static final String filename_$eq$$anonfun$1() {
        return null;
    }

    private static final String filename_$eq$$anonfun$2() {
        return null;
    }

    private static final String checkCompilable$$anonfun$1$$anonfun$1$$anonfun$1() {
        return null;
    }

    private static final String save$$anonfun$1() {
        return null;
    }

    private final void setErrorLabel$1(Events.CompiledEvent e$1) {
        this.errorLabel().setError((Option<Exception>)Option$.MODULE$.apply((Object)e$1.error), StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(e$1.sourceOwner.headerSource())));
    }

    private static final String handle$$anonfun$1() {
        return null;
    }

    private static final String appendIfNecessary$1(String str, String suffix) {
        if (str.endsWith(suffix)) {
            return str;
        }
        return str + suffix;
    }
}

