/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app.common;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import javax.swing.KeyStroke;
import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet$;
import org.nlogo.agent.IndexedAgentSet;
import org.nlogo.agent.OutputObject;
import org.nlogo.api.SourceOwner;
import org.nlogo.app.common.CommandLine$;
import org.nlogo.app.common.CommandLine$ExecutionString$;
import org.nlogo.awt.Fonts$;
import org.nlogo.core.AgentKind;
import org.nlogo.core.AgentKind$Link$;
import org.nlogo.core.AgentKind$Observer$;
import org.nlogo.core.AgentKind$Patch$;
import org.nlogo.core.AgentKind$Turtle$;
import org.nlogo.core.CompilerException;
import org.nlogo.core.Widget;
import org.nlogo.editor.EditorField;
import org.nlogo.editor.EditorField$;
import org.nlogo.ide.AutoSuggestAction;
import org.nlogo.ide.CodeCompletionPopup;
import org.nlogo.ide.CodeCompletionPopup$;
import org.nlogo.swing.ScrollPane;
import org.nlogo.swing.Transparent;
import org.nlogo.theme.InterfaceColors$;
import org.nlogo.window.CommandCenterInterface;
import org.nlogo.window.Editable;
import org.nlogo.window.EditorColorizer;
import org.nlogo.window.Events;
import org.nlogo.window.InterfaceMode$Interact$;
import org.nlogo.window.JobWidget;
import org.nlogo.workspace.AbstractWorkspace;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class CommandLine
extends JobWidget
implements ActionListener,
KeyListener {
    private final CommandCenterInterface commandCenter;
    private final boolean echoCommandsToOutput;
    private final AbstractWorkspace workspace;
    private Agent agent;
    private int historyPosition;
    private String historyBase;
    private AgentKind historyBaseClass;
    private List<ExecutionString> history;
    private final CodeCompletionPopup codeCompletionPopup;
    private final Map<KeyStroke, AutoSuggestAction> actionMap;
    private final EditorField textField;
    private final ScrollPane scrollPane;

    public static String LINK_PROMPT() {
        return CommandLine$.MODULE$.LINK_PROMPT();
    }

    public static int MAX_HISTORY_SIZE() {
        return CommandLine$.MODULE$.MAX_HISTORY_SIZE();
    }

    public static String OBSERVER_PROMPT() {
        return CommandLine$.MODULE$.OBSERVER_PROMPT();
    }

    public static String PATCH_PROMPT() {
        return CommandLine$.MODULE$.PATCH_PROMPT();
    }

    public static String PROMPT() {
        return CommandLine$.MODULE$.PROMPT();
    }

    public static String TURTLE_PROMPT() {
        return CommandLine$.MODULE$.TURTLE_PROMPT();
    }

    public CommandLine(CommandCenterInterface commandCenter, boolean echoCommandsToOutput, int fontSize, AbstractWorkspace workspace) {
        this.commandCenter = commandCenter;
        this.echoCommandsToOutput = echoCommandsToOutput;
        this.workspace = workspace;
        super(workspace.world().mainRNG());
        this.agent = null;
        this.historyPosition = -1;
        this.historyBase = "";
        this.historyBaseClass = AgentKind$Observer$.MODULE$;
        this.history = (List)Nil$.MODULE$;
        this.codeCompletionPopup = CodeCompletionPopup$.MODULE$.apply(workspace.dialect(), workspace.getExtensionManager());
        Object[] objectArray = new Tuple2[1];
        KeyStroke keyStroke = (KeyStroke)Predef$.MODULE$.ArrowAssoc((Object)KeyStroke.getKeyStroke(32, 128));
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)keyStroke, (Object)new AutoSuggestAction("auto-suggest", this.codeCompletionPopup()));
        this.actionMap = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.textField = new EditorField(30, new Font(Fonts$.MODULE$.platformMonospacedFont(), 0, 12), true, new EditorColorizer(workspace), this.actionMap(), EditorField$.MODULE$.$lessinit$greater$default$6());
        this.agentKind(AgentKind$Observer$.MODULE$);
        this.textField().setFont(this.textField().getFont().deriveFont((float)fontSize));
        this.textField().addKeyListener(this);
        this.setLayout(new BorderLayout());
        this.displayName(this.classDisplayName());
        this.scrollPane = new Transparent(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super($outer.textField(), 21, 31);
                Transparent.$init$(this);
            }
        };
        this.add((Component)this.scrollPane, "Center");
    }

    public Agent agent() {
        return this.agent;
    }

    public void agent_$eq(Agent x$1) {
        this.agent = x$1;
    }

    public CodeCompletionPopup codeCompletionPopup() {
        return this.codeCompletionPopup;
    }

    public Map<KeyStroke, AutoSuggestAction> actionMap() {
        return this.actionMap;
    }

    public EditorField textField() {
        return this.textField;
    }

    public void agent(Agent agent) {
        this.agent_$eq(agent);
    }

    @Override
    public Option<Editable> getEditable() {
        return None$.MODULE$;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(super.getMinimumSize().width, this.getPreferredSize().height);
    }

    @Override
    public String classDisplayName() {
        return "Command Center";
    }

    @Override
    public boolean isCommandCenter() {
        return true;
    }

    private String getText() {
        return this.textField().getText();
    }

    private void setText(String s) {
        this.textField().setText(s);
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void requestFocus() {
        this.textField().requestFocus();
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        new Events.SetInterfaceModeEvent(InterfaceMode$Interact$.MODULE$, false).raise(this);
        int n = e.getKeyCode();
        switch (n) {
            case 10: {
                this.executeCurrentBuffer();
                e.consume();
                return;
            }
            case 9: {
                this.commandCenter.cycleAgentType(!e.isShiftDown());
                e.consume();
                return;
            }
            case 40: {
                this.cycleListForward();
                return;
            }
            case 38: {
                this.cycleListBack();
                return;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.executeCurrentBuffer();
    }

    private void executeCurrentBuffer() {
        Object inner = this.getText();
        if (((String)inner).trim().equals("")) {
            this.setText("");
            return;
        }
        if (this.workspace.isReporter((String)inner)) {
            inner = "show " + (String)inner;
            this.setText((String)inner);
        }
        Object header = "to __commandline [] ";
        AgentKind agentKind = this.kind();
        AgentKind$Observer$ agentKind$Observer$ = AgentKind$Observer$.MODULE$;
        if (!(agentKind != null ? !agentKind.equals(agentKind$Observer$) : agentKind$Observer$ != null)) {
            header = (String)header + "__observercode ";
        } else {
            AgentKind agentKind2 = this.kind();
            AgentKind$Turtle$ agentKind$Turtle$ = AgentKind$Turtle$.MODULE$;
            if (!(agentKind2 != null ? !agentKind2.equals(agentKind$Turtle$) : agentKind$Turtle$ != null)) {
                header = (String)header + "__turtlecode ";
            } else {
                AgentKind agentKind3 = this.kind();
                AgentKind$Patch$ agentKind$Patch$ = AgentKind$Patch$.MODULE$;
                if (!(agentKind3 != null ? !agentKind3.equals(agentKind$Patch$) : agentKind$Patch$ != null)) {
                    header = (String)header + "__patchcode ";
                } else {
                    AgentKind agentKind4 = this.kind();
                    AgentKind$Link$ agentKind$Link$ = AgentKind$Link$.MODULE$;
                    if (!(agentKind4 != null ? !agentKind4.equals(agentKind$Link$) : agentKind$Link$ != null)) {
                        header = (String)header + "__linkcode ";
                    }
                }
            }
        }
        String footer = "\n__done end";
        this.source((String)header, (String)inner, footer);
    }

    @Override
    public void handle(Events.CompiledEvent e) {
        super.handle(e);
        SourceOwner sourceOwner = e.sourceOwner;
        CommandLine commandLine = this;
        if (!(sourceOwner != null ? !sourceOwner.equals(commandLine) : commandLine != null)) {
            Exception exception;
            this.error(e.error);
            Option option = this.error();
            if (option instanceof Some && (exception = (Exception)((Some)option).value()) instanceof CompilerException) {
                CompilerException err = (CompilerException)exception;
                int offset = this.headerSource().length();
                this.textField().selectError(err.start() - offset, err.end() - offset);
                new Events.OutputEvent(false, new OutputObject("", "ERROR: " + err.getMessage(), true, true), true, true, System.currentTimeMillis()).raise(this);
                return;
            }
            if (None$.MODULE$.equals(option)) {
                this.setText("");
                Object outStr = this.innerSource();
                if (!((String)outStr).trim().equals("")) {
                    this.addToHistory((String)outStr);
                    if (this.echoCommandsToOutput) {
                        AgentKind agentKind = this.kind();
                        String prefix = AgentKind$Turtle$.MODULE$.equals(agentKind) ? CommandLine$.MODULE$.TURTLE_PROMPT() : (AgentKind$Patch$.MODULE$.equals(agentKind) ? CommandLine$.MODULE$.PATCH_PROMPT() : (AgentKind$Link$.MODULE$.equals(agentKind) ? CommandLine$.MODULE$.LINK_PROMPT() : CommandLine$.MODULE$.OBSERVER_PROMPT()));
                        outStr = prefix + " " + (String)outStr;
                        new Events.OutputEvent(false, new OutputObject("", (String)outStr, true, false), false, true, System.currentTimeMillis()).raise(this);
                    }
                    if (this.agent() != null) {
                        IndexedAgentSet agentSet = AgentSet$.MODULE$.fromAgent(this.agent());
                        this.agents(agentSet);
                    }
                    new Events.AddJobEvent(this, this.agents(), this.procedure()).raise(this);
                    return;
                }
                return;
            }
            return;
        }
    }

    private void addToHistory(String str) {
        block4: {
            ExecutionString executionString;
            block3: {
                executionString = new ExecutionString(this.kind(), str);
                if (this.history.isEmpty()) break block3;
                ExecutionString executionString2 = executionString;
                Object object = this.history.head();
                if (!(executionString2 == null ? object != null : !((Object)executionString2).equals(object))) break block4;
            }
            this.history = this.history.$colon$colon((Object)executionString);
            while (this.history.size() > CommandLine$.MODULE$.MAX_HISTORY_SIZE()) {
                this.history = (List)this.history.dropRight(1);
            }
        }
        this.historyPosition = -1;
    }

    public void cycleListBack() {
        if (!this.history.isEmpty()) {
            if (this.historyPosition == -1) {
                this.historyBase = this.getText();
                this.historyBaseClass = this.kind();
            }
            if (this.historyPosition + 1 < this.history.size()) {
                ++this.historyPosition;
                ExecutionString es = (ExecutionString)this.history.apply(this.historyPosition);
                this.setText(es.string());
                this.agentKind(es.agentClass());
            }
        }
        this.commandCenter.repaintPrompt();
    }

    public void cycleListForward() {
        if (this.historyPosition == 0) {
            this.setText(this.historyBase);
            this.agentKind(this.historyBaseClass);
            this.historyPosition = -1;
        } else if (this.historyPosition > 0 && this.history.nonEmpty()) {
            --this.historyPosition;
            ExecutionString es = (ExecutionString)this.history.apply(this.historyPosition);
            this.setText(es.string());
            this.agentKind(es.agentClass());
        }
        this.commandCenter.repaintPrompt();
    }

    public Seq<ExecutionString> getExecutionList() {
        return this.history.toSeq();
    }

    public void reset() {
        this.clearList();
        this.setText("");
        this.agentKind(AgentKind$Observer$.MODULE$);
        this.textField().resetUndoHistory();
    }

    public void clearList() {
        this.history = (List)Nil$.MODULE$;
        this.historyPosition = 0;
    }

    public void setExecutionString(ExecutionString es) {
        this.setText(es.string());
        this.agentKind(es.agentClass());
        this.textField().setCaretPosition(this.getText().length());
        this.commandCenter.repaintPrompt();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.textField().setEnabled(enabled);
    }

    @Override
    public void load(Widget model) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Widget model() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void raiseWidgetRemoved() {
    }

    @Override
    public void raiseWidgetAdded() {
    }

    @Override
    public void syncTheme() {
        this.textField().setBackground(InterfaceColors$.MODULE$.codeBackground());
        this.textField().setCaretColor(InterfaceColors$.MODULE$.displayAreaText());
        this.scrollPane.setBackground(InterfaceColors$.MODULE$.codeBackground());
        this.codeCompletionPopup().syncTheme();
    }

    public static class ExecutionString
    implements Product,
    Serializable {
        private final AgentKind agentClass;
        private final String string;

        public static ExecutionString apply(AgentKind agentKind, String string) {
            return CommandLine$ExecutionString$.MODULE$.apply(agentKind, string);
        }

        public static ExecutionString fromProduct(Product product) {
            return CommandLine$ExecutionString$.MODULE$.fromProduct(product);
        }

        public static ExecutionString unapply(ExecutionString executionString) {
            return CommandLine$ExecutionString$.MODULE$.unapply(executionString);
        }

        public ExecutionString(AgentKind agentClass, String string) {
            this.agentClass = agentClass;
            this.string = string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ExecutionString)) return false;
            ExecutionString executionString = (ExecutionString)object;
            AgentKind agentKind = this.agentClass();
            AgentKind agentKind2 = executionString.agentClass();
            if (agentKind == null) {
                if (agentKind2 != null) {
                    return false;
                }
            } else if (!agentKind.equals(agentKind2)) return false;
            String string = this.string();
            String string2 = executionString.string();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!executionString.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ExecutionString;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ExecutionString";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "agentClass";
            }
            if (1 == n2) {
                return "string";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public AgentKind agentClass() {
            return this.agentClass;
        }

        public String string() {
            return this.string;
        }

        public ExecutionString copy(AgentKind agentClass, String string) {
            return new ExecutionString(agentClass, string);
        }

        public AgentKind copy$default$1() {
            return this.agentClass();
        }

        public String copy$default$2() {
            return this.string();
        }

        public AgentKind _1() {
            return this.agentClass();
        }

        public String _2() {
            return this.string();
        }
    }
}

