/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app.infotab;

import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ext.autolink.AutolinkExtension;
import com.vladsch.flexmark.ext.escaped.character.EscapedCharacterExtension;
import com.vladsch.flexmark.ext.typographic.TypographicExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.ParserEmulationProfile;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.MutableDataSet;
import com.vladsch.flexmark.util.options.MutableDataSetter;
import java.awt.Color;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import org.nlogo.api.FileIO$;
import org.nlogo.app.infotab.BlockQuoteRenderer;
import org.nlogo.app.infotab.CodeBlockRenderer;
import org.nlogo.theme.InterfaceColors$;
import scala.Predef$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class InfoFormatter$
implements Serializable {
    private static final int MaxParsingTimeMillis;
    private static final int defaultFontSize;
    private static final String defaultStyleSheet;
    public static final InfoFormatter$ MODULE$;

    private InfoFormatter$() {
    }

    static {
        MODULE$ = new InfoFormatter$();
        MaxParsingTimeMillis = 4000;
        defaultFontSize = 14;
        defaultStyleSheet = MODULE$.styleSheet(MODULE$.defaultFontSize());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(InfoFormatter$.class);
    }

    public int MaxParsingTimeMillis() {
        return MaxParsingTimeMillis;
    }

    public void main(String[] argv) {
        Predef$.MODULE$.println((Object)this.apply(this.read(System.in), this.apply$default$2()));
    }

    public String read(InputStream in) {
        return Source$.MODULE$.fromInputStream(in, Codec$.MODULE$.fallbackSystemCodec()).mkString();
    }

    public String styleSheetFile() {
        return FileIO$.MODULE$.getResourceAsString("/system/info.css");
    }

    public int defaultFontSize() {
        return defaultFontSize;
    }

    public String defaultStyleSheet() {
        return defaultStyleSheet;
    }

    public String styleSheet(int fontSize) {
        return "<style type=\"text/css\">\n<!--\n" + this.styleSheetFile().replace("{BODY-FONT-SIZE}", BoxesRunTime.boxToInteger((int)fontSize).toString()).replace("{H1-BACKGROUND}", this.colorString(InterfaceColors$.MODULE$.infoH1Background())).replace("{H1-COLOR}", this.colorString(InterfaceColors$.MODULE$.infoH1Color())).replace("{H1-FONT-SIZE}", BoxesRunTime.boxToInteger((int)(fontSize * 2)).toString()).replace("{H2-BACKGROUND}", this.colorString(InterfaceColors$.MODULE$.infoH2Background())).replace("{H2-COLOR}", this.colorString(InterfaceColors$.MODULE$.infoH2Color())).replace("{H2-FONT-SIZE}", BoxesRunTime.boxToInteger((int)((int)((double)fontSize * 1.75))).toString()).replace("{H3-COLOR}", this.colorString(InterfaceColors$.MODULE$.infoH3Color())).replace("{H3-FONT-SIZE}", BoxesRunTime.boxToInteger((int)((int)((double)fontSize * 1.5))).toString()).replace("{H4-COLOR}", this.colorString(InterfaceColors$.MODULE$.infoH4Color())).replace("{H4-FONT-SIZE}", BoxesRunTime.boxToDouble((double)((double)fontSize * 1.28)).toString()).replace("{H5-FONT-SIZE}", BoxesRunTime.boxToDouble((double)((double)fontSize * 1.14)).toString()).replace("{H6-FONT-SIZE}", BoxesRunTime.boxToInteger((int)fontSize).toString()).replace("{P-COLOR}", this.colorString(InterfaceColors$.MODULE$.infoPColor())).replace("{CODE-BACKGROUND}", this.colorString(InterfaceColors$.MODULE$.infoCodeBackground())).replace("{BLOCK-BAR}", this.colorString(InterfaceColors$.MODULE$.infoBlockBar())).replace("{INFO-BACKGROUND}", this.colorString(InterfaceColors$.MODULE$.infoBackground())).replace("{LINK-COLOR}", this.colorString(InterfaceColors$.MODULE$.infoLink())) + "\n-->\n</style>";
    }

    public String apply(String content, int fontSize) {
        return this.wrapHtml(this.toInnerHtml(content), fontSize);
    }

    public int apply$default$2() {
        return this.defaultFontSize();
    }

    public String wrapHtml(String body, int fontSize) {
        return "<html><head>" + this.styleSheet(fontSize) + "</head><body>" + body + "</body></html>";
    }

    public int wrapHtml$default$2() {
        return this.defaultFontSize();
    }

    public String toInnerHtml(String content) {
        ArrayList<Object> extensions = new ArrayList<Object>();
        MutableDataSet options = new MutableDataSet();
        options.setFrom((MutableDataSetter)ParserEmulationProfile.PEGDOWN);
        extensions.add(EscapedCharacterExtension.create());
        options.set(HtmlRenderer.SOFT_BREAK, (Object)"<br />\n");
        options.set(HtmlRenderer.HARD_BREAK, (Object)"<br />\n");
        extensions.add(TypographicExtension.create());
        options.set(TypographicExtension.ENABLE_QUOTES, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        options.set(TypographicExtension.ENABLE_SMARTS, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        extensions.add(AutolinkExtension.create());
        options.set(Parser.MATCH_CLOSING_FENCE_CHARACTERS, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        extensions.add(new CodeBlockRenderer());
        extensions.add(new BlockQuoteRenderer());
        options.set(Parser.EXTENSIONS, extensions);
        DataHolder opts = options.toImmutable();
        Parser parser = Parser.builder((DataHolder)opts).build();
        HtmlRenderer renderer = HtmlRenderer.builder((DataHolder)opts).build();
        Document document = parser.parse(content);
        return renderer.render((Node)document);
    }

    private String colorString(Color color) {
        return "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
    }
}

