/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app.interfacetab;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.nlogo.api.Advisory$;
import org.nlogo.api.Announcement;
import org.nlogo.api.Announcement$;
import org.nlogo.api.AnnouncementType;
import org.nlogo.api.Event$;
import org.nlogo.api.Release$;
import org.nlogo.app.interfacetab.ComplexXWrapper;
import org.nlogo.app.interfacetab.TextPane;
import org.nlogo.app.interfacetab.Util$;
import org.nlogo.app.interfacetab.XButton;
import org.nlogo.core.NetLogoPreferences$;
import org.nlogo.swing.BrowserLauncher$;
import org.nlogo.swing.MouseUtils;
import org.nlogo.theme.InterfaceColors$;
import org.nlogo.theme.ThemeSync;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

public class AnnouncementBanner
extends JPanel
implements MouseUtils,
ThemeSync {
    private boolean org$nlogo$swing$MouseUtils$$useHandCursor;
    private boolean org$nlogo$swing$MouseUtils$$hover;
    private boolean org$nlogo$swing$MouseUtils$$pressed;
    private final String prefKey;
    public Seq<Announcement> org$nlogo$app$interfacetab$AnnouncementBanner$$announcements;
    private final JLabel annTitle;
    private final JLabel annText;
    private final TextPane textPane;
    public final Function0<BoxedUnit> org$nlogo$app$interfacetab$AnnouncementBanner$$ggGoNext;
    private final XButton simpleXButton;
    private final ComplexXWrapper complexXWrapper;

    public AnnouncementBanner() {
        MouseUtils.$init$(this);
        this.prefKey = "announce.latest-read-id";
        this.org$nlogo$app$interfacetab$AnnouncementBanner$$announcements = (Seq)((SeqOps)Nil$.MODULE$);
        this.annTitle = new JLabel();
        this.annText = new JLabel();
        this.textPane = new TextPane(this.annTitle, this.annText);
        this.org$nlogo$app$interfacetab$AnnouncementBanner$$ggGoNext = (JFunction0.mcV.sp & Serializable)() -> {
            NetLogoPreferences$.MODULE$.put(this.prefKey, BoxesRunTime.boxToInteger((int)((Announcement)this.org$nlogo$app$interfacetab$AnnouncementBanner$$announcements.head()).id()).toString());
            this.org$nlogo$app$interfacetab$AnnouncementBanner$$announcements = (Seq)this.org$nlogo$app$interfacetab$AnnouncementBanner$$announcements.tail();
            this.renderData();
        };
        this.simpleXButton = new XButton(this.org$nlogo$app$interfacetab$AnnouncementBanner$$ggGoNext);
        this.complexXWrapper = new ComplexXWrapper(this.org$nlogo$app$interfacetab$AnnouncementBanner$$ggGoNext);
        this.setHandCursor();
        this.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, InterfaceColors$.MODULE$.viewBorder()));
        this.setLayout(new GridBagLayout());
        Util$.MODULE$.modifyFont(this.annTitle, (Function1<Font, Font>)(Function1 & Serializable)_$1 -> _$1.deriveFont(20.0f));
        Util$.MODULE$.modifyFont(this.annText, (Function1<Font, Font>)(Function1 & Serializable)_$2 -> _$2.deriveFont(16.0f));
        this.addMouseListener(new MouseAdapter(this){
            private final /* synthetic */ AnnouncementBanner $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void mouseClicked(MouseEvent e) {
                this.$outer.org$nlogo$app$interfacetab$AnnouncementBanner$$announcements.headOption().foreach(ann -> {
                    BrowserLauncher$.MODULE$.openURI(new URI("https://www.netlogo.org/announcements#news-item-" + ann.id()));
                    this.$outer.org$nlogo$app$interfacetab$AnnouncementBanner$$ggGoNext.apply$mcV$sp();
                });
            }

            public void mouseEntered(MouseEvent e) {
                this.$outer.org$nlogo$app$interfacetab$AnnouncementBanner$$setSummaryUnderline(true);
            }

            public void mouseExited(MouseEvent e) {
                this.$outer.org$nlogo$app$interfacetab$AnnouncementBanner$$setSummaryUnderline(false);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{mouseClicked$$anonfun$1(org.nlogo.api.Announcement )}, serializedLambda);
            }
        });
        this.syncTheme();
        this.customLayout();
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
    }

    @Override
    public boolean org$nlogo$swing$MouseUtils$$useHandCursor() {
        return this.org$nlogo$swing$MouseUtils$$useHandCursor;
    }

    @Override
    public boolean org$nlogo$swing$MouseUtils$$hover() {
        return this.org$nlogo$swing$MouseUtils$$hover;
    }

    @Override
    public boolean org$nlogo$swing$MouseUtils$$pressed() {
        return this.org$nlogo$swing$MouseUtils$$pressed;
    }

    @Override
    public void org$nlogo$swing$MouseUtils$$useHandCursor_$eq(boolean x$1) {
        this.org$nlogo$swing$MouseUtils$$useHandCursor = x$1;
    }

    @Override
    public void org$nlogo$swing$MouseUtils$$hover_$eq(boolean x$1) {
        this.org$nlogo$swing$MouseUtils$$hover = x$1;
    }

    @Override
    public void org$nlogo$swing$MouseUtils$$pressed_$eq(boolean x$1) {
        this.org$nlogo$swing$MouseUtils$$pressed = x$1;
    }

    private void customLayout() {
        GridBagConstraints textGBC = new GridBagConstraints();
        textGBC.gridy = 0;
        textGBC.anchor = 17;
        textGBC.fill = 2;
        textGBC.weightx = 1.0;
        textGBC.insets = new Insets(0, 20, 0, 20);
        this.add((Component)this.textPane, textGBC);
        GridBagConstraints xGBC = new GridBagConstraints();
        xGBC.anchor = 13;
        xGBC.fill = 0;
        xGBC.weightx = 0.0;
        xGBC.insets = new Insets(0, 20, 0, 22);
        this.simpleXButton.setVisible(false);
        this.add((Component)this.simpleXButton, xGBC);
        this.add((Component)this.complexXWrapper, xGBC);
    }

    public void appendData(Seq<Announcement> anns) {
        String string = NetLogoPreferences$.MODULE$.get("announce.debug", "false");
        String string2 = "true";
        boolean isDebug = !(string != null ? !string.equals(string2) : string2 != null);
        int latestReadID = !isDebug ? StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(NetLogoPreferences$.MODULE$.get(this.prefKey, "-1"))) : -1;
        this.org$nlogo$app$interfacetab$AnnouncementBanner$$announcements = (Seq)this.org$nlogo$app$interfacetab$AnnouncementBanner$$announcements.$plus$plus((IterableOnce)anns.filter((Function1 & Serializable)_$3 -> _$3.id() > latestReadID));
        this.renderData();
    }

    public void org$nlogo$app$interfacetab$AnnouncementBanner$$setSummaryUnderline(boolean shouldUnderline) {
        Util$.MODULE$.handleUnderline(shouldUnderline, this.annTitle);
        Util$.MODULE$.handleUnderline(shouldUnderline, this.annText);
    }

    private void renderData() {
        this.org$nlogo$app$interfacetab$AnnouncementBanner$$announcements.headOption().fold((Function0 & Serializable)() -> {
            this.renderData$$anonfun$1();
            return BoxedUnit.UNIT;
        }, x$1 -> {
            Announcement announcement = x$1;
            if (announcement != null) {
                Color color;
                Announcement announcement2 = Announcement$.MODULE$.unapply(announcement);
                int n = announcement2._1();
                String string = announcement2._2();
                LocalDate localDate = announcement2._3();
                Option<LocalDate> option = announcement2._4();
                AnnouncementType announcementType = announcement2._5();
                String string2 = announcement2._6();
                String string3 = announcement2._7();
                String title = string;
                LocalDate date = localDate;
                AnnouncementType annType = announcementType;
                String summary = string2;
                AnnouncementType announcementType2 = annType;
                if (Release$.MODULE$.equals(announcementType2)) {
                    color = InterfaceColors$.MODULE$.announceRelease();
                } else if (Event$.MODULE$.equals(announcementType2)) {
                    color = InterfaceColors$.MODULE$.announceEvent();
                } else if (Advisory$.MODULE$.equals(announcementType2)) {
                    color = InterfaceColors$.MODULE$.announceAdvisory();
                } else {
                    throw new MatchError((Object)announcementType2);
                }
                Color color2 = color;
                String dateStr = date.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT));
                int remainingAnnCount = this.org$nlogo$app$interfacetab$AnnouncementBanner$$announcements.length() - 1;
                if (remainingAnnCount > 0) {
                    this.simpleXButton.setVisible(false);
                    this.complexXWrapper.setVisible(true);
                    this.complexXWrapper.setRemaining(remainingAnnCount);
                } else {
                    this.simpleXButton.setVisible(true);
                    this.complexXWrapper.setVisible(false);
                }
                this.setBackground(color2);
                this.annTitle.setText(title + " (" + dateStr + ")");
                Util$.MODULE$.modifyFont(this.annTitle, (Function1<Font, Font>)(Function1 & Serializable)_$4 -> _$4.deriveFont(1));
                this.annText.setText(summary.replaceAll("\n", " ").replaceAll("  ", " "));
                this.setVisible(true);
                return;
            }
            throw new MatchError((Object)announcement);
        });
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(super.getPreferredSize().width, 80);
    }

    @Override
    public void syncTheme() {
        this.renderData();
        this.textPane.syncTheme();
        this.simpleXButton.syncTheme();
        this.complexXWrapper.syncTheme();
    }

    private final void renderData$$anonfun$1() {
        this.setVisible(false);
    }
}

