/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app.interfacetab;

import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.undo.AbstractUndoableEdit;
import org.nlogo.app.interfacetab.WidgetActions$;
import org.nlogo.app.interfacetab.WidgetPanel;
import org.nlogo.app.interfacetab.WidgetWrapper;
import org.nlogo.editor.UndoManager;
import org.nlogo.window.Events;
import org.nlogo.window.InterfaceMode$Interact$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;

public final class WidgetActions {
    public static void addWidget(WidgetPanel widgetPanel, WidgetWrapper widgetWrapper) {
        WidgetActions$.MODULE$.addWidget(widgetPanel, widgetWrapper);
    }

    public static void convertWidgetSizes(WidgetPanel widgetPanel, Seq<Tuple2<WidgetWrapper, Rectangle>> seq) {
        WidgetActions$.MODULE$.convertWidgetSizes(widgetPanel, seq);
    }

    public static void moveSelectedWidgets(WidgetPanel widgetPanel) {
        WidgetActions$.MODULE$.moveSelectedWidgets(widgetPanel);
    }

    public static void moveWidgets(Seq<Tuple3<WidgetWrapper, Object, Object>> seq) {
        WidgetActions$.MODULE$.moveWidgets(seq);
    }

    public static void reboundWidgets(Seq<Tuple2<WidgetWrapper, Rectangle>> seq) {
        WidgetActions$.MODULE$.reboundWidgets(seq);
    }

    public static void removeWidget(WidgetPanel widgetPanel, WidgetWrapper widgetWrapper) {
        WidgetActions$.MODULE$.removeWidget(widgetPanel, widgetWrapper);
    }

    public static void removeWidgets(WidgetPanel widgetPanel, Seq<WidgetWrapper> seq) {
        WidgetActions$.MODULE$.removeWidgets(widgetPanel, seq);
    }

    public static void resizeWidget(WidgetWrapper widgetWrapper) {
        WidgetActions$.MODULE$.resizeWidget(widgetWrapper);
    }

    public static void resizeWidgets(Seq<Tuple3<WidgetWrapper, Object, Object>> seq) {
        WidgetActions$.MODULE$.resizeWidgets(seq);
    }

    public static UndoManager undoManager() {
        return WidgetActions$.MODULE$.undoManager();
    }

    public static class AddWidget
    extends AbstractUndoableEdit {
        private final WidgetPanel widgetPanel;
        private final WidgetWrapper widgetWrapper;

        public AddWidget(WidgetPanel widgetPanel, WidgetWrapper widgetWrapper) {
            this.widgetPanel = widgetPanel;
            this.widgetWrapper = widgetWrapper;
        }

        @Override
        public void redo() {
            this.widgetPanel.reAddWidget(this.widgetWrapper);
        }

        @Override
        public void undo() {
            this.widgetPanel.deleteWidget(this.widgetWrapper);
        }

        @Override
        public String getPresentationName() {
            return "Widget Addition";
        }
    }

    public static class ConvertWidgetSizes
    extends AbstractUndoableEdit {
        private final WidgetPanel widgetPanel;
        private final Seq<Tuple3<WidgetWrapper, Rectangle, Rectangle>> wrappers;

        public ConvertWidgetSizes(WidgetPanel widgetPanel, Seq<Tuple3<WidgetWrapper, Rectangle, Rectangle>> wrappers) {
            this.widgetPanel = widgetPanel;
            this.wrappers = wrappers;
        }

        @Override
        public void redo() {
            this.widgetPanel.setInterfaceMode(InterfaceMode$Interact$.MODULE$, true);
            this.wrappers.foreach(WidgetActions$::org$nlogo$app$interfacetab$WidgetActions$ConvertWidgetSizes$$_$redo$$anonfun$4);
        }

        @Override
        public void undo() {
            this.widgetPanel.setInterfaceMode(InterfaceMode$Interact$.MODULE$, true);
            this.wrappers.foreach(WidgetActions$::org$nlogo$app$interfacetab$WidgetActions$ConvertWidgetSizes$$_$undo$$anonfun$5);
        }

        @Override
        public String getPresentationName() {
            return "Convert Widget Sizes";
        }
    }

    public static class MoveSelectedWidgets
    extends AbstractUndoableEdit {
        private final WidgetPanel widgetPanel;
        private final Seq<WidgetWrapper> wws;
        private final Map<WidgetWrapper, Rectangle> initialMap;
        private final Map<WidgetWrapper, Rectangle> finalMap;

        public MoveSelectedWidgets(WidgetPanel widgetPanel, Seq<WidgetWrapper> wws, Map<WidgetWrapper, Rectangle> initialMap, Map<WidgetWrapper, Rectangle> finalMap) {
            this.widgetPanel = widgetPanel;
            this.wws = wws;
            this.initialMap = initialMap;
            this.finalMap = finalMap;
        }

        @Override
        public void redo() {
            this.positionWidgets(this.finalMap);
        }

        @Override
        public void undo() {
            this.positionWidgets(this.initialMap);
        }

        @Override
        public String getPresentationName() {
            return "Widget Movement";
        }

        public void positionWidgets(Map<WidgetWrapper, Rectangle> map) {
            this.wws.foreach(arg_0 -> WidgetActions$.org$nlogo$app$interfacetab$WidgetActions$MoveSelectedWidgets$$_$positionWidgets$$anonfun$1(map, arg_0));
            new Events.DirtyEvent((Option<String>)None$.MODULE$).raise(this.widgetPanel);
        }
    }

    public static class MoveWidgets
    extends AbstractUndoableEdit {
        private final Seq<Tuple3<WidgetWrapper, Rectangle, Rectangle>> moves;

        public MoveWidgets(Seq<Tuple3<WidgetWrapper, Rectangle, Rectangle>> moves) {
            this.moves = moves;
        }

        @Override
        public void redo() {
            this.moves.foreach(move -> this.setBounds((WidgetWrapper)move._1(), (Rectangle)move._3()));
        }

        @Override
        public void undo() {
            this.moves.foreach(move -> this.setBounds((WidgetWrapper)move._1(), (Rectangle)move._2()));
        }

        @Override
        public String getPresentationName() {
            return "Widget Movement";
        }

        private void setBounds(WidgetWrapper widgetWrapper, Rectangle bounds) {
            widgetWrapper.setBounds(widgetWrapper.selected() ? bounds : WidgetActions$.MODULE$.org$nlogo$app$interfacetab$WidgetActions$$$removeSelectionMargin(bounds));
        }
    }

    public static class ReboundWidgets
    extends AbstractUndoableEdit {
        private final Seq<Tuple3<WidgetWrapper, Rectangle, Rectangle>> wrappers;

        public ReboundWidgets(Seq<Tuple3<WidgetWrapper, Rectangle, Rectangle>> wrappers) {
            this.wrappers = wrappers;
        }

        @Override
        public void redo() {
            this.wrappers.foreach(x$1 -> {
                Tuple3 tuple3 = x$1;
                if (tuple3 != null) {
                    WidgetWrapper ww = (WidgetWrapper)tuple3._1();
                    Rectangle bounds = (Rectangle)tuple3._3();
                    this.setBounds(ww, bounds);
                    return;
                }
                throw new MatchError((Object)tuple3);
            });
            this.wrappers.headOption().foreach(WidgetActions$::org$nlogo$app$interfacetab$WidgetActions$ReboundWidgets$$_$redo$$anonfun$3);
        }

        @Override
        public void undo() {
            this.wrappers.foreach(x$1 -> {
                Tuple3 tuple3 = x$1;
                if (tuple3 != null) {
                    WidgetWrapper ww = (WidgetWrapper)tuple3._1();
                    Rectangle bounds = (Rectangle)tuple3._2();
                    this.setBounds(ww, bounds);
                    return;
                }
                throw new MatchError((Object)tuple3);
            });
            this.wrappers.headOption().foreach(WidgetActions$::org$nlogo$app$interfacetab$WidgetActions$ReboundWidgets$$_$undo$$anonfun$4);
        }

        @Override
        public String getPresentationName() {
            return "Widget Stretching";
        }

        private void setBounds(WidgetWrapper widgetWrapper, Rectangle bounds) {
            widgetWrapper.setBounds(widgetWrapper.selected() ? bounds : WidgetActions$.MODULE$.org$nlogo$app$interfacetab$WidgetActions$$$removeSelectionMargin(bounds));
        }
    }

    public static class RemoveMultipleWidgets
    extends AbstractUndoableEdit {
        private final WidgetPanel widgetPanel;
        private final Seq<WidgetWrapper> wws;

        public RemoveMultipleWidgets(WidgetPanel widgetPanel, Seq<WidgetWrapper> wws) {
            this.widgetPanel = widgetPanel;
            this.wws = wws;
        }

        @Override
        public void redo() {
            this.widgetPanel.deleteWidgets(this.wws);
        }

        @Override
        public void undo() {
            this.wws.foreach((Function1 & Serializable)ww -> this.widgetPanel.reAddWidget((WidgetWrapper)ww));
        }

        @Override
        public String getPresentationName() {
            return "Widget(s) Deletion";
        }
    }

    public static class RemoveWidget
    extends AbstractUndoableEdit {
        private final WidgetPanel widgetPanel;
        private final WidgetWrapper ww;

        public RemoveWidget(WidgetPanel widgetPanel, WidgetWrapper ww) {
            this.widgetPanel = widgetPanel;
            this.ww = ww;
        }

        @Override
        public void redo() {
            this.widgetPanel.deleteWidget(this.ww);
        }

        @Override
        public void undo() {
            this.widgetPanel.reAddWidget(this.ww);
        }

        @Override
        public String getPresentationName() {
            return "Widget Deletion";
        }
    }

    public static class ResizeWidget
    extends AbstractUndoableEdit {
        private final WidgetWrapper widgetWrapper;
        private final Rectangle initialBounds;
        private final Rectangle finalBounds;

        public ResizeWidget(WidgetWrapper widgetWrapper, Rectangle initialBounds, Rectangle finalBounds) {
            this.widgetWrapper = widgetWrapper;
            this.initialBounds = initialBounds;
            this.finalBounds = finalBounds;
        }

        @Override
        public void redo() {
            this.setWidgetSize(this.finalBounds);
        }

        @Override
        public void undo() {
            this.setWidgetSize(this.initialBounds);
        }

        @Override
        public String getPresentationName() {
            return "Widget Resizing";
        }

        public void setWidgetSize(Rectangle bounds) {
            this.widgetWrapper.setBounds(this.widgetWrapper.selected() ? bounds : WidgetActions$.MODULE$.org$nlogo$app$interfacetab$WidgetActions$$$removeSelectionMargin(bounds));
            new Events.DirtyEvent((Option<String>)None$.MODULE$).raise(this.widgetWrapper);
        }
    }
}

