/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.Serializable;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import org.nlogo.agent.Agent;
import org.nlogo.agent.Link;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.app.common.CommandLine;
import org.nlogo.app.common.HistoryPrompt;
import org.nlogo.app.common.LinePrompt;
import org.nlogo.app.tools.AgentMonitorEditor;
import org.nlogo.app.tools.AgentMonitorViewPanel;
import org.nlogo.app.tools.AgentMonitorWindow;
import org.nlogo.awt.Hierarchy$;
import org.nlogo.core.AgentKind;
import org.nlogo.core.AgentKind$Observer$;
import org.nlogo.core.I18N;
import org.nlogo.core.I18N$;
import org.nlogo.core.I18N$Prefix$;
import org.nlogo.swing.CollapsiblePane;
import org.nlogo.swing.ScrollPane;
import org.nlogo.swing.Transparent;
import org.nlogo.theme.InterfaceColors$;
import org.nlogo.theme.ThemeSync;
import org.nlogo.window.CommandCenterInterface;
import org.nlogo.window.GUIWorkspace;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public abstract class AgentMonitor
extends JPanel
implements CommandCenterInterface,
ThemeSync {
    private final GUIWorkspace workspace;
    private Agent _agent;
    private List<String> oldVars;
    private final CommandLine commandLine;
    public final AgentLinePrompt org$nlogo$app$tools$AgentMonitor$$prompt;
    public final HistoryPrompt org$nlogo$app$tools$AgentMonitor$$historyPrompt;
    public final AgentMonitorEditor org$nlogo$app$tools$AgentMonitor$$agentEditor;
    private final ScrollPane scrollPane;
    public final MatteBorder org$nlogo$app$tools$AgentMonitor$$separator;
    private final CollapsiblePane viewPane;
    private final CollapsiblePane propertiesPane;
    private final Option<AgentMonitorViewPanel> viewPanel;

    public AgentMonitor(GUIWorkspace workspace, JDialog window) {
        None$ none$;
        this.workspace = workspace;
        super(new BorderLayout());
        I18N.Prefix i18nPrefix = I18N$Prefix$.MODULE$.apply("tools.agentMonitor");
        this._agent = null;
        this.oldVars = this.vars();
        this.commandLine = new CommandLine(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super($outer, false, 11, $outer.workspace());
            }

            public String classDisplayName() {
                return "Agent Monitor";
            }

            public boolean useAgentClass() {
                return false;
            }
        };
        this.org$nlogo$app$tools$AgentMonitor$$prompt = new AgentLinePrompt(this.commandLine());
        this.org$nlogo$app$tools$AgentMonitor$$historyPrompt = new HistoryPrompt(this.commandLine());
        this.org$nlogo$app$tools$AgentMonitor$$agentEditor = new AgentMonitorEditor(this);
        this.scrollPane = new ScrollPane(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super($outer.org$nlogo$app$tools$AgentMonitor$$agentEditor, 20, 31);
                this.setBorder(null);
            }

            public Dimension getPreferredSize() {
                Dimension sup = super.getPreferredSize();
                return new Dimension(sup.width, StrictMath.min(sup.height, 350));
            }
        };
        this.org$nlogo$app$tools$AgentMonitor$$separator = new ThemeSync(){

            public void syncTheme() {
                this.color = InterfaceColors$.MODULE$.agentMonitorSeparator();
            }
        };
        AgentMonitorViewPanel panel = new AgentMonitorViewPanel(workspace);
        this.viewPane = new CollapsiblePane(I18N$.MODULE$.gui().apply("view", i18nPrefix), panel, window);
        this.propertiesPane = new CollapsiblePane(I18N$.MODULE$.gui().apply("properties", i18nPrefix), this.scrollPane, window);
        AgentKind agentKind = this.agentKind();
        AgentKind$Observer$ agentKind$Observer$ = AgentKind$Observer$.MODULE$;
        if (!(agentKind != null ? !agentKind.equals(agentKind$Observer$) : agentKind$Observer$ != null)) {
            this.add((Component)this.scrollPane, "Center");
            none$ = None$.MODULE$;
        } else {
            this.add((Component)this.viewPane, "North");
            this.add((Component)this.propertiesPane, "Center");
            this.commandLine().setEnabled(this.agent() != null && this.agent().id() != -1L);
            this.org$nlogo$app$tools$AgentMonitor$$historyPrompt.setEnabled(this.agent() != null && this.agent().id() != -1L);
            this.commandLine().agentKind(this.agentKind());
            this.add((Component)((Object)new Transparent(this){
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    Transparent.$init$(this);
                    this.setLayout(new BoxLayout(this, 0));
                    this.setBorder(new CompoundBorder($outer.org$nlogo$app$tools$AgentMonitor$$separator, new EmptyBorder(6, 6, 6, 6)));
                    this.add($outer.org$nlogo$app$tools$AgentMonitor$$prompt);
                    this.add(Box.createHorizontalStrut(6));
                    this.add($outer.commandLine());
                    this.add(Box.createHorizontalStrut(6));
                    this.add($outer.org$nlogo$app$tools$AgentMonitor$$historyPrompt);
                }
            }), "South");
            none$ = Some$.MODULE$.apply((Object)panel);
        }
        this.viewPanel = none$;
    }

    public GUIWorkspace workspace() {
        return this.workspace;
    }

    public Agent agent() {
        return this._agent;
    }

    public void setAgent(Agent agent, double radius) {
        Agent oldAgent = this._agent;
        Agent agent2 = agent;
        Agent agent3 = oldAgent;
        if (agent2 == null ? agent3 != null : !agent2.equals(agent3)) {
            this._agent = agent;
            this.commandLine().agent(agent);
            this.commandLine().setEnabled(agent != null && agent.id() != -1L);
            this.org$nlogo$app$tools$AgentMonitor$$historyPrompt.setEnabled(agent != null && agent.id() != -1L);
            this.org$nlogo$app$tools$AgentMonitor$$agentEditor.reset();
            AgentMonitorWindow window = (AgentMonitorWindow)Hierarchy$.MODULE$.findAncestorOfClass(this, AgentMonitorWindow.class).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            if (window != null) {
                window.agentChangeNotify(oldAgent);
            }
            this.viewPanel.foreach(_$1 -> _$1.agent(agent, radius));
            return;
        }
    }

    public abstract List<String> vars();

    public abstract AgentKind agentKind();

    public CommandLine commandLine() {
        return this.commandLine;
    }

    @Override
    public void cycleAgentType(boolean forward) {
        if (forward) {
            this.org$nlogo$app$tools$AgentMonitor$$agentEditor.requestFocus();
            return;
        }
        this.commandLine().transferFocusBackward();
    }

    public void radius(double radius) {
        this.viewPanel.foreach(_$2 -> _$2.radius(radius));
    }

    @Override
    public void requestFocus() {
        if (this.commandLine().isEnabled()) {
            this.commandLine().requestFocus();
            return;
        }
        this.org$nlogo$app$tools$AgentMonitor$$agentEditor.requestFocus();
    }

    public void refresh() {
        this.viewPanel.foreach(_$3 -> _$3.refresh());
        if (this.agent() != null && this.agent().id() == -1L) {
            this.viewPanel.foreach(_$4 -> _$4.setEnabled(false));
            this.commandLine().setEnabled(false);
            this.org$nlogo$app$tools$AgentMonitor$$historyPrompt.setEnabled(false);
        }
        if (!(this.oldVars == this.vars() || this.vars() != null && this.oldVars != null && this.sameVars(this.oldVars, this.vars()))) {
            this.org$nlogo$app$tools$AgentMonitor$$agentEditor.reset();
            this.oldVars = this.vars();
            return;
        }
        this.org$nlogo$app$tools$AgentMonitor$$agentEditor.refresh();
    }

    public void setPrompt() {
        this.org$nlogo$app$tools$AgentMonitor$$prompt.setText(this.org$nlogo$app$tools$AgentMonitor$$prompt.getPrompt());
    }

    private boolean sameVars(List<String> vars1, List<String> vars2) {
        return vars1.size() == vars2.size() && RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), vars1.size()).forall((Function1)(JFunction1.mcZI.sp & Serializable)i -> BoxesRunTime.equals(vars1.get(i), vars2.get(i)));
    }

    public void close() {
        this.viewPanel.foreach(_$5 -> _$5.close());
    }

    @Override
    public void syncTheme() {
        this.setBackground(InterfaceColors$.MODULE$.dialogBackground());
        this.scrollPane.setBackground(InterfaceColors$.MODULE$.dialogBackground());
        this.org$nlogo$app$tools$AgentMonitor$$agentEditor.syncTheme();
        this.viewPane.syncTheme();
        this.propertiesPane.syncTheme();
        ((ThemeSync)((Object)this.org$nlogo$app$tools$AgentMonitor$$separator)).syncTheme();
        this.commandLine().syncTheme();
    }

    public class AgentLinePrompt
    extends LinePrompt {
        public AgentLinePrompt(CommandLine commandLine) {
            if (AgentMonitor.this == null) {
                throw new NullPointerException();
            }
            super(commandLine, false);
        }

        @Override
        public String getPrompt() {
            Agent agent = AgentMonitor.this.agent();
            if (agent instanceof Turtle || agent instanceof Patch || agent instanceof Link) {
                return AgentMonitor.this.agent().toString() + ">";
            }
            return ">";
        }

        public final /* synthetic */ AgentMonitor org$nlogo$app$tools$AgentMonitor$AgentLinePrompt$$$outer() {
            return AgentMonitor.this;
        }
    }
}

