/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app.tools;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.nlogo.agent.Agent;
import org.nlogo.app.tools.AgentMonitor;
import org.nlogo.app.tools.AgentVarEditor;
import org.nlogo.core.AgentKind;
import org.nlogo.core.I18N$;
import org.nlogo.swing.Transparent;
import org.nlogo.theme.InterfaceColors$;
import org.nlogo.theme.ThemeSync;
import org.nlogo.window.GUIWorkspace;
import scala.Function1;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;

public class AgentMonitorEditor
extends JPanel
implements ThemeSync {
    private final AgentMonitor parent;
    private final JLabel noVarLabel;
    private List<AgentVarEditor> editors;

    public AgentMonitorEditor(AgentMonitor parent) {
        this.parent = parent;
        this.noVarLabel = new JLabel(I18N$.MODULE$.gui().get("tools.agentMonitor.editor.noVariables"));
        this.editors = package$.MODULE$.Nil();
        this.reset();
    }

    @Override
    public void requestFocus() {
        this.editors.headOption().foreach(_$1 -> _$1.requestFocus());
    }

    public void refresh() {
        this.editors.foreach(_$2 -> _$2.refresh(false));
    }

    public void reset() {
        Object object;
        this.removeAll();
        this.editors = package$.MODULE$.Nil();
        if (this.vars() == null || this.vars().isEmpty()) {
            this.setLayout(new FlowLayout());
            object = this.add(this.noVarLabel);
        } else {
            this.fill();
            object = BoxedUnit.UNIT;
        }
        this.syncTheme();
    }

    private void fill() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.gridx = 0;
        labelConstraints.anchor = 13;
        labelConstraints.insets = new Insets(0, 3, 0, 3);
        GridBagConstraints editorConstraints = new GridBagConstraints();
        editorConstraints.gridx = 1;
        editorConstraints.fill = 2;
        editorConstraints.weightx = 1.0;
        editorConstraints.insets = new Insets(3, 0, 0, 3);
        this.editors = CollectionConverters$.MODULE$.ListHasAsScala(this.vars()).asScala().toList().map((Function1 & Serializable)variableName -> {
            JLabel label = new JLabel(variableName.toLowerCase());
            int index = this.agent() == null ? this.workspace().world().indexOfVariable(this.agentKind(), (String)variableName) : this.workspace().world().indexOfVariable(this.agent(), (String)variableName);
            AgentVarEditor editor = new AgentVarEditor(this, index, (String)variableName, label);
            editor.agentKind(this.agentKind());
            this.add((Component)label, labelConstraints);
            this.add((Component)editor, editorConstraints);
            return editor;
        });
        GridBagConstraints fillerConstraints = new GridBagConstraints();
        fillerConstraints.gridx = 0;
        fillerConstraints.gridwidth = 2;
        fillerConstraints.fill = 1;
        fillerConstraints.weighty = 1.0;
        Transparent fillerPanel = new Transparent(){
            {
                Transparent.$init$(this);
            }
        };
        this.add((Component)((Object)fillerPanel), fillerConstraints);
        this.revalidate();
    }

    public java.util.List<String> vars() {
        return this.parent.vars();
    }

    public Agent agent() {
        return this.parent.agent();
    }

    public AgentKind agentKind() {
        return this.parent.agentKind();
    }

    public void setAgent(Agent agent) {
        this.parent.setAgent(agent, 3.0);
    }

    public GUIWorkspace workspace() {
        return this.parent.workspace();
    }

    @Override
    public void syncTheme() {
        this.setBackground(InterfaceColors$.MODULE$.dialogBackground());
        this.noVarLabel.setForeground(InterfaceColors$.MODULE$.dialogText());
        this.editors.foreach(_$3 -> _$3.syncTheme());
    }
}

