/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JSlider;
import org.nlogo.agent.Agent;
import org.nlogo.api.Perspective$Watch$;
import org.nlogo.app.tools.AgentMonitorView;
import org.nlogo.core.I18N$;
import org.nlogo.swing.ToggleButton;
import org.nlogo.theme.InterfaceColors$;
import org.nlogo.theme.ThemeSync;
import org.nlogo.window.GUIWorkspace;

public class AgentMonitorViewPanel
extends JPanel
implements ThemeSync {
    public final GUIWorkspace org$nlogo$app$tools$AgentMonitorViewPanel$$workspace;
    public final AgentMonitorView org$nlogo$app$tools$AgentMonitorViewPanel$$view;
    public final ToggleButton org$nlogo$app$tools$AgentMonitorViewPanel$$watchButton;
    private final ZoomSlider zoomer;
    private final JPanel controls;

    public AgentMonitorViewPanel(GUIWorkspace workspace) {
        this.org$nlogo$app$tools$AgentMonitorViewPanel$$workspace = workspace;
        super(new BorderLayout());
        this.org$nlogo$app$tools$AgentMonitorViewPanel$$view = new AgentMonitorView(workspace);
        this.org$nlogo$app$tools$AgentMonitorViewPanel$$watchButton = new ToggleButton(new WatchAction());
        this.zoomer = new ZoomSlider(this, this.org$nlogo$app$tools$AgentMonitorViewPanel$$view);
        this.add((Component)this.org$nlogo$app$tools$AgentMonitorViewPanel$$view, "Center");
        this.org$nlogo$app$tools$AgentMonitorViewPanel$$view.setSize(workspace.world().worldWidth(), workspace.world().worldHeight(), 255.0 / (double)workspace.world().worldWidth());
        this.org$nlogo$app$tools$AgentMonitorViewPanel$$view.applyNewFontSize(workspace.view().fontSize(), 0);
        this.org$nlogo$app$tools$AgentMonitorViewPanel$$watchButton.setFocusable(false);
        this.controls = new JPanel();
        this.controls.add(this.org$nlogo$app$tools$AgentMonitorViewPanel$$watchButton);
        this.controls.add(this.zoomer);
        this.add((Component)this.controls, "South");
        this.org$nlogo$app$tools$AgentMonitorViewPanel$$watchButton.setEnabled(false);
        this.zoomer.setEnabled(false);
    }

    public void agent(Agent agent, double radius) {
        this.org$nlogo$app$tools$AgentMonitorViewPanel$$view.agent(agent);
        this.org$nlogo$app$tools$AgentMonitorViewPanel$$watchButton.setEnabled(true);
        this.zoomer.setEnabled(true);
        this.radius(radius);
    }

    public void radius(double radius) {
        this.zoomer.setValue((int)StrictMath.round(radius * (double)100));
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean wasEnabled = this.isEnabled();
        super.setEnabled(enabled);
        if (!enabled && wasEnabled) {
            JPanel grayPanel = new JPanel();
            grayPanel.setPreferredSize(this.org$nlogo$app$tools$AgentMonitorViewPanel$$view.getPreferredSize());
            this.remove(this.org$nlogo$app$tools$AgentMonitorViewPanel$$view);
            this.add((Component)grayPanel, "Center");
            return;
        }
    }

    public void refresh() {
        this.repaint();
        this.revalidate();
    }

    public void close() {
        this.org$nlogo$app$tools$AgentMonitorViewPanel$$view.close();
    }

    @Override
    public void syncTheme() {
        this.controls.setBackground(InterfaceColors$.MODULE$.dialogBackground());
        this.org$nlogo$app$tools$AgentMonitorViewPanel$$watchButton.syncTheme();
    }

    public class WatchAction
    extends AbstractAction {
        public WatchAction() {
            if (AgentMonitorViewPanel.this == null) {
                throw new NullPointerException();
            }
            super(I18N$.MODULE$.gui().get("tools.agentMonitor.view.watch"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AgentMonitorViewPanel.this.org$nlogo$app$tools$AgentMonitorViewPanel$$watchButton.isSelected()) {
                AgentMonitorViewPanel.this.org$nlogo$app$tools$AgentMonitorViewPanel$$workspace.world().observer().setPerspective(Perspective$Watch$.MODULE$.apply(AgentMonitorViewPanel.this.org$nlogo$app$tools$AgentMonitorViewPanel$$view.agent()));
            } else {
                AgentMonitorViewPanel.this.org$nlogo$app$tools$AgentMonitorViewPanel$$workspace.world().observer().resetPerspective();
            }
            AgentMonitorViewPanel.this.org$nlogo$app$tools$AgentMonitorViewPanel$$workspace.view().discardOffscreenImage();
            AgentMonitorViewPanel.this.org$nlogo$app$tools$AgentMonitorViewPanel$$workspace.viewManager().getPrimary().incrementalUpdateFromEventThread();
        }

        public final /* synthetic */ AgentMonitorViewPanel org$nlogo$app$tools$AgentMonitorViewPanel$WatchAction$$$outer() {
            return AgentMonitorViewPanel.this;
        }
    }

    public class ZoomSlider
    extends JSlider
    implements MouseWheelListener {
        private final AgentMonitorView view;
        private final /* synthetic */ AgentMonitorViewPanel $outer;

        public ZoomSlider(AgentMonitorViewPanel $outer, AgentMonitorView view) {
            this.view = view;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(0, ($outer.org$nlogo$app$tools$AgentMonitorViewPanel$$workspace.world().worldWidth() - 1) / 2 * 100, (int)(view.radius() * (double)100));
            this.addMouseWheelListener(this);
            this.setInverted(true);
        }

        @Override
        public void setValue(int n) {
            super.setValue(n);
            this.view.radius((double)n / 100.0);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            this.setValue(this.getValue() - e.getWheelRotation());
        }

        public final /* synthetic */ AgentMonitorViewPanel org$nlogo$app$tools$AgentMonitorViewPanel$ZoomSlider$$$outer() {
            return this.$outer;
        }
    }
}

