/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.nlogo.analytics.Analytics$;
import org.nlogo.app.common.TabsInterface;
import org.nlogo.app.tools.Preference;
import org.nlogo.app.tools.Preference$;
import org.nlogo.app.tools.Preferences$LogDirectory$;
import org.nlogo.app.tools.Preferences$StringPreference$;
import org.nlogo.app.tools.RequiredAction;
import org.nlogo.app.tools.RequiredAction$Restart$;
import org.nlogo.core.NetLogoPreferences$;
import org.nlogo.swing.Button;
import org.nlogo.swing.CheckBox;
import org.nlogo.swing.TextField;
import org.nlogo.swing.TextField$;
import org.nlogo.swing.Transparent;
import org.nlogo.window.AbstractWidgetPanel;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class Preferences {

    public static class BoldWidgetText
    extends BooleanPreference {
        private final AbstractWidgetPanel widgetPanel;

        public BoldWidgetText(AbstractWidgetPanel widgetPanel) {
            this.widgetPanel = widgetPanel;
            super("boldWidgetText", (Option<RequiredAction>)None$.MODULE$, false);
        }

        @Override
        public void onSelect(boolean selected) {
            this.widgetPanel.setBoldWidgetText(selected);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static abstract class BooleanPreference
    implements Preference {
        private final String i18nKey$field;
        private final Option requirement;
        private final int anchor;
        private final String i18nKey;
        private final boolean default;
        private final CheckBox checkBox;

        public BooleanPreference(String i18nKey, Option<RequiredAction> requirement, boolean bl) {
            this.i18nKey = i18nKey;
            this.default = bl;
            this.i18nKey$field = i18nKey;
            this.requirement = requirement;
            this.anchor = Preference$.MODULE$.$lessinit$greater$default$3();
            this.checkBox = new CheckBox("", (Function1<Object, BoxedUnit>)(Function1 & Serializable)v1 -> {
                this.$init$$$anonfun$1(i18nKey, BoxesRunTime.unboxToBoolean((Object)v1));
                return BoxedUnit.UNIT;
            });
        }

        @Override
        public String i18nKey() {
            return this.i18nKey$field;
        }

        public Option requirement() {
            return this.requirement;
        }

        @Override
        public int anchor() {
            return this.anchor;
        }

        public CheckBox checkBox() {
            return this.checkBox;
        }

        @Override
        public JComponent component() {
            return this.checkBox();
        }

        private boolean getPreference() {
            return NetLogoPreferences$.MODULE$.getBoolean(this.i18nKey, this.default);
        }

        @Override
        public void load() {
            boolean pref = this.getPreference();
            if (this.checkBox().isSelected() != pref) {
                this.checkBox().doClick();
                return;
            }
        }

        @Override
        public void save() {
            NetLogoPreferences$.MODULE$.putBoolean(this.i18nKey, this.checkBox().isSelected());
        }

        @Override
        public boolean changed() {
            return this.getPreference() != this.checkBox().isSelected();
        }

        public void onSelect(boolean selected) {
        }

        private final /* synthetic */ void $init$$$anonfun$1(String i18nKey$1, boolean selected) {
            if (selected != this.getPreference()) {
                Analytics$.MODULE$.preferenceChange(i18nKey$1, BoxesRunTime.boxToBoolean((boolean)selected).toString());
            }
            this.onSelect(selected);
        }
    }

    public static class EditorLineNumbers
    extends BooleanPreference {
        private final TabsInterface tabs;

        public EditorLineNumbers(TabsInterface tabs) {
            this.tabs = tabs;
            super("editorLineNumbers", (Option<RequiredAction>)None$.MODULE$, true);
        }

        @Override
        public void onSelect(boolean selected) {
            this.tabs.lineNumbersVisible_$eq(selected);
        }
    }

    public static class IncludedFilesMenu
    extends BooleanPreference {
        private final TabsInterface tabs;

        public IncludedFilesMenu(TabsInterface tabs) {
            this.tabs = tabs;
            super("includedFilesMenu", (Option<RequiredAction>)None$.MODULE$, true);
        }

        @Override
        public void onSelect(boolean selected) {
            this.tabs.setIncludedFilesShown(selected);
        }
    }

    public static class IndentAutomatically
    extends BooleanPreference {
        private final TabsInterface tabs;

        public IndentAutomatically(TabsInterface tabs) {
            this.tabs = tabs;
            super("indentAutomatically", (Option<RequiredAction>)None$.MODULE$, true);
        }

        @Override
        public void onSelect(boolean selected) {
            this.tabs.smartTabbingEnabled_$eq(selected);
        }
    }

    public static class JumpOnClick
    extends BooleanPreference {
        private final TabsInterface tabs;

        public JumpOnClick(TabsInterface tabs) {
            this.tabs = tabs;
            super("jumpOnClick", (Option<RequiredAction>)None$.MODULE$, true);
        }

        @Override
        public void onSelect(boolean selected) {
            this.tabs.setJumpOnClick(selected);
        }
    }

    public static class LogDirectory
    extends StringPreference {
        private final Frame frame;
        private final JPanel panel;

        public LogDirectory(Frame frame) {
            this.frame = frame;
            super("logDirectory", (Option<RequiredAction>)Some$.MODULE$.apply((Object)RequiredAction$Restart$.MODULE$), "");
            this.panel = new Transparent(this){
                private final Button browseButton;
                private final /* synthetic */ LogDirectory $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super(new BorderLayout(6, 0));
                    Transparent.$init$(this);
                    this.add((Component)$outer.textField(), "Center");
                    this.browseButton = new Button(new AbstractAction(this){
                        private final /* synthetic */ LogDirectory$$anon$5 $outer;
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            super("Browse...");
                        }

                        public void actionPerformed(ActionEvent e) {
                            this.$outer.org$nlogo$app$tools$Preferences$LogDirectory$_$$anon$$$outer().org$nlogo$app$tools$Preferences$LogDirectory$$askForConfigFile(this.$outer.org$nlogo$app$tools$Preferences$LogDirectory$_$$anon$$$outer().textField().getText()).foreach(x$0 -> this.$outer.org$nlogo$app$tools$Preferences$LogDirectory$_$$anon$$$outer().textField().setText((String)x$0));
                        }

                        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{actionPerformed$$anonfun$1(java.lang.String )}, serializedLambda);
                        }
                    });
                    this.add((Component)this.browseButton, "East");
                }

                public void syncTheme() {
                    this.$outer.textField().syncTheme();
                    this.browseButton.syncTheme();
                }

                public final /* synthetic */ LogDirectory org$nlogo$app$tools$Preferences$LogDirectory$_$$anon$$$outer() {
                    return this.$outer;
                }
            };
        }

        public Frame frame() {
            return this.frame;
        }

        @Override
        public JComponent component() {
            return this.panel;
        }

        public Option<String> org$nlogo$app$tools$Preferences$LogDirectory$$askForConfigFile(String current) {
            JFileChooser dialog = new JFileChooser(new File(current));
            dialog.setDialogTitle("Log Directory");
            dialog.setFileSelectionMode(1);
            if (dialog.showOpenDialog(this.frame()) == 0) {
                File file = dialog.getSelectedFile();
                if (file.isDirectory()) {
                    return Option$.MODULE$.apply((Object)file.getAbsolutePath());
                }
                return Option$.MODULE$.apply((Object)dialog.getCurrentDirectory().getAbsolutePath());
            }
            return None$.MODULE$;
        }
    }

    public static class ReloadOnExternalChanges
    extends BooleanPreference {
        private final TabsInterface tabs;

        public ReloadOnExternalChanges(TabsInterface tabs) {
            this.tabs = tabs;
            super("reloadOnExternalChanges", (Option<RequiredAction>)None$.MODULE$, false);
        }

        @Override
        public void onSelect(boolean selected) {
            this.tabs.watchingFiles_$eq(selected);
        }
    }

    public static abstract class StringPreference
    implements Preference {
        private final String i18nKey$field;
        private final Option requirement;
        private final int anchor;
        public final String org$nlogo$app$tools$Preferences$StringPreference$$i18nKey;
        public final String org$nlogo$app$tools$Preferences$StringPreference$$default;
        private final TextField textField;

        public StringPreference(String i18nKey, Option<RequiredAction> requirement, String string) {
            this.org$nlogo$app$tools$Preferences$StringPreference$$i18nKey = i18nKey;
            this.org$nlogo$app$tools$Preferences$StringPreference$$default = string;
            this.i18nKey$field = i18nKey;
            this.requirement = requirement;
            this.anchor = Preference$.MODULE$.$lessinit$greater$default$3();
            this.textField = new TextField(this){
                private final /* synthetic */ StringPreference $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super(20, $outer.org$nlogo$app$tools$Preferences$StringPreference$$default, TextField$.MODULE$.$lessinit$greater$default$3());
                    this.getDocument().addDocumentListener(new DocumentListener(this){
                        private final /* synthetic */ StringPreference$$anon$1 $outer;
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }

                        public void changedUpdate(DocumentEvent e) {
                            this.$outer.org$nlogo$app$tools$Preferences$StringPreference$$anon$1$$changed();
                        }

                        public void insertUpdate(DocumentEvent e) {
                            this.$outer.org$nlogo$app$tools$Preferences$StringPreference$$anon$1$$changed();
                        }

                        public void removeUpdate(DocumentEvent e) {
                            this.$outer.org$nlogo$app$tools$Preferences$StringPreference$$anon$1$$changed();
                        }
                    });
                }

                public Insets getInsets() {
                    return new Insets(3, 3, 3, 0);
                }

                public void org$nlogo$app$tools$Preferences$StringPreference$$anon$1$$changed() {
                    String string = this.getText();
                    String string2 = this.$outer.org$nlogo$app$tools$Preferences$StringPreference$$getPreference();
                    if (string == null ? string2 != null : !string.equals(string2)) {
                        Analytics$.MODULE$.preferenceChange(this.$outer.org$nlogo$app$tools$Preferences$StringPreference$$i18nKey, this.getText());
                        return;
                    }
                }
            };
        }

        @Override
        public String i18nKey() {
            return this.i18nKey$field;
        }

        public Option requirement() {
            return this.requirement;
        }

        @Override
        public int anchor() {
            return this.anchor;
        }

        public TextField textField() {
            return this.textField;
        }

        @Override
        public JComponent component() {
            return this.textField();
        }

        public String org$nlogo$app$tools$Preferences$StringPreference$$getPreference() {
            return NetLogoPreferences$.MODULE$.get(this.org$nlogo$app$tools$Preferences$StringPreference$$i18nKey, this.org$nlogo$app$tools$Preferences$StringPreference$$default);
        }

        @Override
        public void load() {
            this.textField().setText(this.org$nlogo$app$tools$Preferences$StringPreference$$getPreference());
        }

        @Override
        public void save() {
            NetLogoPreferences$.MODULE$.put(this.org$nlogo$app$tools$Preferences$StringPreference$$i18nKey, this.textField().getText());
        }

        @Override
        public boolean changed() {
            String string = this.org$nlogo$app$tools$Preferences$StringPreference$$getPreference();
            String string2 = this.textField().getText();
            return string == null ? string2 != null : !string.equals(string2);
        }
    }
}

