/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.compile;

import java.io.IOException;
import java.io.Serializable;
import java.util.Locale;
import org.nlogo.api.ExtensionManager;
import org.nlogo.api.LibraryManager;
import org.nlogo.api.SourceOwner;
import org.nlogo.api.World;
import org.nlogo.compile.CompilerMain$;
import org.nlogo.compile.Literals$;
import org.nlogo.core.CompilationEnvironment;
import org.nlogo.core.CompilerException;
import org.nlogo.core.CompilerUtilitiesInterface;
import org.nlogo.core.Dialect;
import org.nlogo.core.Femto$;
import org.nlogo.core.File;
import org.nlogo.core.FrontEndInterface;
import org.nlogo.core.FrontEndInterface$;
import org.nlogo.core.FrontEndProcedure;
import org.nlogo.core.ProcedureDefinition;
import org.nlogo.core.ProcedureSyntax;
import org.nlogo.core.Program;
import org.nlogo.core.StructureResults;
import org.nlogo.core.Token;
import org.nlogo.core.TokenType;
import org.nlogo.core.TokenType$Eof$;
import org.nlogo.core.TokenType$Ident$;
import org.nlogo.core.TokenType$Keyword$;
import org.nlogo.core.TokenizerInterface;
import org.nlogo.nvm.CompilerFlags;
import org.nlogo.nvm.CompilerInterface;
import org.nlogo.nvm.CompilerResults;
import org.nlogo.nvm.ImportHandler;
import org.nlogo.nvm.PresentationCompilerInterface;
import org.nlogo.nvm.Procedure;
import org.nlogo.nvm.Reporter;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.MapOps;
import scala.collection.SeqOps;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.ListMap$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public class Compiler
implements CompilerInterface,
PresentationCompilerInterface {
    private final Dialect dialect;
    private final Dialect defaultDialect;
    private final CompilerUtilitiesInterface utilities;
    private final TokenizerInterface parserTokenizer;
    private final ListMap<String, Procedure> noProcedures;

    public Compiler(Dialect dialect) {
        this.dialect = dialect;
        this.defaultDialect = dialect;
        this.utilities = (CompilerUtilitiesInterface)Femto$.MODULE$.scalaSingleton("org.nlogo.parse.CompilerUtilities");
        this.parserTokenizer = (TokenizerInterface)Femto$.MODULE$.scalaSingleton("org.nlogo.lex.Tokenizer");
        this.noProcedures = ListMap$.MODULE$.empty();
    }

    @Override
    public Dialect defaultDialect() {
        return this.defaultDialect;
    }

    @Override
    public CompilerUtilitiesInterface utilities() {
        return this.utilities;
    }

    @Override
    public FrontEndInterface frontEnd() {
        return (FrontEndInterface)Femto$.MODULE$.scalaSingleton("org.nlogo.parse.FrontEnd");
    }

    public TokenizerInterface parserTokenizer() {
        return this.parserTokenizer;
    }

    public CompilerResults compileProgram(String source, Program program, ExtensionManager extensionManager, LibraryManager libManager, CompilationEnvironment compilationEnv) throws CompilerException {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)source);
        Tuple2<ListMap<String, Procedure>, Program> tuple2 = CompilerMain$.MODULE$.compile((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))), (Option<String>)None$.MODULE$, program, false, this.noProcedures, extensionManager, libManager, compilationEnv, CompilerMain$.MODULE$.compile$default$9());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ListMap procedures = (ListMap)tuple2._1();
        Program newProgram = (Program)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)procedures, (Object)newProgram);
        ListMap procedures2 = (ListMap)tuple22._1();
        Program newProgram2 = (Program)tuple22._2();
        return new CompilerResults((ListMap<String, Procedure>)procedures2, newProgram2);
    }

    @Override
    public CompilerResults compileProgram(String source, Seq<SourceOwner> additionalSources, Program program, ExtensionManager extensionManager, LibraryManager libManager, CompilationEnvironment compilationEnv, boolean shouldAutoInstallLibs) throws CompilerException {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)source);
        Map sources = (Map)((MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).$plus$plus((IterableOnce)((IterableOnceOps)additionalSources.map((Function1 & Serializable)additionalSource -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)additionalSource.classDisplayName());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)additionalSource.innerSource());
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        Tuple2<ListMap<String, Procedure>, Program> tuple2 = CompilerMain$.MODULE$.compile((Map<String, String>)sources, (Option<String>)None$.MODULE$, program, false, this.noProcedures, extensionManager, libManager, compilationEnv, shouldAutoInstallLibs);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ListMap procedures = (ListMap)tuple2._1();
        Program newProgram = (Program)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)procedures, (Object)newProgram);
        ListMap procedures2 = (ListMap)tuple22._1();
        Program newProgram2 = (Program)tuple22._2();
        return new CompilerResults((ListMap<String, Procedure>)procedures2, newProgram2);
    }

    @Override
    public CompilerResults compileProgram(String source, Program program, ExtensionManager extensionManager, LibraryManager libManager, CompilationEnvironment compilationEnvironment, boolean shouldAutoInstallLibs, CompilerFlags flags) {
        return this.compileProgram(source, (Seq<SourceOwner>)((Seq)((SeqOps)Nil$.MODULE$)), program, extensionManager, libManager, compilationEnvironment, shouldAutoInstallLibs);
    }

    @Override
    public Reporter makeLiteralReporter(Object value) {
        return Literals$.MODULE$.makeLiteralReporter(value);
    }

    public CompilerResults compileMoreCode(String source, Option<String> displayName, Program program, ListMap<String, Procedure> oldProcedures, ExtensionManager extensionManager, LibraryManager libManager, CompilationEnvironment compilationEnv) throws CompilerException {
        ((IterableOnceOps)((IterableOps)this.frontEnd().tokenizeForColorization(source, this.dialect, extensionManager).drop(1)).dropRight(2)).find((Function1 & Serializable)_$1 -> {
            TokenType tokenType = _$1.tpe();
            TokenType$Keyword$ tokenType$Keyword$ = TokenType$Keyword$.MODULE$;
            return !(tokenType != null ? !tokenType.equals(tokenType$Keyword$) : tokenType$Keyword$ != null);
        }).foreach((Function1 & Serializable)token -> {
            throw new CompilerException("Keyword " + token.text().toUpperCase(Locale.ENGLISH) + " cannot be used in this context.", token.start(), token.end(), token.sourceLocation().filename());
        });
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)source);
        Tuple2<ListMap<String, Procedure>, Program> tuple2 = CompilerMain$.MODULE$.compile((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))), displayName, program, true, oldProcedures, extensionManager, libManager, compilationEnv, CompilerMain$.MODULE$.compile$default$9());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ListMap procedures = (ListMap)tuple2._1();
        Program newProgram = (Program)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)procedures, (Object)newProgram);
        ListMap procedures2 = (ListMap)tuple22._1();
        Program newProgram2 = (Program)tuple22._2();
        return new CompilerResults((ListMap<String, Procedure>)procedures2, newProgram2);
    }

    @Override
    public CompilerResults compileMoreCode(String source, Option<String> displayName, Program program, ListMap<String, Procedure> oldProcedures, ExtensionManager extensionManager, LibraryManager libManager, CompilationEnvironment compilationEnvironment, CompilerFlags flags) {
        return this.compileMoreCode(source, displayName, program, oldProcedures, extensionManager, libManager, compilationEnvironment);
    }

    @Override
    public void checkCommandSyntax(String source, Program program, ListMap<String, Procedure> procedures, ExtensionManager extensionManager, boolean parse, CompilationEnvironment compilationEnv) throws CompilerException {
        this.checkSyntax("to __bogus-name " + source + "\nend", true, program, procedures, extensionManager, parse, compilationEnv);
    }

    @Override
    public void checkReporterSyntax(String source, Program program, ListMap<String, Procedure> procedures, ExtensionManager extensionManager, boolean parse, CompilationEnvironment compilationEnv) throws CompilerException {
        this.checkSyntax("to-report __bogus-name report " + source + "\nend", true, program, procedures, extensionManager, parse, compilationEnv);
    }

    private void checkSyntax(String source, boolean subprogram, Program program, ListMap<String, Procedure> oldProcedures, ExtensionManager extensionManager, boolean parse, CompilationEnvironment compilationEnv) throws CompilerException {
        ListMap oldProceduresListMap = (ListMap)ListMap$.MODULE$.apply(oldProcedures.toSeq());
        FrontEndInterface frontEndInterface = this.frontEnd();
        Tuple2<Seq<ProcedureDefinition>, StructureResults> tuple2 = frontEndInterface.frontEnd(source, (Option<String>)None$.MODULE$, program, subprogram, (ListMap<String, FrontEndProcedure>)oldProceduresListMap, extensionManager, frontEndInterface.frontEnd$default$7(), frontEndInterface.frontEnd$default$8(), frontEndInterface.frontEnd$default$9());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq topLevelDefs = (Seq)tuple2._1();
        StructureResults feStructureResults = (StructureResults)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)topLevelDefs, (Object)feStructureResults);
        Seq topLevelDefs2 = (Seq)tuple22._1();
        StructureResults feStructureResults2 = (StructureResults)tuple22._2();
    }

    @Override
    public Object readFromString(String source) throws CompilerException {
        return this.utilities().readFromString(source);
    }

    @Override
    public Object readFromString(String source, World world, ExtensionManager extensionManager) throws CompilerException {
        ImportHandler literalImportHandler = new ImportHandler(world, extensionManager);
        return this.utilities().readFromString(source, literalImportHandler);
    }

    @Override
    public Double readNumberFromString(String source, World world, ExtensionManager extensionManager) throws CompilerException {
        ImportHandler literalImportHandler = new ImportHandler(world, extensionManager);
        return this.utilities().readNumberFromString(source, literalImportHandler);
    }

    public Object readFromFile(File currFile, World world, ExtensionManager extensionManager) throws IOException, CompilerException {
        ImportHandler literalImportHandler = new ImportHandler(world, extensionManager);
        return this.utilities().readFromFile(currFile, literalImportHandler);
    }

    @Override
    public Map<String, ProcedureSyntax> findProcedurePositions(String source) {
        return this.frontEnd().findProcedurePositions(source, (Option<Dialect>)Some$.MODULE$.apply((Object)this.dialect));
    }

    @Override
    public Option<Map<String, String>> findIncludes(String sourceFileName, String source, CompilationEnvironment compilationEnvironment) throws CompilerException {
        Seq<String> includes = this.frontEnd().findIncludes(source);
        if (includes.isEmpty()) {
            if (!FrontEndInterface$.MODULE$.hasIncludes(source)) {
                return None$.MODULE$;
            }
            return this.parserTokenizer().tokenizeString(source, this.parserTokenizer().tokenizeString$default$2()).find((Function1 & Serializable)t -> t.text().equalsIgnoreCase("__includes")).map((Function1 & Serializable)_$2 -> Predef$.MODULE$.Map().empty());
        }
        return Some$.MODULE$.apply((Object)((IterableOnceOps)includes.zip((IterableOnce)includes.map((Function1 & Serializable)path -> compilationEnvironment.resolvePath((String)path)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    @Override
    public boolean isValidIdentifier(String s, ExtensionManager extensionManager) {
        Iterator iterator = this.frontEnd().tokenizeForColorizationIterator(s, this.defaultDialect(), extensionManager).takeWhile((Function1 & Serializable)_$3 -> {
            TokenType tokenType = _$3.tpe();
            TokenType$Eof$ tokenType$Eof$ = TokenType$Eof$.MODULE$;
            return tokenType == null ? tokenType$Eof$ != null : !tokenType.equals(tokenType$Eof$);
        });
        return iterator.filter((Function1 & Serializable)_$4 -> {
            TokenType tokenType = _$4.tpe();
            TokenType$Ident$ tokenType$Ident$ = TokenType$Ident$.MODULE$;
            return !(tokenType != null ? !tokenType.equals(tokenType$Ident$) : tokenType$Ident$ != null);
        }).size() == 1;
    }

    @Override
    public boolean isReporter(String s, Program program, ListMap<String, Procedure> procedures, ExtensionManager extensionManager, CompilationEnvironment compilationEnv) {
        ListMap proceduresListMap = (ListMap)ListMap$.MODULE$.apply(procedures.toSeq());
        return this.utilities().isReporter(s, program, (ListMap<String, FrontEndProcedure>)proceduresListMap, extensionManager);
    }

    @Override
    public Token getTokenAtPosition(String source, int position) {
        return (Token)this.parserTokenizer().getTokenAtPosition(source, position).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public Token[] tokenizeForColorization(String source, ExtensionManager extensionManager) {
        return (Token[])this.frontEnd().tokenizeForColorization(source, this.defaultDialect(), extensionManager).toArray(ClassTag$.MODULE$.apply(Token.class));
    }

    @Override
    public Iterator<Token> tokenizeForColorizationIterator(String source, ExtensionManager extensionManager) {
        return this.frontEnd().tokenizeForColorizationIterator(source, this.defaultDialect(), extensionManager);
    }

    @Override
    public Iterator<Token> tokenizeWithWhitespace(String source, ExtensionManager extensionManager) {
        return this.frontEnd().tokenizeWithWhitespace(source, this.defaultDialect(), extensionManager);
    }
}

