/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.compile.middle;

import java.io.Serializable;
import org.nlogo.compile.api.Backifier;
import org.nlogo.compile.api.ProcedureDefinition;
import org.nlogo.compile.api.Statements;
import org.nlogo.core.CommandBlock;
import org.nlogo.core.Expression;
import org.nlogo.core.ReporterApp;
import org.nlogo.core.ReporterBlock;
import org.nlogo.core.Statement;
import org.nlogo.nvm.Procedure;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.Seq;

public class ASTBackifier {
    private final Backifier backifier;
    private final ListMap<String, Procedure> procedures;

    public ASTBackifier(Backifier backifier, ListMap<String, Procedure> procedures) {
        this.backifier = backifier;
        this.procedures = procedures;
    }

    public ProcedureDefinition backify(Procedure proc, org.nlogo.core.ProcedureDefinition pd) {
        return new ProcedureDefinition(proc, this.backify(pd.statements()));
    }

    public org.nlogo.compile.api.Expression backify(Expression expr) {
        Expression expression = expr;
        if (expression instanceof CommandBlock) {
            CommandBlock cb = (CommandBlock)expression;
            return this.backify(cb);
        }
        if (expression instanceof ReporterBlock) {
            ReporterBlock rb = (ReporterBlock)expression;
            return this.backify(rb);
        }
        if (expression instanceof ReporterApp) {
            ReporterApp ra = (ReporterApp)expression;
            return this.backify(ra);
        }
        throw new IllegalStateException();
    }

    public Statements backify(org.nlogo.core.Statements stmts) {
        return new Statements((Seq<org.nlogo.compile.api.Statement>)((Seq)stmts.stmts().map((Function1 & Serializable)stmt -> this.backify((Statement)stmt))), stmts.sourceLocation());
    }

    public org.nlogo.compile.api.Statement backify(Statement stmt) {
        return new org.nlogo.compile.api.Statement(stmt.command(), this.backifier.apply(this.procedures, stmt.command()), (Seq<org.nlogo.compile.api.Expression>)((Seq)stmt.args().map((Function1 & Serializable)expr -> this.backify((Expression)expr))), stmt.sourceLocation());
    }

    public org.nlogo.compile.api.CommandBlock backify(CommandBlock cb) {
        return new org.nlogo.compile.api.CommandBlock(this.backify(cb.statements()), cb.sourceLocation());
    }

    public org.nlogo.compile.api.ReporterBlock backify(ReporterBlock rb) {
        return new org.nlogo.compile.api.ReporterBlock(this.backify(rb.app()), rb.sourceLocation());
    }

    public org.nlogo.compile.api.ReporterApp backify(ReporterApp ra) {
        org.nlogo.compile.api.ReporterApp result = new org.nlogo.compile.api.ReporterApp(ra.reporter(), this.backifier.apply(this.procedures, ra.reporter()), ra.sourceLocation());
        ((IterableOnceOps)ra.args().map((Function1 & Serializable)expr -> this.backify((Expression)expr))).foreach(arg -> result.addArgument((org.nlogo.compile.api.Expression)arg));
        return result;
    }
}

