/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.compile.middle;

import java.io.Serializable;
import org.nlogo.compile.api.CommandBlock;
import org.nlogo.compile.api.DefaultAstVisitor;
import org.nlogo.compile.api.ProcedureDefinition;
import org.nlogo.compile.api.ReporterApp;
import org.nlogo.compile.api.ReporterBlock;
import org.nlogo.compile.api.Statement;
import org.nlogo.core.CompilationEnvironment;
import org.nlogo.core.Syntax;
import org.nlogo.nvm.AnonymousProcedure$;
import org.nlogo.nvm.Instruction;
import org.nlogo.nvm.LiftedLambda;
import org.nlogo.nvm.Procedure;
import org.nlogo.nvm.Reporter;
import org.nlogo.prim._commandlambda;
import org.nlogo.prim._reporterlambda;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

public class SourceTagger
extends DefaultAstVisitor {
    private final CompilationEnvironment compilationEnvironment;
    private Map<String, String> sources;
    private Seq<String> internalSources;

    public SourceTagger(Map<String, String> existingSources, CompilationEnvironment compilationEnvironment) {
        this.compilationEnvironment = compilationEnvironment;
        this.sources = (Map)Predef$.MODULE$.Map().apply(existingSources.toSeq());
        this.internalSources = (Seq)((SeqOps)Nil$.MODULE$);
    }

    public Map<String, String> sources() {
        return this.sources;
    }

    public void sources_$eq(Map<String, String> x$1) {
        this.sources = x$1;
    }

    public Seq<String> internalSources() {
        return this.internalSources;
    }

    public void internalSources_$eq(Seq<String> x$1) {
        this.internalSources = x$1;
    }

    @Override
    public void visitProcedureDefinition(ProcedureDefinition proc) {
        String string;
        Procedure procedure;
        super.visitProcedureDefinition(proc);
        Procedure procedure2 = procedure = proc.procedure();
        if (procedure instanceof LiftedLambda) {
            LiftedLambda ll = (LiftedLambda)procedure;
            string = AnonymousProcedure$.MODULE$.displayString("command", ll.source());
        } else {
            Procedure p = procedure;
            string = (String)p.baseDisplayName().getOrElse(() -> this.visitProcedureDefinition$$anonfun$1(p));
        }
        procedure2.displayName_$eq(string);
    }

    private Seq<String> captureInternalSources(Function0<BoxedUnit> f) {
        Seq<String> tmpSources = this.internalSources();
        this.internalSources_$eq((Seq<String>)((Seq)((SeqOps)Nil$.MODULE$)));
        f.apply$mcV$sp();
        Seq<String> resultingSources = this.internalSources();
        this.internalSources_$eq(tmpSources);
        return resultingSources;
    }

    @Override
    public void visitStatement(Statement stmt) {
        Seq<String> argSources = this.captureInternalSources((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> super.visitStatement(stmt));
        this.addInstructionPositions(stmt.command(), stmt.command().token().start(), stmt.command().token().end());
        this.instructionsOwnSource(stmt.command(), stmt.command().token().start(), stmt.command().token().end()).foreach(src -> {
            String fullSource = this.applicationSource((String)src, argSources, stmt.coreInstruction().syntax());
            this.internalSources_$eq((Seq<String>)((Seq)this.internalSources().$colon$plus((Object)fullSource)));
            stmt.command().source_$eq((String)src);
            stmt.command().fullSource_$eq(fullSource);
        });
    }

    @Override
    public void visitReporterApp(ReporterApp app) {
        Tuple2 tuple2;
        Tuple3 tuple3;
        Tuple3 tuple32;
        Seq<String> capturedSources = this.captureInternalSources((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> super.visitReporterApp(app));
        Reporter reporter = app.reporter();
        if (reporter instanceof _reporterlambda) {
            _reporterlambda ct = (_reporterlambda)reporter;
            tuple32 = Tuple3$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)app.start()), (Object)BoxesRunTime.boxToInteger((int)app.end())), (Object)"", (Object)((SeqOps)Nil$.MODULE$));
        } else if (reporter instanceof _commandlambda) {
            _commandlambda cl = (_commandlambda)reporter;
            tuple32 = Tuple3$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)cl.proc().pos()), (Object)BoxesRunTime.boxToInteger((int)cl.proc().end())), (Object)"", (Object)((SeqOps)Nil$.MODULE$));
        } else {
            Tuple2 positions = (Tuple2)Option$.MODULE$.apply((Object)app.reporter().token()).map((Function1 & Serializable)token -> Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)token.start()), (Object)BoxesRunTime.boxToInteger((int)token.end()))).getOrElse(() -> SourceTagger.$anonfun$4(app));
            tuple32 = tuple3 = Tuple3$.MODULE$.apply((Object)positions, (Object)"", capturedSources);
        }
        if (tuple3 == null || (tuple2 = (Tuple2)tuple3._1()) == null) {
            throw new MatchError((Object)tuple3);
        }
        int start = tuple2._1$mcI$sp();
        int end = tuple2._2$mcI$sp();
        String prefix = (String)tuple3._2();
        Seq argSources = (Seq)tuple3._3();
        Tuple4 tuple4 = Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)start), (Object)BoxesRunTime.boxToInteger((int)end), (Object)prefix, (Object)argSources);
        int start2 = BoxesRunTime.unboxToInt((Object)tuple4._1());
        int end2 = BoxesRunTime.unboxToInt((Object)tuple4._2());
        String prefix2 = (String)tuple4._3();
        Seq argSources2 = (Seq)tuple4._4();
        this.addInstructionPositions(app.reporter(), start2, end2);
        this.instructionsOwnSource(app.reporter(), start2, end2).foreach(src -> {
            String fullSource = prefix2 + this.applicationSource((String)src, (Seq<String>)argSources2, app.coreInstruction().syntax());
            this.internalSources_$eq((Seq<String>)((Seq)this.internalSources().$colon$plus((Object)fullSource)));
            app.reporter().source_$eq((String)src);
            app.reporter().fullSource_$eq(fullSource);
        });
    }

    @Override
    public void visitCommandBlock(CommandBlock blk) {
        super.visitCommandBlock(blk);
        this.internalSources_$eq((Seq<String>)((Seq)((SeqOps)this.internalSources().dropRight(1)).$colon$plus((Object)("[ " + this.internalSources().lastOption().getOrElse(SourceTagger::visitCommandBlock$$anonfun$1) + " ]"))));
    }

    @Override
    public void visitReporterBlock(ReporterBlock blk) {
        super.visitReporterBlock(blk);
        this.internalSources_$eq((Seq<String>)((Seq)((SeqOps)this.internalSources().dropRight(1)).$colon$plus((Object)("[ " + this.internalSources().lastOption().getOrElse(SourceTagger::visitReporterBlock$$anonfun$1) + " ]"))));
    }

    private void addInstructionPositions(Instruction i, int start, int end) {
        i.storedSourceStartPosition_$eq(start);
        i.storedSourceEndPosition_$eq(end);
    }

    private Option<String> instructionsOwnSource(Instruction i, int start, int end) {
        boolean validStartAndEnd;
        String filename = i.getFilename();
        boolean bl = validStartAndEnd = start > 0 || start < end;
        if (validStartAndEnd) {
            if (filename != null && !this.sources().isDefinedAt((Object)filename)) {
                Try$.MODULE$.apply(() -> this.instructionsOwnSource$$anonfun$1(filename)).foreach(newSource -> {
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)filename);
                    this.sources_$eq((Map<String, String>)((Map)this.sources().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, newSource))));
                });
            }
            Map<String, String> map = this.sources();
            return Option$.MODULE$.apply((Object)filename).flatMap((Function1 & Serializable)key -> map.get(key)).flatMap((Function1 & Serializable)source -> {
                if (end < source.length()) {
                    return Some$.MODULE$.apply((Object)source.substring(start, end));
                }
                return None$.MODULE$;
            });
        }
        return None$.MODULE$;
    }

    private String applicationSource(String src, Seq<String> argSources, Syntax syntax) {
        Seq syntaxComponents;
        Seq seq;
        if (syntax.isInfix()) {
            String string = (String)argSources.head();
            seq = (Seq)((SeqOps)((SeqOps)argSources.tail()).$plus$colon((Object)src)).$plus$colon((Object)string);
        } else {
            seq = syntaxComponents = (Seq)argSources.$plus$colon((Object)src);
        }
        if (syntax.isVariadic() && argSources.length() != syntax.dfault()) {
            return syntaxComponents.mkString("(", " ", ")");
        }
        return syntaxComponents.mkString(" ");
    }

    private String procedureDisplayName(Procedure p) {
        String nameAndFile = (String)Option$.MODULE$.apply((Object)p.filename()).filter((Function1 & Serializable)_$1 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$1))).map((Function1 & Serializable)filename -> p.name() + " (" + filename + ")").getOrElse(() -> SourceTagger.$anonfun$7(p));
        return "procedure " + nameAndFile;
    }

    private final String visitProcedureDefinition$$anonfun$1(Procedure p$1) {
        return this.procedureDisplayName(p$1);
    }

    private static final Tuple2 $anonfun$4(ReporterApp app$2) {
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)app$2.start()), (Object)BoxesRunTime.boxToInteger((int)app$2.end()));
    }

    private static final String visitCommandBlock$$anonfun$1() {
        return "";
    }

    private static final String visitReporterBlock$$anonfun$1() {
        return "";
    }

    private final String instructionsOwnSource$$anonfun$1(String filename$1) {
        return this.compilationEnvironment.getSource(filename$1);
    }

    private static final String $anonfun$7(Procedure p$3) {
        return p$3.name();
    }
}

