/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.text.TextAction;
import org.nlogo.editor.AbstractEditorArea;
import org.nlogo.editor.Actions$;
import org.nlogo.editor.BracketMatcher;
import org.nlogo.editor.Colorizer;
import org.nlogo.editor.DoubleClickCaret;
import org.nlogo.editor.EditorArea$;
import org.nlogo.editor.EditorAwareAction;
import org.nlogo.editor.EditorConfiguration;
import org.nlogo.editor.FocusTraversable;
import org.nlogo.editor.Indenter;
import org.nlogo.editor.KeyBinding$;
import org.nlogo.editor.MouseQuickHelpAction;
import org.nlogo.editor.SuspendCaretPopupListener;
import org.nlogo.editor.UndoManager;
import org.nlogo.swing.MenuItem;
import org.nlogo.swing.MenuItem$;
import org.nlogo.swing.PopupMenu;
import org.nlogo.swing.PopupMenu$;
import org.nlogo.swing.UserAction;
import org.nlogo.theme.InterfaceColors$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public class EditorArea
extends JEditorPane
implements AbstractEditorArea,
FocusTraversable,
FocusListener {
    private final EditorConfiguration configuration;
    private final int rows;
    private final int columns;
    private final Colorizer colorizer;
    private Option<Indenter> indenter;
    private final PopupMenu contextMenu;
    private final BracketMatcher bracketMatcher;
    private final UndoManager undoManager;
    private final DoubleClickCaret caret;
    public final Color org$nlogo$editor$EditorArea$$defaultSelectionColor;
    private boolean bracketMatcherEnabled;
    private boolean _selectionActive;
    public int org$nlogo$editor$EditorArea$$mousePos;

    public static Dimension defaultSize() {
        return EditorArea$.MODULE$.defaultSize();
    }

    public EditorArea(EditorConfiguration configuration) {
        this.configuration = configuration;
        this.rows = configuration.rows();
        this.columns = configuration.columns();
        this.colorizer = configuration.colorizer();
        this.indenter = None$.MODULE$;
        this.contextMenu = new EditorContextMenu(this.colorizer());
        this.contextMenu.addPopupMenuListener(new SuspendCaretPopupListener(this));
        this.bracketMatcher = new BracketMatcher(this.colorizer());
        this.undoManager = new UndoManager();
        this.caret = new DoubleClickCaret(this.colorizer(), this.bracketMatcher);
        this.org$nlogo$editor$EditorArea$$defaultSelectionColor = this.getSelectionColor();
        this.enableEvents(16L);
        this.addFocusListener(this);
        this.addCaretListener(this.bracketMatcher);
        int blinkRate = this.getCaret().getBlinkRate();
        this.caret.setBlinkRate(blinkRate);
        this.setCaret(this.caret);
        this.setDragEnabled(false);
        this.undoManager.watch(this);
        int mask = GraphicsEnvironment.isHeadless() ? 0 : this.getToolkit().getMenuShortcutKeyMaskEx();
        this.getKeymap().addActionForKeyStroke(KeyBinding$.MODULE$.keystroke(90, mask), UndoManager.undoAction());
        this.getKeymap().addActionForKeyStroke(KeyBinding$.MODULE$.keystroke(89, mask), UndoManager.redoAction());
        configuration.configureEditorArea(this);
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        this.bracketMatcherEnabled = true;
        this._selectionActive = true;
        this.addMouseListener(new MouseAdapter(this){
            private final /* synthetic */ EditorArea $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void mousePressed(MouseEvent e) {
                this.$outer.setSelectionColor(this.$outer.org$nlogo$editor$EditorArea$$defaultSelectionColor);
            }
        });
        this.addKeyListener(new KeyAdapter(this){
            private final /* synthetic */ EditorArea $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void keyPressed(KeyEvent e) {
                this.$outer.setSelectionColor(this.$outer.org$nlogo$editor$EditorArea$$defaultSelectionColor);
            }
        });
        this.org$nlogo$editor$EditorArea$$mousePos = 0;
    }

    @Override
    public EditorConfiguration configuration() {
        return this.configuration;
    }

    public int rows() {
        return this.rows;
    }

    public int columns() {
        return this.columns;
    }

    public Colorizer colorizer() {
        return this.colorizer;
    }

    @Override
    public void enableBracketMatcher(boolean enabled) {
        if (this.bracketMatcherEnabled != enabled) {
            if (enabled) {
                this.addCaretListener(this.bracketMatcher);
            } else {
                this.removeCaretListener(this.bracketMatcher);
            }
            this.bracketMatcherEnabled = enabled;
            return;
        }
    }

    @Override
    public void setIndenter(Indenter newIndenter) {
        this.indenter = Some$.MODULE$.apply((Object)newIndenter);
        newIndenter.addActions(this.configuration(), this.getInputMap());
    }

    @Override
    public Action[] getActions() {
        Action[] extraActions = (Action[])((IterableOnceOps)this.configuration().editorOnlyActions().$colon$plus((Object)new MouseQuickHelpAction(this.colorizer()))).toArray(ClassTag$.MODULE$.apply(Action.class));
        return TextAction.augmentList(super.getActions(), extraActions);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimension = (Dimension)Option$.MODULE$.apply((Object)super.getPreferredScrollableViewportSize()).getOrElse(EditorArea::$anonfun$1);
        dimension.width = this.columns() != 0 ? this.columns() * this.getColumnWidth() : dimension.width;
        dimension.height = this.rows() != 0 ? this.rows() * this.getRowHeight() : dimension.height;
        return dimension;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = (Dimension)Option$.MODULE$.apply((Object)super.getPreferredSize()).getOrElse(EditorArea::$anonfun$2);
        if (this.columns() != 0) {
            dimension.width = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(dimension.width), this.columns() * this.getColumnWidth());
        }
        if (this.rows() != 0) {
            dimension.height = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(dimension.height), this.rows() * this.getRowHeight());
        }
        return dimension;
    }

    private int getColumnWidth() {
        return this.getFontMetrics(this.getFont()).charWidth('m');
    }

    private int getRowHeight() {
        return this.getFontMetrics(this.getFont()).getHeight();
    }

    @Override
    public void resetUndoHistory() {
        this.undoManager.discardAllEdits();
    }

    public String getLineText(int offset) throws BadLocationException {
        PlainDocument doc = (PlainDocument)this.getDocument();
        int currentLine = this.offsetToLine(doc, offset);
        int lineStart = this.lineToStartOffset(doc, currentLine);
        int lineEnd = this.lineToEndOffset(doc, currentLine);
        return doc.getText(lineStart, lineEnd - lineStart);
    }

    public void indentSelection() {
        this.indenter.foreach(_$1 -> _$1.handleTab());
    }

    public int lineToStartOffset(Document doc, int line) {
        return doc.getDefaultRootElement().getElement(line).getStartOffset();
    }

    public int lineToEndOffset(Document doc, int line) {
        return doc.getDefaultRootElement().getElement(line).getEndOffset();
    }

    public int offsetToLine(Document doc, int offset) {
        return doc.getDefaultRootElement().getElementIndex(offset);
    }

    @Override
    public boolean selectionActive() {
        return this._selectionActive;
    }

    @Override
    public void setSelection(boolean s) {
        this._selectionActive = s;
    }

    @Override
    public void selectNormal() {
        this.setSelectionColor(this.org$nlogo$editor$EditorArea$$defaultSelectionColor);
        this.select(this.getSelectionStart(), this.getSelectionEnd());
    }

    @Override
    public void selectError(int start, int end) {
        this.setSelectionColor(InterfaceColors$.MODULE$.errorHighlight());
        this.select(start, end);
    }

    @Override
    public void focusGained(FocusEvent fe) {
    }

    @Override
    public void focusLost(FocusEvent fe) {
        this.bracketMatcher.focusLost(this);
        this.colorizer().reset();
    }

    public int getMousePos() {
        return this.org$nlogo$editor$EditorArea$$mousePos;
    }

    @Override
    public void processMouseEvent(MouseEvent me) {
        if (me.isPopupTrigger() && !this.contextMenu.isShowing()) {
            this.org$nlogo$editor$EditorArea$$mousePos = this.caret.getMousePosition(me);
            this.doPopup(me);
            return;
        }
        super.processMouseEvent(me);
    }

    private void doPopup(MouseEvent e) {
        this.contextMenu.show(this, e.getX(), e.getY());
    }

    @Override
    public void replaceSelection(String s) {
        if (s == null) {
            super.replaceSelection(s);
            return;
        }
        ObjectRef selection = ObjectRef.create((Object)s);
        if (s.length() > 0 && Character.getType(s.charAt(0)) == 16) {
            selection.elem = StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString((String)selection.elem), 1);
        }
        selection.elem = ((String)selection.elem).replace("\t", "  ");
        super.replaceSelection((String)selection.elem);
        this.indenter.foreach(_$4 -> _$4.handleInsertion((String)selection$1.elem));
    }

    @Override
    public String getText(int start, int end) {
        String string;
        try {
            string = this.getDocument().getText(start, end);
        }
        catch (BadLocationException ex) {
            throw new IllegalStateException(ex);
        }
        return string;
    }

    public Option<String> getHelpTarget(int startition) {
        Option<String> option;
        PlainDocument doc = (PlainDocument)this.getDocument();
        try {
            int currentLine = this.offsetToLine(doc, startition);
            int startLineOffset = this.lineToStartOffset(doc, currentLine);
            int lineLength = this.lineToEndOffset(doc, currentLine) - startLineOffset;
            String lineText = doc.getText(startLineOffset, lineLength);
            int selStartInString = startition - startLineOffset;
            option = this.colorizer().getTokenAtPosition(lineText, selStartInString);
        }
        catch (BadLocationException ex) {
            throw new IllegalStateException(ex);
        }
        return option;
    }

    @Override
    public UserAction.MenuAction undoAction() {
        return UndoManager.undoAction();
    }

    @Override
    public UserAction.MenuAction redoAction() {
        return UndoManager.redoAction();
    }

    private static final Dimension $anonfun$1() {
        return EditorArea$.MODULE$.defaultSize();
    }

    private static final Dimension $anonfun$2() {
        return EditorArea$.MODULE$.defaultSize();
    }

    public static final /* synthetic */ MenuItem org$nlogo$editor$EditorArea$EditorContextMenu$$_$$lessinit$greater$$anonfun$1(UserAction.MenuAction _$2) {
        return new MenuItem((Action)((Object)_$2), MenuItem$.MODULE$.$lessinit$greater$default$2());
    }

    public static final /* synthetic */ boolean org$nlogo$editor$EditorArea$EditorContextMenu$$_$_$$anonfun$3(String _$3) {
        return _$3.length() > 0;
    }

    public class EditorContextMenu
    extends PopupMenu {
        private final MenuItem copyItem;
        private final MenuItem cutItem;
        private final MenuItem pasteItem;
        private final Seq<MenuItem> contextItems;

        public EditorContextMenu(Colorizer colorizer) {
            if (EditorArea.this == null) {
                throw new NullPointerException();
            }
            super(PopupMenu$.MODULE$.$lessinit$greater$default$1());
            this.copyItem = new MenuItem(Actions$.MODULE$.CopyAction(), MenuItem$.MODULE$.$lessinit$greater$default$2());
            this.cutItem = new MenuItem(Actions$.MODULE$.CutAction(), MenuItem$.MODULE$.$lessinit$greater$default$2());
            this.pasteItem = new MenuItem(Actions$.MODULE$.PasteAction(), MenuItem$.MODULE$.$lessinit$greater$default$2());
            this.contextItems = (Seq)EditorArea.this.configuration().contextActions().map(EditorArea::org$nlogo$editor$EditorArea$EditorContextMenu$$_$$lessinit$greater$$anonfun$1);
            this.add(this.copyItem());
            this.add(this.cutItem());
            this.add(this.pasteItem());
            this.addSeparator();
            this.contextItems().foreach((Function1 & Serializable)x$0 -> this.add((JMenuItem)x$0));
        }

        public MenuItem copyItem() {
            return this.copyItem;
        }

        public MenuItem cutItem() {
            return this.cutItem;
        }

        public MenuItem pasteItem() {
            return this.pasteItem;
        }

        public Seq<MenuItem> contextItems() {
            return this.contextItems;
        }

        @Override
        public void show(Component invoker, int x, int y) {
            String text = EditorArea.this.getSelectedText();
            boolean isTextSelected = Option$.MODULE$.apply((Object)text).exists(EditorArea::org$nlogo$editor$EditorArea$EditorContextMenu$$_$_$$anonfun$3);
            Point point = new Point(invoker.getLocationOnScreen());
            this.copyItem().setEnabled(isTextSelected);
            this.cutItem().setEnabled(isTextSelected);
            this.pasteItem().setEnabled(Toolkit.getDefaultToolkit().getSystemClipboard().isDataFlavorAvailable(DataFlavor.stringFlavor));
            point.translate(x, y);
            EditorArea.this.configuration().contextActions().foreach(x$1 -> {
                UserAction.MenuAction menuAction = x$1;
                if (menuAction instanceof EditorAwareAction) {
                    EditorAwareAction e = (EditorAwareAction)((Object)menuAction);
                    e.updateEditorInfo(EditorArea.this, point, EditorArea.this.org$nlogo$editor$EditorArea$$mousePos);
                    return;
                }
            });
            this.syncTheme();
            super.show(invoker, x, y);
        }

        public final /* synthetic */ EditorArea org$nlogo$editor$EditorArea$EditorContextMenu$$$outer() {
            return EditorArea.this;
        }
    }
}

