/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.editor;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.nlogo.editor.AbstractEditorArea;
import org.nlogo.editor.InstallableAction;
import scala.runtime.BoxesRunTime;

public interface EditorAwareAction
extends InstallableAction,
MouseListener {
    public static void $init$(EditorAwareAction $this) {
        $this.org$nlogo$editor$EditorAwareAction$_setter_$EditorKey_$eq("Editor");
        $this.org$nlogo$editor$EditorAwareAction$_setter_$LocationKey_$eq("MouseLocation");
        $this.org$nlogo$editor$EditorAwareAction$_setter_$DocumentOffsetKey_$eq("DocumentOffset");
    }

    public String EditorKey();

    public void org$nlogo$editor$EditorAwareAction$_setter_$EditorKey_$eq(String var1);

    public String LocationKey();

    public void org$nlogo$editor$EditorAwareAction$_setter_$LocationKey_$eq(String var1);

    public String DocumentOffsetKey();

    public void org$nlogo$editor$EditorAwareAction$_setter_$DocumentOffsetKey_$eq(String var1);

    public static void updateEditorInfo$(EditorAwareAction $this, AbstractEditorArea editor, Point mouseLocation, int documentOffset) {
        $this.updateEditorInfo(editor, mouseLocation, documentOffset);
    }

    default public void updateEditorInfo(AbstractEditorArea editor, Point mouseLocation, int documentOffset) {
        this.putValue(this.EditorKey(), editor);
        this.putValue(this.LocationKey(), mouseLocation);
        this.putValue(this.DocumentOffsetKey(), BoxesRunTime.boxToInteger((int)documentOffset));
    }

    public static void install$(EditorAwareAction $this, AbstractEditorArea editorArea) {
        $this.install(editorArea);
    }

    @Override
    default public void install(AbstractEditorArea editorArea) {
        this.putValue(this.EditorKey(), editorArea);
        ((Component)((Object)editorArea)).addMouseListener(this);
    }

    public static AbstractEditorArea editor$(EditorAwareAction $this) {
        return $this.editor();
    }

    default public AbstractEditorArea editor() {
        return (AbstractEditorArea)this.getValue(this.EditorKey());
    }

    public static Point location$(EditorAwareAction $this) {
        return $this.location();
    }

    default public Point location() {
        return (Point)this.getValue(this.LocationKey());
    }

    public static int documentOffset$(EditorAwareAction $this) {
        return $this.documentOffset();
    }

    default public int documentOffset() {
        return (Integer)this.getValue(this.DocumentOffsetKey());
    }

    public static void mouseClicked$(EditorAwareAction $this, MouseEvent me) {
        $this.mouseClicked(me);
    }

    @Override
    default public void mouseClicked(MouseEvent me) {
    }

    public static void mouseEntered$(EditorAwareAction $this, MouseEvent me) {
        $this.mouseEntered(me);
    }

    @Override
    default public void mouseEntered(MouseEvent me) {
    }

    public static void mouseExited$(EditorAwareAction $this, MouseEvent me) {
        $this.mouseExited(me);
    }

    @Override
    default public void mouseExited(MouseEvent me) {
    }

    public static void mousePressed$(EditorAwareAction $this, MouseEvent me) {
        $this.mousePressed(me);
    }

    @Override
    default public void mousePressed(MouseEvent me) {
        if (me.isPopupTrigger()) {
            this.updateMouseValues(me);
            return;
        }
    }

    public static void mouseReleased$(EditorAwareAction $this, MouseEvent me) {
        $this.mouseReleased(me);
    }

    @Override
    default public void mouseReleased(MouseEvent me) {
        if (me.isPopupTrigger()) {
            this.updateMouseValues(me);
            return;
        }
    }

    private void updateMouseValues(MouseEvent me) {
        int n;
        Point mouseLocation = me.getComponent().getLocationOnScreen();
        mouseLocation.translate(me.getX(), me.getY());
        Position.Bias[] returnBias = new Position.Bias[1];
        Object object = me.getSource();
        if (object instanceof JTextComponent) {
            JTextComponent tc = (JTextComponent)object;
            n = tc.getUI().viewToModel2D(tc, me.getPoint(), returnBias);
        } else {
            n = ((JTextComponent)((Object)this.editor())).getSelectionEnd();
        }
        int docOffset = n;
        this.putValue(this.LocationKey(), mouseLocation);
        this.putValue(this.DocumentOffsetKey(), BoxesRunTime.boxToInteger((int)docOffset));
    }
}

