/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.editor;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import scala.Predef$;
import scala.runtime.BoxedUnit;

public class LinePainter
implements Highlighter.HighlightPainter,
CaretListener {
    private final JTextComponent component;
    private Rectangle2D lastView;
    private final Color color;

    public LinePainter(JTextComponent component) {
        Object object;
        this.component = component;
        this.lastView = new Rectangle(0, 0, 0, 0);
        this.color = new Color(255, 249, 228, 100);
        component.addCaretListener(this);
        try {
            object = component.getHighlighter().addHighlight(0, 0, this);
        }
        catch (BadLocationException ble) {
            object = BoxedUnit.UNIT;
        }
    }

    @Override
    public void paint(Graphics g, int p0, int p1, Shape bounds, JTextComponent c) {
        try {
            Rectangle2D r = c.modelToView2D(c.getCaretPosition());
            g.setColor(this.color);
            g.fillRect(0, (int)r.getY(), c.getWidth(), (int)r.getHeight());
            if (this.lastView == null) {
                this.lastView = r;
            }
        }
        catch (BadLocationException ble) {
            Predef$.MODULE$.println((Object)ble);
        }
    }

    private void resetHighlight() {
        try {
            int offset = this.component.getCaretPosition();
            Rectangle2D currentView = this.component.modelToView2D(offset);
            if (currentView != null && this.lastView.getY() != currentView.getY()) {
                this.component.repaint(0, (int)this.lastView.getY(), this.component.getWidth(), (int)this.lastView.getHeight());
                this.lastView = currentView;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.resetHighlight();
    }
}

