/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.fileformat;

import java.io.Serializable;
import org.nlogo.api.AutoConvertable;
import org.nlogo.api.AutoConverter;
import org.nlogo.core.Button;
import org.nlogo.core.Model;
import org.nlogo.core.Monitor;
import org.nlogo.core.Plot;
import org.nlogo.core.Slider;
import org.nlogo.core.Widget;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public interface WidgetConverter
extends AutoConvertable {
    public static String componentDescription$(WidgetConverter $this) {
        return $this.componentDescription();
    }

    @Override
    default public String componentDescription() {
        return "NetLogo interface";
    }

    public static boolean requiresAutoConversion$(WidgetConverter $this, Model original, Function1 needsConversion) {
        return $this.requiresAutoConversion(original, (Function1<String, Object>)needsConversion);
    }

    @Override
    default public boolean requiresAutoConversion(Model original, Function1<String, Object> needsConversion) {
        return original.widgets().exists((Function1 & Serializable)w -> this.widgetNeedsConversion(needsConversion, (Widget)w));
    }

    public static Either autoConvert$(WidgetConverter $this, Model original, AutoConverter autoConverter) {
        return $this.autoConvert(original, autoConverter);
    }

    @Override
    default public Either<Tuple2<Model, Seq<Exception>>, Model> autoConvert(Model original, AutoConverter autoConverter) {
        Tuple2 tuple2 = (Tuple2)original.widgets().foldLeft((Object)Tuple2$.MODULE$.apply((Object)package$.MODULE$.Seq().empty(), (Object)package$.MODULE$.Seq().empty()), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                Seq ws = (Seq)tuple2._1();
                Seq es = (Seq)tuple2._2();
                Widget w = (Widget)tuple22._2();
                Try<Widget> try_ = this.convertWidget(autoConverter, w);
                if (try_ instanceof Failure) {
                    Throwable throwable = ((Failure)try_).exception();
                    if (throwable instanceof Exception) {
                        Exception e = (Exception)throwable;
                        return Tuple2$.MODULE$.apply(ws.$colon$plus((Object)w), es.$colon$plus((Object)e));
                    }
                    Throwable t = throwable;
                    throw t;
                }
                if (try_ instanceof Success) {
                    Widget w2 = (Widget)((Success)try_).value();
                    return Tuple2$.MODULE$.apply(ws.$colon$plus((Object)w2), (Object)es);
                }
                throw new MatchError(try_);
            }
            throw new MatchError((Object)tuple22);
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq widgets = (Seq)tuple2._1();
        Seq errors = (Seq)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)widgets, (Object)errors);
        Seq widgets2 = (Seq)tuple22._1();
        Seq errors2 = (Seq)tuple22._2();
        if (errors2.isEmpty()) {
            return package$.MODULE$.Right().apply((Object)original.copy(original.copy$default$1(), (Seq<Widget>)widgets2, original.copy$default$3(), original.copy$default$4(), original.copy$default$5(), original.copy$default$6(), original.copy$default$7(), original.copy$default$8(), original.copy$default$9()));
        }
        return package$.MODULE$.Left().apply((Object)Tuple2$.MODULE$.apply((Object)original.copy(original.copy$default$1(), (Seq<Widget>)widgets2, original.copy$default$3(), original.copy$default$4(), original.copy$default$5(), original.copy$default$6(), original.copy$default$7(), original.copy$default$8(), original.copy$default$9()), (Object)errors2));
    }

    private boolean widgetNeedsConversion(Function1<String, Object> needsConversion, Widget w) {
        Widget widget = w;
        if (widget instanceof Button) {
            Button b = (Button)widget;
            return b.source().exists(needsConversion);
        }
        if (widget instanceof Slider) {
            Slider s = (Slider)widget;
            return ((SeqOps)new .colon.colon((Object)s.min(), (List)new .colon.colon((Object)s.max(), (List)new .colon.colon((Object)s.step(), (List)Nil$.MODULE$)))).exists(needsConversion);
        }
        if (widget instanceof Monitor) {
            Monitor m = (Monitor)widget;
            return m.source().exists(needsConversion);
        }
        if (widget instanceof Plot) {
            Plot p = (Plot)widget;
            return ((IterableOnceOps)((SeqOps)new .colon.colon((Object)p.setupCode(), (List)new .colon.colon((Object)p.updateCode(), (List)Nil$.MODULE$))).$plus$plus((IterableOnce)p.pens().flatMap((Function1 & Serializable)pen -> (SeqOps)new .colon.colon((Object)pen.setupCode(), (List)new .colon.colon((Object)pen.updateCode(), (List)Nil$.MODULE$))))).exists(needsConversion);
        }
        return false;
    }

    private Try<Widget> convertWidget(AutoConverter autoConverter, Widget w) {
        return Try$.MODULE$.apply(() -> WidgetConverter.convertWidget$$anonfun$1(w, autoConverter));
    }

    private static Widget convertWidget$$anonfun$1(Widget w$1, AutoConverter autoConverter$2) {
        Widget widget = w$1;
        if (widget instanceof Button || widget instanceof Plot) {
            Product cWidget = (Product)widget;
            return ((Widget)cWidget).convertSource((Function1<String, String>)(Function1 & Serializable)statement -> autoConverter$2.convertStatement((String)statement));
        }
        if (widget instanceof Monitor || widget instanceof Slider) {
            Product rWidget = (Product)widget;
            return ((Widget)rWidget).convertSource((Function1<String, String>)(Function1 & Serializable)expression -> autoConverter$2.convertReporterExpression((String)expression));
        }
        return w$1;
    }
}

