/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.generate;

import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public abstract class AbstractPeepholeOptimizer
extends MethodVisitor {
    private final MethodVisitor mv;

    public AbstractPeepholeOptimizer(MethodVisitor mv) {
        this.mv = mv;
        super(327680, mv);
    }

    public abstract void restartMatch();

    public void visitJumpInsn(int opcode, Label label) {
        this.restartMatch();
        this.mv.visitJumpInsn(opcode, label);
    }

    public void visitLabel(Label label) {
        this.restartMatch();
        this.mv.visitLabel(label);
    }

    public void visitInsn(int opcode) {
        this.restartMatch();
        this.mv.visitInsn(opcode);
    }

    public void visitIntInsn(int opcode, int operand) {
        this.restartMatch();
        this.mv.visitIntInsn(opcode, operand);
    }

    public void visitVarInsn(int opcode, int variable) {
        this.restartMatch();
        this.mv.visitVarInsn(opcode, variable);
    }

    public void visitTypeInsn(int opcode, String desc) {
        this.restartMatch();
        this.mv.visitTypeInsn(opcode, desc);
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.restartMatch();
        this.mv.visitFieldInsn(opcode, owner, name, desc);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        this.restartMatch();
        this.mv.visitMethodInsn(opcode, owner, name, desc, opcode == 185);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        this.restartMatch();
        this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
    }

    public void visitLdcInsn(Object cst) {
        this.restartMatch();
        this.mv.visitLdcInsn(cst);
    }

    public void visitIincInsn(int variable, int increment) {
        this.restartMatch();
        this.mv.visitIincInsn(variable, increment);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.restartMatch();
        this.mv.visitLookupSwitchInsn(dflt, keys, labels);
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.restartMatch();
        this.mv.visitMultiANewArrayInsn(desc, dims);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String tpe) {
        this.restartMatch();
        this.mv.visitTryCatchBlock(start, end, handler, tpe);
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        this.restartMatch();
        this.mv.visitLocalVariable(name, desc, signature, start, end, index);
    }

    public void visitLineNumber(int line, Label start) {
        this.restartMatch();
        this.mv.visitLineNumber(line, start);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.restartMatch();
        this.mv.visitMaxs(maxStack, maxLocals);
    }

    public void visitEnd() {
        this.restartMatch();
        this.mv.visitEnd();
    }
}

