/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.generate;

import org.nlogo.generate.AbstractPeepholeOptimizer;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class PeepholeOptimizer2
extends AbstractPeepholeOptimizer {
    private final MethodVisitor mv;
    private boolean seenAload0;

    public PeepholeOptimizer2(MethodVisitor mv) {
        this.mv = mv;
        super(mv);
        this.seenAload0 = false;
    }

    @Override
    public void visitLabel(Label label) {
        this.mv.visitLabel(label);
    }

    @Override
    public void restartMatch() {
        if (this.seenAload0) {
            this.mv.visitVarInsn(25, 0);
            this.seenAload0 = false;
            return;
        }
    }

    @Override
    public void visitVarInsn(int opcode, int variable) {
        this.restartMatch();
        if (opcode == 25 && variable == 0) {
            this.seenAload0 = true;
            return;
        }
        this.mv.visitVarInsn(opcode, variable);
    }

    @Override
    public void visitInsn(int opcode) {
        if (this.seenAload0 && opcode == 87) {
            this.seenAload0 = false;
            return;
        }
        super.visitInsn(opcode);
    }
}

