/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.gl.render;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import java.nio.FloatBuffer;
import org.nlogo.api.World3D;
import org.nlogo.gl.render.Direction;
import org.nlogo.gl.render.Light;
import org.nlogo.gl.render.ShapeRenderer;
import scala.Predef$;
import scala.math.package$;

public class DirectionalLight
extends Light {
    private final Direction direction;

    public DirectionalLight(Direction direction) {
        this.direction = direction;
    }

    public Direction direction() {
        return this.direction;
    }

    @Override
    public String typeLabel() {
        return "Directional";
    }

    @Override
    public void applyLight() {
        GL2 gl = this.getGL();
        gl.glEnable(2896);
        if (this.isOn()) {
            gl.glEnable(this.glLightNumber());
            gl.glLightfv(this.glLightNumber(), 4611, FloatBuffer.wrap(this.direction().toFloat4Array()));
            return;
        }
        gl.glDisable(this.glLightNumber());
    }

    @Override
    public final void showLight(GLU glu, World3D world, float worldScale, double observerDistance, ShapeRenderer shapeRenderer) {
        GL2 gl = this.getGL();
        gl.glDisable(2896);
        gl.glPushMatrix();
        Direction normalizedDirection = this.direction().normalized();
        int worldMaxExtent = package$.MODULE$.max(world.maxPxcor(), package$.MODULE$.max(world.maxPycor(), world.maxPzcor()));
        float offset = (float)(-2.0 * (double)worldMaxExtent);
        float lightSourceX = offset * Predef$.MODULE$.Float2float(normalizedDirection.x()) * worldScale;
        float lightSourceY = offset * Predef$.MODULE$.Float2float(normalizedDirection.y()) * worldScale;
        float lightSourceZ = offset * Predef$.MODULE$.Float2float(normalizedDirection.z()) * worldScale;
        gl.glTranslatef(lightSourceX, lightSourceY, lightSourceZ);
        gl.glColor4fv(FloatBuffer.wrap(new float[]{0.98f, 0.98f, 0.82f, 1.0f}));
        this.render3DArrow(glu, Predef$.MODULE$.Float2float(normalizedDirection.x()), Predef$.MODULE$.Float2float(normalizedDirection.y()), Predef$.MODULE$.Float2float(normalizedDirection.z()));
        gl.glPopMatrix();
        this.renderPositionHintLines(Predef$.MODULE$.float2Float(lightSourceX), Predef$.MODULE$.float2Float(lightSourceY), Predef$.MODULE$.float2Float(lightSourceZ), Predef$.MODULE$.float2Float(worldScale * (float)world.minPxcor()), Predef$.MODULE$.float2Float(worldScale * (float)world.minPycor()), Predef$.MODULE$.float2Float(worldScale * (float)world.minPzcor()), Predef$.MODULE$.float2Float(worldScale * (float)world.maxPxcor()), Predef$.MODULE$.float2Float(worldScale * (float)world.maxPycor()), Predef$.MODULE$.float2Float(worldScale * (float)world.maxPzcor()));
        shapeRenderer.renderLabel(this.getGL(), this.getLabel(), Predef$.MODULE$.double2Double(47.0), lightSourceX, lightSourceY, lightSourceZ, 1.0f, 12, world.patchSize());
        gl.glEnable(2896);
    }
}

