/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.gl.render;

import com.jogamp.opengl.GL2;
import java.nio.IntBuffer;
import org.nlogo.api.DrawingInterface;
import org.nlogo.api.World;
import org.nlogo.gl.render.DrawingRendererInterface;
import org.nlogo.gl.render.TextureRenderer;
import org.nlogo.gl.render.TextureUtils$;

public class DrawingRenderer
extends TextureRenderer
implements DrawingRendererInterface {
    private final DrawingInterface drawing;
    private int drawingWidth;
    private int drawingHeight;

    public DrawingRenderer(World world, DrawingInterface drawing) {
        this.drawing = drawing;
        super(world);
        this.drawingWidth = 0;
        this.drawingHeight = 0;
    }

    @Override
    public void init(GL2 gl) {
    }

    @Override
    public void renderDrawing(GL2 gl) {
        this.calculateTextureSize(gl, this.drawing.isBlank());
        this.renderTexture(gl, this.drawing.isBlank());
    }

    private void renderTexture(GL2 gl, boolean blank) {
        int width = this.drawing.getWidth();
        int height = this.drawing.getHeight();
        gl.glEnable(3553);
        gl.glDisable(2896);
        gl.glEnable(3042);
        if (!blank) {
            if (this.newTexture) {
                if (this.texture != 0) {
                    gl.glDeleteTextures(1, IntBuffer.wrap(new int[]{this.texture}));
                }
                this.texture = TextureUtils$.MODULE$.genTexture(gl);
                gl.glBindTexture(3553, this.texture);
                TextureUtils$.MODULE$.makeTexture(gl, this.textureSize);
                this.drawing.markDirty();
                this.newTexture = false;
            } else {
                gl.glBindTexture(3553, this.texture);
            }
            gl.glPushMatrix();
            TextureUtils$.MODULE$.setParameters(gl);
            gl.glBlendFunc(770, 771);
            this.renderTextureTiles(gl, width, height, this.textureSize, this.drawing.colors(), this.drawing.isDirty());
            this.drawing.markClean();
            gl.glPopMatrix();
        }
        gl.glEnable(2896);
        gl.glDisable(3042);
        gl.glBindTexture(3553, 0);
    }

    private void calculateTextureSize(GL2 gl, boolean blank) {
        int newSize = 0;
        if (!blank && (this.drawing.getWidth() != this.drawingWidth || this.drawing.getHeight() != this.drawingHeight) || this.textureSize == 0) {
            newSize = TextureUtils$.MODULE$.calculateTextureSize(gl, this.drawing.getWidth(), this.drawing.getHeight());
            this.newTexture = true;
            this.textureSize = newSize;
            this.tiles = TextureUtils$.MODULE$.createTileArray(this.drawing.getWidth(), this.drawing.getHeight(), this.textureSize);
            this.drawingWidth = this.drawing.getWidth();
            this.drawingHeight = this.drawing.getHeight();
            return;
        }
    }

    @Override
    public void clear() {
        this.deleteTexture();
    }
}

