/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.gl.render;

import com.jogamp.opengl.GL2;
import java.io.Serializable;
import java.nio.IntBuffer;
import org.nlogo.api.AgentFollowingPerspective;
import org.nlogo.api.Color$;
import org.nlogo.api.DrawingInterface;
import org.nlogo.api.Observer;
import org.nlogo.api.ObserverOrientation;
import org.nlogo.api.Patch;
import org.nlogo.api.Patch3D;
import org.nlogo.api.Perspective;
import org.nlogo.api.World;
import org.nlogo.api.WorldRenderable;
import org.nlogo.gl.render.AgentRenderer$;
import org.nlogo.gl.render.ShapeRenderer;
import org.nlogo.gl.render.TextureRenderer;
import org.nlogo.gl.render.TextureUtils$;
import scala.Float$;
import scala.Function1;
import scala.Predef$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public class PatchRenderer
extends TextureRenderer {
    private final World world;
    private final DrawingInterface drawing;
    private final ShapeRenderer shapeRenderer;

    public PatchRenderer(World world, DrawingInterface drawing, ShapeRenderer shapeRenderer) {
        this.world = world;
        this.drawing = drawing;
        this.shapeRenderer = shapeRenderer;
        super(world);
    }

    public float[] getPatchCoords(Patch patch) {
        float[] coords = new float[]{patch.pxcor(), patch.pycor(), 0.0f};
        coords[0] = (float)this.world.wrappedObserverX(Float$.MODULE$.float2double(coords[0]));
        coords[1] = (float)this.world.wrappedObserverY(Float$.MODULE$.float2double(coords[1]));
        return coords;
    }

    public void renderIndividualLabels(GL2 gl, Patch3D patch, int fontSize, double patchSize) {
        if (this.world.patchesWithLabels() > 0) {
            float scale = 0.3f;
            if (patch.hasLabel()) {
                gl.glPushMatrix();
                float[] coords = this.getPatchCoords(patch);
                this.renderLabel(gl, scale * coords[0], scale * coords[1], scale * coords[2], patch, fontSize, patchSize);
                gl.glPopMatrix();
                return;
            }
            return;
        }
    }

    public void renderLabels(GL2 gl, int fontSize, double patchSize) {
        if (this.world.patchesWithLabels() > 0) {
            int numPatches = this.world.patchColors().length;
            float scale = 0.3f;
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPatches).foreach((Function1)(JFunction1.mcVI.sp & Serializable)id -> {
                Patch patch = this.world.getPatch(id);
                if (patch.hasLabel()) {
                    gl.glPushMatrix();
                    float[] coords = this.getPatchCoords(patch);
                    this.renderLabel(gl, scale * coords[0], scale * coords[1], scale * coords[2], patch, fontSize, patchSize);
                    gl.glPopMatrix();
                    return;
                }
            });
            return;
        }
    }

    public void renderLabel(GL2 gl, float col, float row, float dep, Patch patch, int fontSize, double patchSize) {
        Observer observer = this.world.observer();
        ObserverOrientation orientation = (ObserverOrientation)observer.orientation().get();
        gl.glTranslated(Float$.MODULE$.float2double(col), Float$.MODULE$.float2double(row), Float$.MODULE$.float2double(dep));
        gl.glRotated(-orientation.heading(), 0.0, 0.0, 1.0);
        gl.glRotated(90.0, 1.0, 0.0, 0.0);
        Perspective perspective = observer.perspective();
        if (perspective instanceof AgentFollowingPerspective) {
            gl.glRotated(-orientation.pitch(), -1.0, 0.0, 0.0);
            gl.glRotated(-orientation.roll(), 0.0, 0.0, 1.0);
        } else {
            gl.glRotated(orientation.pitch(), -1.0, 0.0, 0.0);
            gl.glRotated(orientation.roll(), 0.0, 0.0, 1.0);
        }
        AgentRenderer$.MODULE$.renderString(gl, this.world, patch.labelString(), patch.labelColor(), fontSize, patchSize);
    }

    public void renderOutline(GL2 gl, Patch patch) {
        gl.glPushMatrix();
        float scale = 0.3f;
        float[] rgb = Color$.MODULE$.getColor(patch.pcolor()).getRGBColorComponents(null);
        gl.glColor3f((rgb[0] + 0.5f) % 1.0f, (rgb[1] + 0.5f) % 1.0f, (rgb[2] + 0.5f) % 1.0f);
        gl.glPolygonMode(1032, 6913);
        gl.glEnable(10754);
        gl.glPolygonOffset(-1.0f, -1.0f);
        gl.glScaled(Float$.MODULE$.float2double(scale), Float$.MODULE$.float2double(scale), Float$.MODULE$.float2double(scale));
        float[] coords = this.getPatchCoords(patch);
        gl.glTranslated(Float$.MODULE$.float2double(coords[0]), Float$.MODULE$.float2double(coords[1]), Float$.MODULE$.float2double(coords[2]));
        gl.glBegin(7);
        gl.glVertex3f(-0.5f, 0.5f, -0.5f);
        gl.glVertex3f(-0.5f, -0.5f, -0.5f);
        gl.glVertex3f(0.5f, -0.5f, -0.5f);
        gl.glVertex3f(0.5f, 0.5f, -0.5f);
        gl.glEnd();
        gl.glDisable(10754);
        gl.glPolygonMode(1032, 6914);
        gl.glPopMatrix();
    }

    public void renderHightlight(GL2 gl, Patch patch) {
        gl.glPushMatrix();
        float scale = 0.3f;
        gl.glScaled(Float$.MODULE$.float2double(scale), Float$.MODULE$.float2double(scale), Float$.MODULE$.float2double(scale));
        float[] coords = this.getPatchCoords(patch);
        gl.glTranslated(Float$.MODULE$.float2double(coords[0]), Float$.MODULE$.float2double(coords[1]), -0.5);
        gl.glScaled(3.3333, 3.3333, 3.3333);
        this.shapeRenderer.renderHalo(gl, false, 1.8999809999999997);
        gl.glPopMatrix();
    }

    public void renderPatchTexture(GL2 gl) {
        this.renderPatches(gl);
    }

    public void renderPatches(GL2 gl) {
        this.calculateTextureSize(gl, this.world.patchesAllBlack());
        this.renderTexture(gl);
    }

    public void renderPatches(GL2 gl, int fontSize, double patchSize) {
    }

    private void renderTexture(GL2 gl) {
        gl.glEnable(3553);
        gl.glDisable(2896);
        if (!this.drawing.isBlank()) {
            gl.glDepthMask(false);
        }
        if (!this.world.patchesAllBlack()) {
            if (this.newTexture) {
                if (this.texture != 0) {
                    gl.glDeleteTextures(1, IntBuffer.wrap(new int[]{this.texture}));
                }
                this.texture = TextureUtils$.MODULE$.genTexture(gl);
                gl.glBindTexture(3553, this.texture);
                TextureUtils$.MODULE$.makeTexture(gl, this.textureSize);
                ((WorldRenderable)((Object)this.world)).markPatchColorsDirty();
                this.newTexture = false;
            } else {
                gl.glBindTexture(3553, this.texture);
            }
        }
        gl.glPushMatrix();
        if (this.world.patchesAllBlack()) {
            gl.glScalef((float)this.world.worldWidth(), (float)this.world.worldHeight(), 1.0f);
            TextureUtils$.MODULE$.renderEmptyPlane(gl, 1.0f, 1.0f, 1.0f);
        } else {
            TextureUtils$.MODULE$.setParameters(gl);
            this.renderTextureTiles(gl, this.world.worldWidth(), this.world.worldHeight(), this.textureSize, this.world.patchColors(), ((WorldRenderable)((Object)this.world)).patchColorsDirty());
            ((WorldRenderable)((Object)this.world)).markPatchColorsClean();
        }
        if (!this.drawing.isBlank()) {
            gl.glDepthMask(true);
        }
        gl.glEnable(2896);
        gl.glPopMatrix();
        gl.glBindTexture(3553, 0);
    }

    private void calculateTextureSize(GL2 gl, boolean patchesBlank) {
        if (!patchesBlank || this.textureSize == 0) {
            int newSize = TextureUtils$.MODULE$.calculateTextureSize(gl, this.world.worldWidth(), this.world.worldHeight());
            if (this.textureSize != newSize) {
                this.newTexture = true;
                this.textureSize = newSize;
                this.tiles = TextureUtils$.MODULE$.createTileArray(this.world.worldWidth(), this.world.worldHeight(), this.textureSize);
                return;
            }
            return;
        }
    }
}

