/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.gl.render;

import com.jogamp.opengl.GL2;
import java.io.Serializable;
import org.nlogo.api.Color$;
import org.nlogo.api.DrawingInterface;
import org.nlogo.api.Patch;
import org.nlogo.api.Patch3D;
import org.nlogo.api.World;
import org.nlogo.api.World3D;
import org.nlogo.gl.render.GLShape;
import org.nlogo.gl.render.PatchRenderer;
import org.nlogo.gl.render.ShapeRenderer;
import scala.Float$;
import scala.Function1;
import scala.Int$;
import scala.Predef$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public class PatchRenderer3D
extends PatchRenderer {
    private final World3D world;
    private final ShapeRenderer shapeRenderer;

    public PatchRenderer3D(World3D world, DrawingInterface drawing, ShapeRenderer shapeRenderer) {
        this.world = world;
        this.shapeRenderer = shapeRenderer;
        super(world, drawing, shapeRenderer);
    }

    @Override
    public void renderPatchTexture(GL2 gl) {
        super.renderPatches(gl);
    }

    @Override
    public void renderLabels(GL2 gl, int fontSize, double patchSize) {
        if (this.world.patchesAllBlack()) {
            super.renderLabels(gl, fontSize, patchSize);
            return;
        }
    }

    @Override
    public void renderIndividualLabels(GL2 gl, Patch3D patch, int fontSize, double patchSize) {
        if (this.world.patchesAllBlack()) {
            super.renderIndividualLabels(gl, patch, fontSize, patchSize);
            return;
        }
    }

    public void renderIndividualPatch(GL2 gl, Patch3D patch, int fontSize, double patchSize) {
        if (!this.world.patchesAllBlack()) {
            boolean flag = true;
            gl.glPushMatrix();
            GLShape shape3D = this.shapeRenderer.getShape("@@@PATCH@@@");
            if ((double)patch.alpha() == 0.0 && patch.hasLabel()) {
                float scale = 0.3f;
                gl.glPushMatrix();
                float[] coords = this.getPatchCoords(patch);
                this.renderLabel(gl, scale * coords[0], scale * coords[1], scale * coords[2], patch, fontSize, patchSize);
                gl.glPopMatrix();
                flag = false;
            }
            if (flag) {
                this.renderWrappedPatch(gl, patch, shape3D, fontSize, patchSize, false);
            }
            gl.glPopMatrix();
            return;
        }
    }

    @Override
    public void renderPatches(GL2 gl, int fontSize, double patchSize) {
        if (!this.world.patchesAllBlack() || this.world.patchesWithLabels() != 0) {
            gl.glPushMatrix();
            int numPatches = this.world.patchColors().length;
            GLShape shape3D = this.shapeRenderer.getShape("@@@PATCH@@@");
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPatches).foreach((Function1)(JFunction1.mcVI.sp & Serializable)id -> {
                Patch3D patch = (Patch3D)this.world.getPatch(id);
                if ((double)patch.alpha() == 0.0) {
                    if (patch.hasLabel()) {
                        float scale = 0.3f;
                        gl.glPushMatrix();
                        float[] coords = this.getPatchCoords(patch);
                        this.renderLabel(gl, scale * coords[0], scale * coords[1], scale * coords[2], patch, fontSize, patchSize);
                        gl.glPopMatrix();
                        return;
                    }
                    return;
                }
                this.renderWrappedPatch(gl, patch, shape3D, fontSize, patchSize, false);
            });
            gl.glPopMatrix();
            return;
        }
    }

    public void renderWrappedPatch(GL2 gl, Patch3D patch, GLShape shape, int fontSize, double patchSize, boolean outline) {
        this.shapeRenderer.renderWrappedAgent(gl, shape, 1.0, Color$.MODULE$.getColor(patch.pcolor()), patch.labelString(), patch.labelColor(), this.world.wrappedObserverX(Int$.MODULE$.int2double(patch.pxcor())), this.world.wrappedObserverY(Int$.MODULE$.int2double(patch.pycor())), this.world.wrappedObserverZ(Int$.MODULE$.int2double(patch.pzcor())), 1.0f, patchSize, fontSize, false, 0.0, new double[]{0.0, 0.0, 0.0});
    }

    public float[] getDimensions(World world) {
        World3D w = (World3D)world;
        return new float[]{w.worldWidth(), w.worldHeight(), w.worldDepth()};
    }

    @Override
    public float[] getPatchCoords(Patch patch) {
        Patch3D p = (Patch3D)patch;
        float[] coords = new float[]{p.pxcor(), p.pycor(), p.pzcor()};
        coords[0] = (float)this.world.wrappedObserverX(Float$.MODULE$.float2double(coords[0]));
        coords[1] = (float)this.world.wrappedObserverY(Float$.MODULE$.float2double(coords[1]));
        coords[2] = (float)this.world.wrappedObserverZ(Float$.MODULE$.float2double(coords[2]));
        return coords;
    }

    @Override
    public void renderOutline(GL2 gl, Patch patch) {
        GLShape shape = this.shapeRenderer.getShape("@@@PATCH@@@");
        float[] rgb = Color$.MODULE$.getColor(patch.pcolor()).getRGBColorComponents(null);
        gl.glPushMatrix();
        float[] coords = this.getPatchCoords(patch);
        gl.glTranslatef(coords[0] * 0.3f, coords[1] * 0.3f, coords[2] * 0.3f);
        gl.glPushMatrix();
        gl.glPolygonMode(1032, 6913);
        gl.glColor3f(rgb[0], rgb[1], rgb[2]);
        gl.glLineWidth(4.0f);
        gl.glCallList(shape.displayListIndex());
        gl.glColor3f((rgb[0] + 0.5f) % 1.0f, (rgb[1] + 0.5f) % 1.0f, (rgb[2] + 0.5f) % 1.0f);
        gl.glLineWidth(2.0f);
        gl.glCallList(shape.displayListIndex());
        gl.glLineWidth(1.0f);
        gl.glPopMatrix();
        gl.glPolygonMode(1032, 6914);
        gl.glPopMatrix();
    }
}

