/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.gl.render;

import com.jogamp.opengl.GL2;
import java.awt.Color;
import java.nio.FloatBuffer;
import org.nlogo.api.Agent;
import org.nlogo.api.AgentFollowingPerspective;
import org.nlogo.api.Observer;
import org.nlogo.api.ObserverOrientation;
import org.nlogo.api.Perspective;
import org.nlogo.api.World;
import org.nlogo.gl.render.AgentRenderer$;
import org.nlogo.gl.render.GLLinkShape;
import org.nlogo.gl.render.GLShape;
import org.nlogo.gl.render.ShapeManager;
import scala.Array;
import scala.Array$;
import scala.Float$;
import scala.MatchError;
import scala.Tuple3;
import scala.Tuple3$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public class ShapeRenderer {
    private final World world;
    private boolean stencilSupport;
    private ShapeManager shapeManager;

    public ShapeRenderer(World world) {
        this.world = world;
        this.stencilSupport = false;
        this.shapeManager = null;
    }

    public boolean stencilSupport() {
        return this.stencilSupport;
    }

    public void stencilSupport_$eq(boolean x$1) {
        this.stencilSupport = x$1;
    }

    public ShapeManager shapeManager() {
        return this.shapeManager;
    }

    public void shapeManager_$eq(ShapeManager x$1) {
        this.shapeManager = x$1;
    }

    public void renderWrappedAgent(GL2 gl, GLShape shape3D, double size, Color color, String label, Object labelColor, double x, double y, double z, float height, double patchSize, int fontSize, boolean outline, double lineThickness, double[] orientation) {
        double maxx = (double)this.world.maxPxcor() + 0.5;
        double minx = (double)this.world.minPxcor() - 0.5;
        double maxy = (double)this.world.maxPycor() + 0.5;
        double miny = (double)this.world.minPycor() - 0.5;
        int worldWidth = this.world.worldWidth();
        int worldHeight = this.world.worldHeight();
        boolean wrapXRight = false;
        boolean wrapXLeft = false;
        float stroke = (float)package$.MODULE$.max(1.0, patchSize * lineThickness);
        this.renderAgent(gl, shape3D, color, size, x, y, z, stroke, outline, orientation);
        if (this.world.wrappingAllowedInX()) {
            if (x + size / (double)2 > maxx) {
                this.renderAgent(gl, shape3D, color, size, x - (double)worldWidth, y, z, stroke, outline, orientation);
                wrapXRight = true;
            }
            if (x - size / (double)2 < minx) {
                this.renderAgent(gl, shape3D, color, size, x + (double)worldWidth, y, z, stroke, outline, orientation);
                wrapXLeft = true;
            }
        }
        if (this.world.wrappingAllowedInY()) {
            if (y + size / (double)2 > maxy) {
                this.renderAgent(gl, shape3D, color, size, x, y - (double)worldHeight, z, stroke, outline, orientation);
                if (wrapXRight) {
                    this.renderAgent(gl, shape3D, color, size, x - (double)worldWidth, y - (double)worldHeight, z, stroke, outline, orientation);
                }
                if (wrapXLeft) {
                    this.renderAgent(gl, shape3D, color, size, x + (double)worldWidth, y - (double)worldHeight, z, stroke, outline, orientation);
                }
            }
            if (y - size / (double)2 < miny) {
                this.renderAgent(gl, shape3D, color, size, x, y + (double)worldHeight, z, stroke, outline, orientation);
                if (wrapXRight) {
                    this.renderAgent(gl, shape3D, color, size, x - (double)worldWidth, y + (double)worldHeight, z, stroke, outline, orientation);
                }
                if (wrapXLeft) {
                    this.renderAgent(gl, shape3D, color, size, x + (double)worldWidth, y + (double)worldHeight, z, stroke, outline, orientation);
                }
            }
        }
        if (label.length() != 0) {
            this.renderLabel(gl, label, labelColor, (float)(x * (double)0.3f), (float)(y * (double)0.3f), (float)(z * (double)0.3f), height, fontSize, patchSize);
            return;
        }
    }

    public void renderAgent(GL2 gl, GLShape shape3D, Color color, double size, double xcor, double ycor, double zcor, float stroke, boolean outline, double[] orientation) {
        gl.glPushMatrix();
        this.alignAgent(gl, size, xcor * (double)0.3f, ycor * (double)0.3f, zcor * (double)0.3f, shape3D, false, orientation);
        gl.glColor4fv(FloatBuffer.wrap(color.getRGBComponents(null)));
        if (outline) {
            this.doOutline(gl, shape3D, color.getComponents(null));
        } else {
            gl.glLineWidth(stroke);
            gl.glCallList(shape3D.displayListIndex());
            gl.glLineWidth(1.0f);
        }
        gl.glPopMatrix();
    }

    public void alignAgent(GL2 gl, double size, double xcor, double ycor, double zcor, GLShape shape3D, boolean highlight, double[] orientation) {
        Object object;
        double[] dArray = orientation;
        if (dArray == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object = Array$.MODULE$.unapplySeq((Object)dArray), 3) != 0) {
            throw new IllegalStateException();
        }
        double d = BoxesRunTime.unboxToDouble((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0));
        double d2 = BoxesRunTime.unboxToDouble((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1));
        double d3 = BoxesRunTime.unboxToDouble((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 2));
        double h = d;
        double p = d2;
        double r = d3;
        Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)h), (Object)BoxesRunTime.boxToDouble((double)p), (Object)BoxesRunTime.boxToDouble((double)r));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        double heading = BoxesRunTime.unboxToDouble((Object)tuple3._1());
        double pitch = BoxesRunTime.unboxToDouble((Object)tuple3._2());
        double roll = BoxesRunTime.unboxToDouble((Object)tuple3._3());
        Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)heading), (Object)BoxesRunTime.boxToDouble((double)pitch), (Object)BoxesRunTime.boxToDouble((double)roll));
        double heading2 = BoxesRunTime.unboxToDouble((Object)tuple32._1());
        double pitch2 = BoxesRunTime.unboxToDouble((Object)tuple32._2());
        double roll2 = BoxesRunTime.unboxToDouble((Object)tuple32._3());
        ObserverOrientation observerOrientation = (ObserverOrientation)this.world.observer().orientation().get();
        gl.glTranslated(xcor, ycor, zcor);
        if (highlight && this.world.observer().perspective() instanceof Perspective.Follow) {
            gl.glRotated(-observerOrientation.heading(), 0.0, 0.0, 1.0);
            gl.glRotated(90.0, 1.0, 0.0, 0.0);
            gl.glRotated(-observerOrientation.pitch(), -1.0, 0.0, 0.0);
        } else if (shape3D.rotatable() && !highlight) {
            gl.glRotated(0.0 - heading2, 0.0, 0.0, 1.0);
            gl.glRotated(pitch2, 1.0, 0.0, 0.0);
            gl.glRotated(roll2, 0.0, 1.0, 0.0);
        } else {
            gl.glRotated(-observerOrientation.heading(), 0.0, 0.0, 1.0);
            gl.glRotated(90.0, 1.0, 0.0, 0.0);
            Perspective perspective = this.world.observer().perspective();
            if (perspective instanceof AgentFollowingPerspective) {
                gl.glRotated(-observerOrientation.pitch(), -1.0, 0.0, 0.0);
                gl.glRotated(-observerOrientation.roll(), 0.0, 0.0, 1.0);
            } else {
                gl.glRotated(observerOrientation.pitch(), -1.0, 0.0, 0.0);
                gl.glRotated(observerOrientation.roll(), 0.0, 0.0, 1.0);
            }
        }
        gl.glScaled(size, size, size);
    }

    public void doOutline(GL2 gl, GLShape shape3D, float[] rgb) {
        if (this.stencilSupport()) {
            gl.glClearStencil(0);
            gl.glClear(1024);
            gl.glEnable(2960);
            gl.glStencilFunc(519, 1, 65535);
            gl.glStencilOp(7680, 7680, 7681);
            gl.glPushMatrix();
            gl.glCallList(shape3D.displayListIndex());
            gl.glPopMatrix();
            gl.glStencilFunc(517, 1, 65535);
            gl.glStencilOp(7680, 7680, 7681);
            gl.glLineWidth(2.0f);
            gl.glPolygonMode(1032, 6913);
            gl.glColor4f((rgb[0] + 0.5f) % 1.0f, (rgb[1] + 0.5f) % 1.0f, (rgb[2] + 0.5f) % 1.0f, 0.5f);
            gl.glCallList(shape3D.displayListIndex());
            gl.glLineWidth(4.0f);
            gl.glPolygonMode(1032, 6913);
            gl.glColor4f(rgb[0], rgb[1], rgb[2], 0.5f);
            gl.glCallList(shape3D.displayListIndex());
            gl.glLineWidth(1.0f);
            gl.glPolygonMode(1032, 6914);
            gl.glDisable(2960);
            return;
        }
        gl.glPushMatrix();
        gl.glPolygonMode(1032, 6913);
        gl.glColor4f(rgb[0], rgb[1], rgb[2], 0.5f);
        gl.glLineWidth(4.0f);
        gl.glCallList(shape3D.displayListIndex());
        gl.glColor4f((rgb[0] + 0.5f) % 1.0f, (rgb[1] + 0.5f) % 1.0f, (rgb[2] + 0.5f) % 1.0f, 0.5f);
        gl.glLineWidth(2.0f);
        gl.glCallList(shape3D.displayListIndex());
        gl.glLineWidth(1.0f);
        gl.glPopMatrix();
        gl.glEnable(32823);
        gl.glPolygonOffset(-3.0f, -3.0f);
        gl.glPolygonMode(1032, 6914);
        gl.glColor4f(rgb[0], rgb[1], rgb[2], 0.5f);
        gl.glCallList(shape3D.displayListIndex());
        gl.glDisable(32823);
    }

    public GLShape getShape(String name) {
        return this.shapeManager().getShape(name);
    }

    public GLLinkShape getLinkShape(String name) {
        return this.shapeManager().getLinkShape(name);
    }

    public float getShapeHeight(String name, GLShape shape, double size) {
        if (this.shapeManager().modelLibraryShape(name) && shape.rotatable()) {
            return 1.0f;
        }
        return (float)size;
    }

    public void renderHighlight(GL2 gl, Agent agent, double[] coords, double[] orientation) {
        gl.glPushMatrix();
        GLShape shape = this.shapeManager().getShape(agent.shape());
        this.alignAgent(gl, agent.size(), coords[0] * (double)0.3f, coords[1] * (double)0.3f, coords[2] * (double)0.3f, shape, true, orientation);
        this.renderHalo(gl, true, agent.size() * 3.3333 * 0.285 * 2.0);
        gl.glPopMatrix();
    }

    public void renderLabel(GL2 gl, String label, Object labelColor, float xcor, float ycor, float zcor, float height, int fontSize, double patchSize) {
        Observer observer = this.world.observer();
        ObserverOrientation orientation = (ObserverOrientation)observer.orientation().get();
        gl.glPushMatrix();
        gl.glTranslated(Float$.MODULE$.float2double(xcor), Float$.MODULE$.float2double(ycor), Float$.MODULE$.float2double(zcor + 0.15f * height));
        gl.glRotated(-orientation.heading(), 0.0, 0.0, 1.0);
        gl.glRotated(90.0, 1.0, 0.0, 0.0);
        Perspective perspective = observer.perspective();
        if (perspective instanceof AgentFollowingPerspective) {
            gl.glRotated(-orientation.pitch(), -1.0, 0.0, 0.0);
            gl.glRotated(-orientation.roll(), 0.0, 0.0, 1.0);
        } else {
            gl.glRotated(orientation.pitch(), -1.0, 0.0, 0.0);
            gl.glRotated(orientation.roll(), 0.0, 0.0, 1.0);
        }
        AgentRenderer$.MODULE$.renderString(gl, this.world, label, labelColor, fontSize, patchSize);
        gl.glPopMatrix();
    }

    public void renderHalo(GL2 gl, boolean isTurtle, double diameter) {
        int height;
        GLShape haloShape = this.shapeManager().getShape("@@@HALO@@@");
        int width = this.world.worldWidth();
        double stretch = diameter < package$.MODULE$.max((double)width / 10.0, (double)(height = this.world.worldHeight()) / 10.0) ? package$.MODULE$.max((double)width / 10.0, (double)height / 10.0) / diameter : 1.0;
        gl.glDepthFunc(519);
        if (this.stencilSupport()) {
            gl.glClearStencil(0);
            gl.glClear(1024);
            gl.glEnable(2960);
            gl.glStencilFunc(519, 1, 65535);
            gl.glStencilOp(7680, 7681, 7681);
        }
        gl.glPushMatrix();
        gl.glScaled(stretch, stretch, 0.0);
        gl.glCallList(haloShape.displayListIndex());
        gl.glPopMatrix();
        if (this.world.observer().perspective() instanceof Perspective.Watch && this.stencilSupport()) {
            ObserverOrientation orientation = (ObserverOrientation)this.world.observer().orientation().get();
            if (!isTurtle) {
                gl.glRotated(-orientation.heading(), 0.0, 0.0, 1.0);
                gl.glRotated(90.0, 1.0, 0.0, 0.0);
                gl.glRotated(orientation.pitch(), -1.0, 0.0, 0.0);
            }
            gl.glStencilFunc(517, 1, 65535);
            gl.glStencilOp(7680, 7680, 7680);
            gl.glEnable(3042);
            gl.glBlendFunc(770, 1);
            float[] darkOverlay = new float[]{0.0f, 0.0f, 0.196f, 0.392f};
            gl.glColor4fv(FloatBuffer.wrap(darkOverlay));
            gl.glBegin(7);
            gl.glNormal3f(0.0f, 0.0f, 1.0f);
            gl.glVertex3f(-100.0f, 100.0f, 0.0f);
            gl.glVertex3f(-100.0f, -100.0f, 0.0f);
            gl.glVertex3f(100.0f, -100.0f, 0.0f);
            gl.glVertex3f(100.0f, 100.0f, 0.0f);
            gl.glEnd();
            gl.glDisable(3042);
            gl.glDisable(2960);
        }
        gl.glDepthFunc(515);
    }
}

