/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.gl.render;

import com.jogamp.opengl.GL2;
import java.awt.Color;
import java.nio.FloatBuffer;
import org.nlogo.api.AgentFollowingPerspective;
import org.nlogo.api.Color$;
import org.nlogo.api.Drawing3D;
import org.nlogo.api.DrawingLine3D;
import org.nlogo.api.Link;
import org.nlogo.api.ObserverOrientation;
import org.nlogo.api.Perspective;
import org.nlogo.api.Turtle;
import org.nlogo.api.World3D;
import org.nlogo.gl.render.DrawingRendererInterface;
import org.nlogo.gl.render.LinkRenderer3D;
import org.nlogo.gl.render.TurtleRenderer3D;
import scala.Predef$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;

public class TrailRenderer3D
implements DrawingRendererInterface {
    private final World3D world;
    private final TurtleRenderer3D renderer;
    private final LinkRenderer3D linkRenderer;
    private int lineIndex;

    public TrailRenderer3D(World3D world, TurtleRenderer3D renderer, LinkRenderer3D linkRenderer) {
        this.world = world;
        this.renderer = renderer;
        this.linkRenderer = linkRenderer;
        this.lineIndex = 0;
    }

    public int lineIndex() {
        return this.lineIndex;
    }

    public void lineIndex_$eq(int x$1) {
        this.lineIndex = x$1;
    }

    @Override
    public void init(GL2 gl) {
        this.lineIndex_$eq(gl.glGenLists(1));
        gl.glNewList(this.lineIndex(), 4864);
        gl.glBegin(1);
        gl.glNormal3f(0.0f, 0.0f, -1.0f);
        gl.glVertex3f(0.0f, 0.0f, 0.0f);
        gl.glVertex3f(0.0f, 0.3f, 0.0f);
        gl.glEnd();
        gl.glEndList();
    }

    private Drawing3D drawing() {
        return (Drawing3D)this.world.getDrawing();
    }

    @Override
    public void renderDrawing(GL2 gl) {
        double defaultDist = 1.5 * (double)RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this.world.worldWidth()), this.world.worldHeight())), this.world.worldDepth());
        CollectionConverters$.MODULE$.IterableHasAsScala(this.drawing().linkStamps()).asScala().foreach(stamp -> {
            double d;
            Perspective perspective = this.world.observer().perspective();
            if (perspective instanceof AgentFollowingPerspective) {
                Perspective afp = (Perspective)((Object)((AgentFollowingPerspective)((Object)perspective)));
                d = ((AgentFollowingPerspective)((Object)afp)).followDistance();
            } else {
                d = ((ObserverOrientation)this.world.observer().orientation().get()).dist();
            }
            double distance = d;
            double lineScale = 0.0;
            if (distance != 0.0) {
                lineScale = (double)package$.MODULE$.max(this.world.worldWidth(), this.world.worldHeight()) * 1.5 / distance;
            }
            this.linkRenderer.renderWrappedLink(gl, (Link)stamp, 0, this.world.patchSize(), false, lineScale);
        });
        CollectionConverters$.MODULE$.IterableHasAsScala(this.drawing().turtleStamps()).asScala().foreach(stamp -> this.renderer.renderWrappedTurtle(gl, (Turtle)stamp, 0, this.world.patchSize(), false, defaultDist));
        this.renderTrails(gl);
        gl.glLineWidth(1.0f);
    }

    public void renderTrails(GL2 gl) {
        CollectionConverters$.MODULE$.IterableHasAsScala(this.drawing().lines()).asScala().foreach(line -> this.renderWrappedLine(gl, (DrawingLine3D)line));
    }

    private void renderWrappedLine(GL2 gl, DrawingLine3D l) {
        double x = this.world.wrappedObserverX(l.x0());
        double y = this.world.wrappedObserverY(l.y0());
        double z = this.world.wrappedObserverZ(l.z0());
        int worldWidth = this.world.worldWidth();
        int worldHeight = this.world.worldHeight();
        int worldDepth = this.world.worldDepth();
        boolean wrapXRight = false;
        boolean wrapXLeft = false;
        boolean wrapYTop = false;
        boolean wrapYBottom = false;
        this.renderLine(gl, l, x, y, z);
        if (x != l.x0()) {
            double endX = x + l.x1() - l.x0();
            double maxx = (double)this.world.maxPxcor() + 0.5;
            double minx = (double)this.world.minPxcor() - 0.5;
            if (endX > maxx) {
                this.renderLine(gl, l, x - (double)worldWidth, y, z);
                wrapXRight = true;
            }
            if (endX < minx) {
                this.renderLine(gl, l, x + (double)worldWidth, y, z);
                wrapXLeft = true;
            }
        }
        if (y != l.y0()) {
            double endY = y + l.y1() - l.y0();
            double maxy = (double)this.world.maxPycor() + 0.5;
            double miny = (double)this.world.minPycor() - 0.5;
            if (endY > maxy) {
                this.renderLine(gl, l, x, y - (double)worldHeight, z);
                if (wrapXRight) {
                    this.renderLine(gl, l, x - (double)worldWidth, y - (double)worldHeight, z);
                }
                if (wrapXLeft) {
                    this.renderLine(gl, l, x + (double)worldWidth, y - (double)worldHeight, z);
                }
                wrapYTop = true;
            }
            if (endY < miny) {
                this.renderLine(gl, l, x, y + (double)worldHeight, z);
                if (wrapXRight) {
                    this.renderLine(gl, l, x - (double)worldWidth, y + (double)worldHeight, z);
                }
                if (wrapXLeft) {
                    this.renderLine(gl, l, x + (double)worldWidth, y + (double)worldHeight, z);
                }
                wrapYBottom = true;
            }
        }
        if (z != l.z0()) {
            double endZ = z + l.z1() - l.z0();
            double maxz = (double)this.world.maxPzcor() + 0.5;
            double minz = (double)this.world.minPzcor() - 0.5;
            if (endZ > maxz) {
                this.renderLine(gl, l, x, y, z - (double)worldDepth);
                if (wrapXRight) {
                    this.renderLine(gl, l, x - (double)worldWidth, y, z - (double)worldDepth);
                    if (wrapYTop) {
                        this.renderLine(gl, l, x - (double)worldWidth, y - (double)worldHeight, z - (double)worldDepth);
                    }
                    if (wrapYBottom) {
                        this.renderLine(gl, l, x - (double)worldWidth, y + (double)worldHeight, z - (double)worldDepth);
                    }
                }
                if (wrapXLeft) {
                    this.renderLine(gl, l, x + (double)worldWidth, y, z - (double)worldDepth);
                    if (wrapYTop) {
                        this.renderLine(gl, l, x + (double)worldWidth, y - (double)worldHeight, z - (double)worldDepth);
                    }
                    if (wrapYBottom) {
                        this.renderLine(gl, l, x + (double)worldWidth, y + (double)worldHeight, z - (double)worldDepth);
                    }
                }
                if (wrapYTop) {
                    this.renderLine(gl, l, x, y - (double)worldHeight, z - (double)worldDepth);
                }
                if (wrapYBottom) {
                    this.renderLine(gl, l, x, y + (double)worldHeight, z - (double)worldDepth);
                }
            }
            if (endZ < minz) {
                this.renderLine(gl, l, x, y, z + (double)worldDepth);
                if (wrapXRight) {
                    this.renderLine(gl, l, x - (double)worldWidth, y, z + (double)worldDepth);
                    if (wrapYTop) {
                        this.renderLine(gl, l, x - (double)worldWidth, y - (double)worldHeight, z + (double)worldDepth);
                    }
                    if (wrapYBottom) {
                        this.renderLine(gl, l, x - (double)worldWidth, y + (double)worldHeight, z + (double)worldDepth);
                    }
                }
                if (wrapXLeft) {
                    this.renderLine(gl, l, x + (double)worldWidth, y, z + (double)worldDepth);
                    if (wrapYTop) {
                        this.renderLine(gl, l, x + (double)worldWidth, y - (double)worldHeight, z + (double)worldDepth);
                    }
                    if (wrapYBottom) {
                        this.renderLine(gl, l, x + (double)worldWidth, y + (double)worldHeight, z + (double)worldDepth);
                    }
                }
                if (wrapYTop) {
                    this.renderLine(gl, l, x, y - (double)worldHeight, z + (double)worldDepth);
                }
                if (wrapYBottom) {
                    this.renderLine(gl, l, x, y + (double)worldHeight, z + (double)worldDepth);
                    return;
                }
                return;
            }
            return;
        }
    }

    private void renderLine(GL2 gl, DrawingLine3D line, double x, double y, double z) {
        Color color = Color$.MODULE$.getColor(line.color());
        gl.glPushMatrix();
        this.alignLine(gl, line, x, y, z);
        gl.glColor3fv(FloatBuffer.wrap(color.getRGBColorComponents(null)));
        gl.glLineWidth((float)RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(1.0), line.width()));
        gl.glCallList(this.lineIndex());
        gl.glPopMatrix();
    }

    private void alignLine(GL2 gl, DrawingLine3D line, double x, double y, double z) {
        double length = line.length();
        gl.glTranslated(x * (double)0.3f, y * (double)0.3f, z * (double)0.3f);
        gl.glRotated(-line.heading(), 0.0, 0.0, 1.0);
        gl.glRotated(line.pitch(), 1.0, 0.0, 0.0);
        gl.glScaled(length, length, length);
    }

    @Override
    public void clear() {
    }
}

