/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.gl.render;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import java.io.Serializable;
import org.nlogo.api.Agent;
import org.nlogo.api.AgentFollowingPerspective;
import org.nlogo.api.Color$;
import org.nlogo.api.Constants$;
import org.nlogo.api.ObserverOrientation;
import org.nlogo.api.Perspective;
import org.nlogo.api.Turtle;
import org.nlogo.api.World;
import org.nlogo.gl.render.AgentRenderer;
import org.nlogo.gl.render.GLShape;
import org.nlogo.gl.render.ShapeRenderer;
import scala.Float$;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.runtime.RichInt$;

public class TurtleRenderer
extends AgentRenderer {
    public TurtleRenderer(World world, ShapeRenderer shapeRenderer) {
        super(world, shapeRenderer);
    }

    private World world$accessor() {
        return super.world();
    }

    private ShapeRenderer shapeRenderer$accessor() {
        return super.shapeRenderer();
    }

    private double lineScale() {
        double distance;
        double d;
        Perspective perspective = this.world$accessor().observer().perspective();
        if (perspective instanceof AgentFollowingPerspective) {
            Perspective afp = (Perspective)((Object)((AgentFollowingPerspective)((Object)perspective)));
            d = ((AgentFollowingPerspective)((Object)afp)).followDistance();
        } else {
            d = distance = ((ObserverOrientation)this.world$accessor().observer().orientation().get()).dist();
        }
        if (distance == 0.0) {
            return 0.0;
        }
        return (double)RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this.world$accessor().worldWidth()), this.world$accessor().worldHeight()) * 1.5 / distance;
    }

    public void renderTurtles(GL2 gl, GLU glu, int fontSize, double patchSize, Agent outlineAgent) {
        if (this.world$accessor().turtles() == null) {
            return;
        }
        ((IterableOnceOps)CollectionConverters$.MODULE$.IterableHasAsScala(this.world$accessor().turtles().agents()).asScala().map((Function1 & Serializable)_$1 -> (Turtle)_$1)).foreach(turtle -> {
            block5: {
                block4: {
                    if (!(this.world$accessor().observer().perspective() instanceof Perspective.Ride)) break block4;
                    Agent agent = this.world$accessor().observer().targetAgent();
                    Turtle turtle2 = turtle;
                    if (!(agent == null ? turtle2 != null : !agent.equals(turtle2))) break block5;
                }
                if (!turtle.hidden()) {
                    Agent agent = outlineAgent;
                    Turtle turtle3 = turtle;
                    this.renderWrappedTurtle(gl, (Turtle)turtle, fontSize, patchSize, !(agent != null ? !agent.equals(turtle3) : turtle3 != null), this.lineScale());
                    return;
                }
            }
        });
    }

    public void renderWrappedTurtle(GL2 gl, Turtle turtle, int fontSize, double patchSize, boolean outline, double lineScale) {
        GLShape shape3D = this.shapeRenderer$accessor().getShape(turtle.shape());
        float height = this.shapeRenderer$accessor().getShapeHeight(turtle.shape(), shape3D, turtle.size());
        double[] coords = this.getAgentCoords(turtle, Float$.MODULE$.float2double(height));
        this.shapeRenderer$accessor().renderWrappedAgent(gl, shape3D, turtle.size(), Color$.MODULE$.getColor(turtle.color()), turtle.labelString(), turtle.labelColor(), coords[0], coords[1], coords[2], height, patchSize, fontSize, outline, lineScale * turtle.lineThickness(), this.getOrientation(turtle));
    }

    public void renderHighlight(GL2 gl, Turtle agent) {
        this.shapeRenderer$accessor().renderHighlight(gl, agent, this.getAgentCoords(agent, 1.0), this.getOrientation(agent));
    }

    public double[] getXYandZComponents(Agent agent, double dist) {
        Turtle turtle = (Turtle)agent;
        double headingRadians = package$.MODULE$.toRadians(turtle.heading());
        double cos = package$.MODULE$.cos(headingRadians);
        double sin = package$.MODULE$.sin(headingRadians);
        if (package$.MODULE$.abs(cos) < Constants$.MODULE$.Infinitesimal()) {
            cos = 0.0;
        }
        if (package$.MODULE$.abs(sin) < Constants$.MODULE$.Infinitesimal()) {
            sin = 0.0;
        }
        return new double[]{dist * sin * (double)0.3f, dist * cos * (double)0.3f, 0.0};
    }

    public double[] getAgentCoords(Agent agent, double height) {
        Turtle turtle = (Turtle)agent;
        double[] coords = new double[]{this.world$accessor().wrappedObserverX(turtle.xcor()), this.world$accessor().wrappedObserverY(turtle.ycor()), (height - 1.0) / (double)2};
        String string = turtle.shape();
        String string2 = "default";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            coords[2] = coords[2] / (double)2;
        }
        return coords;
    }

    public double[] getOrientation(Agent agent) {
        return new double[]{((Turtle)agent).heading(), 0.0, 0.0};
    }
}

