/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.gl.render;

import com.jogamp.opengl.GL2;
import org.nlogo.api.Agent;
import org.nlogo.api.AgentException;
import org.nlogo.api.AgentFollowingPerspective;
import org.nlogo.api.DrawingInterface;
import org.nlogo.api.ObserverOrientation;
import org.nlogo.api.Patch;
import org.nlogo.api.Patch3D;
import org.nlogo.api.Perspective;
import org.nlogo.api.Turtle;
import org.nlogo.api.Turtle3D;
import org.nlogo.api.World;
import org.nlogo.api.World3D;
import org.nlogo.gl.render.DrawingRendererInterface;
import org.nlogo.gl.render.GLViewSettings;
import org.nlogo.gl.render.LinkRenderer;
import org.nlogo.gl.render.LinkRenderer3D;
import org.nlogo.gl.render.PatchRenderer3D;
import org.nlogo.gl.render.TrailRenderer3D;
import org.nlogo.gl.render.TurtleRenderer;
import org.nlogo.gl.render.TurtleRenderer3D;
import org.nlogo.gl.render.WorldRenderer;
import scala.None$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;

public class WorldRenderer3D
extends WorldRenderer {
    private final World3D world;
    private final PatchRenderer3D patchRenderer;
    private final GLViewSettings settings;

    public WorldRenderer3D(World3D world, PatchRenderer3D patchRenderer, DrawingInterface drawing, TurtleRenderer3D turtleRenderer, LinkRenderer3D linkRenderer, GLViewSettings settings) {
        this.world = world;
        this.patchRenderer = patchRenderer;
        this.settings = settings;
        super(world, patchRenderer, drawing, turtleRenderer, linkRenderer, settings);
    }

    @Override
    public DrawingRendererInterface createDrawingRenderer(World world, DrawingInterface drawing, TurtleRenderer renderer, LinkRenderer linkRenderer) {
        return new TrailRenderer3D((World3D)world, (TurtleRenderer3D)renderer, (LinkRenderer3D)linkRenderer);
    }

    @Override
    public void observePerspective(GL2 gl) {
        None$ none$;
        DoubleRef x = DoubleRef.create((double)(this.observer().oxcor() - this.world.followOffsetX()));
        DoubleRef y = DoubleRef.create((double)(this.observer().oycor() - this.world.followOffsetY()));
        DoubleRef z = DoubleRef.create((double)(this.observer().ozcor() - this.world.followOffsetZ()));
        ObserverOrientation orientation = (ObserverOrientation)this.observer().orientation().get();
        double heading = orientation.heading();
        DoubleRef pitch = DoubleRef.create((double)orientation.pitch());
        DoubleRef roll = DoubleRef.create((double)orientation.roll());
        DoubleRef dx = DoubleRef.create((double)orientation.dx());
        DoubleRef dy = DoubleRef.create((double)orientation.dy());
        double dz = orientation.dz();
        Perspective perspective = this.observer().perspective();
        if (perspective instanceof AgentFollowingPerspective) {
            Perspective afp = (Perspective)((Object)((AgentFollowingPerspective)((Object)perspective)));
            none$ = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)((AgentFollowingPerspective)((Object)afp)).targetAgent(), (Object)BoxesRunTime.boxToInteger((int)((AgentFollowingPerspective)((Object)afp)).followDistance())));
        } else {
            none$ = None$.MODULE$;
        }
        None$ turtleAndDistance = none$;
        turtleAndDistance.foreach(x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                Agent agent = (Agent)tuple2._1();
                int n = BoxesRunTime.unboxToInt((Object)tuple2._2());
                if (agent instanceof Turtle3D) {
                    Turtle3D turtle = (Turtle3D)agent;
                    if (true) {
                        double d;
                        int followDist = n;
                        double distance = followDist;
                        if (distance > 0.0) {
                            distance += turtle.size();
                        }
                        if (this.world.worldDepth() > 1) {
                            x$1.elem -= turtle.dx() * distance;
                            y$1.elem -= turtle.dy() * distance;
                            z$1.elem -= turtle.dz() * distance;
                            pitch$1.elem = -pitch$1.elem;
                            dx$1.elem = -dx$1.elem;
                            dy$1.elem = -dy$1.elem;
                            return;
                        }
                        double oldx = x$1.elem;
                        double oldy = y$1.elem;
                        double oldz = z$1.elem;
                        x$1.elem -= distance * package$.MODULE$.sin(package$.MODULE$.toRadians(heading));
                        y$1.elem -= distance * package$.MODULE$.cos(package$.MODULE$.toRadians(heading));
                        z$1.elem = distance * 0.5;
                        DoubleRef doubleRef = pitch;
                        try {
                            d = -this.world.protractor().towardsPitch(x$1.elem, y$1.elem, z$1.elem, oldx, oldy, oldz, false);
                        }
                        catch (AgentException ex) {
                            d = 0.0;
                        }
                        double d2 = d;
                        DoubleRef doubleRef2 = doubleRef;
                        doubleRef = null;
                        doubleRef2.elem = d2;
                        roll$1.elem = 0.0;
                        return;
                    }
                }
            }
        });
        gl.glRotated(90.0, -1.0, 0.0, 0.0);
        gl.glRotated(heading, 0.0, 0.0, 1.0);
        gl.glRotated(pitch.elem, package$.MODULE$.cos(package$.MODULE$.toRadians(heading)), -package$.MODULE$.sin(package$.MODULE$.toRadians(heading)), 0.0);
        gl.glRotated(-roll.elem, -dx.elem, -dy.elem, dz);
        gl.glTranslated(-(x.elem * (double)0.3f), -(y.elem * (double)0.3f), -(z.elem * (double)0.3f));
    }

    @Override
    public void renderPatchShapes(GL2 gl, Agent outlineAgent, int fontSize, double patchSize) {
        if (this.world.patches() != null) {
            Agent agent;
            if (this.world.worldDepth() > 1) {
                this.patchRenderer.renderPatches(gl, fontSize, patchSize);
            }
            if ((agent = outlineAgent) instanceof Patch) {
                Patch p = (Patch)agent;
                this.patchRenderer.renderOutline(gl, p);
                return;
            }
            return;
        }
    }

    @Override
    public void renderIndividualPatchShapes(GL2 gl, Patch3D patch, Agent outlineAgent, int fontSize, double patchSize) {
        if (this.world.patches() != null && this.world.worldDepth() > 1) {
            this.patchRenderer.renderIndividualPatch(gl, patch, fontSize, patchSize);
            return;
        }
    }

    @Override
    public void renderWorld(GL2 gl, int fontSize, double patchSize) {
        if (this.world.patches() != null) {
            if (this.world.worldDepth() == 1) {
                this.patchRenderer.renderPatchTexture(gl);
            } else {
                gl.glDisable(3553);
            }
            if (this.settings.wireframeOn()) {
                this.renderWorldWireFrame(gl);
                return;
            }
            return;
        }
    }

    public void renderTrails(GL2 gl) {
        DrawingRendererInterface drawingRendererInterface = this.drawingRenderer();
        if (drawingRendererInterface instanceof TrailRenderer3D) {
            TrailRenderer3D r = (TrailRenderer3D)drawingRendererInterface;
            r.renderTrails(gl);
            return;
        }
    }

    @Override
    public double[] getCrosshairCoords() {
        return new double[]{this.observer().oxcor() - this.world.followOffsetX(), this.observer().oycor() - this.world.followOffsetY(), this.observer().ozcor() - this.world.followOffsetZ()};
    }

    @Override
    public float[] getWorldDimensions(World world) {
        World3D w = (World3D)world;
        return new float[]{w.worldWidth(), w.worldHeight(), w.worldDepth()};
    }

    @Override
    public double[] getXYandZ(Turtle turtle) {
        Turtle3D t = (Turtle3D)turtle;
        return new double[]{t.xcor(), t.ycor(), t.zcor()};
    }

    @Override
    public double[] getOrientation(Turtle turtle) {
        Turtle3D t = (Turtle3D)turtle;
        return new double[]{t.heading(), t.pitch(), t.roll()};
    }
}

