/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.gl.view;

import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import org.nlogo.analytics.Analytics$;
import org.nlogo.api.Version$;
import org.nlogo.gl.render.ExportRenderer;
import org.nlogo.gl.render.Renderer;
import org.nlogo.gl.render.Renderer3D;
import org.nlogo.gl.view.MouseMotionHandler;
import org.nlogo.gl.view.Picker;
import org.nlogo.gl.view.ViewManager;
import org.nlogo.swing.NetLogoIcon;
import org.nlogo.swing.Utils$;
import org.nlogo.theme.ThemeSync;
import org.nlogo.window.Event;

public abstract class View
extends Frame
implements Event.LinkChild,
ThemeSync,
NetLogoIcon {
    private final ViewManager viewManager;
    private Renderer renderer;
    private GLCanvas canvas;
    private final Picker picker;
    private final MouseMotionHandler inputHandler;

    public View(String title, ViewManager viewManager, Renderer renderer) {
        this.viewManager = viewManager;
        this.renderer = renderer;
        super(title);
        NetLogoIcon.$init$(this);
        this.canvas = null;
        this.picker = new Picker(this);
        if (Version$.MODULE$.is3D()) {
            if (this.renderer() == null) {
                this.renderer_$eq(new Renderer3D(viewManager.world(), viewManager.graphicsSettings(), viewManager.workspace(), viewManager, Utils$.MODULE$.getUIScale()));
            } else {
                this.renderer().cleanUp();
                this.renderer_$eq(new Renderer3D(this.renderer()));
            }
        } else if (this.renderer() == null) {
            this.renderer_$eq(new Renderer(viewManager.world(), viewManager.graphicsSettings(), viewManager.workspace(), viewManager, Utils$.MODULE$.getUIScale()));
        } else {
            this.renderer().cleanUp();
            this.renderer_$eq(new Renderer(this.renderer()));
        }
        this.inputHandler = new MouseMotionHandler(this);
        this.createCanvas(viewManager.antiAliasingOn());
        this.setLayout(new BorderLayout());
        this.add((Component)this.canvas(), "Center");
        this.canvas().setCursor(new Cursor(1));
    }

    public ViewManager viewManager() {
        return this.viewManager;
    }

    public Renderer renderer() {
        return this.renderer;
    }

    public void renderer_$eq(Renderer x$1) {
        this.renderer = x$1;
    }

    public GLCanvas canvas() {
        return this.canvas;
    }

    public void canvas_$eq(GLCanvas x$1) {
        this.canvas = x$1;
    }

    public Picker picker() {
        return this.picker;
    }

    public MouseMotionHandler inputHandler() {
        return this.inputHandler;
    }

    public void updatePerspectiveLabel() {
    }

    public void createCanvas(boolean antiAliasing) {
        GLCapabilities capabilities = new GLCapabilities(GLProfile.get((String)"GL2"));
        capabilities.setSampleBuffers(antiAliasing);
        capabilities.setNumSamples(4);
        capabilities.setStencilBits(1);
        this.canvas_$eq(new GLCanvas((GLCapabilitiesImmutable)capabilities));
        this.canvas().addGLEventListener((GLEventListener)this.renderer());
        this.canvas().addMouseListener((MouseListener)this.inputHandler());
        this.canvas().addMouseMotionListener((MouseMotionListener)this.inputHandler());
        this.canvas().addMouseWheelListener((MouseWheelListener)this.inputHandler());
        this.canvas().addKeyListener((KeyListener)new KeyInputHandler());
    }

    @Override
    public ViewManager getLinkParent() {
        return this.viewManager();
    }

    public void updateRenderer() {
        this.renderer().update();
    }

    public void setVisible() {
        this.setVisible(true);
        this.toFront();
        this.canvas().requestFocus();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            Analytics$.MODULE$.threedViewOpen();
        }
        super.setVisible(visible);
    }

    public void display() {
        this.canvas().display();
    }

    public void invalidateTurtleShape(String shape) {
        this.renderer().invalidateTurtleShape(shape);
    }

    public void invalidateLinkShape(String shape) {
        this.renderer().invalidateLinkShape(shape);
    }

    public void resetPerspective() {
        this.viewManager().world().observer().resetPerspective();
        this.display();
        this.updatePerspectiveLabel();
    }

    public BufferedImage exportView() {
        ExportRenderer exporter = this.renderer().createExportRenderer();
        this.canvas().addGLEventListener((GLEventListener)exporter);
        this.canvas().display();
        this.canvas().removeGLEventListener((GLEventListener)exporter);
        BufferedImage bufferedImage = new BufferedImage(exporter.getWidth(), exporter.getHeight(), 2);
        bufferedImage.setRGB(0, 0, exporter.getWidth(), exporter.getHeight(), exporter.pixelInts(), 0, exporter.getWidth());
        return bufferedImage;
    }

    public boolean editFinished() {
        this.renderer().cleanUp();
        this.display();
        return true;
    }

    public void doPopup(MouseEvent e) {
        this.renderer().queuePick(e.getPoint(), this.picker());
        e.consume();
    }

    @Override
    public void dispose() {
        this.renderer().cleanUp();
        super.dispose();
    }

    public class KeyInputHandler
    extends KeyAdapter {
        public KeyInputHandler() {
            if (View.this == null) {
                throw new NullPointerException();
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                View.this.viewManager().setFullscreen(false);
                return;
            }
        }

        public final /* synthetic */ View org$nlogo$gl$view$View$KeyInputHandler$$$outer() {
            return View.this;
        }
    }
}

