/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.gl.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.nlogo.api.Agent;
import org.nlogo.api.Perspective;
import org.nlogo.api.Perspective$Follow$;
import org.nlogo.api.Perspective$Observe$;
import org.nlogo.api.Perspective$Ride$;
import org.nlogo.api.Perspective$Watch$;
import org.nlogo.core.I18N;
import org.nlogo.core.I18N$;
import org.nlogo.core.I18N$Prefix$;
import org.nlogo.gl.view.MouseMotionHandler;
import org.nlogo.gl.view.MouseMotionHandler$InterfaceMode$;
import org.nlogo.gl.view.MouseMotionHandler$OrbitMode$;
import org.nlogo.gl.view.MouseMotionHandler$TranslateMode$;
import org.nlogo.gl.view.MouseMotionHandler$ZoomMode$;
import org.nlogo.gl.view.View;
import org.nlogo.swing.Button;
import org.nlogo.swing.OptionPane;
import org.nlogo.swing.OptionPane$Icons$;
import org.nlogo.swing.ToolBarToggleButton;
import org.nlogo.swing.Transparent;
import org.nlogo.theme.InterfaceColors$;
import org.nlogo.theme.ThemeSync;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

public class ViewControlToolBar
extends JPanel
implements ThemeSync {
    private final View view;
    public final MouseMotionHandler org$nlogo$gl$view$ViewControlToolBar$$inputHandler;
    private final I18N.Prefix i18nPrefix;
    private final ModeButton orbitButton;
    private final ModeButton zoomButton;
    private final ModeButton moveButton;
    private final ModeButton interactButton;
    private final Button resetButton;
    private final Button fullScreenButton;
    private final JLabel status;
    private Option<Perspective> perspective;

    public ViewControlToolBar(View view, MouseMotionHandler inputHandler) {
        this.view = view;
        this.org$nlogo$gl$view$ViewControlToolBar$$inputHandler = inputHandler;
        super(new GridBagLayout());
        this.i18nPrefix = I18N$Prefix$.MODULE$.apply("view.3d");
        this.orbitButton = new ModeButton(I18N$.MODULE$.gui().apply("orbit", this.i18nPrefix), MouseMotionHandler$OrbitMode$.MODULE$);
        this.zoomButton = new ModeButton(I18N$.MODULE$.gui().apply("zoom", this.i18nPrefix), MouseMotionHandler$ZoomMode$.MODULE$);
        this.moveButton = new ModeButton(I18N$.MODULE$.gui().apply("move", this.i18nPrefix), MouseMotionHandler$TranslateMode$.MODULE$);
        this.interactButton = new ModeButton(I18N$.MODULE$.gui().apply("interact", this.i18nPrefix), MouseMotionHandler$InterfaceMode$.MODULE$);
        this.resetButton = new Button(I18N$.MODULE$.gui().apply("resetPerspective", this.i18nPrefix), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> view.resetPerspective());
        this.fullScreenButton = new Button(I18N$.MODULE$.gui().apply("fullScreen", this.i18nPrefix), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Seq options = (Seq)((SeqOps)new .colon.colon((Object)I18N$.MODULE$.gui().get("common.buttons.continue"), (List)new .colon.colon((Object)I18N$.MODULE$.gui().get("common.buttons.cancel"), (List)Nil$.MODULE$)));
            boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("win");
            if (!isWindows || view.viewManager().warned() || new OptionPane(view, I18N$.MODULE$.gui().get("common.messages.warning"), I18N$.MODULE$.gui().apply("fullScreenWarning", this.i18nPrefix), (Seq<String>)options, OptionPane$Icons$.MODULE$.Warning()).getSelectedIndex() == 0) {
                view.viewManager().setFullscreen(true);
                view.viewManager().warned_$eq(true);
                return;
            }
        });
        this.status = new JLabel();
        this.perspective = None$.MODULE$;
        ButtonGroup group = new ButtonGroup();
        group.add(this.orbitButton);
        group.add(this.zoomButton);
        group.add(this.moveButton);
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.orbitButton, c);
        c.insets = new Insets(6, 0, 6, 6);
        this.add((Component)this.zoomButton, c);
        this.add((Component)this.moveButton, c);
        if (!view.viewManager().workspace().world().program().dialect().is3D()) {
            this.add((Component)this.interactButton, c);
            group.add(this.interactButton);
        }
        this.add(this.status);
        c.weightx = 1.0;
        this.add((Component)((Object)new Transparent(){
            {
                Transparent.$init$(this);
            }
        }), c);
        c.weightx = 0.0;
        this.add((Component)this.resetButton, c);
        this.add((Component)this.fullScreenButton, c);
        this.status.setFont(this.status.getFont().deriveFont(1));
        this.orbitButton.doClick();
        this.setButtonsEnabled(true);
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
    }

    public void setStatus(Perspective perspective) {
        Object object = this.perspective.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Perspective perspective2 = perspective;
        if (object == null ? perspective2 != null : !object.equals(perspective2)) {
            this.perspective = Option$.MODULE$.apply((Object)perspective);
            this.status.setText(perspective.toString());
            Perspective perspective3 = perspective;
            if (Perspective$Observe$.MODULE$.equals(perspective3)) {
                this.setButtonsEnabled(true);
                return;
            }
            if (perspective3 instanceof Perspective.Watch) {
                Agent agent;
                Perspective.Watch watch = Perspective$Watch$.MODULE$.unapply((Perspective.Watch)perspective3);
                Agent a = agent = watch._1();
                this.orbitButton.setEnabled(true);
                this.zoomButton.setEnabled(true);
                this.moveButton.setEnabled(false);
                if (this.moveButton.isSelected()) {
                    this.orbitButton.doClick();
                    return;
                }
                return;
            }
            if (perspective3 instanceof Perspective.Ride) {
                Agent agent;
                Perspective.Ride ride = Perspective$Ride$.MODULE$.unapply((Perspective.Ride)perspective3);
                Agent a = agent = ride._1();
                this.setButtonsEnabled(false);
                this.zoomButton.setEnabled(true);
                if (!this.interactButton.isSelected() && !this.zoomButton.isSelected()) {
                    this.zoomButton.doClick();
                    return;
                }
                return;
            }
            if (perspective3 instanceof Perspective.Follow) {
                Perspective.Follow follow = Perspective$Follow$.MODULE$.unapply((Perspective.Follow)perspective3);
                Agent agent = follow._1();
                int n = follow._2();
                Agent a = agent;
                this.setButtonsEnabled(false);
                this.zoomButton.setEnabled(true);
                if (!this.interactButton.isSelected() && !this.zoomButton.isSelected()) {
                    this.zoomButton.doClick();
                    return;
                }
                return;
            }
            throw new MatchError((Object)perspective3);
        }
    }

    private void setButtonsEnabled(boolean enabled) {
        this.orbitButton.setEnabled(enabled);
        this.zoomButton.setEnabled(enabled);
        this.moveButton.setEnabled(enabled);
    }

    @Override
    public void syncTheme() {
        this.setBackground(InterfaceColors$.MODULE$.toolbarBackground());
        this.status.setForeground(InterfaceColors$.MODULE$.toolbarText());
        this.resetButton.syncTheme();
        this.fullScreenButton.syncTheme();
    }

    public AbstractAction org$nlogo$gl$view$ViewControlToolBar$$ModeButton$superArg$1(String name, MouseMotionHandler.Mode mode) {
        return new AbstractAction(name, mode, this){
            private final MouseMotionHandler.Mode mode$2;
            private final /* synthetic */ ViewControlToolBar $outer;
            {
                this.mode$2 = mode$1;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super(name$1);
            }

            public void actionPerformed(ActionEvent e) {
                this.$outer.org$nlogo$gl$view$ViewControlToolBar$$inputHandler.setMovementMode(this.mode$2);
            }
        };
    }

    public class ModeButton
    extends ToolBarToggleButton {
        public ModeButton(String name, MouseMotionHandler.Mode mode) {
            if (ViewControlToolBar.this == null) {
                throw new NullPointerException();
            }
            super(ViewControlToolBar.this.org$nlogo$gl$view$ViewControlToolBar$$ModeButton$superArg$1(name, mode));
            this.setBorder(new EmptyBorder(3, 12, 3, 12));
        }

        public final /* synthetic */ ViewControlToolBar org$nlogo$gl$view$ViewControlToolBar$ModeButton$$$outer() {
            return ViewControlToolBar.this;
        }
    }
}

