/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.gl.view;

import java.awt.Component;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.JFrame;
import org.nlogo.agent.World;
import org.nlogo.api.ViewSettings;
import org.nlogo.awt.EventQueue$;
import org.nlogo.awt.Positioning$;
import org.nlogo.core.I18N$;
import org.nlogo.core.Shape;
import org.nlogo.gl.render.GLViewSettings;
import org.nlogo.gl.render.Renderer;
import org.nlogo.gl.view.FullscreenView;
import org.nlogo.gl.view.ObserverView;
import org.nlogo.gl.view.View;
import org.nlogo.shape.InvalidShapeDescriptionException;
import org.nlogo.swing.Utils$;
import org.nlogo.window.Event;
import org.nlogo.window.Events;
import org.nlogo.window.GLViewManagerInterface;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.JOGLLoadingException;
import org.nlogo.window.JOGLVersionMismatchException;
import org.nlogo.window.LinkRoot;
import org.nlogo.window.TickCounterLabel;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Some$;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

public class ViewManager
implements GLViewManagerInterface,
Event.LinkChild,
Event.LinkParent,
Events.PeriodicUpdateEvent.Handler,
LinkRoot,
GLViewSettings {
    private ListBuffer linkComponents;
    private final GUIWorkspace workspace;
    private final JFrame appWindow;
    private final KeyListener keyListener;
    private final World world;
    private Option<View> currentView;
    private Option<ObserverView> observerView;
    private final TickCounterLabel tickCounterLabel;
    private Option<FullscreenView> fullscreenView;
    private boolean fullscreen;
    private boolean paintingImmediately;
    private boolean _framesSkipped;
    private final Runnable paintRunnable;
    private boolean antiAliasing;
    private boolean wireframeOn;
    private boolean warned;

    public ViewManager(GUIWorkspace workspace, JFrame appWindow, KeyListener keyListener) {
        this.workspace = workspace;
        this.appWindow = appWindow;
        this.keyListener = keyListener;
        LinkRoot.$init$(this);
        this.world = workspace.world();
        this.currentView = None$.MODULE$;
        this.observerView = None$.MODULE$;
        this.tickCounterLabel = new TickCounterLabel(workspace.world());
        this.addLinkComponent(this.tickCounterLabel());
        this.fullscreenView = None$.MODULE$;
        this.fullscreen = false;
        this.paintingImmediately = false;
        this._framesSkipped = false;
        this.paintRunnable = new Runnable(this){
            private final /* synthetic */ ViewManager $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void run() {
                this.$outer.incrementalUpdateFromEventThread();
            }
        };
        this.antiAliasing = true;
        this.wireframeOn = true;
        this.warned = false;
        Statics.releaseFence();
    }

    public ListBuffer linkComponents() {
        return this.linkComponents;
    }

    @Override
    public void org$nlogo$window$LinkRoot$_setter_$linkComponents_$eq(ListBuffer x$0) {
        this.linkComponents = x$0;
    }

    public GUIWorkspace workspace() {
        return this.workspace;
    }

    public World world() {
        return this.world;
    }

    public Option<View> currentView() {
        return this.currentView;
    }

    public void currentView_$eq(Option<View> x$1) {
        this.currentView = x$1;
    }

    public Option<ObserverView> observerView() {
        return this.observerView;
    }

    public void observerView_$eq(Option<ObserverView> x$1) {
        this.observerView = x$1;
    }

    public TickCounterLabel tickCounterLabel() {
        return this.tickCounterLabel;
    }

    public boolean paintingImmediately() {
        return this.paintingImmediately;
    }

    public void paintingImmediately_$eq(boolean x$1) {
        this.paintingImmediately = x$1;
    }

    @Override
    public void framesSkipped() {
        this._framesSkipped = true;
    }

    @Override
    public JFrame getLinkParent() {
        return this.appWindow;
    }

    @Override
    public void open() throws JOGLLoadingException {
        Option<ObserverView> option = this.observerView();
        if (option instanceof Some) {
            ObserverView view = (ObserverView)((Some)option).value();
            view.toFront();
            view.updatePerspectiveLabel();
        } else {
            try {
                this.init();
            }
            catch (JOGLVersionMismatchException vex) {
                Utils$.MODULE$.alert(vex.getMessage(), I18N$.MODULE$.gui().get("common.buttons.continue"));
            }
            catch (JOGLLoadingException ex) {
                this.observerView().foreach(_$1 -> _$1.dispose());
                this.observerView_$eq((Option<ObserverView>)None$.MODULE$);
                throw ex;
            }
        }
        this.syncTheme();
    }

    public void init() {
        this.observerView().foreach(_$2 -> _$2.dispose());
        try {
            ObserverView view = new ObserverView(this, null);
            this.observerView_$eq((Option<ObserverView>)Option$.MODULE$.apply((Object)view));
            view.canvas().addKeyListener(this.keyListener);
            this.currentView_$eq(this.observerView());
            Positioning$.MODULE$.moveNextTo(view, this.appWindow);
            this.currentView().foreach(_$3 -> _$3.updatePerspectiveLabel());
            view.setVisible(true);
        }
        catch (UnsatisfiedLinkError e) {
            throw new JOGLLoadingException("NetLogo could not load the JOGL native libraries on your computer.\n\nWrite bugs@ccl.northwestern.edu for assistance.", e);
        }
    }

    public void setFullscreen(boolean fullscreen) {
        if (fullscreen != this.isFullscreen()) {
            GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            this.world().markPatchColorsDirty();
            if (fullscreen) {
                if (!gd.isFullScreenSupported()) {
                    throw new UnsupportedOperationException("This graphics environment does not support full screen mode");
                }
                this.currentView().foreach(_$4 -> _$4.setVisible(true));
                this.appWindow.setVisible(false);
                FullscreenView view = new FullscreenView(this, (Renderer)this.currentView().map((Function1 & Serializable)_$5 -> _$5.renderer()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                this.fullscreenView = Some$.MODULE$.apply((Object)view);
                view.canvas().addKeyListener(this.keyListener);
                view.init();
                this.observerView().foreach(_$6 -> _$6.setVisible(false));
                this.currentView_$eq(this.fullscreenView);
                this.fullscreen = true;
                return;
            }
            this.appWindow.setVisible(true);
            gd.setFullScreenWindow(null);
            this.observerView().foreach(_$7 -> _$7.setVisible(true));
            this.observerView().foreach(_$8 -> _$8.display());
            this.observerView().foreach(_$9 -> _$9.updateRenderer());
            this.fullscreen = false;
            this.currentView_$eq(this.observerView());
            this.fullscreenView.foreach(_$10 -> _$10.dispose());
            this.fullscreenView = None$.MODULE$;
            return;
        }
    }

    @Override
    public boolean isFullscreen() {
        return this.fullscreen;
    }

    @Override
    public void editFinished() {
        this.currentView().foreach((Function1 & Serializable)_$11 -> _$11.editFinished());
    }

    public boolean is3D() {
        return this.currentView().isDefined();
    }

    @Override
    public boolean isDead() {
        return false;
    }

    @Override
    public void close() {
        this.currentView().foreach(view -> {
            this.workspace().set2DViewEnabled(true);
            view.dispose();
            this.observerView_$eq((Option<ObserverView>)None$.MODULE$);
            this.currentView_$eq((Option<View>)None$.MODULE$);
        });
    }

    public void incrementalUpdateFromJobThread() {
        try {
            EventQueue$.MODULE$.invokeAndWait(this.paintRunnable);
        }
        catch (InterruptedException ex) {
            this.repaint();
        }
    }

    @Override
    public void incrementalUpdateFromEventThread() {
        this.currentView().foreach(view -> {
            this.workspace().updateManager().beginPainting();
            view.display();
            this.workspace().updateManager().donePainting();
            view.updatePerspectiveLabel();
        });
    }

    @Override
    public void repaint() {
        this.currentView().foreach(view -> {
            this.workspace().updateManager().beginPainting();
            view.display();
            this.workspace().updateManager().donePainting();
            view.updatePerspectiveLabel();
            this._framesSkipped = false;
        });
    }

    @Override
    public void antiAliasingOn(boolean antiAliasing) {
        this.antiAliasing = antiAliasing;
        this.currentView().foreach(view -> {
            this.world().markPatchColorsDirty();
            this.observerView_$eq((Option<ObserverView>)Option$.MODULE$.apply((Object)new ObserverView(this, view.renderer(), view.getBounds())));
            view.dispose();
            this.currentView_$eq(this.observerView());
            this.currentView().foreach(_$12 -> _$12.setVisible(true));
        });
    }

    @Override
    public boolean antiAliasingOn() {
        return this.antiAliasing;
    }

    @Override
    public boolean wireframeOn() {
        return this.wireframeOn;
    }

    public void wireframeOn_$eq(boolean x$1) {
        this.wireframeOn = x$1;
    }

    @Override
    public void setWireframeOn(boolean on) {
        this.wireframeOn_$eq(on);
    }

    @Override
    public void paintImmediately(boolean force) {
        if (this.viewIsVisible() && (this._framesSkipped || force)) {
            this.paintingImmediately_$eq(true);
            this.repaint();
            this.paintingImmediately_$eq(false);
            return;
        }
    }

    @Override
    public boolean viewIsVisible() {
        return this.currentView().exists((Function1 & Serializable)_$13 -> _$13.isShowing());
    }

    @Override
    public Component getExportWindowFrame() {
        return (Component)this.currentView().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public BufferedImage exportView() {
        return (BufferedImage)this.currentView().map((Function1 & Serializable)_$14 -> _$14.exportView()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public void addLinkComponent(Object c) {
        this.linkComponents().clear();
        LinkRoot.addLinkComponent$(this, c);
    }

    @Override
    public void handle(Events.PeriodicUpdateEvent e) {
        this.observerView().foreach(_$15 -> _$15.controlStrip().updateTicks());
    }

    @Override
    public boolean displayOn() {
        return this.workspace().displaySwitchOn();
    }

    @Override
    public void displayOn(boolean displayOn) {
        this.workspace().displaySwitchOn(displayOn);
    }

    public ViewSettings graphicsSettings() {
        return this.workspace().view();
    }

    @Override
    public double mouseXCor() {
        return BoxesRunTime.unboxToDouble((Object)this.currentView().map((Function1 & Serializable)_$16 -> _$16.renderer().mouseXCor()).getOrElse(ViewManager::mouseXCor$$anonfun$2));
    }

    @Override
    public double mouseYCor() {
        return BoxesRunTime.unboxToDouble((Object)this.currentView().map((Function1 & Serializable)_$17 -> _$17.renderer().mouseYCor()).getOrElse(ViewManager::mouseYCor$$anonfun$2));
    }

    @Override
    public void resetMouseCors() {
        this.currentView().foreach(_$18 -> _$18.renderer().resetMouseCors());
    }

    @Override
    public boolean mouseDown() {
        return this.currentView().exists((Function1 & Serializable)_$19 -> _$19.renderer().mouseDown());
    }

    @Override
    public boolean mouseInside() {
        return this.currentView().exists((Function1 & Serializable)_$20 -> _$20.renderer().mouseInside());
    }

    @Override
    public void shapeChanged(Shape shape) {
        this.currentView().foreach(view -> {
            Shape shape = shape;
            if (shape instanceof Shape.VectorShape) {
                view.invalidateTurtleShape(shape.name());
            } else if (shape instanceof Shape.LinkShape) {
                view.invalidateLinkShape(shape.name());
            } else {
                throw new MatchError((Object)shape);
            }
            this.repaint();
        });
    }

    @Override
    public void addCustomShapes(String filename) throws InvalidShapeDescriptionException, IOException {
        this.currentView().foreach(_$21 -> _$21.renderer().addCustomShapes(filename));
    }

    @Override
    public void displaySwitch(boolean on) {
        this.observerView().foreach(_$22 -> _$22.controlStrip().displaySwitch().setOn(on));
    }

    @Override
    public boolean displaySwitch() {
        return this.observerView().exists((Function1 & Serializable)_$23 -> _$23.controlStrip().displaySwitch().isSelected());
    }

    @Override
    public void applyNewFontSize(int fontSize, int zoom) {
    }

    public boolean warned() {
        return this.warned;
    }

    public void warned_$eq(boolean x$1) {
        this.warned = x$1;
    }

    @Override
    public void syncTheme() {
        this.observerView().foreach(_$24 -> _$24.syncTheme());
        this.fullscreenView.foreach(_$25 -> _$25.syncTheme());
    }

    private static final double mouseXCor$$anonfun$2() {
        return 0.0;
    }

    private static final double mouseYCor$$anonfun$2() {
        return 0.0;
    }
}

