/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.headless;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.StringTokenizer;
import org.nlogo.agent.CompilationManagement;
import org.nlogo.agent.ImporterJ;
import org.nlogo.agent.OutputObject;
import org.nlogo.agent.World;
import org.nlogo.api.Agent;
import org.nlogo.api.AggregateManagerInterface;
import org.nlogo.api.CommandRunnable;
import org.nlogo.api.ComponentSerialization;
import org.nlogo.api.ConfigurableModelLoader;
import org.nlogo.api.Dump$;
import org.nlogo.api.Exceptions$;
import org.nlogo.api.FileIO$;
import org.nlogo.api.FormatterPair;
import org.nlogo.api.JobOwner;
import org.nlogo.api.LocalFile;
import org.nlogo.api.LogoException;
import org.nlogo.api.ModelReader$;
import org.nlogo.api.ModelType$New$;
import org.nlogo.api.ModelType$Normal$;
import org.nlogo.api.NetLogoLegacyDialect$;
import org.nlogo.api.NetLogoThreeDDialect$;
import org.nlogo.api.Perspective;
import org.nlogo.api.RendererInterface;
import org.nlogo.api.ReporterRunnable;
import org.nlogo.core.AgentKind;
import org.nlogo.core.CompilerException;
import org.nlogo.core.Dialect;
import org.nlogo.core.Femto$;
import org.nlogo.core.File;
import org.nlogo.core.FileMode$Write$;
import org.nlogo.core.Model;
import org.nlogo.core.Output;
import org.nlogo.core.Program;
import org.nlogo.core.Program$;
import org.nlogo.core.UpdateMode;
import org.nlogo.core.WorldDimensions;
import org.nlogo.core.WorldDimensions3D;
import org.nlogo.core.WorldDimensions3D$;
import org.nlogo.fileformat.FileFormat$;
import org.nlogo.fileformat.NLogoAnyLoader;
import org.nlogo.fileformat.NLogoFormat;
import org.nlogo.fileformat.NLogoThreeDFormat;
import org.nlogo.headless.ErrorReport;
import org.nlogo.headless.HeadlessModelOpener;
import org.nlogo.headless.HeadlessWorkspace$;
import org.nlogo.nvm.CompilerResults;
import org.nlogo.nvm.Context;
import org.nlogo.nvm.ExperimentManager;
import org.nlogo.nvm.Instruction;
import org.nlogo.nvm.LabInterface;
import org.nlogo.nvm.PresentationCompilerInterface;
import org.nlogo.nvm.PrimaryWorkspace;
import org.nlogo.plot.Plot;
import org.nlogo.shape.LinkShape$;
import org.nlogo.shape.VectorShape$;
import org.nlogo.workspace.AbstractWorkspaceScala;
import org.nlogo.workspace.Controllable;
import org.nlogo.workspace.HubNetManagerFactory;
import org.nlogo.workspace.WorldLoaderInterface;
import scala.Function1;
import scala.Int$;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.SeqOps;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class HeadlessWorkspace
extends AbstractWorkspaceScala
implements Controllable,
WorldLoaderInterface,
PrimaryWorkspace {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(HeadlessWorkspace.class.getDeclaredField("loader$lzy1"));
    private ExperimentManager org$nlogo$nvm$PrimaryWorkspace$$experimentManager;
    private final World _world;
    private final PresentationCompilerInterface compiler;
    private final RendererInterface renderer;
    private final AggregateManagerInterface aggregateManager;
    private PrimaryWorkspace primaryWorkspace;
    private boolean mirrorHeadlessOutput;
    private Option<Model> _openModel;
    private final StringBuilder outputAreaBuffer;
    private boolean silent;
    private boolean _is3d;
    private boolean compilerTestingMode;
    private double _frameRate;
    private String _tickCounterLabel;
    private boolean _showTickCounter;
    private ImporterJ.ErrorHandler importerErrorHandler;
    private ErrorReport lastErrorReport;
    private volatile Object loader$lzy1;

    public static String TestDeclarations() {
        return HeadlessWorkspace$.MODULE$.TestDeclarations();
    }

    public static HeadlessWorkspace newInstance() {
        return HeadlessWorkspace$.MODULE$.newInstance();
    }

    public static HeadlessWorkspace newInstance(boolean bl) {
        return HeadlessWorkspace$.MODULE$.newInstance(bl);
    }

    public static HeadlessWorkspace newInstance(Class<? extends HeadlessWorkspace> clazz) {
        return HeadlessWorkspace$.MODULE$.newInstance(clazz);
    }

    public static HeadlessWorkspace newInstance(Class<? extends HeadlessWorkspace> clazz, boolean bl) {
        return HeadlessWorkspace$.MODULE$.newInstance(clazz, bl);
    }

    public static LabInterface newLab() {
        return HeadlessWorkspace$.MODULE$.newLab();
    }

    public static LabInterface newLab(boolean bl) {
        return HeadlessWorkspace$.MODULE$.newLab(bl);
    }

    public HeadlessWorkspace(World _world, PresentationCompilerInterface compiler, RendererInterface renderer, AggregateManagerInterface aggregateManager, HubNetManagerFactory hubNetManagerFactory) {
        this._world = _world;
        this.compiler = compiler;
        this.renderer = renderer;
        this.aggregateManager = aggregateManager;
        super(_world, hubNetManagerFactory);
        PrimaryWorkspace.$init$(this);
        this.primaryWorkspace = this;
        this.mirrorHeadlessOutput = false;
        this.world().trailDrawer(renderer.trailDrawer());
        this._openModel = Option$.MODULE$.empty();
        this.outputAreaBuffer = new StringBuilder();
        this.silent = false;
        this._is3d = false;
        this.compilerTestingMode = false;
        this._frameRate = 0.0;
        this._tickCounterLabel = "ticks";
        this._showTickCounter = true;
        this.importerErrorHandler = new ImporterJ.ErrorHandler(){

            public boolean showError(String title, String errorDetails, boolean fatalError) {
                System.err.println("got a " + (fatalError ? "" : "non") + "fatal error " + title + ": " + errorDetails);
                return true;
            }
        };
        this.lastErrorReport = null;
        Statics.releaseFence();
    }

    @Override
    public ExperimentManager org$nlogo$nvm$PrimaryWorkspace$$experimentManager() {
        return this.org$nlogo$nvm$PrimaryWorkspace$$experimentManager;
    }

    @Override
    public void org$nlogo$nvm$PrimaryWorkspace$_setter_$org$nlogo$nvm$PrimaryWorkspace$$experimentManager_$eq(ExperimentManager x$0) {
        this.org$nlogo$nvm$PrimaryWorkspace$$experimentManager = x$0;
    }

    @Override
    public PresentationCompilerInterface compiler() {
        return this.compiler;
    }

    @Override
    public RendererInterface renderer() {
        return this.renderer;
    }

    @Override
    public AggregateManagerInterface aggregateManager() {
        return this.aggregateManager;
    }

    private HubNetManagerFactory hubNetManagerFactory$accessor() {
        return super.hubNetManagerFactory();
    }

    @Override
    public PrimaryWorkspace getPrimaryWorkspace() {
        return this.primaryWorkspace;
    }

    public void setPrimaryWorkspace(PrimaryWorkspace workspace) {
        this.primaryWorkspace = workspace;
    }

    public void setMirrorHeadlessOutput(boolean b) {
        this.mirrorHeadlessOutput = b;
    }

    public boolean modelOpened() {
        return this._openModel.nonEmpty();
    }

    public void setOpenModel(Model model) {
        this._openModel = Some$.MODULE$.apply((Object)model);
        this.resourceManager.setResources(model.resources());
    }

    public StringBuilder outputAreaBuffer() {
        return this.outputAreaBuffer;
    }

    public boolean silent() {
        return this.silent;
    }

    public void silent_$eq(boolean x$1) {
        this.silent = x$1;
    }

    @Override
    public boolean isHeadless() {
        return true;
    }

    public void set3d(boolean newMode) {
        this._is3d = newMode;
    }

    public boolean is3d() {
        return this._is3d;
    }

    @Override
    public boolean compilerTestingMode() {
        return this.compilerTestingMode;
    }

    public void compilerTestingMode_$eq(boolean x$1) {
        this.compilerTestingMode = x$1;
    }

    @Override
    public void waitFor(CommandRunnable runnable) {
        runnable.run();
    }

    @Override
    public <T> T waitForResult(ReporterRunnable<T> runnable) {
        return runnable.run();
    }

    @Override
    public void waitForQueuedEvents() {
    }

    public void initForTesting(int worldSize) {
        this.initForTesting(worldSize, "");
    }

    public void initForTesting(int worldSize, String modelString) {
        if (this.is3d()) {
            this.initForTesting(new WorldDimensions3D(-worldSize, worldSize, -worldSize, worldSize, -worldSize, worldSize, WorldDimensions3D$.MODULE$.$lessinit$greater$default$7(), WorldDimensions3D$.MODULE$.$lessinit$greater$default$8(), WorldDimensions3D$.MODULE$.$lessinit$greater$default$9(), WorldDimensions3D$.MODULE$.$lessinit$greater$default$10()), modelString);
            return;
        }
        this.initForTesting(-worldSize, worldSize, -worldSize, worldSize, modelString);
    }

    public void initForTesting(int minPxcor, int maxPxcor, int minPycor, int maxPycor, String source) {
        this.initForTesting(new WorldDimensions(minPxcor, maxPxcor, minPycor, maxPycor), source);
    }

    public void initForTesting(WorldDimensions d, String source) {
        this.world().turtleShapes().add(VectorShape$.MODULE$.getDefaultShape());
        this.world().linkShapes().add(LinkShape$.MODULE$.getDefaultLinkShape());
        this.world().createPatches(d);
        Dialect dialect = this.is3d() ? NetLogoThreeDDialect$.MODULE$ : NetLogoLegacyDialect$.MODULE$;
        Program newProgram = Program$.MODULE$.fromDialect(dialect);
        CompilerResults results = this.compiler().compileProgram(source, newProgram, this.getExtensionManager(), this.getLibraryManager(), this.getCompilationEnvironment(), false, this.compiler().compileProgram$default$7());
        this.procedures_$eq((ListMap)results.proceduresMap());
        this.codeBits.clear();
        this.init();
        ((CompilationManagement)((Object)this._world)).program_$eq(results.program());
        this.world().realloc();
        this.plotManager().forgetAll();
        Plot plot1 = this.plotManager().newPlot("plot1");
        plot1.createPlotPen("pen1", false);
        plot1.createPlotPen("pen2", false);
        Plot plot2 = this.plotManager().newPlot("plot2");
        plot2.createPlotPen("pen1", false);
        plot2.createPlotPen("pen2", false);
        this.plotManager().compileAllPlots();
        this.clearDrawing();
    }

    public void initForTesting(WorldDimensions d) {
        this.world().createPatches(d);
        this.world().realloc();
        this.clearDrawing();
    }

    @Override
    public void setDimensions(WorldDimensions d) {
        this.world().createPatches(d);
        this.clearDrawing();
    }

    @Override
    public void setDimensions(WorldDimensions d, double patchSize) {
        this.world().patchSize(patchSize);
        if (!this.compilerTestingMode()) {
            this.world().createPatches(d);
        }
        this.renderer().resetCache(patchSize);
        this.clearDrawing();
    }

    @Override
    public double frameRate() {
        return this._frameRate;
    }

    @Override
    public void frameRate(double frameRate) {
        this._frameRate = frameRate;
    }

    @Override
    public String tickCounterLabel() {
        return this._tickCounterLabel;
    }

    @Override
    public void tickCounterLabel(Option<String> s) {
        this._tickCounterLabel = (String)s.getOrElse(HeadlessWorkspace::tickCounterLabel$$anonfun$1);
    }

    @Override
    public boolean showTickCounter() {
        return this._showTickCounter;
    }

    @Override
    public void showTickCounter(boolean showTickCounter) {
        this._showTickCounter = showTickCounter;
    }

    @Override
    public int getMinimumWidth() {
        return 0;
    }

    @Override
    public int insetWidth() {
        return 0;
    }

    @Override
    public double computePatchSize(int width, int numPatches) {
        return (double)width / (double)numPatches;
    }

    @Override
    public int calculateHeight(int worldHeight, double patchSize) {
        return (int)((double)worldHeight * patchSize);
    }

    @Override
    public int calculateWidth(int worldWidth, double patchSize) {
        return (int)((double)worldWidth * patchSize);
    }

    @Override
    public void resizeView() {
    }

    @Override
    public double viewWidth() {
        return Int$.MODULE$.int2double(this.world().worldWidth());
    }

    @Override
    public double viewHeight() {
        return Int$.MODULE$.int2double(this.world().worldHeight());
    }

    @Override
    public void patchSize(double patchSize) {
        this.world().patchSize(patchSize);
        this.renderer().resetCache(patchSize);
        this.renderer().trailDrawer().rescaleDrawing();
    }

    @Override
    public double patchSize() {
        return this.world().patchSize();
    }

    @Override
    public void changeTopology(boolean wrapX, boolean wrapY) {
        this.world().changeTopology(wrapX, wrapY);
        this.renderer().changeTopology(wrapX, wrapY);
    }

    @Override
    public Perspective perspective() {
        return this.world().observer().perspective();
    }

    @Override
    public boolean drawSpotlight() {
        return true;
    }

    @Override
    public boolean renderPerspective() {
        return true;
    }

    @Override
    public double viewOffsetX() {
        return this.world().observer().followOffsetX();
    }

    @Override
    public double viewOffsetY() {
        return this.world().observer().followOffsetY();
    }

    @Override
    public void updateMode(UpdateMode updateMode) {
    }

    @Override
    public void setSize(int x, int y) {
    }

    @Override
    public void clearTurtles() {
        if (!this.compilerTestingMode()) {
            this.world().clearTurtles();
            return;
        }
    }

    @Override
    public void inspectAgent(Agent agent, double radius) {
        if (!this.silent()) {
            Predef$.MODULE$.println((Object)agent);
            return;
        }
    }

    @Override
    public void inspectAgent(AgentKind agentClass, org.nlogo.agent.Agent agent, double radius) {
        if (!this.silent()) {
            Predef$.MODULE$.println((Object)agent);
            return;
        }
    }

    @Override
    public void stopInspectingAgent(org.nlogo.agent.Agent agent) {
    }

    @Override
    public void stopInspectingDeadAgents() {
    }

    @Override
    public BufferedImage getAndCreateDrawing() {
        return this.renderer().trailDrawer().getAndCreateDrawing(true);
    }

    @Override
    public void importDrawing(InputStream is, Option<String> mimeTypeOpt) {
        this.renderer().trailDrawer().importDrawing(is, mimeTypeOpt);
    }

    public Option<String> importDrawing$default$2() {
        return None$.MODULE$;
    }

    @Override
    public void importDrawing(File file) {
        this.renderer().trailDrawer().importDrawing(file);
    }

    @Override
    public void clearDrawing() {
        this.world().clearDrawing();
        this.renderer().trailDrawer().clearDrawing();
    }

    @Override
    public void exportDrawing(String filename, String format) {
        FileIO$.MODULE$.writeImageFile(this.renderer().trailDrawer().getAndCreateDrawing(true), filename, format);
    }

    @Override
    public void exportDrawingToCSV(PrintWriter writer) {
        this.renderer().trailDrawer().exportDrawingToCSV(writer);
    }

    @Override
    public void exportOutput(String filename) {
        LocalFile file = new LocalFile(filename);
        try {
            ((File)file).open(FileMode$Write$.MODULE$);
            StringTokenizer lines = new StringTokenizer(this.outputAreaBuffer().toString(), "\n");
            while (lines.hasMoreTokens()) {
                ((File)file).println(lines.nextToken());
            }
            ((File)file).close(true);
        }
        catch (IOException ex) {
            try {
                ((File)file).close(false);
            }
            catch (IOException ex2) {
                Exceptions$.MODULE$.ignore(ex2);
            }
        }
        catch (RuntimeException ex) {
            Exceptions$.MODULE$.handle(ex);
        }
    }

    @Override
    public void exportOutputAreaToCSV(PrintWriter writer) {
        if (this._openModel.exists((Function1 & Serializable)_$1 -> _$1.widgets().exists((Function1 & Serializable)_$2 -> _$2 instanceof Output))) {
            writer.println(Dump$.MODULE$.csv().encode("OUTPUT"));
            Dump$.MODULE$.csv().stringToCSV(writer, this.outputAreaBuffer().toString());
            return;
        }
    }

    @Override
    public void clearOutput() {
        this.outputAreaBuffer().setLength(0);
    }

    @Override
    public ImporterJ.ErrorHandler importerErrorHandler() {
        return this.importerErrorHandler;
    }

    public void importerErrorHandler_$eq(ImporterJ.ErrorHandler x$1) {
        this.importerErrorHandler = x$1;
    }

    @Override
    public BufferedImage exportView() {
        return this.renderer().exportView(this);
    }

    public void getGraphics(BufferedImage image) {
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        Font font = graphics.getFont();
        Font newFont = new Font(font.getName(), font.getStyle(), this.fontSize());
        graphics.setFont(newFont);
        this.renderer().exportView(graphics, this);
    }

    @Override
    public void exportView(String filename, String format) {
        FileIO$.MODULE$.writeImageFile(this.renderer().exportView(this), filename, format);
    }

    @Override
    public void exportInterface(String filename) {
        throw this.unsupported();
    }

    @Override
    public void sendOutput(OutputObject oo, boolean toOutputArea) {
        if (!this.silent()) {
            Predef$.MODULE$.print((Object)oo.get());
        }
        if (toOutputArea) {
            this.outputAreaBuffer().append(oo.get());
        }
        if (this.mirrorHeadlessOutput) {
            this.primaryWorkspace.mirrorOutput(oo, toOutputArea);
            return;
        }
    }

    @Override
    public void ownerFinished(JobOwner owner) {
    }

    @Override
    public void updateDisplay(boolean haveWorldLockAlready) {
    }

    @Override
    public void requestDisplayUpdate(boolean force) {
        this.hubNetManager().foreach(_$3 -> _$3.incrementalUpdateFromEventThread());
    }

    @Override
    public void breathe() {
    }

    @Override
    public void periodicUpdate() {
    }

    @Override
    public void magicOpen(String name) {
        throw this.unsupported();
    }

    public void logCustomMessage(String msg) {
        throw this.unsupported();
    }

    public void logCustomGlobals(Seq<Tuple2<String, String>> nameValuePairs) {
        throw this.unsupported();
    }

    public ErrorReport lastErrorReport() {
        return this.lastErrorReport;
    }

    public void lastErrorReport_$eq(ErrorReport x$1) {
        this.lastErrorReport = x$1;
    }

    @Override
    public void runtimeError(Throwable t) {
        Throwable throwable = t;
        if (throwable instanceof LogoException) {
            LogoException le = (LogoException)throwable;
            this.lastLogoException_$eq(le);
            return;
        }
    }

    @Override
    public void runtimeError(JobOwner owner, Context context, Instruction instruction, Exception ex) {
        Exception exception = ex;
        if (exception instanceof LogoException) {
            LogoException le = (LogoException)exception;
            this.lastLogoException_$eq(le);
            this.lastErrorReport_$eq(new ErrorReport(owner, context, instruction, le));
            return;
        }
        System.err.println("owner: " + owner.displayName());
        Exceptions$.MODULE$.handle(ex);
    }

    private NLogoAnyLoader loader() {
        Object object = this.loader$lzy1;
        if (object instanceof NLogoAnyLoader) {
            return (NLogoAnyLoader)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (NLogoAnyLoader)this.loader$lzyINIT1();
    }

    private Object loader$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.loader$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ConfigurableModelLoader configurableModelLoader = null;
                    try {
                        configurableModelLoader = ((NLogoAnyLoader)FileFormat$.MODULE$.standardAnyLoader(true, this.compiler().utilities(), FileFormat$.MODULE$.standardAnyLoader$default$3()).addSerializer((ComponentSerialization)Femto$.MODULE$.get("org.nlogo.sdm.NLogoSDMFormat", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])), ClassTag$.MODULE$.apply(String.class).wrap(), ClassTag$.MODULE$.apply(NLogoFormat.class), ClassTag$.MODULE$.apply(FormatterPair.class))).addSerializer((ComponentSerialization)Femto$.MODULE$.get("org.nlogo.sdm.NLogoThreeDSDMFormat", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])), ClassTag$.MODULE$.apply(String.class).wrap(), ClassTag$.MODULE$.apply(NLogoThreeDFormat.class), ClassTag$.MODULE$.apply(FormatterPair.class));
                        object2 = configurableModelLoader == null ? LazyVals.NullValue$.MODULE$ : configurableModelLoader;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.loader$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.loader$lzy1;
                        LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, object2);
                        waiting.countDown();
                    }
                    return configurableModelLoader;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public void open(String path, boolean shouldAutoInstallLibs) throws LogoException, CompilerException, IOException {
        this.open(path, shouldAutoInstallLibs, (Seq<String>)((Seq)((SeqOps)Nil$.MODULE$)));
    }

    public void open(String path, boolean shouldAutoInstallLibs, Seq<String> loadedExtensions) {
        if (path == null) {
            Model model = this.loader().emptyModel("nlogox");
            Model m = model.copy("extensions [ " + loadedExtensions.mkString(" ") + " ]", model.copy$default$2(), model.copy$default$3(), model.copy$default$4(), model.copy$default$5(), model.copy$default$6(), model.copy$default$7(), model.copy$default$8(), model.copy$default$9());
            this.setModelType(ModelType$New$.MODULE$);
            this.fileManager().handleModelChange();
            this.openModel(m, shouldAutoInstallLibs);
            return;
        }
        Model m = (Model)this.loader().readModel(Paths.get(path, new String[0]).toUri()).get();
        this.setModelPath(path);
        this.setModelType(ModelType$Normal$.MODULE$);
        this.fileManager().handleModelChange();
        this.openModel(m, shouldAutoInstallLibs);
    }

    @Override
    public void openString(String modelContents) {
        this.openFromSource(modelContents, ModelReader$.MODULE$.modelSuffix());
    }

    public void openFromSource(String source, String extension) {
        this.loader().readModel(source, extension).foreach(m -> this.openModel((Model)m, false));
    }

    @Override
    public void openModel(Model model, boolean shouldAutoInstallLibs) {
        new HeadlessModelOpener(this).openFromModel(model, shouldAutoInstallLibs);
    }

    @Override
    public void halt() {
        super.halt();
    }

    public Nothing$ unsupported() {
        throw new UnsupportedOperationException();
    }

    private static final String tickCounterLabel$$anonfun$1() {
        return "ticks";
    }
}

