/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.headless;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import org.nlogo.api.APIVersion$;
import org.nlogo.api.ExportPlotWarningAction;
import org.nlogo.api.ExportPlotWarningAction$Ignore$;
import org.nlogo.api.ExportPlotWarningAction$Output$;
import org.nlogo.api.LabDefaultValues$;
import org.nlogo.api.LabProtocol;
import org.nlogo.api.PlotCompilationErrorAction;
import org.nlogo.api.PlotCompilationErrorAction$Ignore$;
import org.nlogo.api.PlotCompilationErrorAction$Output$;
import org.nlogo.api.Version$;
import org.nlogo.core.WorldDimensions;
import org.nlogo.headless.BehaviorSpaceCoordinator$;
import org.nlogo.headless.HeadlessWorkspace;
import org.nlogo.headless.HeadlessWorkspace$;
import org.nlogo.nvm.DummyPrimaryWorkspace;
import org.nlogo.nvm.LabInterface;
import org.nlogo.nvm.LabInterface$Settings$;
import org.nlogo.nvm.PrimaryWorkspace;
import org.nlogo.nvm.Workspace;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

public final class Main$
implements Serializable {
    private static final String HELP_STRING;
    public static final Main$ MODULE$;

    private Main$() {
    }

    static {
        MODULE$ = new Main$();
        HELP_STRING = "\nRun NetLogo using the NetLogo_Console app with the --headless command line argument.  The NetLogo_Console script supports the following arguments:\n\n* --headless: Enable headless mode to run a BehaviorSpace experiment (required, will open the graphical interface otherwise).\n* --model <path>: pathname of model to open (required)\n* --setup-file <path>: read experiment setups from this file instead of the model file\n* --experiment <name>: name of experiment to run\n* --table <path>: pathname to send table output to (or - for standard output)\n* --spreadsheet <path>: pathname to send spreadsheet output to (or - for standard output)\n* --lists <path>: pathname to send lists output to (or - for standard output), cannot be used without --table or --spreadsheet\n* --stats <path>: pathname to send statistics output to (or - for standard output)\n* --threads <number>: use this many threads to do model runs in parallel, or 1 to disable parallel runs. defaults to floor( .75 * number of processors).\n* --update-plots: enable plot updates. Include this if you want to export plot data, or exclude it for better performance.\n* --min-pxcor <number>: override world size setting in model file\n* --max-pxcor <number>: override world size setting in model file\n* --min-pycor <number>: override world size setting in model file\n* --max-pycor <number>: override world size setting in model file\n\nThe --model flag is required. If you don't specify --experiment, you must specify --setup-file. By default no results are generated, so you'll usually want to specify either --table or --spreadsheet, or both. If you specify any of the world dimensions, you must specify all four.\n\nHere is an example of running an experiment already defined and saved within a model (path separators and line-continue slashes are for macOS or Linux, Windows would be different):\n\n./NetLogo_Console --headless \\\n  --model \"models/IABM Textbook/chapter 4/Wolf Sheep Simple 5.nlogo\" \\\n  --experiment \"Wolf Sheep Simple model analysis\" \\\n  --table -\n\nSee the Advanced Usage section of the BehaviorSpace documentation in the NetLogo User Manual for more information and examples.\n";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Main$.class);
    }

    public void main(String[] args) {
        this.setHeadlessProperty();
        this.parseArgs(args).foreach(_$1 -> this.runExperiment((LabInterface.Settings)_$1, this.runExperiment$default$2()));
    }

    public void runExperiment(LabInterface.Settings settings, Function0<BoxedUnit> finish) {
        Option<LabProtocol> proto;
        Option<LabProtocol> option;
        ObjectRef plotCompilationErrorAction = ObjectRef.create((Object)PlotCompilationErrorAction$Output$.MODULE$);
        ObjectRef exportPlotWarningAction = ObjectRef.create((Object)ExportPlotWarningAction$Output$.MODULE$);
        HeadlessWorkspace openWs = this.newWorkspace$1(plotCompilationErrorAction, exportPlotWarningAction, settings);
        try {
            option = BehaviorSpaceCoordinator$.MODULE$.selectProtocol(settings, openWs);
        }
        finally {
            openWs.dispose();
        }
        Option<LabProtocol> option2 = proto = option;
        if (option2 instanceof Some) {
            LabProtocol protocol = (LabProtocol)((Some)option2).value();
            this.runExperimentWithProtocol(settings, protocol, _$2 -> {}, finish, new DummyPrimaryWorkspace(), this.runExperimentWithProtocol$default$6());
            return;
        }
        if (None$.MODULE$.equals(option2)) {
            throw new IllegalArgumentException("Invalid run, specify experiment name or setup file");
        }
        throw new MatchError(option2);
    }

    public Function0<BoxedUnit> runExperiment$default$2() {
        return (JFunction0.mcV.sp & Serializable)() -> {};
    }

    public void runExperimentWithProtocol(LabInterface.Settings settings, LabProtocol protocol, Function1<LabInterface.Worker, BoxedUnit> assignWorker, Function0<BoxedUnit> finish, PrimaryWorkspace primaryWorkspace, Seq<String> loadedExtensions) {
        ObjectRef plotCompilationErrorAction = ObjectRef.create((Object)PlotCompilationErrorAction$Output$.MODULE$);
        ObjectRef exportPlotWarningAction = ObjectRef.create((Object)ExportPlotWarningAction$Output$.MODULE$);
        LabInterface lab = HeadlessWorkspace$.MODULE$.newLab();
        LabInterface.Worker worker = lab.newWorker(protocol);
        assignWorker.apply((Object)worker);
        lab.run(settings, worker, primaryWorkspace, (Function0<Workspace>)(Function0 & Serializable)() -> this.newWorkspace$2(primaryWorkspace, plotCompilationErrorAction, exportPlotWarningAction, settings, loadedExtensions));
        finish.apply$mcV$sp();
    }

    public Seq<String> runExperimentWithProtocol$default$6() {
        return (Seq)((SeqOps)Nil$.MODULE$);
    }

    public void setHeadlessProperty() {
        String p = "java.awt.headless";
        if (System.getProperty(p) == null) {
            System.setProperty(p, "true");
        }
        System.setProperty("org.nlogo.preferHeadless", "true");
    }

    private Option<LabInterface.Settings> parseArgs(String[] args) {
        List dimStrings;
        None$ model = None$.MODULE$;
        None$ minPxcor = None$.MODULE$;
        None$ maxPxcor = None$.MODULE$;
        None$ minPycor = None$.MODULE$;
        None$ maxPycor = None$.MODULE$;
        None$ setupFile = None$.MODULE$;
        None$ experiment = None$.MODULE$;
        None$ tableWriter = None$.MODULE$;
        None$ spreadsheetWriter = None$.MODULE$;
        None$ statsWriter = None$.MODULE$;
        None$ listsWriter = None$.MODULE$;
        int threads = LabDefaultValues$.MODULE$.getDefaultThreads();
        boolean suppressErrors = false;
        boolean updatePlots = false;
        Object object = Predef$.MODULE$.refArrayOps((Object[])args);
        Iterator it = ArrayOps$.MODULE$.iterator$extension(object);
        String outputPath = "";
        while (it.hasNext()) {
            String arg;
            String string = arg = ((String)it.next()).toLowerCase();
            String string2 = "--headless";
            if (string == null) {
                if (string2 == null) continue;
            } else if (string.equals(string2)) continue;
            String string3 = arg;
            String string4 = "--help";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                Predef$.MODULE$.println((Object)HELP_STRING);
                return None$.MODULE$;
            }
            String string5 = arg;
            String string6 = "--version";
            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                Predef$.MODULE$.println((Object)Version$.MODULE$.version());
                return None$.MODULE$;
            }
            String string7 = arg;
            String string8 = "--extension-api-version";
            if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                Predef$.MODULE$.println((Object)APIVersion$.MODULE$.version());
                return None$.MODULE$;
            }
            String string9 = arg;
            String string10 = "--builddate";
            if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                Predef$.MODULE$.println((Object)Version$.MODULE$.buildDate());
                return None$.MODULE$;
            }
            String string11 = arg;
            String string12 = "--fullversion";
            if (!(string11 != null ? !string11.equals(string12) : string12 != null)) {
                Predef$.MODULE$.println((Object)Version$.MODULE$.fullVersion());
                return None$.MODULE$;
            }
            String string13 = arg;
            String string14 = "--3d";
            if (!(string13 != null ? !string13.equals(string14) : string14 != null)) {
                System.setProperty("org.nlogo.is3d", "true");
                continue;
            }
            String string15 = arg;
            String string16 = "--model";
            if (!(string15 != null ? !string15.equals(string16) : string16 != null)) {
                this.requireHasNext$1(it, arg);
                model = Some$.MODULE$.apply(it.next());
                continue;
            }
            String string17 = arg;
            String string18 = "--min-pxcor";
            if (!(string17 != null ? !string17.equals(string18) : string18 != null)) {
                this.requireHasNext$1(it, arg);
                minPxcor = Some$.MODULE$.apply(it.next());
                continue;
            }
            String string19 = arg;
            String string20 = "--max-pxcor";
            if (!(string19 != null ? !string19.equals(string20) : string20 != null)) {
                this.requireHasNext$1(it, arg);
                maxPxcor = Some$.MODULE$.apply(it.next());
                continue;
            }
            String string21 = arg;
            String string22 = "--min-pycor";
            if (!(string21 != null ? !string21.equals(string22) : string22 != null)) {
                this.requireHasNext$1(it, arg);
                minPycor = Some$.MODULE$.apply(it.next());
                continue;
            }
            String string23 = arg;
            String string24 = "--max-pycor";
            if (!(string23 != null ? !string23.equals(string24) : string24 != null)) {
                this.requireHasNext$1(it, arg);
                maxPycor = Some$.MODULE$.apply(it.next());
                continue;
            }
            String string25 = arg;
            String string26 = "--setup-file";
            if (!(string25 != null ? !string25.equals(string26) : string26 != null)) {
                this.requireHasNext$1(it, arg);
                setupFile = Some$.MODULE$.apply((Object)new File((String)it.next()));
                continue;
            }
            String string27 = arg;
            String string28 = "--experiment";
            if (!(string27 != null ? !string27.equals(string28) : string28 != null)) {
                this.requireHasNext$1(it, arg);
                experiment = Some$.MODULE$.apply(it.next());
                continue;
            }
            String string29 = arg;
            String string30 = "--table";
            if (!(string29 != null ? !string29.equals(string30) : string30 != null)) {
                this.requireHasNext$1(it, arg);
                outputPath = (String)it.next();
                tableWriter = Some$.MODULE$.apply((Object)this.path2writer$1(outputPath));
                continue;
            }
            String string31 = arg;
            String string32 = "--spreadsheet";
            if (!(string31 != null ? !string31.equals(string32) : string32 != null)) {
                this.requireHasNext$1(it, arg);
                String localOut = (String)it.next();
                if (outputPath.isEmpty()) {
                    outputPath = localOut;
                }
                spreadsheetWriter = Some$.MODULE$.apply((Object)this.path2writer$1(localOut));
                continue;
            }
            String string33 = arg;
            String string34 = "--lists";
            if (!(string33 != null ? !string33.equals(string34) : string34 != null)) {
                this.requireHasNext$1(it, arg);
                listsWriter = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)this.path2writer$1((String)it.next()), (Object)outputPath));
                continue;
            }
            String string35 = arg;
            String string36 = "--stats";
            if (!(string35 != null ? !string35.equals(string36) : string36 != null)) {
                this.requireHasNext$1(it, arg);
                statsWriter = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)this.path2writer$1((String)it.next()), (Object)outputPath));
                continue;
            }
            String string37 = arg;
            String string38 = "--threads";
            if (!(string37 != null ? !string37.equals(string38) : string38 != null)) {
                this.requireHasNext$1(it, arg);
                threads = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)it.next()));
                continue;
            }
            String string39 = arg;
            String string40 = "--suppress-errors";
            if (!(string39 != null ? !string39.equals(string40) : string40 != null)) {
                suppressErrors = true;
                continue;
            }
            String string41 = arg;
            String string42 = "--update-plots";
            if (!(string41 != null ? !string41.equals(string42) : string42 != null)) {
                updatePlots = true;
                continue;
            }
            this.die$1("unknown argument: " + arg);
        }
        None$ none$ = model;
        None$ none$2 = None$.MODULE$;
        if (!(none$ != null ? !none$.equals(none$2) : none$2 != null)) {
            this.die$1("You must specify --model.  Try --help for more information.");
        }
        None$ none$3 = setupFile;
        None$ none$4 = None$.MODULE$;
        if (!(none$3 != null ? !none$3.equals(none$4) : none$4 != null)) {
            None$ none$5 = experiment;
            None$ none$6 = None$.MODULE$;
            if (!(none$5 != null ? !none$5.equals(none$6) : none$6 != null)) {
                this.die$1("You must specify either --setup-file or --experiment (or both).  Try --help for more information.");
            }
        }
        None$ none$7 = listsWriter;
        None$ none$8 = None$.MODULE$;
        if (none$7 == null ? none$8 != null : !none$7.equals(none$8)) {
            None$ none$9 = tableWriter;
            None$ none$10 = None$.MODULE$;
            if (!(none$9 != null ? !none$9.equals(none$10) : none$10 != null)) {
                None$ none$11 = spreadsheetWriter;
                None$ none$12 = None$.MODULE$;
                if (!(none$11 != null ? !none$11.equals(none$12) : none$12 != null)) {
                    this.die$1("You cannot specify --lists without also specifying --table or --spreadsheet. Try --help for more information.");
                }
            }
        }
        if ((dimStrings = (List)new .colon.colon((Object)minPxcor, (List)new .colon.colon((Object)maxPxcor, (List)new .colon.colon((Object)minPycor, (List)new .colon.colon((Object)maxPycor, (List)Nil$.MODULE$))))).exists((Function1 & Serializable)_$3 -> _$3.isDefined()) && dimStrings.exists((Function1 & Serializable)_$4 -> !_$4.isDefined())) {
            this.die$1("If any of min/max-px/ycor are specified, all four must be specified.  Try --help for more information.");
        }
        None$ none$13 = statsWriter;
        None$ none$14 = None$.MODULE$;
        if (none$13 == null ? none$14 != null : !none$13.equals(none$14)) {
            None$ none$15 = tableWriter;
            None$ none$16 = None$.MODULE$;
            if (!(none$15 != null ? !none$15.equals(none$16) : none$16 != null)) {
                None$ none$17 = spreadsheetWriter;
                None$ none$18 = None$.MODULE$;
                if (!(none$17 != null ? !none$17.equals(none$18) : none$18 != null)) {
                    this.die$1("You cannot specify --stats without also specifying --table or --spreadsheet. Try --help for more information.");
                }
            }
        }
        None$ dims = dimStrings.forall((Function1 & Serializable)_$5 -> !_$5.isDefined()) ? None$.MODULE$ : Some$.MODULE$.apply((Object)new WorldDimensions(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)minPxcor.get())), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)maxPxcor.get())), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)minPycor.get())), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)maxPycor.get()))));
        return Some$.MODULE$.apply((Object)new LabInterface.Settings((String)model.get(), (Option<String>)experiment, (Option<File>)setupFile, (Option<PrintWriter>)tableWriter, (Option<PrintWriter>)spreadsheetWriter, (Option<Tuple2<PrintWriter, String>>)statsWriter, (Option<Tuple2<PrintWriter, String>>)listsWriter, (Option<WorldDimensions>)dims, threads, suppressErrors, updatePlots, LabInterface$Settings$.MODULE$.$lessinit$greater$default$12()));
    }

    private final HeadlessWorkspace newWorkspace$1(ObjectRef plotCompilationErrorAction$1, ObjectRef exportPlotWarningAction$1, LabInterface.Settings settings$1) {
        HeadlessWorkspace w = HeadlessWorkspace$.MODULE$.newInstance();
        w.setPlotCompilationErrorAction((PlotCompilationErrorAction)plotCompilationErrorAction$1.elem);
        w.setExportPlotWarningAction((ExportPlotWarningAction)exportPlotWarningAction$1.elem);
        w.open(settings$1.modelPath());
        plotCompilationErrorAction$1.elem = PlotCompilationErrorAction$Ignore$.MODULE$;
        exportPlotWarningAction$1.elem = ExportPlotWarningAction$Ignore$.MODULE$;
        w.setShouldUpdatePlots(settings$1.updatePlots());
        return w;
    }

    private final HeadlessWorkspace newWorkspace$2(PrimaryWorkspace primaryWorkspace$1, ObjectRef plotCompilationErrorAction$2, ObjectRef exportPlotWarningAction$2, LabInterface.Settings settings$2, Seq loadedExtensions$1) {
        HeadlessWorkspace w = HeadlessWorkspace$.MODULE$.newInstance();
        w.setPrimaryWorkspace(primaryWorkspace$1);
        w.setPlotCompilationErrorAction((PlotCompilationErrorAction)plotCompilationErrorAction$2.elem);
        w.setExportPlotWarningAction((ExportPlotWarningAction)exportPlotWarningAction$2.elem);
        w.open(settings$2.modelPath(), false, (Seq<String>)loadedExtensions$1);
        plotCompilationErrorAction$2.elem = PlotCompilationErrorAction$Ignore$.MODULE$;
        exportPlotWarningAction$2.elem = ExportPlotWarningAction$Ignore$.MODULE$;
        w.setShouldUpdatePlots(settings$2.updatePlots());
        w.setMirrorHeadlessOutput(settings$2.mirrorHeadlessOutput());
        return w;
    }

    private final void die$1(String msg) {
        System.err.println(msg);
        System.exit(1);
    }

    private final PrintWriter path2writer$1(String path) {
        String string = path;
        String string2 = "-";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return new PrintWriter(){

                public void close() {
                }
            };
        }
        return new PrintWriter(new FileWriter(path.trim()));
    }

    private final void requireHasNext$1(Iterator it$1, String arg$1) {
        if (!it$1.hasNext()) {
            this.die$1("missing argument after " + arg$1);
            return;
        }
    }
}

