/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.hubnet.client;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import javax.swing.border.LineBorder;
import org.nlogo.api.Exceptions$;
import org.nlogo.api.Graphics2DWrapper;
import org.nlogo.api.Perspective;
import org.nlogo.api.ViewSettings;
import org.nlogo.core.View;
import org.nlogo.core.View$;
import org.nlogo.hubnet.client.ClientPanel;
import org.nlogo.hubnet.client.ClientRenderer;
import org.nlogo.hubnet.mirroring.AgentPerspective;
import org.nlogo.hubnet.mirroring.ClearOverride;
import org.nlogo.hubnet.mirroring.ClientWorld;
import org.nlogo.hubnet.mirroring.OverrideList;
import org.nlogo.hubnet.mirroring.SendOverride;
import org.nlogo.theme.InterfaceColors$;
import org.nlogo.window.Editable;
import org.nlogo.window.ViewMouseHandler;
import org.nlogo.window.ViewWidgetInterface;
import org.nlogo.window.Widget;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.runtime.BoxedUnit;

public class ClientView
extends Widget
implements ViewWidgetInterface,
ViewSettings {
    public final ClientPanel org$nlogo$hubnet$client$ClientView$$clientPanel;
    private final ClientWorld world;
    private final ClientRenderer renderer;
    public boolean org$nlogo$hubnet$client$ClientView$$_displayOn;

    public ClientView(ClientPanel clientPanel) {
        this.org$nlogo$hubnet$client$ClientView$$clientPanel = clientPanel;
        this.world = new ClientWorld();
        this.renderer = new ClientRenderer(this.world());
        this.org$nlogo$hubnet$client$ClientView$$_displayOn = false;
        this.setBackground(InterfaceColors$.MODULE$.Transparent());
        this.world().setTrailDrawer(this.renderer().trailDrawer());
        ViewMouseHandler mouser = new ViewMouseHandler(this){
            private final /* synthetic */ ClientView $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer, $outer.world(), $outer);
            }

            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                if (this.$outer.org$nlogo$hubnet$client$ClientView$$_displayOn && this.mouseInside()) {
                    this.$outer.org$nlogo$hubnet$client$ClientView$$clientPanel.sendMouseMessage(this.mouseXCor, this.mouseYCor, true);
                    return;
                }
            }

            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                if (this.$outer.org$nlogo$hubnet$client$ClientView$$_displayOn && this.mouseInside()) {
                    this.$outer.org$nlogo$hubnet$client$ClientView$$clientPanel.sendMouseMessage(this.mouseXCor, this.mouseYCor, false);
                    return;
                }
            }
        };
        this.addMouseListener(mouser);
        this.addMouseMotionListener(mouser);
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
    }

    public ClientWorld world() {
        return this.world;
    }

    public ClientRenderer renderer() {
        return this.renderer;
    }

    @Override
    public boolean isHeadless() {
        return false;
    }

    public void setDisplayOn(boolean on) {
        if (this.org$nlogo$hubnet$client$ClientView$$_displayOn != on) {
            this.org$nlogo$hubnet$client$ClientView$$_displayOn = on;
            this.repaint();
            return;
        }
    }

    @Override
    public Option<Editable> getEditable() {
        return None$.MODULE$;
    }

    @Override
    public void paintComponent(Graphics g) {
        ClientView clientView = this;
        synchronized (clientView) {
            BoxedUnit boxedUnit;
            this.setFontSize(g);
            if (!this.org$nlogo$hubnet$client$ClientView$$_displayOn || this.world() == null) {
                g.setColor(InterfaceColors$.MODULE$.viewBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                g.setClip(0, 0, this.getWidth(), this.getHeight());
                this.world().applyOverrides();
                this.renderer().paint(new Graphics2DWrapper((Graphics2D)g), (ViewSettings)this);
                this.world().rollbackOverrides();
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private void setFontSize(Graphics g) {
        Font font = g.getFont();
        g.setFont(new Font(font.getName(), font.getStyle(), this.world().fontSize()));
    }

    public void updateDisplay(byte[] worldData) {
        ClientView clientView = this;
        synchronized (clientView) {
            BoxedUnit boxedUnit;
            if (this.world() != null) {
                try {
                    this.world().updateFrom(new DataInputStream(new ByteArrayInputStream(worldData)));
                    this.renderer().changeTopology(this.world().wrappingAllowedInX(), this.world().wrappingAllowedInY());
                    this.renderer().resetCache(this.patchSize());
                    this.org$nlogo$hubnet$client$ClientView$$_displayOn = true;
                }
                catch (IOException e) {
                    Exceptions$.MODULE$.handle(e);
                }
                this.repaint();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public void handleOverrideList(OverrideList list, boolean clear) {
        if (clear) {
            this.world().updateOverrides((ClearOverride)list);
        } else {
            this.world().updateOverrides((SendOverride)list);
        }
        if (this.org$nlogo$hubnet$client$ClientView$$_displayOn) {
            this.repaint();
            return;
        }
    }

    public void clearOverrides() {
        this.world().clearOverrides();
        if (this.org$nlogo$hubnet$client$ClientView$$_displayOn) {
            this.repaint();
            return;
        }
    }

    public void handleAgentPerspective(byte[] data) {
        this.world().updateClientPerspective(new AgentPerspective(new DataInputStream(new ByteArrayInputStream(data))));
        if (this.org$nlogo$hubnet$client$ClientView$$_displayOn) {
            this.repaint();
            return;
        }
    }

    @Override
    public void syncTheme() {
        this.setBorder(new LineBorder(InterfaceColors$.MODULE$.viewBorder(), 2));
    }

    @Override
    public void load(org.nlogo.core.Widget model) {
        org.nlogo.core.Widget widget = model;
        if (widget instanceof View) {
            View view = (View)widget;
            this.setBounds(view.x(), view.y(), view.width(), view.height());
            this.world().viewWidth(this.getWidth());
            this.world().viewHeight(this.getHeight());
            this.world().setWorldSize(view.dimensions().minPxcor(), view.dimensions().maxPxcor(), view.dimensions().minPycor(), view.dimensions().maxPycor());
            if (this.getWidth() > this.getHeight()) {
                this.world().patchSize((double)this.getWidth() / (double)this.world().worldWidth());
                return;
            }
            this.world().patchSize((double)this.getHeight() / (double)this.world().worldHeight());
            return;
        }
    }

    @Override
    public org.nlogo.core.Widget model() {
        Rectangle b = this.getUnzoomedBounds();
        return View$.MODULE$.apply(b.x, b.y, b.width, b.height, this.world().getDimensions(), View$.MODULE$.$lessinit$greater$default$6(), View$.MODULE$.$lessinit$greater$default$7(), View$.MODULE$.$lessinit$greater$default$8(), View$.MODULE$.$lessinit$greater$default$9(), View$.MODULE$.$lessinit$greater$default$10());
    }

    @Override
    public int fontSize() {
        return this.world().fontSize();
    }

    @Override
    public double patchSize() {
        return this.world().patchSize();
    }

    @Override
    public double viewWidth() {
        return this.world().viewWidth();
    }

    @Override
    public double viewHeight() {
        return this.world().viewHeight();
    }

    @Override
    public Perspective perspective() {
        return this.world().perspective;
    }

    @Override
    public double viewOffsetX() {
        return this.world().followOffsetX();
    }

    @Override
    public double viewOffsetY() {
        return this.world().followOffsetY();
    }

    @Override
    public boolean renderPerspective() {
        return true;
    }

    @Override
    public boolean drawSpotlight() {
        return this.world().serverMode() || this.world().perspective instanceof Perspective.Follow;
    }

    @Override
    public int getAdditionalHeight() {
        return 0;
    }
}

